#line 1  "fortc.fc"
/*
 * $Id: fortc.c,v 1.1.1.1 1995/08/04 20:54:11 steve Exp $
 *
 * This file implements some support routines for FORTRAN-callable C
 * functions.
 */

/*LINTLIBRARY*/

#include "udposix.h"
#include <stddef.h>		/* for size_t */
#include "udalloc.h"
#include "fortc.h"


/*
 * Return the length of the non-blank portion of a FORTRAN character variable.
 */
    size_t
fclen(string, maxlen)
    const char	*string;	/* string to have its length returned */
    int		maxlen;		/* maximum possible length of string */
{
    const char	*cp;

    for (cp = string + maxlen; cp > string; --cp)
	if (cp[-1] != ' ')
	    break;

    return cp - string;
}


/*
 * FORTRAN interface to the above routine:
 */
    int
#line 39  "fortc.fc"
flen_(string, string_len)
    char      *string;
    int        string_len; 
{
#line 41  "fortc.fc"
    return fclen(string, (int)string_len);
}


/*
 * Duplicate the meaningful portion of a FORTRAN character variable.  Ensure 
 * it's 0-termination.
 */
    char*
fcdup(string, maxlen)
    const char	*string;	/* string to be duplicated */
    int		maxlen;		/* maximum length of string */
{
    return udstrndup(string, fclen(string, maxlen));
}
