static char ident[] = "$Id: harry-bug.c,v 1.1.1.1 1995/08/04 20:54:12 steve Exp $" ;

/***********************************************************************
  Purpose : 
     This is a fortran-callable function to provide a fortran interface
     to the Unidata unit conversion utility. If the returned function
     value == 0, the units conversion was sucessful, otherwise it was
     not.
  Arguments : 
     See below.
  History:
  $Log: harry-bug.c,v $
  Revision 1.1.1.1  1995/08/04 20:54:12  steve
  Starting over due to restructuring.

 * Revision 1.6.1.1  1993/03/10  15:29:00  steve
 * Initial placement under CVS
 *
***********************************************************************/

#include <stdio.h>
#include <udunits.h>



int *convert_units (from_units, to_units, slope, intercept)
     char *from_units ;  /* input
			    units to be converted from. */
     char *to_units ;    /* input
			    units to be converted to. */
     float *slope ;      /* output
			    the slope of the units transformation 
			    function. */
     float *intercept ;  /* output
			    the intercept of the units transformation 
			    function. */
{
    double d_slope = 0.0 , d_intercept = 0.0 ;
    int *status;
    utUnit unit1, unit2 ;
    static int first = 0;

    status = (int *)malloc(sizeof(int));

    /* First check for blank strings. If any of the input strings are
       blank, set error flag and return.
     */
    *status = charcount (from_units) ;
    if ( *status == 0 ){
	*status++;
	return ( status) ;
    }

    *status = charcount (to_units) ;
    if ( *status == 0 ){
	*status++;
	return ( status) ;    
    }

    /* Initialize units conversion package. 
     */
    *status = 0;
    if(!first){
	*status = utInit("") ;
#ifndef TERM
 	first++;
#endif
    }
    if ( *status != 0 ) {
	switch ( *status ) {
	  case UT_ENOFILE : 
	    printf ("Error in convert_units: The units-file doesn't exist.") ;
	    break ;
	  case UT_ESYNTAX :  
	    printf ("Error in convert_units: The units-file contains a syntax error.") ;
	    break ;
	  case UT_EUNKNOWN :
	    printf ("Error in convert_units: The units-file contains an unknown specification.") ;
	    break ;
	  case UT_EIO :
	    printf ("Error in convert_units: An I/O error occurred while accessing the units-file.") ;
	    break ;
	  case UT_EALLOC : 
	    printf ("Error in convert_units: A memory allocation failure occurred.") ;
	    break ;
	    default :
		printf("Code = %d\n", *status);
	      break;
	}
    }
    else {
	/* Convert units strings to binary structure representation.
	 */
	*status = utScan(from_units, &unit1) ;
	*status = *status + utScan(to_units, &unit2) ;
	if ( *status != 0 ) {
	    switch ( *status ) {
	      case UT_ENOINIT :
		printf ("Error in convert_units: Package has not been initialized.") ;
		break ;
	      case UT_EUNKNOWN :
		printf ("Error in convert_units: An unknown unit was specified.") ;
		break ;
	      case UT_ESYNTAX : 
		printf ("Error in convert_units: The units-file contains a syntax error.") ;
		break ;
	      default :
		break ;
	  }
	}
	else {
	    /* Find the coeffecients of the conversion function.
	     */
	    *status = utConvert(&unit1, &unit2, &d_slope, &d_intercept) ;
	    if ( *status != 0) {
		switch ( *status ) {
		  case UT_ENOINIT : 
		    printf ("Error in convert_units: Package has not been initialized.") ;
		    break ;
		  case UT_EINVALID : 
		    printf ("Error in convert_units: One of the unit-structures is invalid.") ;
		    break ;
		  case UT_ECONVERT :
		    printf ("Error in convert_units: Units are not convertable.") ;
		    break ;
		  default :
		    break ;
		}
	    }
	    else {
		/* Cast to correct types.
		 */
		*slope     = (float)d_slope ;
		*intercept = (float)d_intercept ;
	    }
	}
    }

    /* Terminate conversion package.
     */
#ifdef TERM
    utTerm () ;
#endif

    /* Return function value.
     */
    return ( status ) ;
}


/* This routine returns the number of nonblank characters in the 
   input string.
*/

#include <string.h>

int charcount (string)
     char *string;  /* String to be examined */
{
    int i, nchars = 0 ;

    for ( i = 0; i < strlen(string); i++ ) {
        if ( (string[i] != '\n') && (string[i] != ' ') )
	  nchars++ ;
    }
    return (nchars) ;
}


#include <stdio.h>
main()
{
    static char from[] = "in", to[] = "ft" ;
    static char from1[] = "m", to1[] = "km" ;
    static char from2[] = "m", to2[] = "barleycorn" ;
    static char from3[] = "barleycorn", to3[] = "au" ;
    static char from4[] = "s", to4[] = "d" ;
    int  *status ;
    float  slope, intercept ;


    status = convert_units (from, to, &slope, &intercept) ;
    printf ("Status =  %f %f \n", slope,intercept) ;
    status = convert_units (from1, to1, &slope, &intercept) ;
    printf ("Status = %f  %f \n", slope,intercept) ;
    status = convert_units (from2, to2, &slope, &intercept) ;
    printf ("Status = %f  %f \n", slope,intercept) ;
    status = convert_units (from3, to3, &slope, &intercept) ;
    printf ("Status = %f  %f \n", slope,intercept) ;
    status = convert_units (from4, to4, &slope, &intercept) ;
    printf ("Status = %f %f \n", slope,intercept) ;
}
