/*
 *				JULNUM
 * PURPOSE:
 *    To return the absolute Julian day number of any day since January 1, 
 *    4713 B.C.E (day 1).
 *
 * SYNOPSIS:
 *     long julnum(mon, day, year)
 * 
 *     where:
 * 	int	year	= absolute year (eg. 1983)
 * 	int	mon	= month (1 = Jan)
 * 	int	day	= day (1 = first day of the month)
 * 
 * NOTES:
 *     o  Note: Any particular Julian day number refers to the time interval 
 *	  from noon to noon, rather than from midnight to midnight.
 * 
 *     o  This routine is based on algorithm 199 in the Collected Algorithms
 *        of the ACM, 1980.
 */


    long
julnum(year, mon, day)
    int		year;
    int		mon;
    int		day;
{
    long	ya, c;

    if (mon > 2) {
	mon -= 3;
    } else {
	mon += 9;
	year--;
    }
    c = year/100;
    ya = year - 100*c;
    return ((146097*c)/4 + (1461*ya)/4 + (153*mon+2)/5 + day + 1721119);
}
