#include <stdio.h>
#include "udunits.h"

main()
{
    if (utInit("/upc/cur/udunits/etc/udunits.dat") != 0) {
	(void) fputs("utInit() error\n", stderr);
    } else {
	char    delta_unit_string[] = "minutes since 1970-1-1";
	utUnit  delta_unit;

	if (utScan(delta_unit_string, &delta_unit) != 0) {
	    (void) fputs("utScan() error\n", stderr);
	} else {
	    int		in_year		= 1990;
	    int		in_month	= 1;
	    int		in_day		= 1;
	    int		in_hour		= 0;
	    int		in_minute	= 0;
	    float	in_second	= 0;
	    double	in_value;

	    if (utInvCalendar(in_year, in_month, in_day, in_hour, in_minute,
			      in_second, &delta_unit, &in_value) != 0) {
		(void) fputs("utInvCalendar() error\n", stderr);
	    } else {
		int     out_year, out_month, out_day, out_hour, out_minute;
		float   out_second;
		double  delta_value	= 1;

		(void) printf("in_value = %g\n", in_value);
		(void) utCalendar(in_value+delta_value, &delta_unit, &out_year,
				  &out_month, &out_day, &out_hour, &out_minute,
				  &out_second);

		(void) printf("%d-%d-%d %d:%d:%.0f\n",
			      out_year, out_month, out_day, out_hour,
			      out_minute, out_second);
	    }
	}
    }
}
