#include <stdio.h>
#include <stdlib.h>
#include "udunits.h"

main()
{
    if (utInit("/upc/cur/udunits/etc/udunits.dat") != 0) {
	(void) fputs("utInit() error\n", stderr);
    } else {
	char    timecenter_unit_string[] = "2 minutes since 1990-1-1";
	utUnit  timecenter_unit;

	if (utScan(timecenter_unit_string, &timecenter_unit) != 0) {
	    (void) fputs("utScan() error\n", stderr);
	} else {
	    int		ref_year	= 1990;
	    int		ref_month	= 1;
	    int		ref_day		= 1;
	    int		ref_hour	= 1;	/* start time + 1 hour */
	    int		ref_minute	= 0;
	    float	ref_second	= 0;
	    double	ref_value;

	    (void) utInvCalendar(ref_year, ref_month, ref_day,
			      ref_hour, ref_minute, ref_second,
			      &timecenter_unit, &ref_value);
	    /*
	     * Number of 2-minute intervals between start and reference
	     * times:
	     */
	    if (30 == ref_value)
		exit(0);
	}
    }
    abort();
}
