/*
 * $Id: linklist.h,v 1.1.1.1 1995/06/15 22:31:59 steve Exp $
 */

/*
 * This file describes the public portion of the linked-list abstraction.
 */

#ifndef	LINKLIST_H_INCLUDED
#   define	LINKLIST_H_INCLUDED

    /*
     * Opaque, linked-list datatype:
     */
    struct Linklist;
    typedef struct Linklist Linklist;

    /*
     * Linked-list API:
     */
    UD_EXTERN_FUNC(Linklist *llnew,   (void));
    UD_EXTERN_FUNC(voidp     lladd,   (Linklist *list, const voidp data, 
				       size_t size));
    UD_EXTERN_FUNC(voidp     llfirst, (Linklist *list));
    UD_EXTERN_FUNC(voidp     llnext,  (Linklist *list));
    UD_EXTERN_FUNC(Linklist *llfree,  (Linklist *list));

#endif	/* LINKLIST_H_INCLUDED was not defined above */
