/*
 * $Id: sigaction.c,v 1.1.1.1 1995/06/15 22:31:57 steve Exp $
 *
 * POSIX signal interface layered atop the native signal interface.
 */

#include "udposix.h"
#include <stddef.h>		/* for NULL */
#include <signal.h>


/*
 * Set the action associated with a signal.
 *
 * NB: Some struct sigvec have `sv_masks', some have `sv_onstack'; hence, we
 * just use memset() to clear the structure.
 */
    int
sigaction(sig, act, oact)
    int				sig;
    const struct sigaction	*act;
    struct sigaction		*oact;
{
    int			status	= 0;
    struct sigvec	vector;
    struct sigvec	oldvector;
    struct sigvec	*vec	=  act == NULL ? NULL : &vector;
    struct sigvec	*ovec	= oact == NULL ? NULL : &oldvector;

    if (vec != NULL) {
	memset(vec, 0, sizeof(*vec));
	vec->sv_handler	= (void (*)())act->sa_handler;
	vec->sv_mask	= (int)act->sa_mask;
    }

    if (sigvec(sig, vec, ovec) == -1) {
	status	= -1;
    } else {
	if (ovec != NULL) {
	    memset(ovec, 0, sizeof(*ovec));
	    ovec->sv_handler	= (void (*)())oact->sa_handler;
	    ovec->sv_mask	= (int)oact->sa_mask;
	}
    }

    return status;
}
