/*
 * $Id: strbuf.h,v 1.1.1.1 1995/06/15 22:32:00 steve Exp $
 *
 * Copyright (C) 1991 UCAR/Unidata
 *
 * Permission to use, copy, modify, and distribute this software and its
 * documentation for any purpose without fee is hereby granted, provided
 * that the above copyright notice appear in all copies, that both that
 * copyright notice and this permission notice appear in supporting
 * documentation, and that the name of UCAR/Unidata not be used in
 * advertising or publicity pertaining to distribution of the software
 * without specific, written prior permission.  UCAR makes no
 * representations about the suitability of this software for any purpose.
 * It is provided "as is" without express or implied warranty.  It is
 * provided with no support and without obligation on the part of UCAR or
 * Unidata, to assist in its use, correction, modification, or enhancement.
 *
 * This header-file includes:
 *	"udposix.h"	for PROTO() and "const"
 *	<stddef.h>	for "size_t"
 */

#ifndef	UD_STRBUF_H_INCLUDED
#define	UD_STRBUF_H_INCLUDED

#include	"udposix.h"
#include	<stddef.h>

#ifndef	UD_FORTRAN_SOURCE

    /*
     * Opaque, string-buffer, data-type declaration:
     */
    struct Strbuf;
    typedef struct Strbuf	Strbuf;

    /*
     * String-buffer API:
     */
    UD_EXTERN_FUNC(Strbuf *sbnew,    (size_t max));
    UD_EXTERN_FUNC(Strbuf *sbensure, (Strbuf *sb, size_t max));
    UD_EXTERN_FUNC(Strbuf *sbcpy,    (Strbuf *sb, const char *string));
    UD_EXTERN_FUNC(Strbuf *sbncpy,   (Strbuf *sb, const char *string, 
				      size_t len));
    UD_EXTERN_FUNC(Strbuf *sbcat,    (Strbuf *sb, const char *string));
    UD_EXTERN_FUNC(Strbuf *sbncat,   (Strbuf *sb, const char *string, 
				      size_t len));
    UD_EXTERN_FUNC(char   *sbstr,    (Strbuf *sb));
    UD_EXTERN_FUNC(size_t  sblen,    (Strbuf *sb));
    UD_EXTERN_FUNC(size_t  sbmax,    (Strbuf *sb));
    UD_EXTERN_FUNC(Strbuf *sbgrow,   (Strbuf *sb));
    UD_EXTERN_FUNC(Strbuf *sbfree,   (Strbuf *sb));

#endif	/* not FORTRAN source above */

#endif	/* UD_STRBUF_H_INCLUDED not defined */
