/*
 * (C) Copyright 1991 UCAR/Unidata
 * 
 * Permission to use, copy, modify, and distribute this software and its
 * documentation for any purpose without fee is hereby granted, provided that
 * the above copyright notice appear in all copies, that both that copyright
 * notice and this permission notice appear in supporting documentation, and
 * that the name of UCAR/Unidata not be used in advertising or publicity
 * pertaining to distribution of the software without specific, written prior
 * permission.  UCAR makes no representations about the suitability of this
 * software for any purpose. It is provided "as is" without express or
 * implied warranty.  It is provided with no support and without obligation
 * on the part of UCAR or Unidata, to assist in its use, correction,
 * modification, or enhancement.
 * 
 * $Id: strvec.h,v 1.1.1.1 1995/06/15 22:32:00 steve Exp $
 */

/*
 * This file describes the public portion of the string-vector abstraction.
 */

#ifndef	STRINGVEC_H_INCLUDED
#   define	STRVEC_H_INCLUDED

#   ifndef UD_FORTRAN_SOURCE

	/*
	 * Opaque, string-vector datatype:
	 */
	struct Strvec;
	typedef struct Strvec	Strvec;

	UD_EXTERN_FUNC(Strvec *svnew,    (size_t initial_number));
	UD_EXTERN_FUNC(Strvec *svadd,    (Strvec *sv, const char *s));
	UD_EXTERN_FUNC(int     svnumber, (const Strvec *sv));
	UD_EXTERN_FUNC(char  **svvector, (const Strvec *sv));
	UD_EXTERN_FUNC(char   *svstring, (const Strvec *sv, int i));
	UD_EXTERN_FUNC(Strvec *svfree,   (Strvec *sv));

#   endif	/* UD_FORTRAN_SOURCE was not defined above */

#endif	/* STRVEC_H_INCLUDED was not defined above */
