/*
 * $Id: udqueue_err.h,v 1.1.1.1 1995/06/15 22:32:01 steve Exp $
 */

#ifndef	UD_QUEUE_H
#define	UD_QUEUE_H


#include "udposix.h"
#include <stddef.h>
#include <udfifo.h>


/*
 * Access modes:
 */
#define UDQUEUE_WAIT	0	/* wait until action possible */
#define UDQUEUE_NOWAIT	1	/* error return if action not immediately */
				/* possible */
#define UDQUEUE_FORCE	2	/* discard oldest if necessary */


/*
 * Queue data structure.  WARNING: Private definition: don't depend on the
 * details of this structure!
 */
struct Udqueue {
    Udfifo		fifo;		/* single-threaded, non-suspending
					 * FIFO */
    pthread_mutex_t	mutex;		/* to manage FIFO access */
    pthread_cond_t	cond;		/* to manage waits */
    int			mutex_created;	/* mutex created? */
    int			cond_created;	/* condition variable created? */
    int			getmode;	/* wait, nowait */
    int			putmode;	/* wait, nowait, force */
};
typedef struct Udqueue	Udqueue;


/*
 * Return values:
 */
/* negative */
#define UDQUEUE_ETHREAD	 (UDFIFO_ENOENT-1)	/* thread problem: mutex, */
						/* condition variable, etc. */
#define UDQUEUE_ENOENT	 UDFIFO_ENOENT		/* no entry available */
#define UDQUEUE_ENOSPC	 UDFIFO_ENOSPC		/* insufficient space */
#define UDQUEUE_ENOMEM	 UDFIFO_ENOMEM		/* insufficient memory */
#define UDQUEUE_EINVAL	 UDFIFO_EINVAL		/* invalid argument */
/* zero */
#define UDQUEUE_ESUCCESS UDFIFO_ESUCCESS	/* success */
/* positive */
#define	UDQUEUE_EFORCED	 UDFIFO_EFORCED		/* success, but oldest */
						/* element discarded */


/*
 * Initialize a queue.
 */

UD_EXTERN_FUNC(
    int udqueue_init, (
	Udqueue	*queue,		/* the queue */
	size_t	eltsize,	/* size of an element in bytes */
	int	numelts,	/* maximum number of elements */
	int	getmode,	/* UDQUEUE_WAIT, UDQUEUE_NOWAIT */
	int	putmode		/* UDQUEUE_WAIT, UDQUEUE_NOWAIT, 
				 * UDQUEUE_FORCE */
    ));

/*
 * Add to a queue.
 */
UD_EXTERN_FUNC(
    int udqueue_put, (
	Udqueue		*queue,	/* the queue */
	const void	*new,	/* the element to add */
	void		*old	/* (putmode == UDQUEUE_FORCE && old != NULL) => 
				 * discarded, oldest element */
    ));

/*
 * Remove from a queue.
 */
UD_EXTERN_FUNC(
    int udqueue_get, (		/* UDQUEUE_SUCCESS or UDQUEUE_FAILURE */
	Udqueue	*queue,		/* the queue */
	void	*old		/* old != NULL => the oldest element */
    ));

/*
 * Return the number of elements in a queue.
 */
UD_EXTERN_FUNC(
    int udqueue_count, (
	Udqueue *queue		/* the queue */
    ));

/*
 * Return the number of empty spaces in a queue in terms of elements.
 */
UD_EXTERN_FUNC(
    int udqueue_space, (
	Udqueue *queue		/* the queue */
    ));

/*
 * Destroy a queue.
 */
UD_EXTERN_FUNC(
    int udqueue_destroy, (
	Udqueue *queue		/* the queue */
    ));


#endif	/* UD_QUEUE_H not defined above */
