{ -*- buffer-read-only: t -*-

  Copyright 2015-2024 Michalis Kamburelis.

  This file is part of "Castle Game Engine".

  "Castle Game Engine" is free software; see the file COPYING.txt,
  included in this distribution, for details about the copyright.

  "Castle Game Engine" is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.

  ----------------------------------------------------------------------------
}

{ Automatically generated node properties.

  Do not edit this file manually!
  To add new properties:
  - add them to the text files in tools/internal/x3d-nodes-to-pascal/nodes-specification/ ,
  - and regenerate include files by running x3d-nodes-to-pascal }

{$ifdef read_interface}

  strict private
    function GetMatrix: TMatrix4;
    procedure SetMatrix(const Value: TMatrix4);
  public
    { Create node fields and events. }
    procedure CreateNode; override;
    class function ClassX3DType: String; override;

    strict private FFdMatrix: TSFMatrix4f;
    { Internal wrapper for property @code(Matrix). This wrapper API may change, we advise to access simpler @code(Matrix) instead, if it is defined (TODO: for now, some field types do not have a simpler counterpart). }
    public property FdMatrix: TSFMatrix4f read FFdMatrix;
    {  }
    property Matrix: TMatrix4 read GetMatrix write SetMatrix;

{$endif read_interface}

{$ifdef read_implementation}

{ TTextureTransformMatrix3DNode ----------------------------------------------- }

function TTextureTransformMatrix3DNode.GetMatrix: TMatrix4;
begin
  Result := FdMatrix.Value;
end;

procedure TTextureTransformMatrix3DNode.SetMatrix(const Value: TMatrix4);
begin
  FdMatrix.Send(Value);
end;

class function TTextureTransformMatrix3DNode.ClassX3DType: String;
begin
  Result := 'TextureTransformMatrix3D';
end;

procedure TTextureTransformMatrix3DNode.CreateNode;
begin
  inherited;

  FFdMatrix := TSFMatrix4f.Create(Self, True, 'matrix', TMatrix4.Identity);
   FdMatrix.ChangeAlways := chTextureTransform;
  AddField(FFdMatrix);
end;

{$endif read_implementation}
