Contacting
==========

To contact the maintainers of this package, email
<developers-reference@packages.debian.org>.

Contributing
============

If you want to contribute to the Developer's Reference, it's best to
first submit a few patches as bug reports or merge requests. 
Writing patches for existing bugs are also always appreciated.
Please make patches against the Git sources, about which see below.

Git
===

This manual is a part of the Debian Documentation Project (DDP)
and its source is managed in a Git repository in the Debian
group on Salsa, see
[here](https://wiki.debian.org/Salsa/Doc#Collaborative_Maintenance:_.22Debian.22_group).

If you just want to check out the current Git version of this
manual to create patches against, you can use either of these two
commands to do so:

```
git clone https://salsa.debian.org/debian/developers-reference.git
```

or
```
debcheckout developers-reference
```

For write access (automatically given to all Debian Developers,
see rules for change handling below):

```
git clone git@salsa.debian.org:debian/developers-reference.git
```

Change handling
===============

The consensus on the way changes should be made is the following:
-  Consensual changes can be committed by anyone. By definition these
   follow the recommendations described in this file.
-  Non-consensual changes should be discussed on the BTS prior to being
   committed.
-  When someone commits something thinking it is consensual, but the
   change ends up being non-consensual, it can simply be reverted
   and then be discussed in a bug report.

Git commit messages and d/changelog entries
===========================================

Please don't provide `debian/changelog` entries when doing changes. Instead
`debian/changelog` will be generated by running `gbp dch` before a release.
Thus please write meaningful git commit messages in one line and indicate the
file(s) changed in the beginning of that commit message.  See previous commit
messages for examples.

Writing style
=============

Please use gender-neutral formulations. This means avoiding
pronouns like he/she when referring to a role (like "maintainer")
whose gender is unknown. Instead of you should use [singular
they](https://en.wikipedia.org/wiki/Singular_they).

Sphinx style
============

Section header underlines are intentionally set much longer than needed
for English source to accommodate translations which may yield longer
strings.  Please make sure to keep the length of Section header text
below 100 characters for all languages.

Don't use ASCII character only TeX-style writing like `quoted-word' or
``double-quoted-word''.  These interfere with Sphinx markups.

Keep markups minimal and consistent.

Translators
===========

We have tried to keep language-independent bits of text with rst_epilog
variable defined in conf.py.  Feel free to truck stuff out of the
English manual into rst_epilog if it's useful, or else report the
problem.

The translation PO files are in `source/locales/**/LC_MESSAGES/*.po`, we
hope very much for more translations.

Updating the translations after updates of the English source
=============================================================

```
git reset --hard && git clean -idx && make update-po && git diff | diffstat ;
git commit -a -s -m 'Update all .po files for changed strings in the English original.'
```

Useful Makefile targets
=======================

The following 'make' targets exist for your convenience:

```
  make or make all
        build all languages in all available formats

  make html
        test build all languages with html

  make text
        test build all languages with plain text

  make pdf
        test build all valid languages with pdf

  make nopdf
        test build all non-valid languages with pdf

  make epub
        test build all languages with epub

  make info
        test build all languages with info

  make LANGS=en html
        build the English manual in HTML format

  make LANGS=fr pdf
        build the French manual in PDF format

  make LANGS_NOPDF=ja pdf
        build the Japanese place holder manual in PDF format

  make update-po
        update .po files for all languages
        (requires the sphinx-intl package)

  make status
        show the status of all translations

  make LANGS=it status
     show the status of the Italian translation

  DESTDIR=tmp sudo -E make install
        build all languages in all available formats
        and install under ./tmp
```

<sup>🍥 This file was made by Debian markdown gang 🍥</sup>
<!-- hide vim mode line
# vim: set sw=2 sts=2 et ai si tw=72 :
-->
