//
// The Fontaine Font Analysis Project 
// 
// Copyright (c) 2009 by Edward H. Trager
// All Rights Reserved
// 
// Released under the GNU GPL version 2.0 or later.
//     


//
// TraditionalChinese.h
//

#ifndef ORTHOGRAPHY_DATA
#include "../OrthographyData.h"
#endif

#ifndef TRADITIONAL_CHINESE
#define TRADITIONAL_CHINESE

//
// The Unicode values for this TraditionalChinese orthography group 
// were compiled by taking the 3500 most common traditional Chinese
// characters based on TSAI Chih-Hao's work.  The URL and other relevant
// information follow:
// 
// http://technology.chtsai.org/charfreq/
// Frequency and Stroke Counts of Chinese Characters, Published: 1996-01-01,
// Updated: 2005-08-03, Copyright © 1996-2006 Chih-Hao Tsai 
// (Email: hao520@yahoo.com)
//
namespace TraditionalChinese{

//
// Unicode values 
//
UINT32 values[]={
	0x7684,
	0x662f,
	0x4e0d,
	0x6211,
	0x4e00,
	0x6709,
	0x5927,
	0x5728,
	0x4eba,
	0x4e86,
	0x4e2d,
	0x5230,
	0x8cc7,
	0x8981,
	0x4ee5,
	0x53ef,
	0x9019,
	0x500b,
	0x4f60,
	0x6703,
	0x597d,
	0x70ba,
	0x4e0a,
	0x4f86,
	0x5b78,
	0x5c31,
	0x4ea4,
	0x4e5f,
	0x7528,
	0x80fd,
	0x5982,
	0x6642,
	0x6587,
	0x8aaa,
	0x6c92,
	0x4ed6,
	0x770b,
	0x90a3,
	0x554f,
	0x751f,
	0x63d0,
	0x4e0b,
	0x904e,
	0x8acb,
	0x5011,
	0x5929,
	0x6240,
	0x591a,
	0x9ebc,
	0x5c0f,
	0x4e4b,
	0x60f3,
	0x5f97,
	0x5de5,
	0x51fa,
	0x9084,
	0x96fb,
	0x5c0d,
	0x90fd,
	0x6a5f,
	0x81ea,
	0x800c,
	0x5b50,
	0x5f8c,
	0x8a0a,
	0x5bb6,
	0x7ad9,
	0x5fc3,
	0x53ea,
	0x53bb,
	0x77e5,
	0x570b,
	0x5f88,
	0x53f0,
	0x6210,
	0x4fe1,
	0x540c,
	0x4f55,
	0x7ae0,
	0x9053,
	0x767c,
	0x5730,
	0x6cd5,
	0x7121,
	0x7136,
	0x4f46,
	0x7576,
	0x65bc,
	0x55ce,
	0x672c,
	0x5e74,
	0x73fe,
	0x524d,
	0x6700,
	0x771f,
	0x65b0,
	0x548c,
	0x56e0,
	0x679c,
	0x610f,
	0x5b9a,
	0x9ede,
	0x60c5,
	0x5176,
	0x984c,
	0x4e8b,
	0x79d1,
	0x65b9,
	0x4e9b,
	0x6e05,
	0x4e09,
	0x6a23,
	0x6b64,
	0x5427,
	0x4f4d,
	0x4f5c,
	0x7406,
	0x884c,
	0x8005,
	0x7d93,
	0x540d,
	0x4ec0,
	0x8b1d,
	0x65e5,
	0x6b63,
	0x958b,
	0x8a71,
	0x8207,
	0x5be6,
	0x611b,
	0x518d,
	0x83ef,
	0x4e8c,
	0x57ce,
	0x52d5,
	0x6bd4,
	0x9762,
	0x9ad8,
	0x53c8,
	0x6216,
	0x529b,
	0x61c9,
	0x5973,
	0x7a2e,
	0x6559,
	0x8eca,
	0x5206,
	0x50cf,
	0x7cfb,
	0x9577,
	0x624b,
	0x6b21,
	0x5df2,
	0x660e,
	0x6253,
	0x592a,
	0x8def,
	0x8d77,
	0x5df1,
	0x76f8,
	0x4e3b,
	0x95dc,
	0x5341,
	0x9593,
	0x9cf3,
	0x5916,
	0x5462,
	0x89ba,
	0x4f7f,
	0x8a72,
	0x53cb,
	0x624d,
	0x9032,
	0x51f0,
	0x5979,
	0x6c11,
	0x8457,
	0x5404,
	0x5168,
	0x5c07,
	0x5c11,
	0x5169,
	0x52a0,
	0x56de,
	0x611f,
	0x5f0f,
	0x7b2c,
	0x7403,
	0x6027,
	0x8001,
	0x7a0b,
	0x628a,
	0x88ab,
	0x516c,
	0x8ad6,
	0x53ca,
	0x9f8d,
	0x6821,
	0x5225,
	0x9ad4,
	0x91cd,
	0x7d66,
	0x807d,
	0x6c34,
	0x505a,
	0x5e38,
	0x60a8,
	0x898b,
	0x88e1,
	0x6771,
	0x98a8,
	0x89e3,
	0x7063,
	0x6708,
	0x7b49,
	0x5566,
	0x90e8,
	0x539f,
	0x7f8e,
	0x5148,
	0x97f3,
	0x901a,
	0x7ba1,
	0x7db2,
	0x5340,
	0x671f,
	0x932f,
	0x5426,
	0x6a02,
	0x5165,
	0x627e,
	0x66f8,
	0x8b93,
	0x56db,
	0x554a,
	0x7531,
	0x9078,
	0x8f03,
	0x6578,
	0x8868,
	0x5167,
	0x5834,
	0x5b83,
	0x5f9e,
	0x5feb,
	0x6b61,
	0x81f3,
	0x7acb,
	0x76ee,
	0x793e,
	0x5408,
	0x671b,
	0x600e,
	0x8a8d,
	0x544a,
	0x66f4,
	0x5e7e,
	0x8003,
	0x5ea6,
	0x96e3,
	0x7248,
	0x982d,
	0x559c,
	0x8a31,
	0x5149,
	0x4eca,
	0x8cb7,
	0x7b97,
	0x5f1f,
	0x82e5,
	0x7d71,
	0x8eab,
	0x8a18,
	0x4ee3,
	0x865f,
	0x8655,
	0x5b8c,
	0x63a5,
	0x8a08,
	0x8a00,
	0x5b57,
	0x5e2b,
	0x4e26,
	0x653f,
	0x73a9,
	0x5f35,
	0x7537,
	0x8ab0,
	0x5c71,
	0x6bcf,
	0x7d50,
	0x4e14,
	0x661f,
	0x975e,
	0x5efa,
	0x6539,
	0x9023,
	0x653e,
	0x54c8,
	0x6d3b,
	0x7814,
	0x76f4,
	0x8a2d,
	0x9673,
	0x5831,
	0x8f49,
	0x9ee8,
	0x6307,
	0x4e94,
	0x8b8a,
	0x6c23,
	0x897f,
	0x8a66,
	0x5e0c,
	0x795e,
	0x53d6,
	0x5316,
	0x7269,
	0x738b,
	0x4efb,
	0x6797,
	0x55ae,
	0x4e16,
	0x53d7,
	0x8fd1,
	0x7fa9,
	0x6b7b,
	0x4fbf,
	0x53cd,
	0x58eb,
	0x6230,
	0x7a7a,
	0x968a,
	0x8ddf,
	0x537b,
	0x5317,
	0x5fc5,
	0x696d,
	0x529f,
	0x5beb,
	0x5f71,
	0x8072,
	0x5e73,
	0x81fa,
	0x54e1,
	0x91d1,
	0x8a0e,
	0x8272,
	0x5247,
	0x5bb9,
	0x6a94,
	0x7247,
	0x5411,
	0x59b3,
	0x5e02,
	0x5229,
	0x8208,
	0x767d,
	0x5f37,
	0x5b89,
	0x592e,
	0x7279,
	0x8b70,
	0x8fa6,
	0x50f9,
	0x7e3d,
	0x50b3,
	0x601d,
	0x82b1,
	0x5143,
	0x53eb,
	0x4fdd,
	0x4efd,
	0x6c42,
	0x7a76,
	0x5475,
	0x4ef6,
	0x672a,
	0x6c7a,
	0x7d44,
	0x842c,
	0x7af9,
	0x7d1a,
	0x6301,
	0x7b11,
	0x6295,
	0x54ea,
	0x5ba4,
	0x66fe,
	0x8d70,
	0x5594,
	0x6a19,
	0x6d41,
	0x652f,
	0x7368,
	0x8c93,
	0x5361,
	0x9700,
	0x5144,
	0x9580,
	0x5171,
	0x8a9e,
	0x6d77,
	0x53e3,
	0x963f,
	0x7dda,
	0x99ac,
	0x9ec3,
	0x53c3,
	0x822c,
	0x547d,
	0x8996,
	0x89c0,
	0x806f,
	0x8166,
	0x670b,
	0x683c,
	0x5152,
	0x516b,
	0x4fee,
	0x6599,
	0x9322,
	0x5931,
	0x5403,
	0x4f4f,
	0x5373,
	0x53e6,
	0x9304,
	0x5c08,
	0x8c61,
	0x63db,
	0x57fa,
	0x677f,
	0x62ff,
	0x9060,
	0x901f,
	0x5f62,
	0x5b69,
	0x5099,
	0x6b4c,
	0x5e6b,
	0x78ba,
	0x5019,
	0x9664,
	0x754c,
	0x88dd,
	0x985e,
	0x8b1b,
	0x5668,
	0x5357,
	0x6848,
	0x756b,
	0x82f1,
	0x8a34,
	0x5e36,
	0x5dee,
	0x4e4e,
	0x91cf,
	0x4e45,
	0x6389,
	0x4f3c,
	0x6574,
	0x5f15,
	0x73ed,
	0x8ff7,
	0x5716,
	0x5236,
	0x8cbb,
	0x8cfd,
	0x5947,
	0x8b58,
	0x578b,
	0x8d85,
	0x908a,
	0x8036,
	0x54c1,
	0x820d,
	0x96d6,
	0x59cb,
	0x904b,
	0x674e,
	0x52d9,
	0x6b0a,
	0x9a57,
	0x6545,
	0x516d,
	0x8b80,
	0x602a,
	0x98db,
	0x6eff,
	0x670d,
	0x5922,
	0x6536,
	0x773c,
	0x9020,
	0x5ff5,
	0x7559,
	0x8ab2,
	0x8ecd,
	0x7834,
	0x7cbe,
	0x534a,
	0x7d04,
	0x9858,
	0x4ee4,
	0x5e95,
	0x7b54,
	0x6f14,
	0x9054,
	0x96c4,
	0x6df1,
	0x7968,
	0x65e9,
	0x9662,
	0x5920,
	0x66f2,
	0x5047,
	0x8ac7,
	0x8853,
	0x68d2,
	0x8ce3,
	0x9ed1,
	0x767e,
	0x52dd,
	0x63a8,
	0x5b58,
	0x706b,
	0x6e96,
	0x793a,
	0x5f80,
	0x789f,
	0x6613,
	0x6cc1,
	0x665a,
	0x96e2,
	0x6cbb,
	0x5c0e,
	0x4e03,
	0x6bb5,
	0x5718,
	0x8abf,
	0x8b49,
	0x5217,
	0x50b7,
	0x6c38,
	0x525b,
	0x6392,
	0x54e5,
	0x5fb7,
	0x4e5d,
	0x751a,
	0x6bba,
	0x7167,
	0x8edf,
	0x5305,
	0x6015,
	0x689d,
	0x591c,
	0x5546,
	0x6982,
	0x6839,
	0x4f9b,
	0x7d55,
	0x5343,
	0x5ba2,
	0x5207,
	0x96c6,
	0x7a31,
	0x64da,
	0x843d,
	0x8d8a,
	0x7adf,
	0x76e1,
	0x5f85,
	0x805e,
	0x5712,
	0x5fd8,
	0x503c,
	0x7522,
	0x6d88,
	0x96d9,
	0x7d05,
	0x5ea7,
	0x5c55,
	0x80b2,
	0x8dd1,
	0x9644,
	0x561b,
	0x57f7,
	0x5531,
	0x6280,
	0x67d0,
	0x786c,
	0x65af,
	0x96f2,
	0x904a,
	0x606f,
	0x52a9,
	0x9808,
	0x82e6,
	0x4ecb,
	0x6548,
	0x9996,
	0x8cea,
	0x4f8b,
	0x5509,
	0x8077,
	0x5fa9,
	0x8f38,
	0x7bc0,
	0x898f,
	0x6ce8,
	0x7562,
	0x67e5,
	0x71b1,
	0x6cb9,
	0x9928,
	0x614b,
	0x505c,
	0x798f,
	0x6551,
	0x5012,
	0x89aa,
	0x5bb3,
	0x4e82,
	0x53e4,
	0x6b65,
	0x5bf6,
	0x64ca,
	0x8209,
	0x7d42,
	0x55ef,
	0x5370,
	0x9650,
	0x4f9d,
	0x65b7,
	0x8f15,
	0x74b0,
	0x7c21,
	0x8da3,
	0x5fd7,
	0x97ff,
	0x96a8,
	0x7df4,
	0x7e8c,
	0x9b5a,
	0x7bc7,
	0x53f8,
	0x5c40,
	0x9001,
	0x6975,
	0x89d2,
	0x7701,
	0x6e90,
	0x967d,
	0x5e79,
	0x7fd2,
	0x7f85,
	0x6b66,
	0x514d,
	0x7591,
	0x62c9,
	0x514b,
	0x4ecd,
	0x6a13,
	0x4f5b,
	0x8db3,
	0x4f4e,
	0x5ee3,
	0x7169,
	0x9ce5,
	0x986f,
	0x78bc,
	0x571f,
	0x7387,
	0x8056,
	0x58de,
	0x521d,
	0x5177,
	0x9810,
	0x5440,
	0x773e,
	0x8cac,
	0x722d,
	0x5175,
	0x667a,
	0x8aa4,
	0x5883,
	0x9752,
	0x9806,
	0x91ce,
	0x695a,
	0x8cb4,
	0x8ca0,
	0x58d3,
	0x53f2,
	0x9069,
	0x4fc2,
	0x6e2c,
	0x61f7,
	0x8fce,
	0x914d,
	0x9b54,
	0x6162,
	0x54c7,
	0x61c2,
	0x55da,
	0x4ea6,
	0x5473,
	0x8a55,
	0x821e,
	0x7d30,
	0x91ab,
	0x5e1d,
	0x5c6c,
	0x53e5,
	0x6200,
	0x6557,
	0x5b9c,
	0x694a,
	0x7532,
	0x8ffd,
	0x704c,
	0x6625,
	0x5de6,
	0x6562,
	0x9748,
	0x72c2,
	0x969b,
	0x7fa4,
	0x65cf,
	0x6728,
	0x9a0e,
	0x91cc,
	0x9805,
	0x6232,
	0x9047,
	0x72d7,
	0x4f73,
	0x535a,
	0x53f3,
	0x75db,
	0x71df,
	0x59b9,
	0x5eb7,
	0x5584,
	0x5fb5,
	0x6b77,
	0x5b98,
	0x723e,
	0x6309,
	0x7de8,
	0x75c5,
	0x8b77,
	0x88dc,
	0x64c7,
	0x6293,
	0x77f3,
	0x6b72,
	0x96bb,
	0x9818,
	0x5c0b,
	0x6eab,
	0x990a,
	0x6b62,
	0x5b88,
	0x541b,
	0x8840,
	0x7530,
	0x96e8,
	0x5c45,
	0x8b02,
	0x7570,
	0x512a,
	0x8df3,
	0x62dc,
	0x721b,
	0x5c01,
	0x60e1,
	0x826f,
	0x6a21,
	0x72c0,
	0x6d6a,
	0x804a,
	0x589e,
	0x6838,
	0x6fc0,
	0x7dad,
	0x9678,
	0x5433,
	0x725b,
	0x5fd9,
	0x8a5e,
	0x5287,
	0x5bbf,
	0x6025,
	0x5565,
	0x62b1,
	0x975c,
	0x653b,
	0x4e9e,
	0x6c5f,
	0x81f4,
	0x9663,
	0x56b4,
	0x5b97,
	0x8b66,
	0x58d8,
	0x592b,
	0x5bc6,
	0x7761,
	0x5348,
	0x5e97,
	0x52e2,
	0x60b2,
	0x862d,
	0x5e55,
	0x7de3,
	0x9031,
	0x5ee0,
	0x7c3d,
	0x5750,
	0x9999,
	0x723d,
	0x63a7,
	0x5fae,
	0x767b,
	0x7ffb,
	0x666e,
	0x883b,
	0x51b7,
	0x5a01,
	0x6bd2,
	0x4fca,
	0x7d61,
	0x8f2f,
	0x6bcd,
	0x5275,
	0x5802,
	0x8d99,
	0x5957,
	0x820a,
	0x96dc,
	0x5468,
	0x8ff0,
	0x6050,
	0x5e78,
	0x4eae,
	0x9e97,
	0x5df4,
	0x79ae,
	0x9152,
	0x4ec1,
	0x9910,
	0x724c,
	0x7a81,
	0x8173,
	0x528d,
	0x62db,
	0x5409,
	0x7236,
	0x4ed4,
	0x5178,
	0x641e,
	0x623f,
	0x7d20,
	0x9632,
	0x6388,
	0x5145,
	0x8349,
	0x66b4,
	0x616e,
	0x7d39,
	0x80cc,
	0x5289,
	0x59d4,
	0x5e9c,
	0x666f,
	0x61b6,
	0x5c24,
	0x8af8,
	0x7f3a,
	0x63f4,
	0x6f2b,
	0x7434,
	0x7f75,
	0x7d14,
	0x5c1a,
	0x85dd,
	0x60dc,
	0x7f6e,
	0x76ca,
	0x59d0,
	0x8aa0,
	0x7e7c,
	0x6e56,
	0x6b32,
	0x9ebb,
	0x9760,
	0x8089,
	0x677e,
	0x523b,
	0x7d00,
	0x9000,
	0x65e2,
	0x542b,
	0x5224,
	0x91cb,
	0x76ae,
	0x6ce2,
	0x627f,
	0x5c04,
	0x5806,
	0x83ab,
	0x88fd,
	0x9375,
	0x8d95,
	0x65c1,
	0x7b46,
	0x6241,
	0x8a3b,
	0x594f,
	0x6a39,
	0x5f8b,
	0x9435,
	0x69ae,
	0x6628,
	0x6bdb,
	0x5f69,
	0x6b78,
	0x864e,
	0x7f6a,
	0x7686,
	0x8449,
	0x552e,
	0x5f48,
	0x885b,
	0x65bd,
	0x9298,
	0x5200,
	0x584a,
	0x6f22,
	0x6b23,
	0x5e03,
	0x8cde,
	0x8f09,
	0x96aa,
	0x64ad,
	0x5347,
	0x9418,
	0x5bc4,
	0x5f04,
	0x4ed8,
	0x69cb,
	0x56c9,
	0x78c1,
	0x87a2,
	0x5049,
	0x85a6,
	0x6d0b,
	0x563f,
	0x555f,
	0x6885,
	0x7b56,
	0x563b,
	0x71c8,
	0x9b3c,
	0x6aa2,
	0x5ba3,
	0x54e6,
	0x5abd,
	0x5747,
	0x6d3e,
	0x8c6c,
	0x6fdf,
	0x67b6,
	0x4eab,
	0x5446,
	0x8a13,
	0x85cd,
	0x5283,
	0x64d4,
	0x52aa,
	0x90ed,
	0x6b49,
	0x7d19,
	0x8cbc,
	0x6697,
	0x547c,
	0x7f77,
	0x5de7,
	0x6167,
	0x7a7f,
	0x8a73,
	0x96f7,
	0x5354,
	0x7763,
	0x9867,
	0x81c9,
	0x9022,
	0x5cf6,
	0x734e,
	0x6e38,
	0x6279,
	0x7565,
	0x77ed,
	0x5e7b,
	0x6c99,
	0x6563,
	0x6575,
	0x9109,
	0x518a,
	0x8f2a,
	0x671d,
	0x7a97,
	0x5fcd,
	0x6cb3,
	0x85cf,
	0x885d,
	0x6df7,
	0x552f,
	0x4e7e,
	0x51a0,
	0x719f,
	0x9df9,
	0x86cb,
	0x5c0a,
	0x68c4,
	0x656c,
	0x5b63,
	0x5a5a,
	0x7e23,
	0x7dca,
	0x4f2f,
	0x7533,
	0x8863,
	0x8cfc,
	0x50c5,
	0x5e33,
	0x5c64,
	0x79cb,
	0x731c,
	0x504f,
	0x93e1,
	0x98df,
	0x559d,
	0x5077,
	0x8d0a,
	0x72af,
	0x52c7,
	0x9846,
	0x59d3,
	0x675f,
	0x6de1,
	0x8a69,
	0x5609,
	0x66c9,
	0x501f,
	0x5f92,
	0x6d32,
	0x64c1,
	0x5e8f,
	0x6176,
	0x7e3e,
	0x795d,
	0x7345,
	0x570d,
	0x9918,
	0x79c1,
	0x9b25,
	0x67d4,
	0x6f02,
	0x5bcc,
	0x79c0,
	0x7bc4,
	0x907f,
	0x8f1d,
	0x8b6f,
	0x5b64,
	0x7b28,
	0x62ec,
	0x5438,
	0x7aef,
	0x79fb,
	0x5ef3,
	0x84cb,
	0x672b,
	0x5bdf,
	0x6297,
	0x63ee,
	0x4e56,
	0x7a4d,
	0x63d2,
	0x9a5a,
	0x8521,
	0x5fe0,
	0x6108,
	0x96ea,
	0x5de8,
	0x78a9,
	0x745e,
	0x51e1,
	0x6731,
	0x7c43,
	0x4e1f,
	0x76e4,
	0x5076,
	0x6e2f,
	0x5bae,
	0x5e25,
	0x5b8f,
	0x96c5,
	0x8ca8,
	0x9192,
	0x865b,
	0x907a,
	0x639b,
	0x900f,
	0x7206,
	0x70c8,
	0x6ec5,
	0x6750,
	0x62cd,
	0x4f11,
	0x8a8c,
	0x5713,
	0x9280,
	0x4e92,
	0x98ef,
	0x638c,
	0x8c6a,
	0x66ff,
	0x6311,
	0x9802,
	0x718a,
	0x7d2f,
	0x5740,
	0x5065,
	0x4fe0,
	0x96de,
	0x56f0,
	0x8afe,
	0x8f14,
	0x4f34,
	0x7389,
	0x6d17,
	0x654f,
	0x81e8,
	0x8857,
	0x964d,
	0x5538,
	0x6190,
	0x8607,
	0x7c73,
	0x6e1b,
	0x64cd,
	0x760b,
	0x8f9b,
	0x5b87,
	0x805a,
	0x516e,
	0x5f7c,
	0x63a1,
	0x5c46,
	0x5c3c,
	0x8f29,
	0x85e5,
	0x9a19,
	0x7da0,
	0x7ae5,
	0x7e2e,
	0x7b26,
	0x7372,
	0x9ed8,
	0x90ce,
	0x78b0,
	0x7981,
	0x5a46,
	0x54a7,
	0x80a1,
	0x62bd,
	0x780d,
	0x6068,
	0x80af,
	0x520a,
	0x6ce1,
	0x6f38,
	0x92fc,
	0x5ee2,
	0x6dda,
	0x6a1e,
	0x8d0f,
	0x6b50,
	0x8ca1,
	0x8a02,
	0x9014,
	0x89f8,
	0x8ce2,
	0x5091,
	0x812b,
	0x7bb1,
	0x4f48,
	0x4ed9,
	0x51b0,
	0x6790,
	0x84bc,
	0x53ad,
	0x7c4d,
	0x5805,
	0x54ed,
	0x590f,
	0x61f6,
	0x6a4b,
	0x7a69,
	0x9732,
	0x8a62,
	0x68ee,
	0x7d72,
	0x5875,
	0x6163,
	0x6fe4,
	0x8abc,
	0x4f54,
	0x8336,
	0x8cf4,
	0x968e,
	0x8c50,
	0x8c9d,
	0x6691,
	0x90f5,
	0x5371,
	0x5bd2,
	0x68b0,
	0x96b1,
	0x7238,
	0x6c7d,
	0x6158,
	0x65c5,
	0x6751,
	0x4e88,
	0x632f,
	0x4ea1,
	0x74f6,
	0x906d,
	0x54f2,
	0x96f6,
	0x7d0d,
	0x73cd,
	0x4e43,
	0x5e2d,
	0x54e9,
	0x912d,
	0x5439,
	0x9aa8,
	0x7159,
	0x80e1,
	0x502b,
	0x6d2a,
	0x6416,
	0x5a18,
	0x82b3,
	0x7d22,
	0x5cf0,
	0x7e54,
	0x60e0,
	0x676f,
	0x6d6e,
	0x72fc,
	0x9694,
	0x6930,
	0x79df,
	0x5c3e,
	0x5ffd,
	0x8907,
	0x838a,
	0x6b3e,
	0x83dc,
	0x526f,
	0x4f01,
	0x6298,
	0x64fe,
	0x63da,
	0x9f20,
	0x5192,
	0x7661,
	0x9f13,
	0x523a,
	0x983b,
	0x55b5,
	0x91dd,
	0x9738,
	0x66ab,
	0x4f0a,
	0x6c89,
	0x5634,
	0x5eab,
	0x6094,
	0x9670,
	0x5bc2,
	0x501a,
	0x63a2,
	0x7956,
	0x6469,
	0x8ddd,
	0x5269,
	0x904d,
	0x87f2,
	0x71d2,
	0x9801,
	0x9686,
	0x5f31,
	0x8c46,
	0x5ef6,
	0x856d,
	0x63e1,
	0x5be7,
	0x662d,
	0x76df,
	0x8986,
	0x61b2,
	0x79d8,
	0x8010,
	0x6101,
	0x4e01,
	0x64a5,
	0x6c88,
	0x6607,
	0x9aee,
	0x54c0,
	0x9f9c,
	0x7709,
	0x56fa,
	0x5377,
	0x984f,
	0x9592,
	0x7a0d,
	0x6b98,
	0x642d,
	0x4eac,
	0x50bb,
	0x8033,
	0x6620,
	0x8a17,
	0x6069,
	0x9d3b,
	0x5999,
	0x8faf,
	0x5a92,
	0x5435,
	0x64ec,
	0x9055,
	0x6182,
	0x684c,
	0x62fc,
	0x92b7,
	0x85c9,
	0x80d6,
	0x5c4b,
	0x57df,
	0x8239,
	0x52de,
	0x6d1e,
	0x5be2,
	0x4e95,
	0x5f90,
	0x5ddd,
	0x5948,
	0x6236,
	0x4e58,
	0x984d,
	0x500d,
	0x8fb2,
	0x64fa,
	0x585e,
	0x6a6b,
	0x8cc0,
	0x7687,
	0x62d6,
	0x6028,
	0x7259,
	0x9f4a,
	0x9003,
	0x969c,
	0x8cfa,
	0x6efe,
	0x5e72,
	0x8b5c,
	0x70cf,
	0x77ad,
	0x6234,
	0x642c,
	0x9b06,
	0x74dc,
	0x8feb,
	0x5687,
	0x5976,
	0x68cb,
	0x9b27,
	0x76db,
	0x6478,
	0x5c3a,
	0x4f19,
	0x67d3,
	0x4f69,
	0x5e8a,
	0x9177,
	0x5b6b,
	0x7260,
	0x5c41,
	0x9189,
	0x9707,
	0x9396,
	0x51f1,
	0x640d,
	0x6f6e,
	0x5f79,
	0x6cf0,
	0x4f0d,
	0x51ac,
	0x6843,
	0x8070,
	0x4e59,
	0x8ff4,
	0x7af6,
	0x5d07,
	0x649e,
	0x53b2,
	0x6de8,
	0x727d,
	0x7f8a,
	0x60d1,
	0x6eaa,
	0x5e3d,
	0x7720,
	0x5df7,
	0x6e9d,
	0x4fd7,
	0x5b8b,
	0x98c4,
	0x6dfa,
	0x737b,
	0x9eb5,
	0x8266,
	0x6ed1,
	0x699c,
	0x5708,
	0x5ead,
	0x7e31,
	0x9583,
	0x84ee,
	0x9ea5,
	0x90a6,
	0x8000,
	0x65cb,
	0x95b1,
	0x8ad2,
	0x7d2b,
	0x651d,
	0x5100,
	0x59a8,
	0x5be9,
	0x63cf,
	0x6d3d,
	0x6bc0,
	0x9010,
	0x966a,
	0x586b,
	0x8e0f,
	0x8dcc,
	0x85e4,
	0x6155,
	0x52d2,
	0x95c6,
	0x6b8a,
	0x59ca,
	0x6191,
	0x5bde,
	0x5cb8,
	0x82ac,
	0x93ae,
	0x6c60,
	0x62d2,
	0x845b,
	0x5dde,
	0x92d2,
	0x5bec,
	0x62f3,
	0x4e8e,
	0x51fd,
	0x9a45,
	0x540e,
	0x88c1,
	0x87f9,
	0x963b,
	0x90aa,
	0x9769,
	0x9817,
	0x81e5,
	0x660c,
	0x5b5f,
	0x822a,
	0x9059,
	0x7fd4,
	0x880d,
	0x606d,
	0x5967,
	0x9f4b,
	0x775b,
	0x69cd,
	0x5854,
	0x9589,
	0x9813,
	0x7cca,
	0x4ef0,
	0x65d7,
	0x52f5,
	0x539a,
	0x9b42,
	0x51c6,
	0x4e38,
	0x5b99,
	0x9038,
	0x88d5,
	0x8212,
	0x8a2a,
	0x517c,
	0x85a9,
	0x98f2,
	0x8d64,
	0x95a3,
	0x5eb8,
	0x556a,
	0x6436,
	0x52ff,
	0x7802,
	0x7dd2,
	0x4e0c,
	0x7a79,
	0x5118,
	0x6383,
	0x6148,
	0x6b04,
	0x5617,
	0x52f8,
	0x9bae,
	0x596e,
	0x8cdc,
	0x83e9,
	0x558a,
	0x95e1,
	0x5e7d,
	0x64f4,
	0x6c61,
	0x5f70,
	0x6beb,
	0x7965,
	0x76dc,
	0x8a3c,
	0x7f70,
	0x756a,
	0x5c16,
	0x7070,
	0x72d0,
	0x8861,
	0x64ce,
	0x6c6a,
	0x76e3,
	0x7c4c,
	0x9072,
	0x8a87,
	0x90b1,
	0x7a05,
	0x6d69,
	0x62c6,
	0x7d1b,
	0x543e,
	0x6258,
	0x59d1,
	0x54b1,
	0x6f0f,
	0x8a95,
	0x6dd1,
	0x9b31,
	0x7832,
	0x67cf,
	0x7246,
	0x7aa9,
	0x50be,
	0x8fad,
	0x79d2,
	0x7fbd,
	0x6e21,
	0x6c96,
	0x5ed6,
	0x8f1b,
	0x9f61,
	0x57f9,
	0x9080,
	0x7518,
	0x888b,
	0x675c,
	0x9178,
	0x80f8,
	0x908f,
	0x8c48,
	0x6dbc,
	0x80a5,
	0x8c37,
	0x7378,
	0x5a03,
	0x5b54,
	0x9677,
	0x4f30,
	0x59bb,
	0x5f91,
	0x73ab,
	0x6f5b,
	0x6676,
	0x80de,
	0x715e,
	0x8106,
	0x62b9,
	0x7336,
	0x7bc9,
	0x5442,
	0x788e,
	0x5674,
	0x622a,
	0x65e6,
	0x5a66,
	0x5783,
	0x8352,
	0x5e63,
	0x573e,
	0x4e32,
	0x58ef,
	0x4f38,
	0x50b2,
	0x5f26,
	0x6ce5,
	0x7e41,
	0x9b6f,
	0x5fcc,
	0x5104,
	0x53ed,
	0x5766,
	0x6065,
	0x871c,
	0x6b3a,
	0x6368,
	0x6021,
	0x73b2,
	0x81ed,
	0x5510,
	0x6e6f,
	0x7aae,
	0x6089,
	0x52c1,
	0x62d4,
	0x751c,
	0x8499,
	0x901b,
	0x6735,
	0x6458,
	0x81bd,
	0x7cdf,
	0x817f,
	0x5587,
	0x919c,
	0x8e8d,
	0x7e73,
	0x6cc9,
	0x6fa4,
	0x78a7,
	0x978b,
	0x97d3,
	0x5f65,
	0x6668,
	0x8389,
	0x99d5,
	0x731b,
	0x7de9,
	0x5761,
	0x70b8,
	0x6012,
	0x53ec,
	0x6355,
	0x5e7c,
	0x827e,
	0x6046,
	0x5272,
	0x626f,
	0x76fe,
	0x4e48,
	0x5410,
	0x660f,
	0x8fa8,
	0x8ed2,
	0x5deb,
	0x4e39,
	0x9451,
	0x5f4e,
	0x8ce6,
	0x576a,
	0x4fb5,
	0x80ce,
	0x60a0,
	0x85aa,
	0x522a,
	0x5f6c,
	0x609f,
	0x73e0,
	0x52e4,
	0x7470,
	0x690d,
	0x75f4,
	0x7919,
	0x655d,
	0x76c3,
	0x76fc,
	0x4ea8,
	0x901d,
	0x526a,
	0x78e8,
	0x903c,
	0x6fc3,
	0x6d1b,
	0x4e4f,
	0x64cb,
	0x59c6,
	0x75c7,
	0x5acc,
	0x8eb2,
	0x58c1,
	0x91e3,
	0x6696,
	0x61be,
	0x905c,
	0x6109,
	0x66f0,
	0x91c7,
	0x6377,
	0x5606,
	0x7384,
	0x6ef4,
	0x6263,
	0x62b5,
	0x5954,
	0x7fc1,
	0x8e5f,
	0x83f2,
	0x722c,
	0x68da,
	0x5915,
	0x60f1,
	0x6212,
	0x7272,
	0x6cf3,
	0x6070,
	0x6ec4,
	0x6851,
	0x8523,
	0x6f54,
	0x7126,
	0x52c9,
	0x596a,
	0x840a,
	0x5496,
	0x8caa,
	0x8e22,
	0x6284,
	0x8de1,
	0x937e,
	0x6daf,
	0x7bad,
	0x8a93,
	0x7a4c,
	0x6d89,
	0x7a3f,
	0x7f72,
	0x7642,
	0x790e,
	0x50d1,
	0x6db5,
	0x9727,
	0x7c89,
	0x4ff1,
	0x5fb9,
	0x8b00,
	0x5c60,
	0x72a7,
	0x5537,
	0x7e5e,
	0x58fd,
	0x723a,
	0x9a37,
	0x6c0f,
	0x7ffc,
	0x4e91,
	0x809a,
	0x541d,
	0x6881,
	0x54aa,
	0x7e6a,
	0x5ec9,
	0x98fd,
	0x9cf4,
	0x8c8c,
	0x9739,
	0x70ae,
	0x6350,
	0x5561,
	0x708e,
	0x55e8,
	0x8ca2,
	0x66fc,
	0x58e2,
	0x9f3b,
	0x5949,
	0x9234,
	0x8017,
	0x6062,
	0x878d,
	0x7b4b,
	0x64bf,
	0x5112,
	0x98fe,
	0x798d,
	0x4faf,
	0x552c,
	0x6316,
	0x5e45,
	0x77a7,
	0x5ef7,
	0x54a6,
	0x6490,
	0x67f3,
	0x8584,
	0x9ece,
	0x6372,
	0x5d50,
	0x540a,
	0x9742,
	0x64e0,
	0x89bd,
	0x8fea,
	0x51cc,
	0x832b,
	0x71c3,
	0x746a,
	0x5f18,
	0x77db,
	0x6566,
	0x745c,
	0x9326,
	0x6953,
	0x8cd3,
	0x68af,
	0x742a,
	0x7344,
	0x5074,
	0x54ac,
	0x58a8,
	0x60b6,
	0x6674,
	0x6016,
	0x55ac,
	0x9f52,
	0x5dba,
	0x4ef2,
	0x97fb,
	0x65ed,
	0x7d9c,
	0x5154,
	0x8e64,
	0x59ff,
	0x9081,
	0x50a2,
	0x8b7d,
	0x8932,
	0x5b5d,
	0x4fc3,
	0x99db,
	0x4ec7,
	0x7c97,
	0x59ae,
	0x7267,
	0x821f,
	0x7cd5,
	0x6bbc,
	0x8776,
	0x5147,
	0x934b,
	0x61fc,
	0x92b3,
	0x541f,
	0x8667,
	0x679d,
	0x800d,
	0x95ca,
	0x75bc,
	0x62fe,
	0x6bc5,
	0x5237,
	0x5857,
	0x593e,
	0x88c2,
	0x9640,
	0x54c9,
	0x9130,
	0x6085,
	0x5951,
	0x8f5f,
	0x7235,
	0x5c4f,
	0x99d0,
	0x8ced,
	0x8702,
	0x6247,
	0x7f9e,
	0x74e6,
	0x758f,
	0x6b3d,
	0x6597,
	0x5764,
	0x582a,
	0x6d29,
	0x9006,
	0x62ac,
	0x54ce,
	0x9905,
	0x5f4c,
	0x8cab,
	0x7db1,
	0x60f9,
	0x7ff9,
	0x58ae,
	0x72e0,
	0x9811,
	0x838e,
	0x64e6,
	0x8d08,
	0x51dd,
	0x6ecb,
	0x9756,
	0x5582,
	0x5141,
	0x5f6d,
	0x633a,
	0x62cb,
	0x611a,
	0x5f81,
	0x8fb1,
	0x6717,
	0x4f59,
	0x6170,
	0x79aa,
	0x86d9,
	0x79e6,
	0x707d,
	0x5075,
	0x8b9a,
	0x6905,
	0x5925,
	0x7897,
	0x4e19,
	0x5352,
	0x8377,
	0x62ab,
	0x8da8,
	0x52ab,
	0x8fc5,
	0x7b1b,
	0x70e4,
	0x80a9,
	0x77e3,
	0x9077,
	0x6c5d,
	0x9e7f,
	0x7f38,
	0x617e,
	0x7210,
	0x9b45,
	0x4e08,
	0x5de1,
	0x63aa,
	0x79e4,
	0x6cbf,
	0x75d5,
	0x6feb,
	0x6f32,
	0x8170,
	0x8ce4,
	0x59a5,
	0x6db2,
	0x9d5d,
	0x8ecc,
	0x53d4,
	0x9675,
	0x8c9e,
	0x626d,
	0x6f20,
	0x7955,
	0x8766,
	0x6349,
	0x8b20,
	0x6c1b,
	0x81a0,
	0x905e,
	0x9716,
	0x96ef,
	0x9ad2,
	0x5006,
	0x65fa,
	0x6749,
	0x71d5,
	0x5bf8,
	0x8302,
	0x5faa,
	0x5c4d,
	0x947d,
	0x6643,
	0x6084,
	0x7fc5,
	0x8292,
	0x659c,
	0x5ec1,
	0x5466,
	0x6e9c,
	0x9db4,
	0x55aa,
	0x76d2,
	0x6454,
	0x6127,
	0x7051,
	0x6d25,
	0x76c8,
	0x8108,
	0x82d7,
	0x5821,
	0x5211,
	0x53c9,
	0x6492,
	0x866b,
	0x7e8f,
	0x9075,
	0x81e3,
	0x6afb,
	0x626e,
	0x6e3e,
	0x5641,
	0x8d81,
	0x5448,
	0x7262,
	0x6cca,
	0x6b20,
	0x614e,
	0x7433,
	0x5026,
	0x8150,
	0x86c7,
	0x641c,
	0x60a3,
	0x4f0f,
	0x9676,
	0x67ef,
	0x52a3,
	0x75b2,
	0x5132,
	0x687f,
	0x7942,
	0x5851,
	0x84c9,
	0x7e6b,
	0x75be,
	0x6ce3,
	0x7c92,
	0x6e34,
	0x7483,
	0x8332,
	0x9127,
	0x6b6a,
	0x68df,
	0x9a30,
	0x73bb,
	0x5a1f,
	0x53e1,
	0x8fd4,
	0x4f75,
	0x5f0a,
	0x57cb,
	0x6649,
	0x7a00,
	0x9d28,
	0x6c57,
	0x7261,
	0x66a2,
	0x6dfb,
	0x5996,
	0x5291,
	0x6cdb,
	0x67f4,
	0x6770,
	0x651c,
	0x98c6,
	0x58c7,
	0x962e,
	0x5306,
	0x559a,
	0x6606,
	0x62f7,
	0x5102,
	0x65a5,
	0x5782,
	0x840d,
	0x52fe,
	0x50ac,
	0x7cd6,
	0x6f8e,
	0x8e29,
	0x6ac3,
	0x87fb,
	0x8ca9,
	0x6291,
	0x8679,
	0x6f58,
	0x5751,
	0x66f9,
	0x66ae,
	0x8179,
	0x716e,
	0x8972,
	0x4eff,
	0x81c2,
	0x543b,
	0x6d74,
	0x6846,
	0x6572,
	0x4f51,
	0x4f53,
	0x5f77,
	0x8b39,
	0x5cb3,
	0x6558,
	0x8cca,
	0x7f50,
	0x5be1,
	0x71e6,
	0x4fb6,
	0x6524,
	0x82ad,
	0x7fe0,
	0x7fa8,
	0x5360,
	0x7dbf,
	0x8b0e,
	0x63a9,
	0x55bb,
	0x79e9,
	0x714c,
	0x8ce0,
	0x7c64,
	0x73ca,
	0x99a8,
	0x672d,
	0x8105,
	0x65e8,
	0x62d8,
	0x7d10,
	0x55b2,
	0x8822,
	0x8a60,
	0x5319,
	0x7faf,
	0x6514,
	0x819a,
	0x9a5f,
	0x5ac1,
	0x5edf,
	0x5b55,
	0x4fc4,
	0x809d,
	0x7f69,
	0x8178,
	0x53db,
	0x532a,
	0x5009,
	0x5378,
	0x796d,
	0x888d,
	0x8b0a,
	0x57d4,
	0x51e0,
	0x8cbf,
	0x9b4f,
	0x79a6,
	0x8e34,
	0x860b,
	0x535c,
	0x6f84,
	0x9e9f,
	0x5bb5,
	0x964c,
	0x964b,
	0x5c48,
	0x8877,
	0x5d17,
	0x76ea,
	0x66c6,
	0x60df,
	0x820c,
	0x532f,
	0x8a98,
	0x6842,
	0x5a1c,
	0x83c1,
	0x7779,
	0x6bbf,
	0x5085,
	0x5492,
	0x8b19,
	0x96c0,
	0x7cbd,
	0x5353,
	0x9470,
	0x658c,
	0x8896,
	0x9215,
	0x5a9a,
	0x53ee,
	0x7ff0,
	0x582f,
	0x76e7,
	0x6367,
	0x58f9,
	0x61a4,
	0x7334,
	0x7cb9,
	0x8de8,
	0x879e,
	0x57c3,
	0x6789,
	0x537f,
	0x6495,
	0x7d0b,
	0x744b,
	0x5212,
	0x56c2,
	0x96d5,
	0x4e73,
	0x8180,
	0x4ed7,
	0x8d6b,
	0x7b52,
	0x8f9c,
	0x6876,
	0x5f7f,
	0x8870,
	0x7375,
	0x8b6c,
	0x52f3,
	0x886b,
	0x61c7,
	0x74ca,
	0x51cd,
	0x621a,
	0x7a4e,
	0x8ef8,
	0x6b96,
	0x64a4,
	0x540b,
	0x5bee,
	0x6f6d,
	0x59fb,
	0x8eba,
	0x6a11,
	0x6602,
	0x6f51,
	0x8154,
	0x9f90,
	0x6fb3,
	0x77ac,
	0x5bfa,
	0x9285,
	0x95a9,
	0x80a2,
	0x7cfe,
	0x53e2,
	0x5351,
	0x62d3,
	0x5bb0,
	0x934a,
	0x6e4a,
	0x68ad,
	0x8463,
	0x5b85,
	0x522e,
	0x80c3,
	0x829d,
	0x6dcb,
	0x6583,
	0x9a55,
	0x5978,
	0x6bb7,
	0x5893,
	0x511f,
	0x51a5,
	0x7092,
	0x6f64,
	0x8569,
	0x5984,
	0x7838,
	0x9913,
	0x624e,
	0x4f47,
	0x5c3f,
	0x7737,
	0x6fd5,
	0x76f2,
	0x507d,
	0x8e10,
	0x6deb,
	0x9f0e,
	0x8ca7,
	0x8b2c,
	0x77e9,
	0x87d1,
	0x99c1,
	0x5146,
	0x6df5,
	0x68cd,
	0x99b3,
	0x7199,
	0x6276,
	0x8058,
	0x65ac,
	0x7a74,
	0x69fd,
	0x8a6d,
	0x6627,
	0x6fa1,
	0x8782,
	0x8fa3,
	0x5339,
	0x868a,
	0x50e7,
	0x67f1,
	0x632b,
	0x8881,
	0x7c60,
	0x6296,
	0x8a1d,
	0x52c3,
	0x985b,
	0x6dd8,
	0x64b2,
	0x4e18,
	0x541e,
	0x4ead,
	0x761f,
	0x7662,
	0x8086,
	0x6f06,
	0x8a57,
	0x5c39,
	0x7329,
	0x5e16,
	0x4f50,
	0x6631,
	0x54b3,
	0x7948,
	0x8a79,
	0x6bcb,
	0x77ee,
	0x82d1,
	0x8cc4,
	0x7dfb,
	0x5a49,
	0x65a4,
	0x9952,
	0x95d6,
	0x6208,
	0x6b67,
	0x8af7,
	0x71ac,
	0x8a3a,
	0x971c,
	0x8ae7,
	0x6399,
	0x921e,
	0x8993,
	0x701f,
	0x5c51,
	0x75de,
	0x92ea,
	0x9ecf,
	0x9063,
	0x8e48,
	0x61f8,
	0x8a6e,
	0x5ca1,
	0x8774,
	0x6c41,
	0x650f,
	0x5e06,
	0x58fa,
	0x745f,
	0x96c1,
	0x8fb0,
	0x5a77,
	0x7a57,
	0x6168,
	0x54fc,
	0x6dd2,
	0x4f6c,
	0x819c,
	0x8085,
	0x6ffe,
	0x6d82,
	0x8303,
	0x6055,
	0x91ac,
	0x7e96,
	0x8f3b,
	0x61ff,
	0x7a1a,
	0x90c1,
	0x52df,
	0x8c6b,
	0x8247,
	0x67af,
	0x63b0,
	0x5bf5,
	0x9068,
	0x5e76,
	0x6f01,
	0x6df9,
	0x5ca9,
	0x588a,
	0x97ad,
	0x7e2b,
	0x99ff,
	0x6b79,
	0x6591,
	0x7504,
	0x7aff,
	0x99dd,
	0x6614,
	0x5d0e,
	0x51a4,
	0x68f5,
	0x50d5,
	0x758a,
	0x7b8f,
	0x524e,
	0x589c,
	0x906e,
	0x87ba,
	0x714e,
	0x85b0,
	0x766e,
	0x881f,
	0x778e,
	0x79b1,
	0x7693,
	0x574e,
	0x8482,
	0x7109,
	0x9b41,
	0x5507,
	0x72ac,
	0x5f13,
	0x9336,
	0x7c72,
	0x5a1b,
	0x7529,
	0x98b1,
	0x5c4e,
	0x6cbe,
	0x64ab,
	0x5098,
	0x5b0c,
	0x932b,
	0x5514,
	0x90dd,
	0x79bf,
	0x6dea,
	0x525d,
	0x63ed,
	0x6eb6,
	0x8087,
	0x533f,
	0x8d9f,
	0x76c6,
	0x6e67,
	0x574a,
	0x78b3,
	0x8d74,
	0x7d43,
	0x78da,
	0x6817,
	0x72f9,
	0x5eff,
	0x83ca,
	0x560e,
	0x7626,
	0x5974,
	0x6c27,
	0x9839,
	0x748b,
	0x9a62,
	0x754f,
	0x73ee,
	0x50b5,
	0x6467,
	0x9e7d,
	0x5679,
	0x5653,
	0x633d,
	0x58be,
	0x971e,
	0x4f10,
	0x7554,
	0x97cb,
	0x59ec,
	0x900d,
	0x7469,
	0x813e,
	0x561f,
	0x5e15,
	0x566a,
	0x7a6b,
	0x7e1b,
	0x6688,
	0x88d9,
	0x9838,
	0x7aca,
	0x6fc1,
	0x5cfd,
	0x5018,
	0x860a,
	0x9935,
	0x56ca,
	0x9709,
	0x8587,
	0x5243,
	0x884d,
	0x8a23,
	0x5ec2,
	0x81df,
	0x6795,
	0x614c,
	0x8c54,
	0x6e58,
	0x7184,
	0x7426,
	0x84c4,
	0x524a,
	0x9d6c,
	0x5238,
	0x6e3a,
	0x81d8,
	0x4f3a,
	0x857e,
	0x77e2,
	0x6328,
	0x6f3f,
	0x5a36,
	0x5eda,
	0x775c,
	0x8650,
	0x859b,
	0x84ec,
	0x57ae,
	0x66a8,
	0x947c,
	0x9042,
	0x55a7,
	0x91d8,
	0x5835,
	0x9187,
	0x5b30,
	0x8015,
	0x6ff1,
	0x846c,
	0x5c65,
	0x8271,
	0x7def,
	0x59e6,
	0x646f,
	0x9d09,
	0x84b8,
	0x8461,
	0x5690,
	0x752b,
	0x74bf,
	0x970d,
	0x5c09,
	0x5993,
	0x68c9,
	0x79c9,
	0x7239,
	0x6488,
	0x7d81,
	0x7fe9,
	0x5638,
	0x547b,
	0x62c2,
	0x8cb3,
	0x71ed,
	0x61f2,
	0x5bb4,
	0x6487,
	0x720d,
	0x6c70,
	0x6b47,
	0x764c,
	0x5495,
	0x5d29,
	0x81a9,
	0x64b0,
	0x6a38,
	0x68fa,
	0x980c,
	0x9b44,
	0x821c,
	0x8543,
	0x5bc7,
	0x8404,
	0x599d,
	0x907c,
	0x8944,
	0x85af,
	0x66dd,
	0x8aee,
	0x863f,
	0x9812,
	0x83cc,
	0x56ae,
	0x6c13,
	0x679a,
	0x916c,
	0x99ae,
	0x5632,
	0x6a58,
	0x4fae,
	0x7058,
	0x5c62,
	0x6b4e,
	0x5de2,
	0x9ad3,
	0x7891,
	0x68a8,
	0x7926,
	0x758b,
	0x8139,
	0x8cc8,
	0x8b74,
	0x60b8,
	0x7149,
	0x80cf,
	0x8c79,
	0x64c5,
	0x8fe6,
	0x8836,
	0x808c,
	0x6500,
	0x5375,
	0x95e2,
	0x70b3,
	0x560d,
	0x76de,
	0x9119,
	0x6d66,
	0x5c2c,
	0x5f17,
	0x682a,
	0x722a,
	0x6292,
	0x4f8d,
	0x962a,
	0x7947,
	0x9017,
	0x5589,
	0x683d,
	0x75ab,
	0x9eef,
	0x98fc,
	0x92c1,
	0x925b,
	0x5288,
	0x8258,
	0x4ed5,
	0x5dbc,
	0x90ca,
	0x91f5,
	0x9d70,
	0x88f8,
	0x562f,
	0x749e,
	0x51f6,
	0x9803,
	0x5bd3,
	0x72f8,
	0x67c4,
	0x632a,
	0x6c9b,
	0x9c31,
	0x549a,
	0x82b7,
	0x5f59,
	0x8c4e,
	0x50da,
	0x59dc,
	0x7a84,
	0x6756,
	0x5029,
	0x515c,
	0x5eca,
	0x71d9,
	0x60f6,
	0x5436,
	0x797a,
	0x803f,
	0x93d8,
	0x7dbd,
	0x8fc4,
	0x67f5,
	0x5937,
	0x62d9,
	0x7165,
	0x5992,
	0x9dd7,
	0x6eaf,
	0x8805,
	0x6c8c,
	0x8046,
	0x6f70,
	0x652a,
	0x543c,
	0x7aed,
	0x78ca,
	0x7784,
	0x553e,
	0x68f2,
	0x5021,
	0x638f,
	0x4ffa,
	0x6d78,
	0x914c,
	0x7e6d,
	0x8299,
	0x6963,
	0x62bc,
	0x5366,
	0x82db,
	0x9d3f,
	0x51f8,
	0x5320,
	0x60bc,
	0x86db,
	0x7e69,
	0x63a0,
	0x66b1,
	0x779e,
	0x828b,
	0x8525,
	0x58b3,
	0x62ef,
	0x5564,
	0x524b,
	0x9015,
	0x8335,
	0x4f6e,
	0x6ed4,
	0x5d14,
	0x5b9b,
	0x8d16,
	0x87ec,
	0x8549,
	0x8cb6,
	0x88f9,
	0x71c4,
	0x6726,
	0x82bd,
	0x5fa1,
	0x72c4,
	0x986b,
	0x502a,
	0x71e5,
	0x555e,
	0x9821,
	0x6a3a,
	0x60f0,
	0x8373,
	0x7ce7,
	0x8cb8,
	0x7950,
	0x70ab,
	0x65ec,
	0x5662,
	0x9f63,
	0x9c49,
	0x7c3f,
	0x5598,
	0x7db8,
	0x8165,
	0x6577,
	0x608d,
	0x8882,
	0x50f5,
	0x5c37,
	0x7de0,
	0x6ab3,
	0x7d2e,
	0x65a7,
	0x895f,
	0x8f44,
	0x8096,
	0x920d,
	0x816b,
	0x6aac,
	0x8e72,
	0x55dc,
	0x903e,
	0x7011,
	0x7f55,
	0x7652,
	0x788c,
	0x8fcb,
	0x7a3b,
	0x8b5a,
	0x64bc,
	0x798e,
	0x88cf,
	0x51cb,
	0x54e8,
	0x6398,
	0x6f80,
	0x91c1,
	0x6c59,
	0x5e9a,
	0x615a,
	0x96a7,
	0x81a8,
	0x8a50,
	0x91c0,
	0x8102,
	0x572d,
	0x51f3,
	0x946b,
	0x69d3,
	0x7dba,
	0x62ed,
	0x634f,
	0x62d0,
	0x745b,
	0x918b,
	0x851a,
	0x7b60,
	0x9daf,
	0x95c7,
	0x4f36,
	0x66ec,
	0x9b0d,
	0x819d,
	0x4e9f,
	0x5345,
	0x66e0,
	0x6289,
	0x60d8,
	0x6ea2,
	0x5256,
	0x5583,
	0x7409,
	0x7ac5,
	0x8778,
	0x5443,
	0x5321,
	0x902e,
	0x6994,
	0x5955,
	0x508d,
	0x6ab8,
	0x9264,
	0x896a,
	0x6687,
	0x6273,
	0x68b5,
	0x6cd3,
	0x6d85,
	0x5201,
	0x8f3e,
	0x8514,
	0x6590,
	0x634d,
	0x8073,
	0x75a4,
	0x8718,
	0x59da,
	0x5fff,
	0x604d,
	0x9edb,
	0x701a,
	0x8ae6,
	0x5824,
	0x7a9f,
	0x7be0,
	0x4edf,
	0x7e61,
	0x6689,
	0x55f6,
	0x7aba,
	0x6666,
	0x6e1d,
	0x79a7,
	0x5203,
	0x6cab,
	0x8475,
	0x5323,
	0x6960,
	0x96b8,
	0x8f4e,
	0x5614,
	0x853d,
	0x7dbb,
	0x4e1e,
	0x8adc,
	0x896f,
	0x6670,
	0x818f,
	0x7a88,
	0x5695,
	0x8606,
	0x6582,
	0x76ba,
	0x5cfb,
	0x5b70,
	0x4ec4,
	0x700f,
	0x6d95,
	0x9214,
	0x6cae,
	0x64f2,
	0x7a95,
	0x717d,
	0x88b1,
	0x8755,
	0x7d46,
	0x8339,
	0x77aa,
	0x4e10,
	0x8205,
	0x8a70,
	0x61fa,
	0x9e79,
	0x9310,
	0x4e11,
	0x6df3,
	0x711a,
	0x6e89,
	0x6bd3,
	0x8490,
	0x6233,
	0x96db,
	0x95d5,
	0x4f70,
	0x923a,
	0x54c4,
	0x83f1,
	0x80ba,
	0x8ec0,
	0x82b8,
	0x59e8,
	0x58df,
	0x76ef,
	0x5962,
	0x5dfe,
	0x69c3,
	0x7d17,
	0x83f8,
	0x51f9,
	0x8155,
	0x7fdf,
	0x6020,
	0x87fe,
	0x852d,
	0x5e84,
	0x5bf0,
	0x56e1,
	0x7444,
	0x994b,
	0x9631,
	0x9776,
	0x814e,
	0x64f1,
	0x640f,
	0x95cc,
	0x7a46,
	0x5471,
	0x7280,
	0x98e2,
	0x8e7a,
	0x75b5,
	0x7464,
	0x6a35,
	0x9d1b,
	0x8f12,
	0x95a5,
	0x7428,
	0x61a7,
	0x52fb,
	0x6417,
	0x9699,
	0x60b5,
	0x865e,
	0x8dea,
	0x4e5e,
	0x901e,
	0x5b7d,
	0x7030,
	0x6995,
	0x5fbd,
	0x8700,
	0x8783,
	0x4fcf,
	0x6dc6,
	0x4e30,
	0x8431,
	0x4fef,
	0x655e,
	0x6e23,
	0x7ddd,
	0x8a5b,
	0x7d33,
	0x5c50,
	0x773a,
	0x54ab,
	0x6eba,
	0x7586,
	0x9945,
	0x74cf,
	0x5c6f,
	0x6cb8,
	0x9903,
	0x9d26,
	0x592d,
	0x61ac,
	0x99f1,
	0x82b9,
	0x8466,
	0x5f98,
	0x7ac4,
	0x8b17,
	0x557c,
	0x56da,
	0x7d6e,
	0x9438,
	0x4e4d,
	0x8559,
	0x6746,
	0x5197,
	0x7c27,
	0x810a,
	0x7738,
	0x613f,
	0x8db4,
	0x6eef,
	0x8c82,
	0x5636,
	0x62f1,
	0x6380,
	0x8403,
	0x5f57,
	0x90b5,
	0x5fa8,
	0x8f3f,
	0x672e,
	0x5dcd,
	0x5f8a,
	0x53e9,
	0x599e,
	0x4f8f,
	0x82df,
	0x5420,
	0x5629,
	0x618a,
	0x8305,
	0x77ef,
	0x9082,
	0x6aaf,
	0x939a,
	0x79bd,
	0x68e0,
	0x5d16,
	0x6f86,
	0x5544,
	0x6302,
	0x929c,
	0x673d,
	0x5ad6,
	0x6c50,
	0x63e3,
	0x5be5,
	0x5fac,
	0x755c,
	0x7455,
	0x6c3e,
	0x8d66,
	0x7b71,
	0x7ca5,
	0x7a1c,
	0x8654,
	0x6e5b,
	0x5d19,
	0x77bb,
	0x61e6,
	0x6ef2,
	0x5121,
	0x797f,
	0x7c3e,
	0x64d2,
	0x840e,
	0x6f88,
	0x84d3,
	0x78cb,
	0x81b3,
	0x7009,
	0x86a4,
	0x6912,
	0x5115,
	0x584c,
	0x83bd,
	0x742e,
	0x58e4,
	0x77fd,
	0x5f27,
	0x830d,
	0x8116,
	0x61ab,
	0x9b4e,
	0x93c8,
	0x854a,
	0x935b,
	0x594e,
	0x56bc,
	0x7cd7,
	0x6977,
	0x8301,
	0x504e,
	0x78c5,
	0x7b19,
	0x8513,
	0x6043,
	0x9685,
	0x990c,
	0x88d8,
	0x4fd0,
	0x62da,
	0x5ed3,
	0x9112,
	0x70d8,
	0x6c40,
	0x9444,
	0x5d11,
	0x9452,
	0x56b7,
	0x8396,
	0x5678,
	0x7164,
	0x52d8,
	0x6bb2,
	0x6a3d,
	0x6254,
	0x674f,
	0x703e,
	0x5ec8,
	0x564e,
	0x7a62,
	0x99b4,
	0x5cd9,
	0x5384,
	0x8eac,
	0x50fb,
	0x9165,
	0x6bc6,
	0x90e4,
	0x66d6,
	0x7e7d,
	0x4f3d,
	0x9594,
	0x8511,
	0x831c,
	0x8e81,
	0x8aa1,
	0x7e55,
	0x548e,
	0x93fd,
	0x6dcc,
	0x66dc,
	0x625b,
	0x9830,
	0x4f6b,
	0x9e92,
	0x5580,
	0x849e,
	0x82a5,
	0x9005,
	0x96c7,
	0x659f,
	0x83c7,
	0x8aa6,
	0x77b3,
	0x82d4,
	0x6a01,
	0x61cb,
	0x66f3,
	0x6ef7,
	0x958f,
	0x803d,
	0x99ed,
	0x7cde,
	0x536f,
	0x5c94,
	0x7435,
	0x8e4b,
	0x79b9,
	0x6c72,
	0x500c,
	0x55e1,
	0x6ccc,
	0x634c,
	0x7682,
	0x665d,
	0x6e26,
	0x5cb1,
	0x68b3,
	0x8393,
	0x777f,
	0x92f8,
	0x778c,
	0x8f45,
	0x60d5,
	0x5eec,
	0x65fb,
	0x9041,
	0x8d13,
	0x7901,
	0x6bef,
	0x7d68,
	0x6dc7,
	0x7526,
	0x8392,
	0x7cb5,
	0x710a,
	0x7028,
	0x9698,
	0x5ae9,
	0x85d0,
	0x57a2,
	0x8076,
	0x8b4f,
	0x6064,
	0x602f,
	0x5cab,
	0x5dd6,
	0x5016,
	0x8a36,
	0x88d4,
	0x87c4,
	0x542d,
	0x8de4,
	0x5630,
	0x6893,
	0x93a7,
	0x9c57,
	0x75d8,
	0x6714,
	0x9a01,
	0x9a40,
	0x77c7,
	0x690e,
	0x568e,
	0x91d0,
	0x6a44,
	0x4ea5,
	0x9f94,
	0x6fdb,
	0x4fde,
	0x6b83,
	0x5e5f,
	0x5543,
	0x6b16,
	0x6413,
	0x74e3,
	0x5983,
	0x5671,
	0x57e0,
	0x786b,
	0x88ca,
	0x95bb,
	0x72e1,
	0x6a59,
	0x8e44,
	0x8594,
	0x8c5a,
	0x70ad,
	0x7436,
	0x5180,
	0x795f,
	0x5599,
	0x9dfa,
	0x708a,
	0x7cd9,
	0x9761,
	0x5858,
	0x5ab3,
	0x7b77,
	0x61c8,
	0x5ac2,
	0x5edd,
	0x6a61,
	0x74e2,
	0x66b8,
	0x514c,
	0x6538,
	0x5506,
	0x585a,
	0x6ebc,
	0x642a,
	0x8304,
	0x819b,
	0x7949,
	0x6c2b,
	0x70ac,
	0x633e,
	0x74f7,
	0x652c,
	0x82d3,
	0x9706,
	0x8d05,
	0x6850,
	0x934d,
	0x72f7,
	0x5478,
	0x5ac9,
	0x8e39,
	0x5486,
	0x780c,
	0x6123,
	0x8722,
	0x85fb,
	0x7624,
	0x97a0,
	0x5885,
	0x7463,
	0x544e,
	0x725f,
	0x774f,
	0x90e1,
	0x9245,
	0x9957,
	0x9050,
	0x80fa,
	0x9704,
	0x733f,
	0x8760,
	0x6c90,
	0x645f,
	0x66e6,
	0x931a,
	0x5080,
	0x715a,
	0x71fc,
	0x97dc,
	0x7487,
	0x8277,
	0x4f83,
	0x759a,
	0x98ba,
	0x8e66,
	0x606c,
	0x74a7,
	0x9708,
	0x5c5c,
	0x7be4,
	0x54bd,
	0x834a,
	0x9d51,
	0x6636,
	0x8af1,
	0x5c4c,
	0x618e,
	0x88f3,
	0x9661,
	0x695e,
	0x6d36,
	0x8018,
	0x56a8,
	0x8398,
	0x6dfc,
	0x55e4,
	0x9175,
	0x9293,
	0x715c,
	0x9de5,
	0x539d,
	0x8f4d,
	0x55d3,
	0x5055,
	0x63cd,
	0x647a,
	0x7c2b,
	0x620c,
	0x70f9,
	0x978f,
	0x76d4,
	0x50ad,
	0x9aaf,
	0x70d9,
	0x86b1,
	0x6177,
	0x5db8,
	0x5f9c,
	0x5048,
	0x7130,
	0x557e,
	0x8a85,
	0x66d9,
	0x85f9,
	0x86b5,
	0x61a8,
	0x5ce8,
	0x60bd,
	0x78ef,
	0x6d93,
	0x84b2,
	0x8309,
	0x63c9,
	0x9591,
	0x749f,
	0x9951,
	0x7578,
	0x9bc9,
	0x9bfd,
	0x92ac,
	0x5c90,
	0x96cb,
	0x8aa8,
	0x7a3d,
	0x620a,
	0x81fb,
	0x7e43,
	0x6252,
	0x8235,
	0x5df3,
	0x7f94,
	0x776c,
	0x6041,
	0x7678,
	0x8259,
	0x7d21,
	0x7152,
	0x97cc,
	0x5f14,
	0x5a11,
	0x64f7,
	0x5195,
	0x7898,
	0x8c41,
	0x6473,
	0x8098,
	0x62a8,
	0x66c7,
	0x81c6,
	0x7194,
	0x99d2,
	0x58e9,
	0x7d5e,
	0x7587,
	0x73c8,
	0x809b,
	0x9ab7,
	0x6727,
	0x5a9b,
	0x5ae3,
	0x69a8,
	0x7e9c,
	0x892a,
	0x6600,
	0x8dbe,
	0x9179,
	0x67da,
	0x6414,
	0x7fb9,
	0x8216,
	0x7728,
	0x5807,
	0x9768,
	0x8759,
	END_OF_DATA
};

//
// Sample sentences
// 
const char *sentences[]={
	"天地玄黃　宇宙洪荒　日月盈昃　辰宿列張　寒來暑往　秋收冬藏",
	END_OF_DATA
};


//
// 
//
OrthographyData data={
	"Traditional Chinese",
	"中文正體字",
	0x8cc7,  //  資 zi1, resource material.
	values,
	"指薪修祜永綏吉劭",
	sentences
};

const OrthographyData *pData = &data;

}; // end of namespace

#endif
