// Code generated by go-swagger; DO NOT EDIT.

package models

// This file was generated by the swagger tool.
// Editing this file might prove futile when you re-run the swagger generate command

import (
	strfmt "github.com/go-openapi/strfmt"

	"github.com/go-openapi/errors"
	"github.com/go-openapi/swag"
	"github.com/go-openapi/validate"
)

// InstanceInfo Describes MicroVM instance information.
// swagger:model InstanceInfo
type InstanceInfo struct {

	// Application name.
	AppName string `json:"app_name,omitempty"`

	// MicroVM / instance ID.
	// Required: true
	ID *string `json:"id"`

	// The current detailed state of the Firecracker instance. This value is read-only for the control-plane.
	Started bool `json:"started,omitempty"`

	// MicroVM hypervisor build version.
	// Required: true
	VmmVersion *string `json:"vmm_version"`
}

// Validate validates this instance info
func (m *InstanceInfo) Validate(formats strfmt.Registry) error {
	var res []error

	if err := m.validateID(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateVmmVersion(formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *InstanceInfo) validateID(formats strfmt.Registry) error {

	if err := validate.Required("id", "body", m.ID); err != nil {
		return err
	}

	return nil
}

func (m *InstanceInfo) validateVmmVersion(formats strfmt.Registry) error {

	if err := validate.Required("vmm_version", "body", m.VmmVersion); err != nil {
		return err
	}

	return nil
}

// MarshalBinary interface implementation
func (m *InstanceInfo) MarshalBinary() ([]byte, error) {
	if m == nil {
		return nil, nil
	}
	return swag.WriteJSON(m)
}

// UnmarshalBinary interface implementation
func (m *InstanceInfo) UnmarshalBinary(b []byte) error {
	var res InstanceInfo
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*m = res
	return nil
}
