
/*

  KLayout Layout Viewer
  Copyright (C) 2006-2019 Matthias Koefferlein

  This program is free software; you can redistribute it and/or modify
  it under the terms of the GNU General Public License as published by
  the Free Software Foundation; either version 2 of the License, or
  (at your option) any later version.

  This program is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
  GNU General Public License for more details.

  You should have received a copy of the GNU General Public License
  along with this program; if not, write to the Free Software
  Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA

*/

/**
*  @file gsiDeclQAudioDecoder.cc 
*
*  DO NOT EDIT THIS FILE. 
*  This file has been created automatically
*/

#include <QAudioDecoder>
#include <QAudioBuffer>
#include <QAudioFormat>
#include <QChildEvent>
#include <QEvent>
#include <QIODevice>
#include <QMediaService>
#include <QMetaMethod>
#include <QObject>
#include <QThread>
#include <QTimerEvent>
#include "gsiQt.h"
#include "gsiQtMultimediaCommon.h"
#include "gsiDeclQtMultimediaTypeTraits.h"
#include <memory>

// -----------------------------------------------------------------------
// class QAudioDecoder

//  get static meta object

static void _init_smo (qt_gsi::GenericStaticMethod *decl)
{
  decl->set_return<const QMetaObject &> ();
}

static void _call_smo (const qt_gsi::GenericStaticMethod *, gsi::SerialArgs &, gsi::SerialArgs &ret) 
{
  ret.write<const QMetaObject &> (QAudioDecoder::staticMetaObject);
}


// QAudioFormat QAudioDecoder::audioFormat()


static void _init_f_audioFormat_c0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<QAudioFormat > ();
}

static void _call_f_audioFormat_c0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  ret.write<QAudioFormat > ((QAudioFormat)((QAudioDecoder *)cls)->audioFormat ());
}


// bool QAudioDecoder::bind(QObject *)


static void _init_f_bind_1302 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("arg1");
  decl->add_arg<QObject * > (argspec_0);
  decl->set_return<bool > ();
}

static void _call_f_bind_1302 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  QObject *arg1 = gsi::arg_reader<QObject * >() (args, heap);
  ret.write<bool > ((bool)((QAudioDecoder *)cls)->bind (arg1));
}


// bool QAudioDecoder::bufferAvailable()


static void _init_f_bufferAvailable_c0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<bool > ();
}

static void _call_f_bufferAvailable_c0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  ret.write<bool > ((bool)((QAudioDecoder *)cls)->bufferAvailable ());
}


// qint64 QAudioDecoder::duration()


static void _init_f_duration_c0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<qint64 > ();
}

static void _call_f_duration_c0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  ret.write<qint64 > ((qint64)((QAudioDecoder *)cls)->duration ());
}


// QAudioDecoder::Error QAudioDecoder::error()


static void _init_f_error_c0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<qt_gsi::Converter<QAudioDecoder::Error>::target_type > ();
}

static void _call_f_error_c0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  ret.write<qt_gsi::Converter<QAudioDecoder::Error>::target_type > ((qt_gsi::Converter<QAudioDecoder::Error>::target_type)qt_gsi::CppToQtAdaptor<QAudioDecoder::Error>(((QAudioDecoder *)cls)->error ()));
}


// QString QAudioDecoder::errorString()


static void _init_f_errorString_c0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<QString > ();
}

static void _call_f_errorString_c0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  ret.write<QString > ((QString)((QAudioDecoder *)cls)->errorString ());
}


// qint64 QAudioDecoder::position()


static void _init_f_position_c0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<qint64 > ();
}

static void _call_f_position_c0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  ret.write<qint64 > ((qint64)((QAudioDecoder *)cls)->position ());
}


// QAudioBuffer QAudioDecoder::read()


static void _init_f_read_c0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<QAudioBuffer > ();
}

static void _call_f_read_c0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  ret.write<QAudioBuffer > ((QAudioBuffer)((QAudioDecoder *)cls)->read ());
}


// void QAudioDecoder::setAudioFormat(const QAudioFormat &format)


static void _init_f_setAudioFormat_2509 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("format");
  decl->add_arg<const QAudioFormat & > (argspec_0);
  decl->set_return<void > ();
}

static void _call_f_setAudioFormat_2509 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  const QAudioFormat &arg1 = gsi::arg_reader<const QAudioFormat & >() (args, heap);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QAudioDecoder *)cls)->setAudioFormat (arg1);
}


// void QAudioDecoder::setSourceDevice(QIODevice *device)


static void _init_f_setSourceDevice_1447 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("device");
  decl->add_arg<QIODevice * > (argspec_0);
  decl->set_return<void > ();
}

static void _call_f_setSourceDevice_1447 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  QIODevice *arg1 = gsi::arg_reader<QIODevice * >() (args, heap);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QAudioDecoder *)cls)->setSourceDevice (arg1);
}


// void QAudioDecoder::setSourceFilename(const QString &fileName)


static void _init_f_setSourceFilename_2025 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("fileName");
  decl->add_arg<const QString & > (argspec_0);
  decl->set_return<void > ();
}

static void _call_f_setSourceFilename_2025 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  const QString &arg1 = gsi::arg_reader<const QString & >() (args, heap);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QAudioDecoder *)cls)->setSourceFilename (arg1);
}


// QIODevice *QAudioDecoder::sourceDevice()


static void _init_f_sourceDevice_c0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<QIODevice * > ();
}

static void _call_f_sourceDevice_c0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  ret.write<QIODevice * > ((QIODevice *)((QAudioDecoder *)cls)->sourceDevice ());
}


// QString QAudioDecoder::sourceFilename()


static void _init_f_sourceFilename_c0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<QString > ();
}

static void _call_f_sourceFilename_c0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  ret.write<QString > ((QString)((QAudioDecoder *)cls)->sourceFilename ());
}


// void QAudioDecoder::start()


static void _init_f_start_0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<void > ();
}

static void _call_f_start_0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QAudioDecoder *)cls)->start ();
}


// QAudioDecoder::State QAudioDecoder::state()


static void _init_f_state_c0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<qt_gsi::Converter<QAudioDecoder::State>::target_type > ();
}

static void _call_f_state_c0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  ret.write<qt_gsi::Converter<QAudioDecoder::State>::target_type > ((qt_gsi::Converter<QAudioDecoder::State>::target_type)qt_gsi::CppToQtAdaptor<QAudioDecoder::State>(((QAudioDecoder *)cls)->state ()));
}


// void QAudioDecoder::stop()


static void _init_f_stop_0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<void > ();
}

static void _call_f_stop_0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QAudioDecoder *)cls)->stop ();
}


// void QAudioDecoder::unbind(QObject *)


static void _init_f_unbind_1302 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("arg1");
  decl->add_arg<QObject * > (argspec_0);
  decl->set_return<void > ();
}

static void _call_f_unbind_1302 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  QObject *arg1 = gsi::arg_reader<QObject * >() (args, heap);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QAudioDecoder *)cls)->unbind (arg1);
}


// static QMultimedia::SupportEstimate QAudioDecoder::hasSupport(const QString &mimeType, const QStringList &codecs)


static void _init_f_hasSupport_4354 (qt_gsi::GenericStaticMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("mimeType");
  decl->add_arg<const QString & > (argspec_0);
  static gsi::ArgSpecBase argspec_1 ("codecs", true, "QStringList()");
  decl->add_arg<const QStringList & > (argspec_1);
  decl->set_return<qt_gsi::Converter<QMultimedia::SupportEstimate>::target_type > ();
}

static void _call_f_hasSupport_4354 (const qt_gsi::GenericStaticMethod * /*decl*/, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  const QString &arg1 = gsi::arg_reader<const QString & >() (args, heap);
  const QStringList &arg2 = args ? gsi::arg_reader<const QStringList & >() (args, heap) : gsi::arg_maker<const QStringList & >() (QStringList(), heap);
  ret.write<qt_gsi::Converter<QMultimedia::SupportEstimate>::target_type > ((qt_gsi::Converter<QMultimedia::SupportEstimate>::target_type)qt_gsi::CppToQtAdaptor<QMultimedia::SupportEstimate>(QAudioDecoder::hasSupport (arg1, arg2)));
}


// static QString QAudioDecoder::tr(const char *s, const char *c, int n)


static void _init_f_tr_4013 (qt_gsi::GenericStaticMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("s");
  decl->add_arg<const char * > (argspec_0);
  static gsi::ArgSpecBase argspec_1 ("c", true, "__null");
  decl->add_arg<const char * > (argspec_1);
  static gsi::ArgSpecBase argspec_2 ("n", true, "-1");
  decl->add_arg<int > (argspec_2);
  decl->set_return<QString > ();
}

static void _call_f_tr_4013 (const qt_gsi::GenericStaticMethod * /*decl*/, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  const char *arg1 = gsi::arg_reader<const char * >() (args, heap);
  const char *arg2 = args ? gsi::arg_reader<const char * >() (args, heap) : gsi::arg_maker<const char * >() (__null, heap);
  int arg3 = args ? gsi::arg_reader<int >() (args, heap) : gsi::arg_maker<int >() (-1, heap);
  ret.write<QString > ((QString)QAudioDecoder::tr (arg1, arg2, arg3));
}


// static QString QAudioDecoder::trUtf8(const char *s, const char *c, int n)


static void _init_f_trUtf8_4013 (qt_gsi::GenericStaticMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("s");
  decl->add_arg<const char * > (argspec_0);
  static gsi::ArgSpecBase argspec_1 ("c", true, "__null");
  decl->add_arg<const char * > (argspec_1);
  static gsi::ArgSpecBase argspec_2 ("n", true, "-1");
  decl->add_arg<int > (argspec_2);
  decl->set_return<QString > ();
}

static void _call_f_trUtf8_4013 (const qt_gsi::GenericStaticMethod * /*decl*/, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  const char *arg1 = gsi::arg_reader<const char * >() (args, heap);
  const char *arg2 = args ? gsi::arg_reader<const char * >() (args, heap) : gsi::arg_maker<const char * >() (__null, heap);
  int arg3 = args ? gsi::arg_reader<int >() (args, heap) : gsi::arg_maker<int >() (-1, heap);
  ret.write<QString > ((QString)QAudioDecoder::trUtf8 (arg1, arg2, arg3));
}


namespace gsi
{

static gsi::Methods methods_QAudioDecoder () {
  gsi::Methods methods;
  methods += new qt_gsi::GenericStaticMethod ("staticMetaObject", "@brief Obtains the static MetaObject for this class.", &_init_smo, &_call_smo);
  methods += new qt_gsi::GenericMethod (":audioFormat", "@brief Method QAudioFormat QAudioDecoder::audioFormat()\n", true, &_init_f_audioFormat_c0, &_call_f_audioFormat_c0);
  methods += new qt_gsi::GenericMethod ("bind", "@brief Method bool QAudioDecoder::bind(QObject *)\nThis is a reimplementation of QMediaObject::bind", false, &_init_f_bind_1302, &_call_f_bind_1302);
  methods += new qt_gsi::GenericMethod (":bufferAvailable", "@brief Method bool QAudioDecoder::bufferAvailable()\n", true, &_init_f_bufferAvailable_c0, &_call_f_bufferAvailable_c0);
  methods += new qt_gsi::GenericMethod ("duration", "@brief Method qint64 QAudioDecoder::duration()\n", true, &_init_f_duration_c0, &_call_f_duration_c0);
  methods += new qt_gsi::GenericMethod (":error", "@brief Method QAudioDecoder::Error QAudioDecoder::error()\n", true, &_init_f_error_c0, &_call_f_error_c0);
  methods += new qt_gsi::GenericMethod ("errorString", "@brief Method QString QAudioDecoder::errorString()\n", true, &_init_f_errorString_c0, &_call_f_errorString_c0);
  methods += new qt_gsi::GenericMethod ("position", "@brief Method qint64 QAudioDecoder::position()\n", true, &_init_f_position_c0, &_call_f_position_c0);
  methods += new qt_gsi::GenericMethod ("read", "@brief Method QAudioBuffer QAudioDecoder::read()\n", true, &_init_f_read_c0, &_call_f_read_c0);
  methods += new qt_gsi::GenericMethod ("setAudioFormat|audioFormat=", "@brief Method void QAudioDecoder::setAudioFormat(const QAudioFormat &format)\n", false, &_init_f_setAudioFormat_2509, &_call_f_setAudioFormat_2509);
  methods += new qt_gsi::GenericMethod ("setSourceDevice|sourceDevice=", "@brief Method void QAudioDecoder::setSourceDevice(QIODevice *device)\n", false, &_init_f_setSourceDevice_1447, &_call_f_setSourceDevice_1447);
  methods += new qt_gsi::GenericMethod ("setSourceFilename|sourceFilename=", "@brief Method void QAudioDecoder::setSourceFilename(const QString &fileName)\n", false, &_init_f_setSourceFilename_2025, &_call_f_setSourceFilename_2025);
  methods += new qt_gsi::GenericMethod (":sourceDevice", "@brief Method QIODevice *QAudioDecoder::sourceDevice()\n", true, &_init_f_sourceDevice_c0, &_call_f_sourceDevice_c0);
  methods += new qt_gsi::GenericMethod (":sourceFilename", "@brief Method QString QAudioDecoder::sourceFilename()\n", true, &_init_f_sourceFilename_c0, &_call_f_sourceFilename_c0);
  methods += new qt_gsi::GenericMethod ("start", "@brief Method void QAudioDecoder::start()\n", false, &_init_f_start_0, &_call_f_start_0);
  methods += new qt_gsi::GenericMethod (":state", "@brief Method QAudioDecoder::State QAudioDecoder::state()\n", true, &_init_f_state_c0, &_call_f_state_c0);
  methods += new qt_gsi::GenericMethod ("stop", "@brief Method void QAudioDecoder::stop()\n", false, &_init_f_stop_0, &_call_f_stop_0);
  methods += new qt_gsi::GenericMethod ("unbind", "@brief Method void QAudioDecoder::unbind(QObject *)\nThis is a reimplementation of QMediaObject::unbind", false, &_init_f_unbind_1302, &_call_f_unbind_1302);
  methods += gsi::qt_signal<bool > ("availabilityChanged(bool)", "availabilityChanged_bool", gsi::arg("available"), "@brief Signal declaration for QAudioDecoder::availabilityChanged(bool available)\nYou can bind a procedure to this signal.");
  methods += gsi::qt_signal<const qt_gsi::Converter<QMultimedia::AvailabilityStatus>::target_type & > ("availabilityChanged(QMultimedia::AvailabilityStatus)", "availabilityChanged_status", gsi::arg("availability"), "@brief Signal declaration for QAudioDecoder::availabilityChanged(QMultimedia::AvailabilityStatus availability)\nYou can bind a procedure to this signal.");
  methods += gsi::qt_signal<bool > ("bufferAvailableChanged(bool)", "bufferAvailableChanged", gsi::arg("arg1"), "@brief Signal declaration for QAudioDecoder::bufferAvailableChanged(bool)\nYou can bind a procedure to this signal.");
  methods += gsi::qt_signal ("bufferReady()", "bufferReady", "@brief Signal declaration for QAudioDecoder::bufferReady()\nYou can bind a procedure to this signal.");
  methods += gsi::qt_signal<QObject * > ("destroyed(QObject *)", "destroyed", gsi::arg("arg1"), "@brief Signal declaration for QAudioDecoder::destroyed(QObject *)\nYou can bind a procedure to this signal.");
  methods += gsi::qt_signal<qint64 > ("durationChanged(qint64)", "durationChanged", gsi::arg("duration"), "@brief Signal declaration for QAudioDecoder::durationChanged(qint64 duration)\nYou can bind a procedure to this signal.");
  methods += gsi::qt_signal<const qt_gsi::Converter<QAudioDecoder::Error>::target_type & > ("error(QAudioDecoder::Error)", "error_sig", gsi::arg("error"), "@brief Signal declaration for QAudioDecoder::error(QAudioDecoder::Error error)\nYou can bind a procedure to this signal.");
  methods += gsi::qt_signal ("finished()", "finished", "@brief Signal declaration for QAudioDecoder::finished()\nYou can bind a procedure to this signal.");
  methods += gsi::qt_signal<const QAudioFormat & > ("formatChanged(const QAudioFormat &)", "formatChanged", gsi::arg("format"), "@brief Signal declaration for QAudioDecoder::formatChanged(const QAudioFormat &format)\nYou can bind a procedure to this signal.");
  methods += gsi::qt_signal<bool > ("metaDataAvailableChanged(bool)", "metaDataAvailableChanged", gsi::arg("available"), "@brief Signal declaration for QAudioDecoder::metaDataAvailableChanged(bool available)\nYou can bind a procedure to this signal.");
  methods += gsi::qt_signal ("metaDataChanged()", "metaDataChanged", "@brief Signal declaration for QAudioDecoder::metaDataChanged()\nYou can bind a procedure to this signal.");
  methods += gsi::qt_signal<const QString &, const QVariant & > ("metaDataChanged(const QString &, const QVariant &)", "metaDataChanged_kv", gsi::arg("key"), gsi::arg("value"), "@brief Signal declaration for QAudioDecoder::metaDataChanged(const QString &key, const QVariant &value)\nYou can bind a procedure to this signal.");
  methods += gsi::qt_signal<int > ("notifyIntervalChanged(int)", "notifyIntervalChanged", gsi::arg("milliSeconds"), "@brief Signal declaration for QAudioDecoder::notifyIntervalChanged(int milliSeconds)\nYou can bind a procedure to this signal.");
  methods += gsi::qt_signal<qint64 > ("positionChanged(qint64)", "positionChanged", gsi::arg("position"), "@brief Signal declaration for QAudioDecoder::positionChanged(qint64 position)\nYou can bind a procedure to this signal.");
  methods += gsi::qt_signal ("sourceChanged()", "sourceChanged", "@brief Signal declaration for QAudioDecoder::sourceChanged()\nYou can bind a procedure to this signal.");
  methods += gsi::qt_signal<const qt_gsi::Converter<QAudioDecoder::State>::target_type & > ("stateChanged(QAudioDecoder::State)", "stateChanged", gsi::arg("newState"), "@brief Signal declaration for QAudioDecoder::stateChanged(QAudioDecoder::State newState)\nYou can bind a procedure to this signal.");
  methods += new qt_gsi::GenericStaticMethod ("hasSupport", "@brief Static method QMultimedia::SupportEstimate QAudioDecoder::hasSupport(const QString &mimeType, const QStringList &codecs)\nThis method is static and can be called without an instance.", &_init_f_hasSupport_4354, &_call_f_hasSupport_4354);
  methods += new qt_gsi::GenericStaticMethod ("tr", "@brief Static method QString QAudioDecoder::tr(const char *s, const char *c, int n)\nThis method is static and can be called without an instance.", &_init_f_tr_4013, &_call_f_tr_4013);
  methods += new qt_gsi::GenericStaticMethod ("trUtf8", "@brief Static method QString QAudioDecoder::trUtf8(const char *s, const char *c, int n)\nThis method is static and can be called without an instance.", &_init_f_trUtf8_4013, &_call_f_trUtf8_4013);
  return methods;
}

gsi::Class<QMediaObject> &qtdecl_QMediaObject ();

qt_gsi::QtNativeClass<QAudioDecoder> decl_QAudioDecoder (qtdecl_QMediaObject (), "QtMultimedia", "QAudioDecoder_Native",
  methods_QAudioDecoder (),
  "@hide\n@alias QAudioDecoder");

GSI_QTMULTIMEDIA_PUBLIC gsi::Class<QAudioDecoder> &qtdecl_QAudioDecoder () { return decl_QAudioDecoder; }

}


class QAudioDecoder_Adaptor : public QAudioDecoder, public qt_gsi::QtObjectBase
{
public:

  virtual ~QAudioDecoder_Adaptor();

  //  [adaptor ctor] QAudioDecoder::QAudioDecoder(QObject *parent)
  QAudioDecoder_Adaptor() : QAudioDecoder()
  {
    qt_gsi::QtObjectBase::init (this);
  }

  //  [adaptor ctor] QAudioDecoder::QAudioDecoder(QObject *parent)
  QAudioDecoder_Adaptor(QObject *parent) : QAudioDecoder(parent)
  {
    qt_gsi::QtObjectBase::init (this);
  }

  //  [expose] void QAudioDecoder::addPropertyWatch(QByteArray const &name)
  void fp_QAudioDecoder_addPropertyWatch_2309 (QByteArray const &name) {
    QAudioDecoder::addPropertyWatch(name);
  }

  //  [expose] bool QAudioDecoder::isSignalConnected(const QMetaMethod &signal)
  bool fp_QAudioDecoder_isSignalConnected_c2394 (const QMetaMethod &signal) const {
    return QAudioDecoder::isSignalConnected(signal);
  }

  //  [expose] int QAudioDecoder::receivers(const char *signal)
  int fp_QAudioDecoder_receivers_c1731 (const char *signal) const {
    return QAudioDecoder::receivers(signal);
  }

  //  [expose] void QAudioDecoder::removePropertyWatch(QByteArray const &name)
  void fp_QAudioDecoder_removePropertyWatch_2309 (QByteArray const &name) {
    QAudioDecoder::removePropertyWatch(name);
  }

  //  [expose] QObject *QAudioDecoder::sender()
  QObject * fp_QAudioDecoder_sender_c0 () const {
    return QAudioDecoder::sender();
  }

  //  [expose] int QAudioDecoder::senderSignalIndex()
  int fp_QAudioDecoder_senderSignalIndex_c0 () const {
    return QAudioDecoder::senderSignalIndex();
  }

  //  [adaptor impl] QMultimedia::AvailabilityStatus QAudioDecoder::availability()
  qt_gsi::Converter<QMultimedia::AvailabilityStatus>::target_type cbs_availability_c0_0() const
  {
    return qt_gsi::CppToQtAdaptor<QMultimedia::AvailabilityStatus>(QAudioDecoder::availability());
  }

  virtual QMultimedia::AvailabilityStatus availability() const
  {
    if (cb_availability_c0_0.can_issue()) {
      return qt_gsi::QtToCppAdaptor<QMultimedia::AvailabilityStatus>(cb_availability_c0_0.issue<QAudioDecoder_Adaptor, qt_gsi::Converter<QMultimedia::AvailabilityStatus>::target_type>(&QAudioDecoder_Adaptor::cbs_availability_c0_0)).cref();
    } else {
      return QAudioDecoder::availability();
    }
  }

  //  [emitter impl] void QAudioDecoder::availabilityChanged(bool available)
  void emitter_QAudioDecoder_availabilityChanged_864(bool available)
  {
    emit QAudioDecoder::availabilityChanged(available);
  }

  //  [emitter impl] void QAudioDecoder::availabilityChanged(QMultimedia::AvailabilityStatus availability)
  void emitter_QAudioDecoder_availabilityChanged_3555(QMultimedia::AvailabilityStatus availability)
  {
    emit QAudioDecoder::availabilityChanged(availability);
  }

  //  [adaptor impl] bool QAudioDecoder::bind(QObject *)
  bool cbs_bind_1302_0(QObject *arg1)
  {
    return QAudioDecoder::bind(arg1);
  }

  virtual bool bind(QObject *arg1)
  {
    if (cb_bind_1302_0.can_issue()) {
      return cb_bind_1302_0.issue<QAudioDecoder_Adaptor, bool, QObject *>(&QAudioDecoder_Adaptor::cbs_bind_1302_0, arg1);
    } else {
      return QAudioDecoder::bind(arg1);
    }
  }

  //  [emitter impl] void QAudioDecoder::bufferAvailableChanged(bool)
  void emitter_QAudioDecoder_bufferAvailableChanged_864(bool arg1)
  {
    emit QAudioDecoder::bufferAvailableChanged(arg1);
  }

  //  [emitter impl] void QAudioDecoder::bufferReady()
  void emitter_QAudioDecoder_bufferReady_0()
  {
    emit QAudioDecoder::bufferReady();
  }

  //  [emitter impl] void QAudioDecoder::destroyed(QObject *)
  void emitter_QAudioDecoder_destroyed_1302(QObject *arg1)
  {
    emit QAudioDecoder::destroyed(arg1);
  }

  //  [emitter impl] void QAudioDecoder::durationChanged(qint64 duration)
  void emitter_QAudioDecoder_durationChanged_986(qint64 duration)
  {
    emit QAudioDecoder::durationChanged(duration);
  }

  //  [emitter impl] void QAudioDecoder::error(QAudioDecoder::Error error)
  void emitter_QAudioDecoder_error_2347(QAudioDecoder::Error _error)
  {
    emit QAudioDecoder::error(_error);
  }

  //  [adaptor impl] bool QAudioDecoder::event(QEvent *)
  bool cbs_event_1217_0(QEvent *arg1)
  {
    return QAudioDecoder::event(arg1);
  }

  virtual bool event(QEvent *arg1)
  {
    if (cb_event_1217_0.can_issue()) {
      return cb_event_1217_0.issue<QAudioDecoder_Adaptor, bool, QEvent *>(&QAudioDecoder_Adaptor::cbs_event_1217_0, arg1);
    } else {
      return QAudioDecoder::event(arg1);
    }
  }

  //  [adaptor impl] bool QAudioDecoder::eventFilter(QObject *, QEvent *)
  bool cbs_eventFilter_2411_0(QObject *arg1, QEvent *arg2)
  {
    return QAudioDecoder::eventFilter(arg1, arg2);
  }

  virtual bool eventFilter(QObject *arg1, QEvent *arg2)
  {
    if (cb_eventFilter_2411_0.can_issue()) {
      return cb_eventFilter_2411_0.issue<QAudioDecoder_Adaptor, bool, QObject *, QEvent *>(&QAudioDecoder_Adaptor::cbs_eventFilter_2411_0, arg1, arg2);
    } else {
      return QAudioDecoder::eventFilter(arg1, arg2);
    }
  }

  //  [emitter impl] void QAudioDecoder::finished()
  void emitter_QAudioDecoder_finished_0()
  {
    emit QAudioDecoder::finished();
  }

  //  [emitter impl] void QAudioDecoder::formatChanged(const QAudioFormat &format)
  void emitter_QAudioDecoder_formatChanged_2509(const QAudioFormat &format)
  {
    emit QAudioDecoder::formatChanged(format);
  }

  //  [adaptor impl] bool QAudioDecoder::isAvailable()
  bool cbs_isAvailable_c0_0() const
  {
    return QAudioDecoder::isAvailable();
  }

  virtual bool isAvailable() const
  {
    if (cb_isAvailable_c0_0.can_issue()) {
      return cb_isAvailable_c0_0.issue<QAudioDecoder_Adaptor, bool>(&QAudioDecoder_Adaptor::cbs_isAvailable_c0_0);
    } else {
      return QAudioDecoder::isAvailable();
    }
  }

  //  [emitter impl] void QAudioDecoder::metaDataAvailableChanged(bool available)
  void emitter_QAudioDecoder_metaDataAvailableChanged_864(bool available)
  {
    emit QAudioDecoder::metaDataAvailableChanged(available);
  }

  //  [emitter impl] void QAudioDecoder::metaDataChanged()
  void emitter_QAudioDecoder_metaDataChanged_0()
  {
    emit QAudioDecoder::metaDataChanged();
  }

  //  [emitter impl] void QAudioDecoder::metaDataChanged(const QString &key, const QVariant &value)
  void emitter_QAudioDecoder_metaDataChanged_4036(const QString &key, const QVariant &value)
  {
    emit QAudioDecoder::metaDataChanged(key, value);
  }

  //  [emitter impl] void QAudioDecoder::notifyIntervalChanged(int milliSeconds)
  void emitter_QAudioDecoder_notifyIntervalChanged_767(int milliSeconds)
  {
    emit QAudioDecoder::notifyIntervalChanged(milliSeconds);
  }

  //  [emitter impl] void QAudioDecoder::positionChanged(qint64 position)
  void emitter_QAudioDecoder_positionChanged_986(qint64 position)
  {
    emit QAudioDecoder::positionChanged(position);
  }

  //  [adaptor impl] QMediaService *QAudioDecoder::service()
  QMediaService * cbs_service_c0_0() const
  {
    return QAudioDecoder::service();
  }

  virtual QMediaService * service() const
  {
    if (cb_service_c0_0.can_issue()) {
      return cb_service_c0_0.issue<QAudioDecoder_Adaptor, QMediaService *>(&QAudioDecoder_Adaptor::cbs_service_c0_0);
    } else {
      return QAudioDecoder::service();
    }
  }

  //  [emitter impl] void QAudioDecoder::sourceChanged()
  void emitter_QAudioDecoder_sourceChanged_0()
  {
    emit QAudioDecoder::sourceChanged();
  }

  //  [emitter impl] void QAudioDecoder::stateChanged(QAudioDecoder::State newState)
  void emitter_QAudioDecoder_stateChanged_2338(QAudioDecoder::State newState)
  {
    emit QAudioDecoder::stateChanged(newState);
  }

  //  [adaptor impl] void QAudioDecoder::unbind(QObject *)
  void cbs_unbind_1302_0(QObject *arg1)
  {
    QAudioDecoder::unbind(arg1);
  }

  virtual void unbind(QObject *arg1)
  {
    if (cb_unbind_1302_0.can_issue()) {
      cb_unbind_1302_0.issue<QAudioDecoder_Adaptor, QObject *>(&QAudioDecoder_Adaptor::cbs_unbind_1302_0, arg1);
    } else {
      QAudioDecoder::unbind(arg1);
    }
  }

  //  [adaptor impl] void QAudioDecoder::childEvent(QChildEvent *)
  void cbs_childEvent_1701_0(QChildEvent *arg1)
  {
    QAudioDecoder::childEvent(arg1);
  }

  virtual void childEvent(QChildEvent *arg1)
  {
    if (cb_childEvent_1701_0.can_issue()) {
      cb_childEvent_1701_0.issue<QAudioDecoder_Adaptor, QChildEvent *>(&QAudioDecoder_Adaptor::cbs_childEvent_1701_0, arg1);
    } else {
      QAudioDecoder::childEvent(arg1);
    }
  }

  //  [adaptor impl] void QAudioDecoder::customEvent(QEvent *)
  void cbs_customEvent_1217_0(QEvent *arg1)
  {
    QAudioDecoder::customEvent(arg1);
  }

  virtual void customEvent(QEvent *arg1)
  {
    if (cb_customEvent_1217_0.can_issue()) {
      cb_customEvent_1217_0.issue<QAudioDecoder_Adaptor, QEvent *>(&QAudioDecoder_Adaptor::cbs_customEvent_1217_0, arg1);
    } else {
      QAudioDecoder::customEvent(arg1);
    }
  }

  //  [adaptor impl] void QAudioDecoder::disconnectNotify(const QMetaMethod &signal)
  void cbs_disconnectNotify_2394_0(const QMetaMethod &signal)
  {
    QAudioDecoder::disconnectNotify(signal);
  }

  virtual void disconnectNotify(const QMetaMethod &signal)
  {
    if (cb_disconnectNotify_2394_0.can_issue()) {
      cb_disconnectNotify_2394_0.issue<QAudioDecoder_Adaptor, const QMetaMethod &>(&QAudioDecoder_Adaptor::cbs_disconnectNotify_2394_0, signal);
    } else {
      QAudioDecoder::disconnectNotify(signal);
    }
  }

  //  [adaptor impl] void QAudioDecoder::timerEvent(QTimerEvent *)
  void cbs_timerEvent_1730_0(QTimerEvent *arg1)
  {
    QAudioDecoder::timerEvent(arg1);
  }

  virtual void timerEvent(QTimerEvent *arg1)
  {
    if (cb_timerEvent_1730_0.can_issue()) {
      cb_timerEvent_1730_0.issue<QAudioDecoder_Adaptor, QTimerEvent *>(&QAudioDecoder_Adaptor::cbs_timerEvent_1730_0, arg1);
    } else {
      QAudioDecoder::timerEvent(arg1);
    }
  }

  gsi::Callback cb_availability_c0_0;
  gsi::Callback cb_bind_1302_0;
  gsi::Callback cb_event_1217_0;
  gsi::Callback cb_eventFilter_2411_0;
  gsi::Callback cb_isAvailable_c0_0;
  gsi::Callback cb_service_c0_0;
  gsi::Callback cb_unbind_1302_0;
  gsi::Callback cb_childEvent_1701_0;
  gsi::Callback cb_customEvent_1217_0;
  gsi::Callback cb_disconnectNotify_2394_0;
  gsi::Callback cb_timerEvent_1730_0;
};

QAudioDecoder_Adaptor::~QAudioDecoder_Adaptor() { }

//  Constructor QAudioDecoder::QAudioDecoder(QObject *parent) (adaptor class)

static void _init_ctor_QAudioDecoder_Adaptor_1302 (qt_gsi::GenericStaticMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("parent", true, "0");
  decl->add_arg<QObject * > (argspec_0);
  decl->set_return_new<QAudioDecoder_Adaptor> ();
}

static void _call_ctor_QAudioDecoder_Adaptor_1302 (const qt_gsi::GenericStaticMethod * /*decl*/, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  QObject *arg1 = args ? gsi::arg_reader<QObject * >() (args, heap) : gsi::arg_maker<QObject * >() (0, heap);
  ret.write<QAudioDecoder_Adaptor *> (new QAudioDecoder_Adaptor (arg1));
}


// exposed void QAudioDecoder::addPropertyWatch(QByteArray const &name)

static void _init_fp_addPropertyWatch_2309 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("name");
  decl->add_arg<QByteArray const & > (argspec_0);
  decl->set_return<void > ();
}

static void _call_fp_addPropertyWatch_2309 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  QByteArray const &arg1 = gsi::arg_reader<QByteArray const & >() (args, heap);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QAudioDecoder_Adaptor *)cls)->fp_QAudioDecoder_addPropertyWatch_2309 (arg1);
}


// QMultimedia::AvailabilityStatus QAudioDecoder::availability()

static void _init_cbs_availability_c0_0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<qt_gsi::Converter<QMultimedia::AvailabilityStatus>::target_type > ();
}

static void _call_cbs_availability_c0_0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  ret.write<qt_gsi::Converter<QMultimedia::AvailabilityStatus>::target_type > ((qt_gsi::Converter<QMultimedia::AvailabilityStatus>::target_type)((QAudioDecoder_Adaptor *)cls)->cbs_availability_c0_0 ());
}

static void _set_callback_cbs_availability_c0_0 (void *cls, const gsi::Callback &cb)
{
  ((QAudioDecoder_Adaptor *)cls)->cb_availability_c0_0 = cb;
}


// emitter void QAudioDecoder::availabilityChanged(bool available)

static void _init_emitter_availabilityChanged_864 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("available");
  decl->add_arg<bool > (argspec_0);
  decl->set_return<void > ();
}

static void _call_emitter_availabilityChanged_864 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs & /*ret*/) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  bool arg1 = gsi::arg_reader<bool >() (args, heap);
  ((QAudioDecoder_Adaptor *)cls)->emitter_QAudioDecoder_availabilityChanged_864 (arg1);
}


// emitter void QAudioDecoder::availabilityChanged(QMultimedia::AvailabilityStatus availability)

static void _init_emitter_availabilityChanged_3555 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("availability");
  decl->add_arg<const qt_gsi::Converter<QMultimedia::AvailabilityStatus>::target_type & > (argspec_0);
  decl->set_return<void > ();
}

static void _call_emitter_availabilityChanged_3555 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs & /*ret*/) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  const qt_gsi::Converter<QMultimedia::AvailabilityStatus>::target_type & arg1 = gsi::arg_reader<const qt_gsi::Converter<QMultimedia::AvailabilityStatus>::target_type & >() (args, heap);
  ((QAudioDecoder_Adaptor *)cls)->emitter_QAudioDecoder_availabilityChanged_3555 (arg1);
}


// bool QAudioDecoder::bind(QObject *)

static void _init_cbs_bind_1302_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("arg1");
  decl->add_arg<QObject * > (argspec_0);
  decl->set_return<bool > ();
}

static void _call_cbs_bind_1302_0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  QObject *arg1 = args.read<QObject * > (heap);
  ret.write<bool > ((bool)((QAudioDecoder_Adaptor *)cls)->cbs_bind_1302_0 (arg1));
}

static void _set_callback_cbs_bind_1302_0 (void *cls, const gsi::Callback &cb)
{
  ((QAudioDecoder_Adaptor *)cls)->cb_bind_1302_0 = cb;
}


// emitter void QAudioDecoder::bufferAvailableChanged(bool)

static void _init_emitter_bufferAvailableChanged_864 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("arg1");
  decl->add_arg<bool > (argspec_0);
  decl->set_return<void > ();
}

static void _call_emitter_bufferAvailableChanged_864 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs & /*ret*/) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  bool arg1 = gsi::arg_reader<bool >() (args, heap);
  ((QAudioDecoder_Adaptor *)cls)->emitter_QAudioDecoder_bufferAvailableChanged_864 (arg1);
}


// emitter void QAudioDecoder::bufferReady()

static void _init_emitter_bufferReady_0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<void > ();
}

static void _call_emitter_bufferReady_0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs & /*ret*/) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  ((QAudioDecoder_Adaptor *)cls)->emitter_QAudioDecoder_bufferReady_0 ();
}


// void QAudioDecoder::childEvent(QChildEvent *)

static void _init_cbs_childEvent_1701_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("arg1");
  decl->add_arg<QChildEvent * > (argspec_0);
  decl->set_return<void > ();
}

static void _call_cbs_childEvent_1701_0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  QChildEvent *arg1 = args.read<QChildEvent * > (heap);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QAudioDecoder_Adaptor *)cls)->cbs_childEvent_1701_0 (arg1);
}

static void _set_callback_cbs_childEvent_1701_0 (void *cls, const gsi::Callback &cb)
{
  ((QAudioDecoder_Adaptor *)cls)->cb_childEvent_1701_0 = cb;
}


// void QAudioDecoder::customEvent(QEvent *)

static void _init_cbs_customEvent_1217_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("arg1");
  decl->add_arg<QEvent * > (argspec_0);
  decl->set_return<void > ();
}

static void _call_cbs_customEvent_1217_0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  QEvent *arg1 = args.read<QEvent * > (heap);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QAudioDecoder_Adaptor *)cls)->cbs_customEvent_1217_0 (arg1);
}

static void _set_callback_cbs_customEvent_1217_0 (void *cls, const gsi::Callback &cb)
{
  ((QAudioDecoder_Adaptor *)cls)->cb_customEvent_1217_0 = cb;
}


// emitter void QAudioDecoder::destroyed(QObject *)

static void _init_emitter_destroyed_1302 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("arg1", true, "0");
  decl->add_arg<QObject * > (argspec_0);
  decl->set_return<void > ();
}

static void _call_emitter_destroyed_1302 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs & /*ret*/) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  QObject *arg1 = args ? gsi::arg_reader<QObject * >() (args, heap) : gsi::arg_maker<QObject * >() (0, heap);
  ((QAudioDecoder_Adaptor *)cls)->emitter_QAudioDecoder_destroyed_1302 (arg1);
}


// void QAudioDecoder::disconnectNotify(const QMetaMethod &signal)

static void _init_cbs_disconnectNotify_2394_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("signal");
  decl->add_arg<const QMetaMethod & > (argspec_0);
  decl->set_return<void > ();
}

static void _call_cbs_disconnectNotify_2394_0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  const QMetaMethod &arg1 = args.read<const QMetaMethod & > (heap);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QAudioDecoder_Adaptor *)cls)->cbs_disconnectNotify_2394_0 (arg1);
}

static void _set_callback_cbs_disconnectNotify_2394_0 (void *cls, const gsi::Callback &cb)
{
  ((QAudioDecoder_Adaptor *)cls)->cb_disconnectNotify_2394_0 = cb;
}


// emitter void QAudioDecoder::durationChanged(qint64 duration)

static void _init_emitter_durationChanged_986 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("duration");
  decl->add_arg<qint64 > (argspec_0);
  decl->set_return<void > ();
}

static void _call_emitter_durationChanged_986 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs & /*ret*/) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  qint64 arg1 = gsi::arg_reader<qint64 >() (args, heap);
  ((QAudioDecoder_Adaptor *)cls)->emitter_QAudioDecoder_durationChanged_986 (arg1);
}


// emitter void QAudioDecoder::error(QAudioDecoder::Error error)

static void _init_emitter_error_2347 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("error");
  decl->add_arg<const qt_gsi::Converter<QAudioDecoder::Error>::target_type & > (argspec_0);
  decl->set_return<void > ();
}

static void _call_emitter_error_2347 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs & /*ret*/) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  const qt_gsi::Converter<QAudioDecoder::Error>::target_type & arg1 = gsi::arg_reader<const qt_gsi::Converter<QAudioDecoder::Error>::target_type & >() (args, heap);
  ((QAudioDecoder_Adaptor *)cls)->emitter_QAudioDecoder_error_2347 (arg1);
}


// bool QAudioDecoder::event(QEvent *)

static void _init_cbs_event_1217_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("arg1");
  decl->add_arg<QEvent * > (argspec_0);
  decl->set_return<bool > ();
}

static void _call_cbs_event_1217_0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  QEvent *arg1 = args.read<QEvent * > (heap);
  ret.write<bool > ((bool)((QAudioDecoder_Adaptor *)cls)->cbs_event_1217_0 (arg1));
}

static void _set_callback_cbs_event_1217_0 (void *cls, const gsi::Callback &cb)
{
  ((QAudioDecoder_Adaptor *)cls)->cb_event_1217_0 = cb;
}


// bool QAudioDecoder::eventFilter(QObject *, QEvent *)

static void _init_cbs_eventFilter_2411_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("arg1");
  decl->add_arg<QObject * > (argspec_0);
  static gsi::ArgSpecBase argspec_1 ("arg2");
  decl->add_arg<QEvent * > (argspec_1);
  decl->set_return<bool > ();
}

static void _call_cbs_eventFilter_2411_0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  QObject *arg1 = args.read<QObject * > (heap);
  QEvent *arg2 = args.read<QEvent * > (heap);
  ret.write<bool > ((bool)((QAudioDecoder_Adaptor *)cls)->cbs_eventFilter_2411_0 (arg1, arg2));
}

static void _set_callback_cbs_eventFilter_2411_0 (void *cls, const gsi::Callback &cb)
{
  ((QAudioDecoder_Adaptor *)cls)->cb_eventFilter_2411_0 = cb;
}


// emitter void QAudioDecoder::finished()

static void _init_emitter_finished_0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<void > ();
}

static void _call_emitter_finished_0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs & /*ret*/) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  ((QAudioDecoder_Adaptor *)cls)->emitter_QAudioDecoder_finished_0 ();
}


// emitter void QAudioDecoder::formatChanged(const QAudioFormat &format)

static void _init_emitter_formatChanged_2509 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("format");
  decl->add_arg<const QAudioFormat & > (argspec_0);
  decl->set_return<void > ();
}

static void _call_emitter_formatChanged_2509 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs & /*ret*/) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  const QAudioFormat &arg1 = gsi::arg_reader<const QAudioFormat & >() (args, heap);
  ((QAudioDecoder_Adaptor *)cls)->emitter_QAudioDecoder_formatChanged_2509 (arg1);
}


// bool QAudioDecoder::isAvailable()

static void _init_cbs_isAvailable_c0_0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<bool > ();
}

static void _call_cbs_isAvailable_c0_0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  ret.write<bool > ((bool)((QAudioDecoder_Adaptor *)cls)->cbs_isAvailable_c0_0 ());
}

static void _set_callback_cbs_isAvailable_c0_0 (void *cls, const gsi::Callback &cb)
{
  ((QAudioDecoder_Adaptor *)cls)->cb_isAvailable_c0_0 = cb;
}


// exposed bool QAudioDecoder::isSignalConnected(const QMetaMethod &signal)

static void _init_fp_isSignalConnected_c2394 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("signal");
  decl->add_arg<const QMetaMethod & > (argspec_0);
  decl->set_return<bool > ();
}

static void _call_fp_isSignalConnected_c2394 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  const QMetaMethod &arg1 = gsi::arg_reader<const QMetaMethod & >() (args, heap);
  ret.write<bool > ((bool)((QAudioDecoder_Adaptor *)cls)->fp_QAudioDecoder_isSignalConnected_c2394 (arg1));
}


// emitter void QAudioDecoder::metaDataAvailableChanged(bool available)

static void _init_emitter_metaDataAvailableChanged_864 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("available");
  decl->add_arg<bool > (argspec_0);
  decl->set_return<void > ();
}

static void _call_emitter_metaDataAvailableChanged_864 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs & /*ret*/) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  bool arg1 = gsi::arg_reader<bool >() (args, heap);
  ((QAudioDecoder_Adaptor *)cls)->emitter_QAudioDecoder_metaDataAvailableChanged_864 (arg1);
}


// emitter void QAudioDecoder::metaDataChanged()

static void _init_emitter_metaDataChanged_0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<void > ();
}

static void _call_emitter_metaDataChanged_0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs & /*ret*/) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  ((QAudioDecoder_Adaptor *)cls)->emitter_QAudioDecoder_metaDataChanged_0 ();
}


// emitter void QAudioDecoder::metaDataChanged(const QString &key, const QVariant &value)

static void _init_emitter_metaDataChanged_4036 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("key");
  decl->add_arg<const QString & > (argspec_0);
  static gsi::ArgSpecBase argspec_1 ("value");
  decl->add_arg<const QVariant & > (argspec_1);
  decl->set_return<void > ();
}

static void _call_emitter_metaDataChanged_4036 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs & /*ret*/) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  const QString &arg1 = gsi::arg_reader<const QString & >() (args, heap);
  const QVariant &arg2 = gsi::arg_reader<const QVariant & >() (args, heap);
  ((QAudioDecoder_Adaptor *)cls)->emitter_QAudioDecoder_metaDataChanged_4036 (arg1, arg2);
}


// emitter void QAudioDecoder::notifyIntervalChanged(int milliSeconds)

static void _init_emitter_notifyIntervalChanged_767 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("milliSeconds");
  decl->add_arg<int > (argspec_0);
  decl->set_return<void > ();
}

static void _call_emitter_notifyIntervalChanged_767 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs & /*ret*/) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  int arg1 = gsi::arg_reader<int >() (args, heap);
  ((QAudioDecoder_Adaptor *)cls)->emitter_QAudioDecoder_notifyIntervalChanged_767 (arg1);
}


// emitter void QAudioDecoder::positionChanged(qint64 position)

static void _init_emitter_positionChanged_986 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("position");
  decl->add_arg<qint64 > (argspec_0);
  decl->set_return<void > ();
}

static void _call_emitter_positionChanged_986 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs & /*ret*/) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  qint64 arg1 = gsi::arg_reader<qint64 >() (args, heap);
  ((QAudioDecoder_Adaptor *)cls)->emitter_QAudioDecoder_positionChanged_986 (arg1);
}


// exposed int QAudioDecoder::receivers(const char *signal)

static void _init_fp_receivers_c1731 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("signal");
  decl->add_arg<const char * > (argspec_0);
  decl->set_return<int > ();
}

static void _call_fp_receivers_c1731 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  const char *arg1 = gsi::arg_reader<const char * >() (args, heap);
  ret.write<int > ((int)((QAudioDecoder_Adaptor *)cls)->fp_QAudioDecoder_receivers_c1731 (arg1));
}


// exposed void QAudioDecoder::removePropertyWatch(QByteArray const &name)

static void _init_fp_removePropertyWatch_2309 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("name");
  decl->add_arg<QByteArray const & > (argspec_0);
  decl->set_return<void > ();
}

static void _call_fp_removePropertyWatch_2309 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  QByteArray const &arg1 = gsi::arg_reader<QByteArray const & >() (args, heap);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QAudioDecoder_Adaptor *)cls)->fp_QAudioDecoder_removePropertyWatch_2309 (arg1);
}


// exposed QObject *QAudioDecoder::sender()

static void _init_fp_sender_c0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<QObject * > ();
}

static void _call_fp_sender_c0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  ret.write<QObject * > ((QObject *)((QAudioDecoder_Adaptor *)cls)->fp_QAudioDecoder_sender_c0 ());
}


// exposed int QAudioDecoder::senderSignalIndex()

static void _init_fp_senderSignalIndex_c0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<int > ();
}

static void _call_fp_senderSignalIndex_c0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  ret.write<int > ((int)((QAudioDecoder_Adaptor *)cls)->fp_QAudioDecoder_senderSignalIndex_c0 ());
}


// QMediaService *QAudioDecoder::service()

static void _init_cbs_service_c0_0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<QMediaService * > ();
}

static void _call_cbs_service_c0_0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  ret.write<QMediaService * > ((QMediaService *)((QAudioDecoder_Adaptor *)cls)->cbs_service_c0_0 ());
}

static void _set_callback_cbs_service_c0_0 (void *cls, const gsi::Callback &cb)
{
  ((QAudioDecoder_Adaptor *)cls)->cb_service_c0_0 = cb;
}


// emitter void QAudioDecoder::sourceChanged()

static void _init_emitter_sourceChanged_0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<void > ();
}

static void _call_emitter_sourceChanged_0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs & /*ret*/) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  ((QAudioDecoder_Adaptor *)cls)->emitter_QAudioDecoder_sourceChanged_0 ();
}


// emitter void QAudioDecoder::stateChanged(QAudioDecoder::State newState)

static void _init_emitter_stateChanged_2338 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("newState");
  decl->add_arg<const qt_gsi::Converter<QAudioDecoder::State>::target_type & > (argspec_0);
  decl->set_return<void > ();
}

static void _call_emitter_stateChanged_2338 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs & /*ret*/) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  const qt_gsi::Converter<QAudioDecoder::State>::target_type & arg1 = gsi::arg_reader<const qt_gsi::Converter<QAudioDecoder::State>::target_type & >() (args, heap);
  ((QAudioDecoder_Adaptor *)cls)->emitter_QAudioDecoder_stateChanged_2338 (arg1);
}


// void QAudioDecoder::timerEvent(QTimerEvent *)

static void _init_cbs_timerEvent_1730_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("arg1");
  decl->add_arg<QTimerEvent * > (argspec_0);
  decl->set_return<void > ();
}

static void _call_cbs_timerEvent_1730_0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  QTimerEvent *arg1 = args.read<QTimerEvent * > (heap);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QAudioDecoder_Adaptor *)cls)->cbs_timerEvent_1730_0 (arg1);
}

static void _set_callback_cbs_timerEvent_1730_0 (void *cls, const gsi::Callback &cb)
{
  ((QAudioDecoder_Adaptor *)cls)->cb_timerEvent_1730_0 = cb;
}


// void QAudioDecoder::unbind(QObject *)

static void _init_cbs_unbind_1302_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("arg1");
  decl->add_arg<QObject * > (argspec_0);
  decl->set_return<void > ();
}

static void _call_cbs_unbind_1302_0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  QObject *arg1 = args.read<QObject * > (heap);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QAudioDecoder_Adaptor *)cls)->cbs_unbind_1302_0 (arg1);
}

static void _set_callback_cbs_unbind_1302_0 (void *cls, const gsi::Callback &cb)
{
  ((QAudioDecoder_Adaptor *)cls)->cb_unbind_1302_0 = cb;
}


namespace gsi
{

gsi::Class<QAudioDecoder> &qtdecl_QAudioDecoder ();

static gsi::Methods methods_QAudioDecoder_Adaptor () {
  gsi::Methods methods;
  methods += new qt_gsi::GenericStaticMethod ("new", "@brief Constructor QAudioDecoder::QAudioDecoder(QObject *parent)\nThis method creates an object of class QAudioDecoder.", &_init_ctor_QAudioDecoder_Adaptor_1302, &_call_ctor_QAudioDecoder_Adaptor_1302);
  methods += new qt_gsi::GenericMethod ("*addPropertyWatch", "@brief Method void QAudioDecoder::addPropertyWatch(QByteArray const &name)\nThis method is protected and can only be called from inside a derived class.", false, &_init_fp_addPropertyWatch_2309, &_call_fp_addPropertyWatch_2309);
  methods += new qt_gsi::GenericMethod ("availability", "@hide", true, &_init_cbs_availability_c0_0, &_call_cbs_availability_c0_0);
  methods += new qt_gsi::GenericMethod ("availability", "@brief Virtual method QMultimedia::AvailabilityStatus QAudioDecoder::availability()\nThis method can be reimplemented in a derived class.", true, &_init_cbs_availability_c0_0, &_call_cbs_availability_c0_0, &_set_callback_cbs_availability_c0_0);
  methods += new qt_gsi::GenericMethod ("emit_availabilityChanged_bool", "@brief Emitter for signal void QAudioDecoder::availabilityChanged(bool available)\nCall this method to emit this signal.", false, &_init_emitter_availabilityChanged_864, &_call_emitter_availabilityChanged_864);
  methods += new qt_gsi::GenericMethod ("emit_availabilityChanged_status", "@brief Emitter for signal void QAudioDecoder::availabilityChanged(QMultimedia::AvailabilityStatus availability)\nCall this method to emit this signal.", false, &_init_emitter_availabilityChanged_3555, &_call_emitter_availabilityChanged_3555);
  methods += new qt_gsi::GenericMethod ("bind", "@hide", false, &_init_cbs_bind_1302_0, &_call_cbs_bind_1302_0);
  methods += new qt_gsi::GenericMethod ("bind", "@brief Virtual method bool QAudioDecoder::bind(QObject *)\nThis method can be reimplemented in a derived class.", false, &_init_cbs_bind_1302_0, &_call_cbs_bind_1302_0, &_set_callback_cbs_bind_1302_0);
  methods += new qt_gsi::GenericMethod ("emit_bufferAvailableChanged", "@brief Emitter for signal void QAudioDecoder::bufferAvailableChanged(bool)\nCall this method to emit this signal.", false, &_init_emitter_bufferAvailableChanged_864, &_call_emitter_bufferAvailableChanged_864);
  methods += new qt_gsi::GenericMethod ("emit_bufferReady", "@brief Emitter for signal void QAudioDecoder::bufferReady()\nCall this method to emit this signal.", false, &_init_emitter_bufferReady_0, &_call_emitter_bufferReady_0);
  methods += new qt_gsi::GenericMethod ("*childEvent", "@hide", false, &_init_cbs_childEvent_1701_0, &_call_cbs_childEvent_1701_0);
  methods += new qt_gsi::GenericMethod ("*childEvent", "@brief Virtual method void QAudioDecoder::childEvent(QChildEvent *)\nThis method can be reimplemented in a derived class.", false, &_init_cbs_childEvent_1701_0, &_call_cbs_childEvent_1701_0, &_set_callback_cbs_childEvent_1701_0);
  methods += new qt_gsi::GenericMethod ("*customEvent", "@hide", false, &_init_cbs_customEvent_1217_0, &_call_cbs_customEvent_1217_0);
  methods += new qt_gsi::GenericMethod ("*customEvent", "@brief Virtual method void QAudioDecoder::customEvent(QEvent *)\nThis method can be reimplemented in a derived class.", false, &_init_cbs_customEvent_1217_0, &_call_cbs_customEvent_1217_0, &_set_callback_cbs_customEvent_1217_0);
  methods += new qt_gsi::GenericMethod ("emit_destroyed", "@brief Emitter for signal void QAudioDecoder::destroyed(QObject *)\nCall this method to emit this signal.", false, &_init_emitter_destroyed_1302, &_call_emitter_destroyed_1302);
  methods += new qt_gsi::GenericMethod ("*disconnectNotify", "@hide", false, &_init_cbs_disconnectNotify_2394_0, &_call_cbs_disconnectNotify_2394_0);
  methods += new qt_gsi::GenericMethod ("*disconnectNotify", "@brief Virtual method void QAudioDecoder::disconnectNotify(const QMetaMethod &signal)\nThis method can be reimplemented in a derived class.", false, &_init_cbs_disconnectNotify_2394_0, &_call_cbs_disconnectNotify_2394_0, &_set_callback_cbs_disconnectNotify_2394_0);
  methods += new qt_gsi::GenericMethod ("emit_durationChanged", "@brief Emitter for signal void QAudioDecoder::durationChanged(qint64 duration)\nCall this method to emit this signal.", false, &_init_emitter_durationChanged_986, &_call_emitter_durationChanged_986);
  methods += new qt_gsi::GenericMethod ("emit_error_sig", "@brief Emitter for signal void QAudioDecoder::error(QAudioDecoder::Error error)\nCall this method to emit this signal.", false, &_init_emitter_error_2347, &_call_emitter_error_2347);
  methods += new qt_gsi::GenericMethod ("event", "@hide", false, &_init_cbs_event_1217_0, &_call_cbs_event_1217_0);
  methods += new qt_gsi::GenericMethod ("event", "@brief Virtual method bool QAudioDecoder::event(QEvent *)\nThis method can be reimplemented in a derived class.", false, &_init_cbs_event_1217_0, &_call_cbs_event_1217_0, &_set_callback_cbs_event_1217_0);
  methods += new qt_gsi::GenericMethod ("eventFilter", "@hide", false, &_init_cbs_eventFilter_2411_0, &_call_cbs_eventFilter_2411_0);
  methods += new qt_gsi::GenericMethod ("eventFilter", "@brief Virtual method bool QAudioDecoder::eventFilter(QObject *, QEvent *)\nThis method can be reimplemented in a derived class.", false, &_init_cbs_eventFilter_2411_0, &_call_cbs_eventFilter_2411_0, &_set_callback_cbs_eventFilter_2411_0);
  methods += new qt_gsi::GenericMethod ("emit_finished", "@brief Emitter for signal void QAudioDecoder::finished()\nCall this method to emit this signal.", false, &_init_emitter_finished_0, &_call_emitter_finished_0);
  methods += new qt_gsi::GenericMethod ("emit_formatChanged", "@brief Emitter for signal void QAudioDecoder::formatChanged(const QAudioFormat &format)\nCall this method to emit this signal.", false, &_init_emitter_formatChanged_2509, &_call_emitter_formatChanged_2509);
  methods += new qt_gsi::GenericMethod ("isAvailable", "@hide", true, &_init_cbs_isAvailable_c0_0, &_call_cbs_isAvailable_c0_0);
  methods += new qt_gsi::GenericMethod ("isAvailable", "@brief Virtual method bool QAudioDecoder::isAvailable()\nThis method can be reimplemented in a derived class.", true, &_init_cbs_isAvailable_c0_0, &_call_cbs_isAvailable_c0_0, &_set_callback_cbs_isAvailable_c0_0);
  methods += new qt_gsi::GenericMethod ("*isSignalConnected", "@brief Method bool QAudioDecoder::isSignalConnected(const QMetaMethod &signal)\nThis method is protected and can only be called from inside a derived class.", true, &_init_fp_isSignalConnected_c2394, &_call_fp_isSignalConnected_c2394);
  methods += new qt_gsi::GenericMethod ("emit_metaDataAvailableChanged", "@brief Emitter for signal void QAudioDecoder::metaDataAvailableChanged(bool available)\nCall this method to emit this signal.", false, &_init_emitter_metaDataAvailableChanged_864, &_call_emitter_metaDataAvailableChanged_864);
  methods += new qt_gsi::GenericMethod ("emit_metaDataChanged", "@brief Emitter for signal void QAudioDecoder::metaDataChanged()\nCall this method to emit this signal.", false, &_init_emitter_metaDataChanged_0, &_call_emitter_metaDataChanged_0);
  methods += new qt_gsi::GenericMethod ("emit_metaDataChanged_kv", "@brief Emitter for signal void QAudioDecoder::metaDataChanged(const QString &key, const QVariant &value)\nCall this method to emit this signal.", false, &_init_emitter_metaDataChanged_4036, &_call_emitter_metaDataChanged_4036);
  methods += new qt_gsi::GenericMethod ("emit_notifyIntervalChanged", "@brief Emitter for signal void QAudioDecoder::notifyIntervalChanged(int milliSeconds)\nCall this method to emit this signal.", false, &_init_emitter_notifyIntervalChanged_767, &_call_emitter_notifyIntervalChanged_767);
  methods += new qt_gsi::GenericMethod ("emit_positionChanged", "@brief Emitter for signal void QAudioDecoder::positionChanged(qint64 position)\nCall this method to emit this signal.", false, &_init_emitter_positionChanged_986, &_call_emitter_positionChanged_986);
  methods += new qt_gsi::GenericMethod ("*receivers", "@brief Method int QAudioDecoder::receivers(const char *signal)\nThis method is protected and can only be called from inside a derived class.", true, &_init_fp_receivers_c1731, &_call_fp_receivers_c1731);
  methods += new qt_gsi::GenericMethod ("*removePropertyWatch", "@brief Method void QAudioDecoder::removePropertyWatch(QByteArray const &name)\nThis method is protected and can only be called from inside a derived class.", false, &_init_fp_removePropertyWatch_2309, &_call_fp_removePropertyWatch_2309);
  methods += new qt_gsi::GenericMethod ("*sender", "@brief Method QObject *QAudioDecoder::sender()\nThis method is protected and can only be called from inside a derived class.", true, &_init_fp_sender_c0, &_call_fp_sender_c0);
  methods += new qt_gsi::GenericMethod ("*senderSignalIndex", "@brief Method int QAudioDecoder::senderSignalIndex()\nThis method is protected and can only be called from inside a derived class.", true, &_init_fp_senderSignalIndex_c0, &_call_fp_senderSignalIndex_c0);
  methods += new qt_gsi::GenericMethod ("service", "@hide", true, &_init_cbs_service_c0_0, &_call_cbs_service_c0_0);
  methods += new qt_gsi::GenericMethod ("service", "@brief Virtual method QMediaService *QAudioDecoder::service()\nThis method can be reimplemented in a derived class.", true, &_init_cbs_service_c0_0, &_call_cbs_service_c0_0, &_set_callback_cbs_service_c0_0);
  methods += new qt_gsi::GenericMethod ("emit_sourceChanged", "@brief Emitter for signal void QAudioDecoder::sourceChanged()\nCall this method to emit this signal.", false, &_init_emitter_sourceChanged_0, &_call_emitter_sourceChanged_0);
  methods += new qt_gsi::GenericMethod ("emit_stateChanged", "@brief Emitter for signal void QAudioDecoder::stateChanged(QAudioDecoder::State newState)\nCall this method to emit this signal.", false, &_init_emitter_stateChanged_2338, &_call_emitter_stateChanged_2338);
  methods += new qt_gsi::GenericMethod ("*timerEvent", "@hide", false, &_init_cbs_timerEvent_1730_0, &_call_cbs_timerEvent_1730_0);
  methods += new qt_gsi::GenericMethod ("*timerEvent", "@brief Virtual method void QAudioDecoder::timerEvent(QTimerEvent *)\nThis method can be reimplemented in a derived class.", false, &_init_cbs_timerEvent_1730_0, &_call_cbs_timerEvent_1730_0, &_set_callback_cbs_timerEvent_1730_0);
  methods += new qt_gsi::GenericMethod ("unbind", "@hide", false, &_init_cbs_unbind_1302_0, &_call_cbs_unbind_1302_0);
  methods += new qt_gsi::GenericMethod ("unbind", "@brief Virtual method void QAudioDecoder::unbind(QObject *)\nThis method can be reimplemented in a derived class.", false, &_init_cbs_unbind_1302_0, &_call_cbs_unbind_1302_0, &_set_callback_cbs_unbind_1302_0);
  return methods;
}

gsi::Class<QAudioDecoder_Adaptor> decl_QAudioDecoder_Adaptor (qtdecl_QAudioDecoder (), "QtMultimedia", "QAudioDecoder",
  methods_QAudioDecoder_Adaptor (),
  "@qt\n@brief Binding of QAudioDecoder");

}


//  Implementation of the enum wrapper class for QAudioDecoder::Error
namespace qt_gsi
{

static gsi::Enum<QAudioDecoder::Error> decl_QAudioDecoder_Error_Enum ("QtMultimedia", "QAudioDecoder_Error",
    gsi::enum_const ("NoError", QAudioDecoder::NoError, "@brief Enum constant QAudioDecoder::NoError") +
    gsi::enum_const ("ResourceError", QAudioDecoder::ResourceError, "@brief Enum constant QAudioDecoder::ResourceError") +
    gsi::enum_const ("FormatError", QAudioDecoder::FormatError, "@brief Enum constant QAudioDecoder::FormatError") +
    gsi::enum_const ("AccessDeniedError", QAudioDecoder::AccessDeniedError, "@brief Enum constant QAudioDecoder::AccessDeniedError") +
    gsi::enum_const ("ServiceMissingError", QAudioDecoder::ServiceMissingError, "@brief Enum constant QAudioDecoder::ServiceMissingError"),
  "@qt\n@brief This class represents the QAudioDecoder::Error enum");

static gsi::QFlagsClass<QAudioDecoder::Error > decl_QAudioDecoder_Error_Enums ("QtMultimedia", "QAudioDecoder_QFlags_Error",
  "@qt\n@brief This class represents the QFlags<QAudioDecoder::Error> flag set");

//  Inject the declarations into the parent
static gsi::ClassExt<QAudioDecoder> inject_QAudioDecoder_Error_Enum_in_parent (decl_QAudioDecoder_Error_Enum.defs ());
static gsi::ClassExt<QAudioDecoder> decl_QAudioDecoder_Error_Enum_as_child (decl_QAudioDecoder_Error_Enum, "Error");
static gsi::ClassExt<QAudioDecoder> decl_QAudioDecoder_Error_Enums_as_child (decl_QAudioDecoder_Error_Enums, "QFlags_Error");

}


//  Implementation of the enum wrapper class for QAudioDecoder::State
namespace qt_gsi
{

static gsi::Enum<QAudioDecoder::State> decl_QAudioDecoder_State_Enum ("QtMultimedia", "QAudioDecoder_State",
    gsi::enum_const ("StoppedState", QAudioDecoder::StoppedState, "@brief Enum constant QAudioDecoder::StoppedState") +
    gsi::enum_const ("DecodingState", QAudioDecoder::DecodingState, "@brief Enum constant QAudioDecoder::DecodingState"),
  "@qt\n@brief This class represents the QAudioDecoder::State enum");

static gsi::QFlagsClass<QAudioDecoder::State > decl_QAudioDecoder_State_Enums ("QtMultimedia", "QAudioDecoder_QFlags_State",
  "@qt\n@brief This class represents the QFlags<QAudioDecoder::State> flag set");

//  Inject the declarations into the parent
static gsi::ClassExt<QAudioDecoder> inject_QAudioDecoder_State_Enum_in_parent (decl_QAudioDecoder_State_Enum.defs ());
static gsi::ClassExt<QAudioDecoder> decl_QAudioDecoder_State_Enum_as_child (decl_QAudioDecoder_State_Enum, "State");
static gsi::ClassExt<QAudioDecoder> decl_QAudioDecoder_State_Enums_as_child (decl_QAudioDecoder_State_Enums, "QFlags_State");

}

