
/*

  KLayout Layout Viewer
  Copyright (C) 2006-2023 Matthias Koefferlein

  This program is free software; you can redistribute it and/or modify
  it under the terms of the GNU General Public License as published by
  the Free Software Foundation; either version 2 of the License, or
  (at your option) any later version.

  This program is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
  GNU General Public License for more details.

  You should have received a copy of the GNU General Public License
  along with this program; if not, write to the Free Software
  Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA

*/

/**
*  @file gsiDeclQApplication.cc 
*
*  DO NOT EDIT THIS FILE. 
*  This file has been created automatically
*/

#include <QApplication>
#include <QSessionManager>
#include <QStyle>
#include <QWindow>
#include <QScreen>
#include <QFont>
#include <QFontMetrics>
#include <QWidget>
#include "gsiQt.h"
#include "gsiQtWidgetsCommon.h"
#include <memory>

// -----------------------------------------------------------------------
// class QApplication

//  get static meta object

static void _init_smo (qt_gsi::GenericStaticMethod *decl)
{
  decl->set_return<const QMetaObject &> ();
}

static void _call_smo (const qt_gsi::GenericStaticMethod *, gsi::SerialArgs &, gsi::SerialArgs &ret) 
{
  ret.write<const QMetaObject &> (QApplication::staticMetaObject);
}


// bool QApplication::autoSipEnabled()


static void _init_f_autoSipEnabled_c0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<bool > ();
}

static void _call_f_autoSipEnabled_c0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  ret.write<bool > ((bool)((QApplication *)cls)->autoSipEnabled ());
}


// void QApplication::setAutoSipEnabled(const bool enabled)


static void _init_f_setAutoSipEnabled_1559 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("enabled");
  decl->add_arg<const bool > (argspec_0);
  decl->set_return<void > ();
}

static void _call_f_setAutoSipEnabled_1559 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  const bool arg1 = gsi::arg_reader<const bool >() (args, heap);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QApplication *)cls)->setAutoSipEnabled (arg1);
}


// void QApplication::setStyleSheet(const QString &sheet)


static void _init_f_setStyleSheet_2025 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("sheet");
  decl->add_arg<const QString & > (argspec_0);
  decl->set_return<void > ();
}

static void _call_f_setStyleSheet_2025 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  const QString &arg1 = gsi::arg_reader<const QString & >() (args, heap);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QApplication *)cls)->setStyleSheet (arg1);
}


// QString QApplication::styleSheet()


static void _init_f_styleSheet_c0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<QString > ();
}

static void _call_f_styleSheet_c0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  ret.write<QString > ((QString)((QApplication *)cls)->styleSheet ());
}


// static void QApplication::aboutQt()


static void _init_f_aboutQt_0 (qt_gsi::GenericStaticMethod *decl)
{
  decl->set_return<void > ();
}

static void _call_f_aboutQt_0 (const qt_gsi::GenericStaticMethod * /*decl*/, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  __SUPPRESS_UNUSED_WARNING(ret);
  QApplication::aboutQt ();
}


// static QWidget *QApplication::activeModalWidget()


static void _init_f_activeModalWidget_0 (qt_gsi::GenericStaticMethod *decl)
{
  decl->set_return<QWidget * > ();
}

static void _call_f_activeModalWidget_0 (const qt_gsi::GenericStaticMethod * /*decl*/, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  ret.write<QWidget * > ((QWidget *)QApplication::activeModalWidget ());
}


// static QWidget *QApplication::activePopupWidget()


static void _init_f_activePopupWidget_0 (qt_gsi::GenericStaticMethod *decl)
{
  decl->set_return<QWidget * > ();
}

static void _call_f_activePopupWidget_0 (const qt_gsi::GenericStaticMethod * /*decl*/, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  ret.write<QWidget * > ((QWidget *)QApplication::activePopupWidget ());
}


// static QWidget *QApplication::activeWindow()


static void _init_f_activeWindow_0 (qt_gsi::GenericStaticMethod *decl)
{
  decl->set_return<QWidget * > ();
}

static void _call_f_activeWindow_0 (const qt_gsi::GenericStaticMethod * /*decl*/, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  ret.write<QWidget * > ((QWidget *)QApplication::activeWindow ());
}


// static void QApplication::alert(QWidget *widget, int duration)


static void _init_f_alert_1974 (qt_gsi::GenericStaticMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("widget");
  decl->add_arg<QWidget * > (argspec_0);
  static gsi::ArgSpecBase argspec_1 ("duration", true, "0");
  decl->add_arg<int > (argspec_1);
  decl->set_return<void > ();
}

static void _call_f_alert_1974 (const qt_gsi::GenericStaticMethod * /*decl*/, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  QWidget *arg1 = gsi::arg_reader<QWidget * >() (args, heap);
  int arg2 = args ? gsi::arg_reader<int >() (args, heap) : gsi::arg_maker<int >() (0, heap);
  __SUPPRESS_UNUSED_WARNING(ret);
  QApplication::alert (arg1, arg2);
}


// static QList<QWidget *> QApplication::allWidgets()


static void _init_f_allWidgets_0 (qt_gsi::GenericStaticMethod *decl)
{
  decl->set_return<QList<QWidget *> > ();
}

static void _call_f_allWidgets_0 (const qt_gsi::GenericStaticMethod * /*decl*/, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  ret.write<QList<QWidget *> > ((QList<QWidget *>)QApplication::allWidgets ());
}


// static void QApplication::beep()


static void _init_f_beep_0 (qt_gsi::GenericStaticMethod *decl)
{
  decl->set_return<void > ();
}

static void _call_f_beep_0 (const qt_gsi::GenericStaticMethod * /*decl*/, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  __SUPPRESS_UNUSED_WARNING(ret);
  QApplication::beep ();
}


// static void QApplication::closeAllWindows()


static void _init_f_closeAllWindows_0 (qt_gsi::GenericStaticMethod *decl)
{
  decl->set_return<void > ();
}

static void _call_f_closeAllWindows_0 (const qt_gsi::GenericStaticMethod * /*decl*/, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  __SUPPRESS_UNUSED_WARNING(ret);
  QApplication::closeAllWindows ();
}


// static int QApplication::cursorFlashTime()


static void _init_f_cursorFlashTime_0 (qt_gsi::GenericStaticMethod *decl)
{
  decl->set_return<int > ();
}

static void _call_f_cursorFlashTime_0 (const qt_gsi::GenericStaticMethod * /*decl*/, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  ret.write<int > ((int)QApplication::cursorFlashTime ());
}


// static int QApplication::doubleClickInterval()


static void _init_f_doubleClickInterval_0 (qt_gsi::GenericStaticMethod *decl)
{
  decl->set_return<int > ();
}

static void _call_f_doubleClickInterval_0 (const qt_gsi::GenericStaticMethod * /*decl*/, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  ret.write<int > ((int)QApplication::doubleClickInterval ());
}


// static int QApplication::exec()


static void _init_f_exec_0 (qt_gsi::GenericStaticMethod *decl)
{
  decl->set_return<int > ();
}

static void _call_f_exec_0 (const qt_gsi::GenericStaticMethod * /*decl*/, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  ret.write<int > ((int)QApplication::exec ());
}


// static QWidget *QApplication::focusWidget()


static void _init_f_focusWidget_0 (qt_gsi::GenericStaticMethod *decl)
{
  decl->set_return<QWidget * > ();
}

static void _call_f_focusWidget_0 (const qt_gsi::GenericStaticMethod * /*decl*/, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  ret.write<QWidget * > ((QWidget *)QApplication::focusWidget ());
}


// static QFont QApplication::font()


static void _init_f_font_0 (qt_gsi::GenericStaticMethod *decl)
{
  decl->set_return<QFont > ();
}

static void _call_f_font_0 (const qt_gsi::GenericStaticMethod * /*decl*/, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  ret.write<QFont > ((QFont)QApplication::font ());
}


// static QFont QApplication::font(const QWidget *)


static void _init_f_font_2010 (qt_gsi::GenericStaticMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("arg1");
  decl->add_arg<const QWidget * > (argspec_0);
  decl->set_return<QFont > ();
}

static void _call_f_font_2010 (const qt_gsi::GenericStaticMethod * /*decl*/, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  const QWidget *arg1 = gsi::arg_reader<const QWidget * >() (args, heap);
  ret.write<QFont > ((QFont)QApplication::font (arg1));
}


// static QFont QApplication::font(const char *className)


static void _init_f_font_1731 (qt_gsi::GenericStaticMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("className");
  decl->add_arg<const char * > (argspec_0);
  decl->set_return<QFont > ();
}

static void _call_f_font_1731 (const qt_gsi::GenericStaticMethod * /*decl*/, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  const char *arg1 = gsi::arg_reader<const char * >() (args, heap);
  ret.write<QFont > ((QFont)QApplication::font (arg1));
}


// static QFontMetrics QApplication::fontMetrics()


static void _init_f_fontMetrics_0 (qt_gsi::GenericStaticMethod *decl)
{
  decl->set_return<QFontMetrics > ();
}

static void _call_f_fontMetrics_0 (const qt_gsi::GenericStaticMethod * /*decl*/, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  ret.write<QFontMetrics > ((QFontMetrics)QApplication::fontMetrics ());
}


// static bool QApplication::isEffectEnabled(Qt::UIEffect)


static void _init_f_isEffectEnabled_1496 (qt_gsi::GenericStaticMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("arg1");
  decl->add_arg<const qt_gsi::Converter<Qt::UIEffect>::target_type & > (argspec_0);
  decl->set_return<bool > ();
}

static void _call_f_isEffectEnabled_1496 (const qt_gsi::GenericStaticMethod * /*decl*/, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  const qt_gsi::Converter<Qt::UIEffect>::target_type & arg1 = gsi::arg_reader<const qt_gsi::Converter<Qt::UIEffect>::target_type & >() (args, heap);
  ret.write<bool > ((bool)QApplication::isEffectEnabled (qt_gsi::QtToCppAdaptor<Qt::UIEffect>(arg1).cref()));
}


// static int QApplication::keyboardInputInterval()


static void _init_f_keyboardInputInterval_0 (qt_gsi::GenericStaticMethod *decl)
{
  decl->set_return<int > ();
}

static void _call_f_keyboardInputInterval_0 (const qt_gsi::GenericStaticMethod * /*decl*/, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  ret.write<int > ((int)QApplication::keyboardInputInterval ());
}


// static QPalette QApplication::palette()


static void _init_f_palette_0 (qt_gsi::GenericStaticMethod *decl)
{
  decl->set_return<QPalette > ();
}

static void _call_f_palette_0 (const qt_gsi::GenericStaticMethod * /*decl*/, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  ret.write<QPalette > ((QPalette)QApplication::palette ());
}


// static QPalette QApplication::palette(const QWidget *)


static void _init_f_palette_2010 (qt_gsi::GenericStaticMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("arg1");
  decl->add_arg<const QWidget * > (argspec_0);
  decl->set_return<QPalette > ();
}

static void _call_f_palette_2010 (const qt_gsi::GenericStaticMethod * /*decl*/, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  const QWidget *arg1 = gsi::arg_reader<const QWidget * >() (args, heap);
  ret.write<QPalette > ((QPalette)QApplication::palette (arg1));
}


// static QPalette QApplication::palette(const char *className)


static void _init_f_palette_1731 (qt_gsi::GenericStaticMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("className");
  decl->add_arg<const char * > (argspec_0);
  decl->set_return<QPalette > ();
}

static void _call_f_palette_1731 (const qt_gsi::GenericStaticMethod * /*decl*/, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  const char *arg1 = gsi::arg_reader<const char * >() (args, heap);
  ret.write<QPalette > ((QPalette)QApplication::palette (arg1));
}


// static void QApplication::setActiveWindow(QWidget *act)


static void _init_f_setActiveWindow_1315 (qt_gsi::GenericStaticMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("act");
  decl->add_arg<QWidget * > (argspec_0);
  decl->set_return<void > ();
}

static void _call_f_setActiveWindow_1315 (const qt_gsi::GenericStaticMethod * /*decl*/, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  QWidget *arg1 = gsi::arg_reader<QWidget * >() (args, heap);
  __SUPPRESS_UNUSED_WARNING(ret);
  QApplication::setActiveWindow (arg1);
}


// static void QApplication::setCursorFlashTime(int)


static void _init_f_setCursorFlashTime_767 (qt_gsi::GenericStaticMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("arg1");
  decl->add_arg<int > (argspec_0);
  decl->set_return<void > ();
}

static void _call_f_setCursorFlashTime_767 (const qt_gsi::GenericStaticMethod * /*decl*/, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  int arg1 = gsi::arg_reader<int >() (args, heap);
  __SUPPRESS_UNUSED_WARNING(ret);
  QApplication::setCursorFlashTime (arg1);
}


// static void QApplication::setDoubleClickInterval(int)


static void _init_f_setDoubleClickInterval_767 (qt_gsi::GenericStaticMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("arg1");
  decl->add_arg<int > (argspec_0);
  decl->set_return<void > ();
}

static void _call_f_setDoubleClickInterval_767 (const qt_gsi::GenericStaticMethod * /*decl*/, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  int arg1 = gsi::arg_reader<int >() (args, heap);
  __SUPPRESS_UNUSED_WARNING(ret);
  QApplication::setDoubleClickInterval (arg1);
}


// static void QApplication::setEffectEnabled(Qt::UIEffect, bool enable)


static void _init_f_setEffectEnabled_2252 (qt_gsi::GenericStaticMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("arg1");
  decl->add_arg<const qt_gsi::Converter<Qt::UIEffect>::target_type & > (argspec_0);
  static gsi::ArgSpecBase argspec_1 ("enable", true, "true");
  decl->add_arg<bool > (argspec_1);
  decl->set_return<void > ();
}

static void _call_f_setEffectEnabled_2252 (const qt_gsi::GenericStaticMethod * /*decl*/, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  const qt_gsi::Converter<Qt::UIEffect>::target_type & arg1 = gsi::arg_reader<const qt_gsi::Converter<Qt::UIEffect>::target_type & >() (args, heap);
  bool arg2 = args ? gsi::arg_reader<bool >() (args, heap) : gsi::arg_maker<bool >() (true, heap);
  __SUPPRESS_UNUSED_WARNING(ret);
  QApplication::setEffectEnabled (qt_gsi::QtToCppAdaptor<Qt::UIEffect>(arg1).cref(), arg2);
}


// static void QApplication::setFont(const QFont &, const char *className)


static void _init_f_setFont_3424 (qt_gsi::GenericStaticMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("arg1");
  decl->add_arg<const QFont & > (argspec_0);
  static gsi::ArgSpecBase argspec_1 ("className", true, "nullptr");
  decl->add_arg<const char * > (argspec_1);
  decl->set_return<void > ();
}

static void _call_f_setFont_3424 (const qt_gsi::GenericStaticMethod * /*decl*/, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  const QFont &arg1 = gsi::arg_reader<const QFont & >() (args, heap);
  const char *arg2 = args ? gsi::arg_reader<const char * >() (args, heap) : gsi::arg_maker<const char * >() (nullptr, heap);
  __SUPPRESS_UNUSED_WARNING(ret);
  QApplication::setFont (arg1, arg2);
}


// static void QApplication::setKeyboardInputInterval(int)


static void _init_f_setKeyboardInputInterval_767 (qt_gsi::GenericStaticMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("arg1");
  decl->add_arg<int > (argspec_0);
  decl->set_return<void > ();
}

static void _call_f_setKeyboardInputInterval_767 (const qt_gsi::GenericStaticMethod * /*decl*/, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  int arg1 = gsi::arg_reader<int >() (args, heap);
  __SUPPRESS_UNUSED_WARNING(ret);
  QApplication::setKeyboardInputInterval (arg1);
}


// static void QApplication::setPalette(const QPalette &, const char *className)


static void _init_f_setPalette_3736 (qt_gsi::GenericStaticMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("arg1");
  decl->add_arg<const QPalette & > (argspec_0);
  static gsi::ArgSpecBase argspec_1 ("className", true, "nullptr");
  decl->add_arg<const char * > (argspec_1);
  decl->set_return<void > ();
}

static void _call_f_setPalette_3736 (const qt_gsi::GenericStaticMethod * /*decl*/, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  const QPalette &arg1 = gsi::arg_reader<const QPalette & >() (args, heap);
  const char *arg2 = args ? gsi::arg_reader<const char * >() (args, heap) : gsi::arg_maker<const char * >() (nullptr, heap);
  __SUPPRESS_UNUSED_WARNING(ret);
  QApplication::setPalette (arg1, arg2);
}


// static void QApplication::setStartDragDistance(int l)


static void _init_f_setStartDragDistance_767 (qt_gsi::GenericStaticMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("l");
  decl->add_arg<int > (argspec_0);
  decl->set_return<void > ();
}

static void _call_f_setStartDragDistance_767 (const qt_gsi::GenericStaticMethod * /*decl*/, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  int arg1 = gsi::arg_reader<int >() (args, heap);
  __SUPPRESS_UNUSED_WARNING(ret);
  QApplication::setStartDragDistance (arg1);
}


// static void QApplication::setStartDragTime(int ms)


static void _init_f_setStartDragTime_767 (qt_gsi::GenericStaticMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("ms");
  decl->add_arg<int > (argspec_0);
  decl->set_return<void > ();
}

static void _call_f_setStartDragTime_767 (const qt_gsi::GenericStaticMethod * /*decl*/, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  int arg1 = gsi::arg_reader<int >() (args, heap);
  __SUPPRESS_UNUSED_WARNING(ret);
  QApplication::setStartDragTime (arg1);
}


// static void QApplication::setStyle(QStyle *)


static void _init_f_setStyle_1232 (qt_gsi::GenericStaticMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("arg1");
  decl->add_arg<QStyle * > (argspec_0);
  decl->set_return<void > ();
}

static void _call_f_setStyle_1232 (const qt_gsi::GenericStaticMethod * /*decl*/, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  QStyle *arg1 = gsi::arg_reader<QStyle * >() (args, heap);
  __SUPPRESS_UNUSED_WARNING(ret);
  QApplication::setStyle (arg1);
}


// static QStyle *QApplication::setStyle(const QString &)


static void _init_f_setStyle_2025 (qt_gsi::GenericStaticMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("arg1");
  decl->add_arg<const QString & > (argspec_0);
  decl->set_return<QStyle * > ();
}

static void _call_f_setStyle_2025 (const qt_gsi::GenericStaticMethod * /*decl*/, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  const QString &arg1 = gsi::arg_reader<const QString & >() (args, heap);
  ret.write<QStyle * > ((QStyle *)QApplication::setStyle (arg1));
}


// static void QApplication::setWheelScrollLines(int)


static void _init_f_setWheelScrollLines_767 (qt_gsi::GenericStaticMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("arg1");
  decl->add_arg<int > (argspec_0);
  decl->set_return<void > ();
}

static void _call_f_setWheelScrollLines_767 (const qt_gsi::GenericStaticMethod * /*decl*/, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  int arg1 = gsi::arg_reader<int >() (args, heap);
  __SUPPRESS_UNUSED_WARNING(ret);
  QApplication::setWheelScrollLines (arg1);
}


// static int QApplication::startDragDistance()


static void _init_f_startDragDistance_0 (qt_gsi::GenericStaticMethod *decl)
{
  decl->set_return<int > ();
}

static void _call_f_startDragDistance_0 (const qt_gsi::GenericStaticMethod * /*decl*/, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  ret.write<int > ((int)QApplication::startDragDistance ());
}


// static int QApplication::startDragTime()


static void _init_f_startDragTime_0 (qt_gsi::GenericStaticMethod *decl)
{
  decl->set_return<int > ();
}

static void _call_f_startDragTime_0 (const qt_gsi::GenericStaticMethod * /*decl*/, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  ret.write<int > ((int)QApplication::startDragTime ());
}


// static QStyle *QApplication::style()


static void _init_f_style_0 (qt_gsi::GenericStaticMethod *decl)
{
  decl->set_return<QStyle * > ();
}

static void _call_f_style_0 (const qt_gsi::GenericStaticMethod * /*decl*/, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  ret.write<QStyle * > ((QStyle *)QApplication::style ());
}


// static QWidget *QApplication::topLevelAt(const QPoint &p)


static void _init_f_topLevelAt_1916 (qt_gsi::GenericStaticMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("p");
  decl->add_arg<const QPoint & > (argspec_0);
  decl->set_return<QWidget * > ();
}

static void _call_f_topLevelAt_1916 (const qt_gsi::GenericStaticMethod * /*decl*/, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  const QPoint &arg1 = gsi::arg_reader<const QPoint & >() (args, heap);
  ret.write<QWidget * > ((QWidget *)QApplication::topLevelAt (arg1));
}


// static QWidget *QApplication::topLevelAt(int x, int y)


static void _init_f_topLevelAt_1426 (qt_gsi::GenericStaticMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("x");
  decl->add_arg<int > (argspec_0);
  static gsi::ArgSpecBase argspec_1 ("y");
  decl->add_arg<int > (argspec_1);
  decl->set_return<QWidget * > ();
}

static void _call_f_topLevelAt_1426 (const qt_gsi::GenericStaticMethod * /*decl*/, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  int arg1 = gsi::arg_reader<int >() (args, heap);
  int arg2 = gsi::arg_reader<int >() (args, heap);
  ret.write<QWidget * > ((QWidget *)QApplication::topLevelAt (arg1, arg2));
}


// static QList<QWidget *> QApplication::topLevelWidgets()


static void _init_f_topLevelWidgets_0 (qt_gsi::GenericStaticMethod *decl)
{
  decl->set_return<QList<QWidget *> > ();
}

static void _call_f_topLevelWidgets_0 (const qt_gsi::GenericStaticMethod * /*decl*/, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  ret.write<QList<QWidget *> > ((QList<QWidget *>)QApplication::topLevelWidgets ());
}


// static QString QApplication::tr(const char *s, const char *c, int n)


static void _init_f_tr_4013 (qt_gsi::GenericStaticMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("s");
  decl->add_arg<const char * > (argspec_0);
  static gsi::ArgSpecBase argspec_1 ("c", true, "nullptr");
  decl->add_arg<const char * > (argspec_1);
  static gsi::ArgSpecBase argspec_2 ("n", true, "-1");
  decl->add_arg<int > (argspec_2);
  decl->set_return<QString > ();
}

static void _call_f_tr_4013 (const qt_gsi::GenericStaticMethod * /*decl*/, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  const char *arg1 = gsi::arg_reader<const char * >() (args, heap);
  const char *arg2 = args ? gsi::arg_reader<const char * >() (args, heap) : gsi::arg_maker<const char * >() (nullptr, heap);
  int arg3 = args ? gsi::arg_reader<int >() (args, heap) : gsi::arg_maker<int >() (-1, heap);
  ret.write<QString > ((QString)QApplication::tr (arg1, arg2, arg3));
}


// static int QApplication::wheelScrollLines()


static void _init_f_wheelScrollLines_0 (qt_gsi::GenericStaticMethod *decl)
{
  decl->set_return<int > ();
}

static void _call_f_wheelScrollLines_0 (const qt_gsi::GenericStaticMethod * /*decl*/, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  ret.write<int > ((int)QApplication::wheelScrollLines ());
}


// static QWidget *QApplication::widgetAt(const QPoint &p)


static void _init_f_widgetAt_1916 (qt_gsi::GenericStaticMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("p");
  decl->add_arg<const QPoint & > (argspec_0);
  decl->set_return<QWidget * > ();
}

static void _call_f_widgetAt_1916 (const qt_gsi::GenericStaticMethod * /*decl*/, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  const QPoint &arg1 = gsi::arg_reader<const QPoint & >() (args, heap);
  ret.write<QWidget * > ((QWidget *)QApplication::widgetAt (arg1));
}


// static QWidget *QApplication::widgetAt(int x, int y)


static void _init_f_widgetAt_1426 (qt_gsi::GenericStaticMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("x");
  decl->add_arg<int > (argspec_0);
  static gsi::ArgSpecBase argspec_1 ("y");
  decl->add_arg<int > (argspec_1);
  decl->set_return<QWidget * > ();
}

static void _call_f_widgetAt_1426 (const qt_gsi::GenericStaticMethod * /*decl*/, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  int arg1 = gsi::arg_reader<int >() (args, heap);
  int arg2 = gsi::arg_reader<int >() (args, heap);
  ret.write<QWidget * > ((QWidget *)QApplication::widgetAt (arg1, arg2));
}


namespace gsi
{

static gsi::Methods methods_QApplication () {
  gsi::Methods methods;
  methods += new qt_gsi::GenericStaticMethod ("staticMetaObject", "@brief Obtains the static MetaObject for this class.", &_init_smo, &_call_smo);
  methods += new qt_gsi::GenericMethod (":autoSipEnabled", "@brief Method bool QApplication::autoSipEnabled()\n", true, &_init_f_autoSipEnabled_c0, &_call_f_autoSipEnabled_c0);
  methods += new qt_gsi::GenericMethod ("setAutoSipEnabled|autoSipEnabled=", "@brief Method void QApplication::setAutoSipEnabled(const bool enabled)\n", false, &_init_f_setAutoSipEnabled_1559, &_call_f_setAutoSipEnabled_1559);
  methods += new qt_gsi::GenericMethod ("setStyleSheet|styleSheet=", "@brief Method void QApplication::setStyleSheet(const QString &sheet)\n", false, &_init_f_setStyleSheet_2025, &_call_f_setStyleSheet_2025);
  methods += new qt_gsi::GenericMethod (":styleSheet", "@brief Method QString QApplication::styleSheet()\n", true, &_init_f_styleSheet_c0, &_call_f_styleSheet_c0);
  methods += gsi::qt_signal ("aboutToQuit()", "aboutToQuit", "@brief Signal declaration for QApplication::aboutToQuit()\nYou can bind a procedure to this signal.");
  methods += gsi::qt_signal ("applicationDisplayNameChanged()", "applicationDisplayNameChanged", "@brief Signal declaration for QApplication::applicationDisplayNameChanged()\nYou can bind a procedure to this signal.");
  methods += gsi::qt_signal ("applicationNameChanged()", "applicationNameChanged", "@brief Signal declaration for QApplication::applicationNameChanged()\nYou can bind a procedure to this signal.");
  methods += gsi::qt_signal<const qt_gsi::Converter<Qt::ApplicationState>::target_type & > ("applicationStateChanged(Qt::ApplicationState)", "applicationStateChanged", gsi::arg("state"), "@brief Signal declaration for QApplication::applicationStateChanged(Qt::ApplicationState state)\nYou can bind a procedure to this signal.");
  methods += gsi::qt_signal ("applicationVersionChanged()", "applicationVersionChanged", "@brief Signal declaration for QApplication::applicationVersionChanged()\nYou can bind a procedure to this signal.");
  methods += gsi::qt_signal<QSessionManager & > ("commitDataRequest(QSessionManager &)", "commitDataRequest", gsi::arg("sessionManager"), "@brief Signal declaration for QApplication::commitDataRequest(QSessionManager &sessionManager)\nYou can bind a procedure to this signal.");
  methods += gsi::qt_signal<QObject * > ("destroyed(QObject *)", "destroyed", gsi::arg("arg1"), "@brief Signal declaration for QApplication::destroyed(QObject *)\nYou can bind a procedure to this signal.");
  methods += gsi::qt_signal<QWidget *, QWidget * > ("focusChanged(QWidget *, QWidget *)", "focusChanged", gsi::arg("old"), gsi::arg("now"), "@brief Signal declaration for QApplication::focusChanged(QWidget *old, QWidget *now)\nYou can bind a procedure to this signal.");
  methods += gsi::qt_signal<QObject * > ("focusObjectChanged(QObject *)", "focusObjectChanged", gsi::arg("focusObject"), "@brief Signal declaration for QApplication::focusObjectChanged(QObject *focusObject)\nYou can bind a procedure to this signal.");
  methods += gsi::qt_signal<QWindow * > ("focusWindowChanged(QWindow *)", "focusWindowChanged", gsi::arg("focusWindow"), "@brief Signal declaration for QApplication::focusWindowChanged(QWindow *focusWindow)\nYou can bind a procedure to this signal.");
  methods += gsi::qt_signal<const QFont & > ("fontChanged(const QFont &)", "fontChanged", gsi::arg("font"), "@brief Signal declaration for QApplication::fontChanged(const QFont &font)\nYou can bind a procedure to this signal.");
  methods += gsi::qt_signal ("fontDatabaseChanged()", "fontDatabaseChanged", "@brief Signal declaration for QApplication::fontDatabaseChanged()\nYou can bind a procedure to this signal.");
  methods += gsi::qt_signal ("lastWindowClosed()", "lastWindowClosed", "@brief Signal declaration for QApplication::lastWindowClosed()\nYou can bind a procedure to this signal.");
  methods += gsi::qt_signal<const qt_gsi::Converter<Qt::LayoutDirection>::target_type & > ("layoutDirectionChanged(Qt::LayoutDirection)", "layoutDirectionChanged", gsi::arg("direction"), "@brief Signal declaration for QApplication::layoutDirectionChanged(Qt::LayoutDirection direction)\nYou can bind a procedure to this signal.");
  methods += gsi::qt_signal<const QString & > ("objectNameChanged(const QString &)", "objectNameChanged", gsi::arg("objectName"), "@brief Signal declaration for QApplication::objectNameChanged(const QString &objectName)\nYou can bind a procedure to this signal.");
  methods += gsi::qt_signal ("organizationDomainChanged()", "organizationDomainChanged", "@brief Signal declaration for QApplication::organizationDomainChanged()\nYou can bind a procedure to this signal.");
  methods += gsi::qt_signal ("organizationNameChanged()", "organizationNameChanged", "@brief Signal declaration for QApplication::organizationNameChanged()\nYou can bind a procedure to this signal.");
  methods += gsi::qt_signal<const QPalette & > ("paletteChanged(const QPalette &)", "paletteChanged", gsi::arg("pal"), "@brief Signal declaration for QApplication::paletteChanged(const QPalette &pal)\nYou can bind a procedure to this signal.");
  methods += gsi::qt_signal<QScreen * > ("primaryScreenChanged(QScreen *)", "primaryScreenChanged", gsi::arg("screen"), "@brief Signal declaration for QApplication::primaryScreenChanged(QScreen *screen)\nYou can bind a procedure to this signal.");
  methods += gsi::qt_signal<QSessionManager & > ("saveStateRequest(QSessionManager &)", "saveStateRequest", gsi::arg("sessionManager"), "@brief Signal declaration for QApplication::saveStateRequest(QSessionManager &sessionManager)\nYou can bind a procedure to this signal.");
  methods += gsi::qt_signal<QScreen * > ("screenAdded(QScreen *)", "screenAdded", gsi::arg("screen"), "@brief Signal declaration for QApplication::screenAdded(QScreen *screen)\nYou can bind a procedure to this signal.");
  methods += gsi::qt_signal<QScreen * > ("screenRemoved(QScreen *)", "screenRemoved", gsi::arg("screen"), "@brief Signal declaration for QApplication::screenRemoved(QScreen *screen)\nYou can bind a procedure to this signal.");
  methods += new qt_gsi::GenericStaticMethod ("aboutQt", "@brief Static method void QApplication::aboutQt()\nThis method is static and can be called without an instance.", &_init_f_aboutQt_0, &_call_f_aboutQt_0);
  methods += new qt_gsi::GenericStaticMethod ("activeModalWidget", "@brief Static method QWidget *QApplication::activeModalWidget()\nThis method is static and can be called without an instance.", &_init_f_activeModalWidget_0, &_call_f_activeModalWidget_0);
  methods += new qt_gsi::GenericStaticMethod ("activePopupWidget", "@brief Static method QWidget *QApplication::activePopupWidget()\nThis method is static and can be called without an instance.", &_init_f_activePopupWidget_0, &_call_f_activePopupWidget_0);
  methods += new qt_gsi::GenericStaticMethod (":activeWindow", "@brief Static method QWidget *QApplication::activeWindow()\nThis method is static and can be called without an instance.", &_init_f_activeWindow_0, &_call_f_activeWindow_0);
  methods += new qt_gsi::GenericStaticMethod ("alert", "@brief Static method void QApplication::alert(QWidget *widget, int duration)\nThis method is static and can be called without an instance.", &_init_f_alert_1974, &_call_f_alert_1974);
  methods += new qt_gsi::GenericStaticMethod ("allWidgets", "@brief Static method QList<QWidget *> QApplication::allWidgets()\nThis method is static and can be called without an instance.", &_init_f_allWidgets_0, &_call_f_allWidgets_0);
  methods += new qt_gsi::GenericStaticMethod ("beep", "@brief Static method void QApplication::beep()\nThis method is static and can be called without an instance.", &_init_f_beep_0, &_call_f_beep_0);
  methods += new qt_gsi::GenericStaticMethod ("closeAllWindows", "@brief Static method void QApplication::closeAllWindows()\nThis method is static and can be called without an instance.", &_init_f_closeAllWindows_0, &_call_f_closeAllWindows_0);
  methods += new qt_gsi::GenericStaticMethod (":cursorFlashTime", "@brief Static method int QApplication::cursorFlashTime()\nThis method is static and can be called without an instance.", &_init_f_cursorFlashTime_0, &_call_f_cursorFlashTime_0);
  methods += new qt_gsi::GenericStaticMethod (":doubleClickInterval", "@brief Static method int QApplication::doubleClickInterval()\nThis method is static and can be called without an instance.", &_init_f_doubleClickInterval_0, &_call_f_doubleClickInterval_0);
  methods += new qt_gsi::GenericStaticMethod ("exec", "@brief Static method int QApplication::exec()\nThis method is static and can be called without an instance.", &_init_f_exec_0, &_call_f_exec_0);
  methods += new qt_gsi::GenericStaticMethod ("focusWidget", "@brief Static method QWidget *QApplication::focusWidget()\nThis method is static and can be called without an instance.", &_init_f_focusWidget_0, &_call_f_focusWidget_0);
  methods += new qt_gsi::GenericStaticMethod (":font", "@brief Static method QFont QApplication::font()\nThis method is static and can be called without an instance.", &_init_f_font_0, &_call_f_font_0);
  methods += new qt_gsi::GenericStaticMethod ("font", "@brief Static method QFont QApplication::font(const QWidget *)\nThis method is static and can be called without an instance.", &_init_f_font_2010, &_call_f_font_2010);
  methods += new qt_gsi::GenericStaticMethod ("font", "@brief Static method QFont QApplication::font(const char *className)\nThis method is static and can be called without an instance.", &_init_f_font_1731, &_call_f_font_1731);
  methods += new qt_gsi::GenericStaticMethod ("fontMetrics", "@brief Static method QFontMetrics QApplication::fontMetrics()\nThis method is static and can be called without an instance.", &_init_f_fontMetrics_0, &_call_f_fontMetrics_0);
  methods += new qt_gsi::GenericStaticMethod ("isEffectEnabled?", "@brief Static method bool QApplication::isEffectEnabled(Qt::UIEffect)\nThis method is static and can be called without an instance.", &_init_f_isEffectEnabled_1496, &_call_f_isEffectEnabled_1496);
  methods += new qt_gsi::GenericStaticMethod (":keyboardInputInterval", "@brief Static method int QApplication::keyboardInputInterval()\nThis method is static and can be called without an instance.", &_init_f_keyboardInputInterval_0, &_call_f_keyboardInputInterval_0);
  methods += new qt_gsi::GenericStaticMethod (":palette", "@brief Static method QPalette QApplication::palette()\nThis method is static and can be called without an instance.", &_init_f_palette_0, &_call_f_palette_0);
  methods += new qt_gsi::GenericStaticMethod ("palette", "@brief Static method QPalette QApplication::palette(const QWidget *)\nThis method is static and can be called without an instance.", &_init_f_palette_2010, &_call_f_palette_2010);
  methods += new qt_gsi::GenericStaticMethod ("palette", "@brief Static method QPalette QApplication::palette(const char *className)\nThis method is static and can be called without an instance.", &_init_f_palette_1731, &_call_f_palette_1731);
  methods += new qt_gsi::GenericStaticMethod ("setActiveWindow|activeWindow=", "@brief Static method void QApplication::setActiveWindow(QWidget *act)\nThis method is static and can be called without an instance.", &_init_f_setActiveWindow_1315, &_call_f_setActiveWindow_1315);
  methods += new qt_gsi::GenericStaticMethod ("setCursorFlashTime|cursorFlashTime=", "@brief Static method void QApplication::setCursorFlashTime(int)\nThis method is static and can be called without an instance.", &_init_f_setCursorFlashTime_767, &_call_f_setCursorFlashTime_767);
  methods += new qt_gsi::GenericStaticMethod ("setDoubleClickInterval|doubleClickInterval=", "@brief Static method void QApplication::setDoubleClickInterval(int)\nThis method is static and can be called without an instance.", &_init_f_setDoubleClickInterval_767, &_call_f_setDoubleClickInterval_767);
  methods += new qt_gsi::GenericStaticMethod ("setEffectEnabled", "@brief Static method void QApplication::setEffectEnabled(Qt::UIEffect, bool enable)\nThis method is static and can be called without an instance.", &_init_f_setEffectEnabled_2252, &_call_f_setEffectEnabled_2252);
  methods += new qt_gsi::GenericStaticMethod ("setFont", "@brief Static method void QApplication::setFont(const QFont &, const char *className)\nThis method is static and can be called without an instance.", &_init_f_setFont_3424, &_call_f_setFont_3424);
  methods += new qt_gsi::GenericStaticMethod ("setKeyboardInputInterval|keyboardInputInterval=", "@brief Static method void QApplication::setKeyboardInputInterval(int)\nThis method is static and can be called without an instance.", &_init_f_setKeyboardInputInterval_767, &_call_f_setKeyboardInputInterval_767);
  methods += new qt_gsi::GenericStaticMethod ("setPalette", "@brief Static method void QApplication::setPalette(const QPalette &, const char *className)\nThis method is static and can be called without an instance.", &_init_f_setPalette_3736, &_call_f_setPalette_3736);
  methods += new qt_gsi::GenericStaticMethod ("setStartDragDistance|startDragDistance=", "@brief Static method void QApplication::setStartDragDistance(int l)\nThis method is static and can be called without an instance.", &_init_f_setStartDragDistance_767, &_call_f_setStartDragDistance_767);
  methods += new qt_gsi::GenericStaticMethod ("setStartDragTime|startDragTime=", "@brief Static method void QApplication::setStartDragTime(int ms)\nThis method is static and can be called without an instance.", &_init_f_setStartDragTime_767, &_call_f_setStartDragTime_767);
  methods += new qt_gsi::GenericStaticMethod ("setStyle|style=", "@brief Static method void QApplication::setStyle(QStyle *)\nThis method is static and can be called without an instance.", &_init_f_setStyle_1232, &_call_f_setStyle_1232);
  methods += new qt_gsi::GenericStaticMethod ("setStyle|style=", "@brief Static method QStyle *QApplication::setStyle(const QString &)\nThis method is static and can be called without an instance.", &_init_f_setStyle_2025, &_call_f_setStyle_2025);
  methods += new qt_gsi::GenericStaticMethod ("setWheelScrollLines|wheelScrollLines=", "@brief Static method void QApplication::setWheelScrollLines(int)\nThis method is static and can be called without an instance.", &_init_f_setWheelScrollLines_767, &_call_f_setWheelScrollLines_767);
  methods += new qt_gsi::GenericStaticMethod (":startDragDistance", "@brief Static method int QApplication::startDragDistance()\nThis method is static and can be called without an instance.", &_init_f_startDragDistance_0, &_call_f_startDragDistance_0);
  methods += new qt_gsi::GenericStaticMethod (":startDragTime", "@brief Static method int QApplication::startDragTime()\nThis method is static and can be called without an instance.", &_init_f_startDragTime_0, &_call_f_startDragTime_0);
  methods += new qt_gsi::GenericStaticMethod (":style", "@brief Static method QStyle *QApplication::style()\nThis method is static and can be called without an instance.", &_init_f_style_0, &_call_f_style_0);
  methods += new qt_gsi::GenericStaticMethod ("topLevelAt", "@brief Static method QWidget *QApplication::topLevelAt(const QPoint &p)\nThis method is static and can be called without an instance.", &_init_f_topLevelAt_1916, &_call_f_topLevelAt_1916);
  methods += new qt_gsi::GenericStaticMethod ("topLevelAt", "@brief Static method QWidget *QApplication::topLevelAt(int x, int y)\nThis method is static and can be called without an instance.", &_init_f_topLevelAt_1426, &_call_f_topLevelAt_1426);
  methods += new qt_gsi::GenericStaticMethod ("topLevelWidgets", "@brief Static method QList<QWidget *> QApplication::topLevelWidgets()\nThis method is static and can be called without an instance.", &_init_f_topLevelWidgets_0, &_call_f_topLevelWidgets_0);
  methods += new qt_gsi::GenericStaticMethod ("tr", "@brief Static method QString QApplication::tr(const char *s, const char *c, int n)\nThis method is static and can be called without an instance.", &_init_f_tr_4013, &_call_f_tr_4013);
  methods += new qt_gsi::GenericStaticMethod (":wheelScrollLines", "@brief Static method int QApplication::wheelScrollLines()\nThis method is static and can be called without an instance.", &_init_f_wheelScrollLines_0, &_call_f_wheelScrollLines_0);
  methods += new qt_gsi::GenericStaticMethod ("widgetAt", "@brief Static method QWidget *QApplication::widgetAt(const QPoint &p)\nThis method is static and can be called without an instance.", &_init_f_widgetAt_1916, &_call_f_widgetAt_1916);
  methods += new qt_gsi::GenericStaticMethod ("widgetAt", "@brief Static method QWidget *QApplication::widgetAt(int x, int y)\nThis method is static and can be called without an instance.", &_init_f_widgetAt_1426, &_call_f_widgetAt_1426);
  return methods;
}

gsi::Class<QGuiApplication> &qtdecl_QGuiApplication ();

qt_gsi::QtNativeClass<QApplication> decl_QApplication (qtdecl_QGuiApplication (), "QtWidgets", "QApplication_Native",
  methods_QApplication (),
  "@hide\n@alias QApplication");

GSI_QTWIDGETS_PUBLIC gsi::Class<QApplication> &qtdecl_QApplication () { return decl_QApplication; }

}


class QApplication_Adaptor : public QApplication, public qt_gsi::QtObjectBase
{
public:
  static QApplication *ctor_QApplication_Adaptor_args(const std::vector<std::string> &args, bool gui)
  {
    //  QApplication needs static sources, so we give it some.
    static char **argv = 0;
    static std::vector<std::string> args_copy;
    static int argc = 0;

    if (argv != 0) {
      throw tl::Exception(tl::to_string(QObject::tr("QApplication cannot be instantiated twice")));
    }
    argv = new char *[args.size ()];
    args_copy = args;
    argc = int (args.size ());
    for (std::vector<std::string>::const_iterator a = args_copy.begin (); a != args_copy.end (); ++a) {
      argv[a - args_copy.begin ()] = (char *) a->c_str ();
    }

    return new QApplication_Adaptor (argc, argv, gui);
  }

  QApplication_Adaptor (int &argc, char **argv, bool gui) : QApplication (argc, argv, gui) { }

  virtual ~QApplication_Adaptor();

  //  [expose] bool QApplication::isSignalConnected(const QMetaMethod &signal)
  bool fp_QApplication_isSignalConnected_c2394 (const QMetaMethod &signal) const {
    return QApplication::isSignalConnected(signal);
  }

  //  [expose] int QApplication::receivers(const char *signal)
  int fp_QApplication_receivers_c1731 (const char *signal) const {
    return QApplication::receivers(signal);
  }

  //  [expose] void *QApplication::resolveInterface(const char *name, int revision)
  void * fp_QApplication_resolveInterface_c2390 (const char *name, int revision) const {
    return QApplication::resolveInterface(name, revision);
  }

  //  [expose] QObject *QApplication::sender()
  QObject * fp_QApplication_sender_c0 () const {
    return QApplication::sender();
  }

  //  [expose] int QApplication::senderSignalIndex()
  int fp_QApplication_senderSignalIndex_c0 () const {
    return QApplication::senderSignalIndex();
  }

  //  [emitter impl] void QApplication::aboutToQuit()
  void emitter_QApplication_aboutToQuit_3584()
  {
    throw tl::Exception ("Can't emit private signal 'void QApplication::aboutToQuit()'");
  }

  //  [emitter impl] void QApplication::applicationDisplayNameChanged()
  void emitter_QApplication_applicationDisplayNameChanged_0()
  {
    emit QApplication::applicationDisplayNameChanged();
  }

  //  [emitter impl] void QApplication::applicationNameChanged()
  void emitter_QApplication_applicationNameChanged_0()
  {
    emit QApplication::applicationNameChanged();
  }

  //  [emitter impl] void QApplication::applicationStateChanged(Qt::ApplicationState state)
  void emitter_QApplication_applicationStateChanged_2402(Qt::ApplicationState state)
  {
    emit QApplication::applicationStateChanged(state);
  }

  //  [emitter impl] void QApplication::applicationVersionChanged()
  void emitter_QApplication_applicationVersionChanged_0()
  {
    emit QApplication::applicationVersionChanged();
  }

  //  [emitter impl] void QApplication::commitDataRequest(QSessionManager &sessionManager)
  void emitter_QApplication_commitDataRequest_2138(QSessionManager &sessionManager)
  {
    emit QApplication::commitDataRequest(sessionManager);
  }

  //  [emitter impl] void QApplication::destroyed(QObject *)
  void emitter_QApplication_destroyed_1302(QObject *arg1)
  {
    emit QApplication::destroyed(arg1);
  }

  //  [adaptor impl] bool QApplication::eventFilter(QObject *watched, QEvent *event)
  bool cbs_eventFilter_2411_0(QObject *watched, QEvent *event)
  {
    return QApplication::eventFilter(watched, event);
  }

  virtual bool eventFilter(QObject *watched, QEvent *event)
  {
    if (cb_eventFilter_2411_0.can_issue()) {
      return cb_eventFilter_2411_0.issue<QApplication_Adaptor, bool, QObject *, QEvent *>(&QApplication_Adaptor::cbs_eventFilter_2411_0, watched, event);
    } else {
      return QApplication::eventFilter(watched, event);
    }
  }

  //  [emitter impl] void QApplication::focusChanged(QWidget *old, QWidget *now)
  void emitter_QApplication_focusChanged_2522(QWidget *old, QWidget *now)
  {
    emit QApplication::focusChanged(old, now);
  }

  //  [emitter impl] void QApplication::focusObjectChanged(QObject *focusObject)
  void emitter_QApplication_focusObjectChanged_1302(QObject *focusObject)
  {
    emit QApplication::focusObjectChanged(focusObject);
  }

  //  [emitter impl] void QApplication::focusWindowChanged(QWindow *focusWindow)
  void emitter_QApplication_focusWindowChanged_1335(QWindow *focusWindow)
  {
    emit QApplication::focusWindowChanged(focusWindow);
  }

  //  [emitter impl] void QApplication::fontChanged(const QFont &font)
  void emitter_QApplication_fontChanged_1801(const QFont &font)
  {
    emit QApplication::fontChanged(font);
  }

  //  [emitter impl] void QApplication::fontDatabaseChanged()
  void emitter_QApplication_fontDatabaseChanged_0()
  {
    emit QApplication::fontDatabaseChanged();
  }

  //  [emitter impl] void QApplication::lastWindowClosed()
  void emitter_QApplication_lastWindowClosed_0()
  {
    emit QApplication::lastWindowClosed();
  }

  //  [emitter impl] void QApplication::layoutDirectionChanged(Qt::LayoutDirection direction)
  void emitter_QApplication_layoutDirectionChanged_2316(Qt::LayoutDirection direction)
  {
    emit QApplication::layoutDirectionChanged(direction);
  }

  //  [emitter impl] void QApplication::objectNameChanged(const QString &objectName)
  void emitter_QApplication_objectNameChanged_4567(const QString &objectName)
  {
    __SUPPRESS_UNUSED_WARNING (objectName);
    throw tl::Exception ("Can't emit private signal 'void QApplication::objectNameChanged(const QString &objectName)'");
  }

  //  [emitter impl] void QApplication::organizationDomainChanged()
  void emitter_QApplication_organizationDomainChanged_0()
  {
    emit QApplication::organizationDomainChanged();
  }

  //  [emitter impl] void QApplication::organizationNameChanged()
  void emitter_QApplication_organizationNameChanged_0()
  {
    emit QApplication::organizationNameChanged();
  }

  //  [emitter impl] void QApplication::paletteChanged(const QPalette &pal)
  void emitter_QApplication_paletteChanged_2113(const QPalette &pal)
  {
    emit QApplication::paletteChanged(pal);
  }

  //  [emitter impl] void QApplication::primaryScreenChanged(QScreen *screen)
  void emitter_QApplication_primaryScreenChanged_1311(QScreen *screen)
  {
    emit QApplication::primaryScreenChanged(screen);
  }

  //  [emitter impl] void QApplication::saveStateRequest(QSessionManager &sessionManager)
  void emitter_QApplication_saveStateRequest_2138(QSessionManager &sessionManager)
  {
    emit QApplication::saveStateRequest(sessionManager);
  }

  //  [emitter impl] void QApplication::screenAdded(QScreen *screen)
  void emitter_QApplication_screenAdded_1311(QScreen *screen)
  {
    emit QApplication::screenAdded(screen);
  }

  //  [emitter impl] void QApplication::screenRemoved(QScreen *screen)
  void emitter_QApplication_screenRemoved_1311(QScreen *screen)
  {
    emit QApplication::screenRemoved(screen);
  }

  //  [adaptor impl] void QApplication::childEvent(QChildEvent *event)
  void cbs_childEvent_1701_0(QChildEvent *event)
  {
    QApplication::childEvent(event);
  }

  virtual void childEvent(QChildEvent *event)
  {
    if (cb_childEvent_1701_0.can_issue()) {
      cb_childEvent_1701_0.issue<QApplication_Adaptor, QChildEvent *>(&QApplication_Adaptor::cbs_childEvent_1701_0, event);
    } else {
      QApplication::childEvent(event);
    }
  }

  //  [adaptor impl] void QApplication::customEvent(QEvent *event)
  void cbs_customEvent_1217_0(QEvent *event)
  {
    QApplication::customEvent(event);
  }

  virtual void customEvent(QEvent *event)
  {
    if (cb_customEvent_1217_0.can_issue()) {
      cb_customEvent_1217_0.issue<QApplication_Adaptor, QEvent *>(&QApplication_Adaptor::cbs_customEvent_1217_0, event);
    } else {
      QApplication::customEvent(event);
    }
  }

  //  [adaptor impl] void QApplication::disconnectNotify(const QMetaMethod &signal)
  void cbs_disconnectNotify_2394_0(const QMetaMethod &signal)
  {
    QApplication::disconnectNotify(signal);
  }

  virtual void disconnectNotify(const QMetaMethod &signal)
  {
    if (cb_disconnectNotify_2394_0.can_issue()) {
      cb_disconnectNotify_2394_0.issue<QApplication_Adaptor, const QMetaMethod &>(&QApplication_Adaptor::cbs_disconnectNotify_2394_0, signal);
    } else {
      QApplication::disconnectNotify(signal);
    }
  }

  //  [adaptor impl] bool QApplication::event(QEvent *)
  bool cbs_event_1217_0(QEvent *arg1)
  {
    return QApplication::event(arg1);
  }

  virtual bool event(QEvent *arg1)
  {
    if (cb_event_1217_0.can_issue()) {
      return cb_event_1217_0.issue<QApplication_Adaptor, bool, QEvent *>(&QApplication_Adaptor::cbs_event_1217_0, arg1);
    } else {
      return QApplication::event(arg1);
    }
  }

  //  [adaptor impl] void QApplication::timerEvent(QTimerEvent *event)
  void cbs_timerEvent_1730_0(QTimerEvent *event)
  {
    QApplication::timerEvent(event);
  }

  virtual void timerEvent(QTimerEvent *event)
  {
    if (cb_timerEvent_1730_0.can_issue()) {
      cb_timerEvent_1730_0.issue<QApplication_Adaptor, QTimerEvent *>(&QApplication_Adaptor::cbs_timerEvent_1730_0, event);
    } else {
      QApplication::timerEvent(event);
    }
  }

  gsi::Callback cb_eventFilter_2411_0;
  gsi::Callback cb_childEvent_1701_0;
  gsi::Callback cb_customEvent_1217_0;
  gsi::Callback cb_disconnectNotify_2394_0;
  gsi::Callback cb_event_1217_0;
  gsi::Callback cb_timerEvent_1730_0;
};

QApplication_Adaptor::~QApplication_Adaptor() { }

// emitter void QApplication::aboutToQuit()

static void _init_emitter_aboutToQuit_3584 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<void > ();
}

static void _call_emitter_aboutToQuit_3584 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs & /*ret*/) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  ((QApplication_Adaptor *)cls)->emitter_QApplication_aboutToQuit_3584 ();
}


// emitter void QApplication::applicationDisplayNameChanged()

static void _init_emitter_applicationDisplayNameChanged_0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<void > ();
}

static void _call_emitter_applicationDisplayNameChanged_0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs & /*ret*/) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  ((QApplication_Adaptor *)cls)->emitter_QApplication_applicationDisplayNameChanged_0 ();
}


// emitter void QApplication::applicationNameChanged()

static void _init_emitter_applicationNameChanged_0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<void > ();
}

static void _call_emitter_applicationNameChanged_0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs & /*ret*/) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  ((QApplication_Adaptor *)cls)->emitter_QApplication_applicationNameChanged_0 ();
}


// emitter void QApplication::applicationStateChanged(Qt::ApplicationState state)

static void _init_emitter_applicationStateChanged_2402 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("state");
  decl->add_arg<const qt_gsi::Converter<Qt::ApplicationState>::target_type & > (argspec_0);
  decl->set_return<void > ();
}

static void _call_emitter_applicationStateChanged_2402 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs & /*ret*/) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  const qt_gsi::Converter<Qt::ApplicationState>::target_type & arg1 = gsi::arg_reader<const qt_gsi::Converter<Qt::ApplicationState>::target_type & >() (args, heap);
  ((QApplication_Adaptor *)cls)->emitter_QApplication_applicationStateChanged_2402 (arg1);
}


// emitter void QApplication::applicationVersionChanged()

static void _init_emitter_applicationVersionChanged_0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<void > ();
}

static void _call_emitter_applicationVersionChanged_0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs & /*ret*/) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  ((QApplication_Adaptor *)cls)->emitter_QApplication_applicationVersionChanged_0 ();
}


// void QApplication::childEvent(QChildEvent *event)

static void _init_cbs_childEvent_1701_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("event");
  decl->add_arg<QChildEvent * > (argspec_0);
  decl->set_return<void > ();
}

static void _call_cbs_childEvent_1701_0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  QChildEvent *arg1 = args.read<QChildEvent * > (heap);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QApplication_Adaptor *)cls)->cbs_childEvent_1701_0 (arg1);
}

static void _set_callback_cbs_childEvent_1701_0 (void *cls, const gsi::Callback &cb)
{
  ((QApplication_Adaptor *)cls)->cb_childEvent_1701_0 = cb;
}


// emitter void QApplication::commitDataRequest(QSessionManager &sessionManager)

static void _init_emitter_commitDataRequest_2138 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("sessionManager");
  decl->add_arg<QSessionManager & > (argspec_0);
  decl->set_return<void > ();
}

static void _call_emitter_commitDataRequest_2138 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs & /*ret*/) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  QSessionManager &arg1 = gsi::arg_reader<QSessionManager & >() (args, heap);
  ((QApplication_Adaptor *)cls)->emitter_QApplication_commitDataRequest_2138 (arg1);
}


// void QApplication::customEvent(QEvent *event)

static void _init_cbs_customEvent_1217_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("event");
  decl->add_arg<QEvent * > (argspec_0);
  decl->set_return<void > ();
}

static void _call_cbs_customEvent_1217_0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  QEvent *arg1 = args.read<QEvent * > (heap);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QApplication_Adaptor *)cls)->cbs_customEvent_1217_0 (arg1);
}

static void _set_callback_cbs_customEvent_1217_0 (void *cls, const gsi::Callback &cb)
{
  ((QApplication_Adaptor *)cls)->cb_customEvent_1217_0 = cb;
}


// emitter void QApplication::destroyed(QObject *)

static void _init_emitter_destroyed_1302 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("arg1", true, "nullptr");
  decl->add_arg<QObject * > (argspec_0);
  decl->set_return<void > ();
}

static void _call_emitter_destroyed_1302 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs & /*ret*/) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  QObject *arg1 = args ? gsi::arg_reader<QObject * >() (args, heap) : gsi::arg_maker<QObject * >() (nullptr, heap);
  ((QApplication_Adaptor *)cls)->emitter_QApplication_destroyed_1302 (arg1);
}


// void QApplication::disconnectNotify(const QMetaMethod &signal)

static void _init_cbs_disconnectNotify_2394_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("signal");
  decl->add_arg<const QMetaMethod & > (argspec_0);
  decl->set_return<void > ();
}

static void _call_cbs_disconnectNotify_2394_0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  const QMetaMethod &arg1 = args.read<const QMetaMethod & > (heap);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QApplication_Adaptor *)cls)->cbs_disconnectNotify_2394_0 (arg1);
}

static void _set_callback_cbs_disconnectNotify_2394_0 (void *cls, const gsi::Callback &cb)
{
  ((QApplication_Adaptor *)cls)->cb_disconnectNotify_2394_0 = cb;
}


// bool QApplication::event(QEvent *)

static void _init_cbs_event_1217_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("arg1");
  decl->add_arg<QEvent * > (argspec_0);
  decl->set_return<bool > ();
}

static void _call_cbs_event_1217_0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  QEvent *arg1 = args.read<QEvent * > (heap);
  ret.write<bool > ((bool)((QApplication_Adaptor *)cls)->cbs_event_1217_0 (arg1));
}

static void _set_callback_cbs_event_1217_0 (void *cls, const gsi::Callback &cb)
{
  ((QApplication_Adaptor *)cls)->cb_event_1217_0 = cb;
}


// bool QApplication::eventFilter(QObject *watched, QEvent *event)

static void _init_cbs_eventFilter_2411_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("watched");
  decl->add_arg<QObject * > (argspec_0);
  static gsi::ArgSpecBase argspec_1 ("event");
  decl->add_arg<QEvent * > (argspec_1);
  decl->set_return<bool > ();
}

static void _call_cbs_eventFilter_2411_0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  QObject *arg1 = args.read<QObject * > (heap);
  QEvent *arg2 = args.read<QEvent * > (heap);
  ret.write<bool > ((bool)((QApplication_Adaptor *)cls)->cbs_eventFilter_2411_0 (arg1, arg2));
}

static void _set_callback_cbs_eventFilter_2411_0 (void *cls, const gsi::Callback &cb)
{
  ((QApplication_Adaptor *)cls)->cb_eventFilter_2411_0 = cb;
}


// emitter void QApplication::focusChanged(QWidget *old, QWidget *now)

static void _init_emitter_focusChanged_2522 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("old");
  decl->add_arg<QWidget * > (argspec_0);
  static gsi::ArgSpecBase argspec_1 ("now");
  decl->add_arg<QWidget * > (argspec_1);
  decl->set_return<void > ();
}

static void _call_emitter_focusChanged_2522 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs & /*ret*/) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  QWidget *arg1 = gsi::arg_reader<QWidget * >() (args, heap);
  QWidget *arg2 = gsi::arg_reader<QWidget * >() (args, heap);
  ((QApplication_Adaptor *)cls)->emitter_QApplication_focusChanged_2522 (arg1, arg2);
}


// emitter void QApplication::focusObjectChanged(QObject *focusObject)

static void _init_emitter_focusObjectChanged_1302 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("focusObject");
  decl->add_arg<QObject * > (argspec_0);
  decl->set_return<void > ();
}

static void _call_emitter_focusObjectChanged_1302 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs & /*ret*/) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  QObject *arg1 = gsi::arg_reader<QObject * >() (args, heap);
  ((QApplication_Adaptor *)cls)->emitter_QApplication_focusObjectChanged_1302 (arg1);
}


// emitter void QApplication::focusWindowChanged(QWindow *focusWindow)

static void _init_emitter_focusWindowChanged_1335 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("focusWindow");
  decl->add_arg<QWindow * > (argspec_0);
  decl->set_return<void > ();
}

static void _call_emitter_focusWindowChanged_1335 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs & /*ret*/) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  QWindow *arg1 = gsi::arg_reader<QWindow * >() (args, heap);
  ((QApplication_Adaptor *)cls)->emitter_QApplication_focusWindowChanged_1335 (arg1);
}


// emitter void QApplication::fontChanged(const QFont &font)

static void _init_emitter_fontChanged_1801 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("font");
  decl->add_arg<const QFont & > (argspec_0);
  decl->set_return<void > ();
}

static void _call_emitter_fontChanged_1801 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs & /*ret*/) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  const QFont &arg1 = gsi::arg_reader<const QFont & >() (args, heap);
  ((QApplication_Adaptor *)cls)->emitter_QApplication_fontChanged_1801 (arg1);
}


// emitter void QApplication::fontDatabaseChanged()

static void _init_emitter_fontDatabaseChanged_0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<void > ();
}

static void _call_emitter_fontDatabaseChanged_0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs & /*ret*/) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  ((QApplication_Adaptor *)cls)->emitter_QApplication_fontDatabaseChanged_0 ();
}


// exposed bool QApplication::isSignalConnected(const QMetaMethod &signal)

static void _init_fp_isSignalConnected_c2394 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("signal");
  decl->add_arg<const QMetaMethod & > (argspec_0);
  decl->set_return<bool > ();
}

static void _call_fp_isSignalConnected_c2394 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  const QMetaMethod &arg1 = gsi::arg_reader<const QMetaMethod & >() (args, heap);
  ret.write<bool > ((bool)((QApplication_Adaptor *)cls)->fp_QApplication_isSignalConnected_c2394 (arg1));
}


// emitter void QApplication::lastWindowClosed()

static void _init_emitter_lastWindowClosed_0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<void > ();
}

static void _call_emitter_lastWindowClosed_0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs & /*ret*/) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  ((QApplication_Adaptor *)cls)->emitter_QApplication_lastWindowClosed_0 ();
}


// emitter void QApplication::layoutDirectionChanged(Qt::LayoutDirection direction)

static void _init_emitter_layoutDirectionChanged_2316 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("direction");
  decl->add_arg<const qt_gsi::Converter<Qt::LayoutDirection>::target_type & > (argspec_0);
  decl->set_return<void > ();
}

static void _call_emitter_layoutDirectionChanged_2316 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs & /*ret*/) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  const qt_gsi::Converter<Qt::LayoutDirection>::target_type & arg1 = gsi::arg_reader<const qt_gsi::Converter<Qt::LayoutDirection>::target_type & >() (args, heap);
  ((QApplication_Adaptor *)cls)->emitter_QApplication_layoutDirectionChanged_2316 (arg1);
}


// emitter void QApplication::objectNameChanged(const QString &objectName)

static void _init_emitter_objectNameChanged_4567 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("objectName");
  decl->add_arg<const QString & > (argspec_0);
  decl->set_return<void > ();
}

static void _call_emitter_objectNameChanged_4567 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs & /*ret*/) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  const QString &arg1 = gsi::arg_reader<const QString & >() (args, heap);
  ((QApplication_Adaptor *)cls)->emitter_QApplication_objectNameChanged_4567 (arg1);
}


// emitter void QApplication::organizationDomainChanged()

static void _init_emitter_organizationDomainChanged_0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<void > ();
}

static void _call_emitter_organizationDomainChanged_0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs & /*ret*/) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  ((QApplication_Adaptor *)cls)->emitter_QApplication_organizationDomainChanged_0 ();
}


// emitter void QApplication::organizationNameChanged()

static void _init_emitter_organizationNameChanged_0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<void > ();
}

static void _call_emitter_organizationNameChanged_0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs & /*ret*/) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  ((QApplication_Adaptor *)cls)->emitter_QApplication_organizationNameChanged_0 ();
}


// emitter void QApplication::paletteChanged(const QPalette &pal)

static void _init_emitter_paletteChanged_2113 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("pal");
  decl->add_arg<const QPalette & > (argspec_0);
  decl->set_return<void > ();
}

static void _call_emitter_paletteChanged_2113 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs & /*ret*/) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  const QPalette &arg1 = gsi::arg_reader<const QPalette & >() (args, heap);
  ((QApplication_Adaptor *)cls)->emitter_QApplication_paletteChanged_2113 (arg1);
}


// emitter void QApplication::primaryScreenChanged(QScreen *screen)

static void _init_emitter_primaryScreenChanged_1311 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("screen");
  decl->add_arg<QScreen * > (argspec_0);
  decl->set_return<void > ();
}

static void _call_emitter_primaryScreenChanged_1311 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs & /*ret*/) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  QScreen *arg1 = gsi::arg_reader<QScreen * >() (args, heap);
  ((QApplication_Adaptor *)cls)->emitter_QApplication_primaryScreenChanged_1311 (arg1);
}


// exposed int QApplication::receivers(const char *signal)

static void _init_fp_receivers_c1731 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("signal");
  decl->add_arg<const char * > (argspec_0);
  decl->set_return<int > ();
}

static void _call_fp_receivers_c1731 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  const char *arg1 = gsi::arg_reader<const char * >() (args, heap);
  ret.write<int > ((int)((QApplication_Adaptor *)cls)->fp_QApplication_receivers_c1731 (arg1));
}


// exposed void *QApplication::resolveInterface(const char *name, int revision)

static void _init_fp_resolveInterface_c2390 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("name");
  decl->add_arg<const char * > (argspec_0);
  static gsi::ArgSpecBase argspec_1 ("revision");
  decl->add_arg<int > (argspec_1);
  decl->set_return<void * > ();
}

static void _call_fp_resolveInterface_c2390 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  const char *arg1 = gsi::arg_reader<const char * >() (args, heap);
  int arg2 = gsi::arg_reader<int >() (args, heap);
  ret.write<void * > ((void *)((QApplication_Adaptor *)cls)->fp_QApplication_resolveInterface_c2390 (arg1, arg2));
}


// emitter void QApplication::saveStateRequest(QSessionManager &sessionManager)

static void _init_emitter_saveStateRequest_2138 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("sessionManager");
  decl->add_arg<QSessionManager & > (argspec_0);
  decl->set_return<void > ();
}

static void _call_emitter_saveStateRequest_2138 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs & /*ret*/) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  QSessionManager &arg1 = gsi::arg_reader<QSessionManager & >() (args, heap);
  ((QApplication_Adaptor *)cls)->emitter_QApplication_saveStateRequest_2138 (arg1);
}


// emitter void QApplication::screenAdded(QScreen *screen)

static void _init_emitter_screenAdded_1311 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("screen");
  decl->add_arg<QScreen * > (argspec_0);
  decl->set_return<void > ();
}

static void _call_emitter_screenAdded_1311 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs & /*ret*/) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  QScreen *arg1 = gsi::arg_reader<QScreen * >() (args, heap);
  ((QApplication_Adaptor *)cls)->emitter_QApplication_screenAdded_1311 (arg1);
}


// emitter void QApplication::screenRemoved(QScreen *screen)

static void _init_emitter_screenRemoved_1311 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("screen");
  decl->add_arg<QScreen * > (argspec_0);
  decl->set_return<void > ();
}

static void _call_emitter_screenRemoved_1311 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs & /*ret*/) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  QScreen *arg1 = gsi::arg_reader<QScreen * >() (args, heap);
  ((QApplication_Adaptor *)cls)->emitter_QApplication_screenRemoved_1311 (arg1);
}


// exposed QObject *QApplication::sender()

static void _init_fp_sender_c0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<QObject * > ();
}

static void _call_fp_sender_c0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  ret.write<QObject * > ((QObject *)((QApplication_Adaptor *)cls)->fp_QApplication_sender_c0 ());
}


// exposed int QApplication::senderSignalIndex()

static void _init_fp_senderSignalIndex_c0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<int > ();
}

static void _call_fp_senderSignalIndex_c0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  ret.write<int > ((int)((QApplication_Adaptor *)cls)->fp_QApplication_senderSignalIndex_c0 ());
}


// void QApplication::timerEvent(QTimerEvent *event)

static void _init_cbs_timerEvent_1730_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("event");
  decl->add_arg<QTimerEvent * > (argspec_0);
  decl->set_return<void > ();
}

static void _call_cbs_timerEvent_1730_0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  QTimerEvent *arg1 = args.read<QTimerEvent * > (heap);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QApplication_Adaptor *)cls)->cbs_timerEvent_1730_0 (arg1);
}

static void _set_callback_cbs_timerEvent_1730_0 (void *cls, const gsi::Callback &cb)
{
  ((QApplication_Adaptor *)cls)->cb_timerEvent_1730_0 = cb;
}


namespace gsi
{

gsi::Class<QApplication> &qtdecl_QApplication ();

static gsi::Methods methods_QApplication_Adaptor () {
  gsi::Methods methods;
  methods += new qt_gsi::GenericMethod ("emit_aboutToQuit", "@brief Emitter for signal void QApplication::aboutToQuit()\nCall this method to emit this signal.", false, &_init_emitter_aboutToQuit_3584, &_call_emitter_aboutToQuit_3584);
  methods += new qt_gsi::GenericMethod ("emit_applicationDisplayNameChanged", "@brief Emitter for signal void QApplication::applicationDisplayNameChanged()\nCall this method to emit this signal.", false, &_init_emitter_applicationDisplayNameChanged_0, &_call_emitter_applicationDisplayNameChanged_0);
  methods += new qt_gsi::GenericMethod ("emit_applicationNameChanged", "@brief Emitter for signal void QApplication::applicationNameChanged()\nCall this method to emit this signal.", false, &_init_emitter_applicationNameChanged_0, &_call_emitter_applicationNameChanged_0);
  methods += new qt_gsi::GenericMethod ("emit_applicationStateChanged", "@brief Emitter for signal void QApplication::applicationStateChanged(Qt::ApplicationState state)\nCall this method to emit this signal.", false, &_init_emitter_applicationStateChanged_2402, &_call_emitter_applicationStateChanged_2402);
  methods += new qt_gsi::GenericMethod ("emit_applicationVersionChanged", "@brief Emitter for signal void QApplication::applicationVersionChanged()\nCall this method to emit this signal.", false, &_init_emitter_applicationVersionChanged_0, &_call_emitter_applicationVersionChanged_0);
  methods += new qt_gsi::GenericMethod ("*childEvent", "@brief Virtual method void QApplication::childEvent(QChildEvent *event)\nThis method can be reimplemented in a derived class.", false, &_init_cbs_childEvent_1701_0, &_call_cbs_childEvent_1701_0);
  methods += new qt_gsi::GenericMethod ("*childEvent", "@hide", false, &_init_cbs_childEvent_1701_0, &_call_cbs_childEvent_1701_0, &_set_callback_cbs_childEvent_1701_0);
  methods += new qt_gsi::GenericMethod ("emit_commitDataRequest", "@brief Emitter for signal void QApplication::commitDataRequest(QSessionManager &sessionManager)\nCall this method to emit this signal.", false, &_init_emitter_commitDataRequest_2138, &_call_emitter_commitDataRequest_2138);
  methods += new qt_gsi::GenericMethod ("*customEvent", "@brief Virtual method void QApplication::customEvent(QEvent *event)\nThis method can be reimplemented in a derived class.", false, &_init_cbs_customEvent_1217_0, &_call_cbs_customEvent_1217_0);
  methods += new qt_gsi::GenericMethod ("*customEvent", "@hide", false, &_init_cbs_customEvent_1217_0, &_call_cbs_customEvent_1217_0, &_set_callback_cbs_customEvent_1217_0);
  methods += new qt_gsi::GenericMethod ("emit_destroyed", "@brief Emitter for signal void QApplication::destroyed(QObject *)\nCall this method to emit this signal.", false, &_init_emitter_destroyed_1302, &_call_emitter_destroyed_1302);
  methods += new qt_gsi::GenericMethod ("*disconnectNotify", "@brief Virtual method void QApplication::disconnectNotify(const QMetaMethod &signal)\nThis method can be reimplemented in a derived class.", false, &_init_cbs_disconnectNotify_2394_0, &_call_cbs_disconnectNotify_2394_0);
  methods += new qt_gsi::GenericMethod ("*disconnectNotify", "@hide", false, &_init_cbs_disconnectNotify_2394_0, &_call_cbs_disconnectNotify_2394_0, &_set_callback_cbs_disconnectNotify_2394_0);
  methods += new qt_gsi::GenericMethod ("*event", "@brief Virtual method bool QApplication::event(QEvent *)\nThis method can be reimplemented in a derived class.", false, &_init_cbs_event_1217_0, &_call_cbs_event_1217_0);
  methods += new qt_gsi::GenericMethod ("*event", "@hide", false, &_init_cbs_event_1217_0, &_call_cbs_event_1217_0, &_set_callback_cbs_event_1217_0);
  methods += new qt_gsi::GenericMethod ("eventFilter", "@brief Virtual method bool QApplication::eventFilter(QObject *watched, QEvent *event)\nThis method can be reimplemented in a derived class.", false, &_init_cbs_eventFilter_2411_0, &_call_cbs_eventFilter_2411_0);
  methods += new qt_gsi::GenericMethod ("eventFilter", "@hide", false, &_init_cbs_eventFilter_2411_0, &_call_cbs_eventFilter_2411_0, &_set_callback_cbs_eventFilter_2411_0);
  methods += new qt_gsi::GenericMethod ("emit_focusChanged", "@brief Emitter for signal void QApplication::focusChanged(QWidget *old, QWidget *now)\nCall this method to emit this signal.", false, &_init_emitter_focusChanged_2522, &_call_emitter_focusChanged_2522);
  methods += new qt_gsi::GenericMethod ("emit_focusObjectChanged", "@brief Emitter for signal void QApplication::focusObjectChanged(QObject *focusObject)\nCall this method to emit this signal.", false, &_init_emitter_focusObjectChanged_1302, &_call_emitter_focusObjectChanged_1302);
  methods += new qt_gsi::GenericMethod ("emit_focusWindowChanged", "@brief Emitter for signal void QApplication::focusWindowChanged(QWindow *focusWindow)\nCall this method to emit this signal.", false, &_init_emitter_focusWindowChanged_1335, &_call_emitter_focusWindowChanged_1335);
  methods += new qt_gsi::GenericMethod ("emit_fontChanged", "@brief Emitter for signal void QApplication::fontChanged(const QFont &font)\nCall this method to emit this signal.", false, &_init_emitter_fontChanged_1801, &_call_emitter_fontChanged_1801);
  methods += new qt_gsi::GenericMethod ("emit_fontDatabaseChanged", "@brief Emitter for signal void QApplication::fontDatabaseChanged()\nCall this method to emit this signal.", false, &_init_emitter_fontDatabaseChanged_0, &_call_emitter_fontDatabaseChanged_0);
  methods += new qt_gsi::GenericMethod ("*isSignalConnected", "@brief Method bool QApplication::isSignalConnected(const QMetaMethod &signal)\nThis method is protected and can only be called from inside a derived class.", true, &_init_fp_isSignalConnected_c2394, &_call_fp_isSignalConnected_c2394);
  methods += new qt_gsi::GenericMethod ("emit_lastWindowClosed", "@brief Emitter for signal void QApplication::lastWindowClosed()\nCall this method to emit this signal.", false, &_init_emitter_lastWindowClosed_0, &_call_emitter_lastWindowClosed_0);
  methods += new qt_gsi::GenericMethod ("emit_layoutDirectionChanged", "@brief Emitter for signal void QApplication::layoutDirectionChanged(Qt::LayoutDirection direction)\nCall this method to emit this signal.", false, &_init_emitter_layoutDirectionChanged_2316, &_call_emitter_layoutDirectionChanged_2316);
  methods += new qt_gsi::GenericMethod ("emit_objectNameChanged", "@brief Emitter for signal void QApplication::objectNameChanged(const QString &objectName)\nCall this method to emit this signal.", false, &_init_emitter_objectNameChanged_4567, &_call_emitter_objectNameChanged_4567);
  methods += new qt_gsi::GenericMethod ("emit_organizationDomainChanged", "@brief Emitter for signal void QApplication::organizationDomainChanged()\nCall this method to emit this signal.", false, &_init_emitter_organizationDomainChanged_0, &_call_emitter_organizationDomainChanged_0);
  methods += new qt_gsi::GenericMethod ("emit_organizationNameChanged", "@brief Emitter for signal void QApplication::organizationNameChanged()\nCall this method to emit this signal.", false, &_init_emitter_organizationNameChanged_0, &_call_emitter_organizationNameChanged_0);
  methods += new qt_gsi::GenericMethod ("emit_paletteChanged", "@brief Emitter for signal void QApplication::paletteChanged(const QPalette &pal)\nCall this method to emit this signal.", false, &_init_emitter_paletteChanged_2113, &_call_emitter_paletteChanged_2113);
  methods += new qt_gsi::GenericMethod ("emit_primaryScreenChanged", "@brief Emitter for signal void QApplication::primaryScreenChanged(QScreen *screen)\nCall this method to emit this signal.", false, &_init_emitter_primaryScreenChanged_1311, &_call_emitter_primaryScreenChanged_1311);
  methods += new qt_gsi::GenericMethod ("*receivers", "@brief Method int QApplication::receivers(const char *signal)\nThis method is protected and can only be called from inside a derived class.", true, &_init_fp_receivers_c1731, &_call_fp_receivers_c1731);
  methods += new qt_gsi::GenericMethod ("*resolveInterface", "@brief Method void *QApplication::resolveInterface(const char *name, int revision)\nThis method is protected and can only be called from inside a derived class.", true, &_init_fp_resolveInterface_c2390, &_call_fp_resolveInterface_c2390);
  methods += new qt_gsi::GenericMethod ("emit_saveStateRequest", "@brief Emitter for signal void QApplication::saveStateRequest(QSessionManager &sessionManager)\nCall this method to emit this signal.", false, &_init_emitter_saveStateRequest_2138, &_call_emitter_saveStateRequest_2138);
  methods += new qt_gsi::GenericMethod ("emit_screenAdded", "@brief Emitter for signal void QApplication::screenAdded(QScreen *screen)\nCall this method to emit this signal.", false, &_init_emitter_screenAdded_1311, &_call_emitter_screenAdded_1311);
  methods += new qt_gsi::GenericMethod ("emit_screenRemoved", "@brief Emitter for signal void QApplication::screenRemoved(QScreen *screen)\nCall this method to emit this signal.", false, &_init_emitter_screenRemoved_1311, &_call_emitter_screenRemoved_1311);
  methods += new qt_gsi::GenericMethod ("*sender", "@brief Method QObject *QApplication::sender()\nThis method is protected and can only be called from inside a derived class.", true, &_init_fp_sender_c0, &_call_fp_sender_c0);
  methods += new qt_gsi::GenericMethod ("*senderSignalIndex", "@brief Method int QApplication::senderSignalIndex()\nThis method is protected and can only be called from inside a derived class.", true, &_init_fp_senderSignalIndex_c0, &_call_fp_senderSignalIndex_c0);
  methods += new qt_gsi::GenericMethod ("*timerEvent", "@brief Virtual method void QApplication::timerEvent(QTimerEvent *event)\nThis method can be reimplemented in a derived class.", false, &_init_cbs_timerEvent_1730_0, &_call_cbs_timerEvent_1730_0);
  methods += new qt_gsi::GenericMethod ("*timerEvent", "@hide", false, &_init_cbs_timerEvent_1730_0, &_call_cbs_timerEvent_1730_0, &_set_callback_cbs_timerEvent_1730_0);
  return methods;
}

gsi::Class<QApplication_Adaptor> decl_QApplication_Adaptor (qtdecl_QApplication (), "QtWidgets", "QApplication",
    gsi::constructor("new", &QApplication_Adaptor::ctor_QApplication_Adaptor_args, gsi::arg ("argv"), gsi::arg ("gui", true), "@brief Creates a new QApplication object\n\n@param argv The command line arguments to pass to Qt\n@param gui If true, a GUI-enabled application is constructed")
+
  methods_QApplication_Adaptor (),
  "@qt\n@brief Binding of QApplication");

}

