/*
 * Copyright 2010-2019 JetBrains s.r.o. Use of this source code is governed by the Apache 2.0 license
 * that can be found in the license/LICENSE.txt file.
 */

package org.jetbrains.kotlin.formatter;

import com.intellij.testFramework.TestDataPath;
import org.jetbrains.kotlin.test.JUnit3RunnerWithInners;
import org.jetbrains.kotlin.test.KotlinTestUtils;
import org.jetbrains.kotlin.test.TargetBackend;
import org.jetbrains.kotlin.test.TestMetadata;
import org.junit.runner.RunWith;

import java.io.File;
import java.util.regex.Pattern;

/** This class is generated by {@link org.jetbrains.kotlin.generators.tests.TestsPackage}. DO NOT MODIFY MANUALLY */
@SuppressWarnings("all")
@RunWith(JUnit3RunnerWithInners.class)
public class FormatterTestGenerated extends AbstractFormatterTest {
    @TestMetadata("idea/testData/formatter")
    @TestDataPath("$PROJECT_ROOT")
    @RunWith(JUnit3RunnerWithInners.class)
    public static class Formatter extends AbstractFormatterTest {
        private void runTest(String testDataFilePath) throws Exception {
            KotlinTestUtils.runTest(this::doTest, TargetBackend.ANY, testDataFilePath);
        }

        @TestMetadata("AfterSemiColonInEnumClass.after.kt")
        public void testAfterSemiColonInEnumClass() throws Exception {
            runTest("idea/testData/formatter/AfterSemiColonInEnumClass.after.kt");
        }

        public void testAllFilesPresentInFormatter() throws Exception {
            KotlinTestUtils.assertAllTestsPresentByMetadata(this.getClass(), new File("idea/testData/formatter"), Pattern.compile("^([^\\.]+)\\.after\\.kt.*$"), TargetBackend.ANY, true);
        }

        @TestMetadata("AnnotationBeforeExpression.after.kt")
        public void testAnnotationBeforeExpression() throws Exception {
            runTest("idea/testData/formatter/AnnotationBeforeExpression.after.kt");
        }

        @TestMetadata("AnnotationBeforeTypeAliasOrConstructor.after.kt")
        public void testAnnotationBeforeTypeAliasOrConstructor() throws Exception {
            runTest("idea/testData/formatter/AnnotationBeforeTypeAliasOrConstructor.after.kt");
        }

        @TestMetadata("AnonymousInitializers.after.kt")
        public void testAnonymousInitializers() throws Exception {
            runTest("idea/testData/formatter/AnonymousInitializers.after.kt");
        }

        @TestMetadata("AnonymousInitializersLineBreak.after.kt")
        public void testAnonymousInitializersLineBreak() throws Exception {
            runTest("idea/testData/formatter/AnonymousInitializersLineBreak.after.kt");
        }

        @TestMetadata("ArrayAccess.after.kt")
        public void testArrayAccess() throws Exception {
            runTest("idea/testData/formatter/ArrayAccess.after.kt");
        }

        @TestMetadata("ArrayLiteral.after.kt")
        public void testArrayLiteral() throws Exception {
            runTest("idea/testData/formatter/ArrayLiteral.after.kt");
        }

        @TestMetadata("AssignmentWrap.after.kt")
        public void testAssignmentWrap() throws Exception {
            runTest("idea/testData/formatter/AssignmentWrap.after.kt");
        }

        @TestMetadata("BinaryExpressionAlignmentSpread.after.kt")
        public void testBinaryExpressionAlignmentSpread() throws Exception {
            runTest("idea/testData/formatter/BinaryExpressionAlignmentSpread.after.kt");
        }

        @TestMetadata("BinaryExpressions.after.kt")
        public void testBinaryExpressions() throws Exception {
            runTest("idea/testData/formatter/BinaryExpressions.after.kt");
        }

        @TestMetadata("BinaryExpressionsBoolean.after.kt")
        public void testBinaryExpressionsBoolean() throws Exception {
            runTest("idea/testData/formatter/BinaryExpressionsBoolean.after.kt");
        }

        @TestMetadata("BinaryExpressionsWithoutAlignment.after.kt")
        public void testBinaryExpressionsWithoutAlignment() throws Exception {
            runTest("idea/testData/formatter/BinaryExpressionsWithoutAlignment.after.kt");
        }

        @TestMetadata("BlankLinesAfterClassHeader.after.kt")
        public void testBlankLinesAfterClassHeader() throws Exception {
            runTest("idea/testData/formatter/BlankLinesAfterClassHeader.after.kt");
        }

        @TestMetadata("BlankLinesBeforeRBrace.after.kt")
        public void testBlankLinesBeforeRBrace() throws Exception {
            runTest("idea/testData/formatter/BlankLinesBeforeRBrace.after.kt");
        }

        @TestMetadata("BlankLinesBeforeRBrace2.after.kt")
        public void testBlankLinesBeforeRBrace2() throws Exception {
            runTest("idea/testData/formatter/BlankLinesBeforeRBrace2.after.kt");
        }

        @TestMetadata("BlockFor.after.kt")
        public void testBlockFor() throws Exception {
            runTest("idea/testData/formatter/BlockFor.after.kt");
        }

        @TestMetadata("By.after.kt")
        public void testBy() throws Exception {
            runTest("idea/testData/formatter/By.after.kt");
        }

        @TestMetadata("CallLParenthOnNextLine.after.kt")
        public void testCallLParenthOnNextLine() throws Exception {
            runTest("idea/testData/formatter/CallLParenthOnNextLine.after.kt");
        }

        @TestMetadata("CallRParenthOnNextLine.after.kt")
        public void testCallRParenthOnNextLine() throws Exception {
            runTest("idea/testData/formatter/CallRParenthOnNextLine.after.kt");
        }

        @TestMetadata("Cast.after.kt")
        public void testCast() throws Exception {
            runTest("idea/testData/formatter/Cast.after.kt");
        }

        @TestMetadata("CatchFinallyOnNewLine.after.kt")
        public void testCatchFinallyOnNewLine() throws Exception {
            runTest("idea/testData/formatter/CatchFinallyOnNewLine.after.kt");
        }

        @TestMetadata("Class.after.kt")
        public void testClass() throws Exception {
            runTest("idea/testData/formatter/Class.after.kt");
        }

        @TestMetadata("ClassAnnotationWrapping.after.kt")
        public void testClassAnnotationWrapping() throws Exception {
            runTest("idea/testData/formatter/ClassAnnotationWrapping.after.kt");
        }

        @TestMetadata("ClassInBody.after.kt")
        public void testClassInBody() throws Exception {
            runTest("idea/testData/formatter/ClassInBody.after.kt");
        }

        @TestMetadata("ClassLineBreak.after.kt")
        public void testClassLineBreak() throws Exception {
            runTest("idea/testData/formatter/ClassLineBreak.after.kt");
        }

        @TestMetadata("ClassTypeParam.after.kt")
        public void testClassTypeParam() throws Exception {
            runTest("idea/testData/formatter/ClassTypeParam.after.kt");
        }

        @TestMetadata("ColonSpaces.after.kt")
        public void testColonSpaces() throws Exception {
            runTest("idea/testData/formatter/ColonSpaces.after.kt");
        }

        @TestMetadata("CommentInExpressionBodies.after.kt")
        public void testCommentInExpressionBodies() throws Exception {
            runTest("idea/testData/formatter/CommentInExpressionBodies.after.kt");
        }

        @TestMetadata("CommentInFunctionLiteral.after.kt")
        public void testCommentInFunctionLiteral() throws Exception {
            runTest("idea/testData/formatter/CommentInFunctionLiteral.after.kt");
        }

        @TestMetadata("ContinuationIndentInAssigments.after.kt")
        public void testContinuationIndentInAssigments() throws Exception {
            runTest("idea/testData/formatter/ContinuationIndentInAssigments.after.kt");
        }

        @TestMetadata("ContinuationIndentInParameterLists.after.kt")
        public void testContinuationIndentInParameterLists() throws Exception {
            runTest("idea/testData/formatter/ContinuationIndentInParameterLists.after.kt");
        }

        @TestMetadata("ContinuationIndentInSupertypeLists.after.kt")
        public void testContinuationIndentInSupertypeLists() throws Exception {
            runTest("idea/testData/formatter/ContinuationIndentInSupertypeLists.after.kt");
        }

        @TestMetadata("CurlyBraceStringInterpolation.after.kt")
        public void testCurlyBraceStringInterpolation() throws Exception {
            runTest("idea/testData/formatter/CurlyBraceStringInterpolation.after.kt");
        }

        @TestMetadata("DanglingComments.after.kt")
        public void testDanglingComments() throws Exception {
            runTest("idea/testData/formatter/DanglingComments.after.kt");
        }

        @TestMetadata("DelegationList.after.kt")
        public void testDelegationList() throws Exception {
            runTest("idea/testData/formatter/DelegationList.after.kt");
        }

        @TestMetadata("DoWhileLineBreak.after.kt")
        public void testDoWhileLineBreak() throws Exception {
            runTest("idea/testData/formatter/DoWhileLineBreak.after.kt");
        }

        @TestMetadata("DoWhileSpacing.after.kt")
        public void testDoWhileSpacing() throws Exception {
            runTest("idea/testData/formatter/DoWhileSpacing.after.kt");
        }

        @TestMetadata("DocComments.after.kt")
        public void testDocComments() throws Exception {
            runTest("idea/testData/formatter/DocComments.after.kt");
        }

        @TestMetadata("ElseOnNewLine.after.kt")
        public void testElseOnNewLine() throws Exception {
            runTest("idea/testData/formatter/ElseOnNewLine.after.kt");
        }

        @TestMetadata("Elvis.after.kt")
        public void testElvis() throws Exception {
            runTest("idea/testData/formatter/Elvis.after.kt");
        }

        @TestMetadata("ElvisContinuationIndentOptions.after.kt")
        public void testElvisContinuationIndentOptions() throws Exception {
            runTest("idea/testData/formatter/ElvisContinuationIndentOptions.after.kt");
        }

        @TestMetadata("ElvisIndent.after.kt")
        public void testElvisIndent() throws Exception {
            runTest("idea/testData/formatter/ElvisIndent.after.kt");
        }

        @TestMetadata("ElvisWrap.after.kt")
        public void testElvisWrap() throws Exception {
            runTest("idea/testData/formatter/ElvisWrap.after.kt");
        }

        @TestMetadata("EmptyLineAfterObjectDeclaration.after.kt")
        public void testEmptyLineAfterObjectDeclaration() throws Exception {
            runTest("idea/testData/formatter/EmptyLineAfterObjectDeclaration.after.kt");
        }

        @TestMetadata("EmptyLineAfterPackage.after.kt")
        public void testEmptyLineAfterPackage() throws Exception {
            runTest("idea/testData/formatter/EmptyLineAfterPackage.after.kt");
        }

        @TestMetadata("EmptyLineBetweeAbstractFunctions.after.kt")
        public void testEmptyLineBetweeAbstractFunctions() throws Exception {
            runTest("idea/testData/formatter/EmptyLineBetweeAbstractFunctions.after.kt");
        }

        @TestMetadata("EmptyLineBetweenClassAndFunction.after.kt")
        public void testEmptyLineBetweenClassAndFunction() throws Exception {
            runTest("idea/testData/formatter/EmptyLineBetweenClassAndFunction.after.kt");
        }

        @TestMetadata("EmptyLineBetweenClasses.after.kt")
        public void testEmptyLineBetweenClasses() throws Exception {
            runTest("idea/testData/formatter/EmptyLineBetweenClasses.after.kt");
        }

        @TestMetadata("EmptyLineBetweenEnumEntries.after.kt")
        public void testEmptyLineBetweenEnumEntries() throws Exception {
            runTest("idea/testData/formatter/EmptyLineBetweenEnumEntries.after.kt");
        }

        @TestMetadata("EmptyLineBetweenFunAndProperty.after.kt")
        public void testEmptyLineBetweenFunAndProperty() throws Exception {
            runTest("idea/testData/formatter/EmptyLineBetweenFunAndProperty.after.kt");
        }

        @TestMetadata("EmptyLineBetweenFunctions.after.kt")
        public void testEmptyLineBetweenFunctions() throws Exception {
            runTest("idea/testData/formatter/EmptyLineBetweenFunctions.after.kt");
        }

        @TestMetadata("EmptyLineBetweenProperties.after.kt")
        public void testEmptyLineBetweenProperties() throws Exception {
            runTest("idea/testData/formatter/EmptyLineBetweenProperties.after.kt");
        }

        @TestMetadata("EnumArguments.after.kt")
        public void testEnumArguments() throws Exception {
            runTest("idea/testData/formatter/EnumArguments.after.kt");
        }

        @TestMetadata("EnumInitializerList.after.kt")
        public void testEnumInitializerList() throws Exception {
            runTest("idea/testData/formatter/EnumInitializerList.after.kt");
        }

        @TestMetadata("EnumWrapping.after.kt")
        public void testEnumWrapping() throws Exception {
            runTest("idea/testData/formatter/EnumWrapping.after.kt");
        }

        @TestMetadata("ExpressionBodyWrap.after.kt")
        public void testExpressionBodyWrap() throws Exception {
            runTest("idea/testData/formatter/ExpressionBodyWrap.after.kt");
        }

        @TestMetadata("ExtendsListAlignEnum.after.kt")
        public void testExtendsListAlignEnum() throws Exception {
            runTest("idea/testData/formatter/ExtendsListAlignEnum.after.kt");
        }

        @TestMetadata("ExtendsListWrap.after.kt")
        public void testExtendsListWrap() throws Exception {
            runTest("idea/testData/formatter/ExtendsListWrap.after.kt");
        }

        @TestMetadata("ForLineBreak.after.kt")
        public void testForLineBreak() throws Exception {
            runTest("idea/testData/formatter/ForLineBreak.after.kt");
        }

        @TestMetadata("ForNoBraces.after.kt")
        public void testForNoBraces() throws Exception {
            runTest("idea/testData/formatter/ForNoBraces.after.kt");
        }

        @TestMetadata("ForSpacing.after.kt")
        public void testForSpacing() throws Exception {
            runTest("idea/testData/formatter/ForSpacing.after.kt");
        }

        @TestMetadata("FormatFirstColumnComments.after.kt")
        public void testFormatFirstColumnComments() throws Exception {
            runTest("idea/testData/formatter/FormatFirstColumnComments.after.kt");
        }

        @TestMetadata("FormatFirstColumnCommentsBeforeDeclaration.after.kt")
        public void testFormatFirstColumnCommentsBeforeDeclaration() throws Exception {
            runTest("idea/testData/formatter/FormatFirstColumnCommentsBeforeDeclaration.after.kt");
        }

        @TestMetadata("FunctionCallParametersAlign.after.kt")
        public void testFunctionCallParametersAlign() throws Exception {
            runTest("idea/testData/formatter/FunctionCallParametersAlign.after.kt");
        }

        @TestMetadata("FunctionDefParametersAlign.after.kt")
        public void testFunctionDefParametersAlign() throws Exception {
            runTest("idea/testData/formatter/FunctionDefParametersAlign.after.kt");
        }

        @TestMetadata("FunctionExpression.after.kt")
        public void testFunctionExpression() throws Exception {
            runTest("idea/testData/formatter/FunctionExpression.after.kt");
        }

        @TestMetadata("FunctionLineBreak.after.kt")
        public void testFunctionLineBreak() throws Exception {
            runTest("idea/testData/formatter/FunctionLineBreak.after.kt");
        }

        @TestMetadata("FunctionReferenceOperator.after.kt")
        public void testFunctionReferenceOperator() throws Exception {
            runTest("idea/testData/formatter/FunctionReferenceOperator.after.kt");
        }

        @TestMetadata("FunctionWithInference.after.kt")
        public void testFunctionWithInference() throws Exception {
            runTest("idea/testData/formatter/FunctionWithInference.after.kt");
        }

        @TestMetadata("FunctionalType.after.kt")
        public void testFunctionalType() throws Exception {
            runTest("idea/testData/formatter/FunctionalType.after.kt");
        }

        @TestMetadata("GetterAndSetter.after.kt")
        public void testGetterAndSetter() throws Exception {
            runTest("idea/testData/formatter/GetterAndSetter.after.kt");
        }

        @TestMetadata("If.after.kt")
        public void testIf() throws Exception {
            runTest("idea/testData/formatter/If.after.kt");
        }

        @TestMetadata("IfClosingParen.after.kt")
        public void testIfClosingParen() throws Exception {
            runTest("idea/testData/formatter/IfClosingParen.after.kt");
        }

        @TestMetadata("IfConditionIndent.after.kt")
        public void testIfConditionIndent() throws Exception {
            runTest("idea/testData/formatter/IfConditionIndent.after.kt");
        }

        @TestMetadata("IfElseRemoveLineBreak.after.kt")
        public void testIfElseRemoveLineBreak() throws Exception {
            runTest("idea/testData/formatter/IfElseRemoveLineBreak.after.kt");
        }

        @TestMetadata("IfElseWithLineBreak.after.kt")
        public void testIfElseWithLineBreak() throws Exception {
            runTest("idea/testData/formatter/IfElseWithLineBreak.after.kt");
        }

        @TestMetadata("IfElseWithTrickyComments.after.kt")
        public void testIfElseWithTrickyComments() throws Exception {
            runTest("idea/testData/formatter/IfElseWithTrickyComments.after.kt");
        }

        @TestMetadata("IfRParen.after.kt")
        public void testIfRParen() throws Exception {
            runTest("idea/testData/formatter/IfRParen.after.kt");
        }

        @TestMetadata("IfSpacing.after.kt")
        public void testIfSpacing() throws Exception {
            runTest("idea/testData/formatter/IfSpacing.after.kt");
        }

        @TestMetadata("In.after.kt")
        public void testIn() throws Exception {
            runTest("idea/testData/formatter/In.after.kt");
        }

        @TestMetadata("InfixCall.after.kt")
        public void testInfixCall() throws Exception {
            runTest("idea/testData/formatter/InfixCall.after.kt");
        }

        @TestMetadata("Is.after.kt")
        public void testIs() throws Exception {
            runTest("idea/testData/formatter/Is.after.kt");
        }

        @TestMetadata("KDoc.after.kt")
        public void testKDoc() throws Exception {
            runTest("idea/testData/formatter/KDoc.after.kt");
        }

        @TestMetadata("KT22230.after.kt")
        public void testKT22230() throws Exception {
            runTest("idea/testData/formatter/KT22230.after.kt");
        }

        @TestMetadata("KeepLineBreak.after.kt")
        public void testKeepLineBreak() throws Exception {
            runTest("idea/testData/formatter/KeepLineBreak.after.kt");
        }

        @TestMetadata("LabeledExpression.after.kt")
        public void testLabeledExpression() throws Exception {
            runTest("idea/testData/formatter/LabeledExpression.after.kt");
        }

        @TestMetadata("LambdaArrow.after.kt")
        public void testLambdaArrow() throws Exception {
            runTest("idea/testData/formatter/LambdaArrow.after.kt");
        }

        @TestMetadata("LineBreakBeforeExtendsColon.after.kt")
        public void testLineBreakBeforeExtendsColon() throws Exception {
            runTest("idea/testData/formatter/LineBreakBeforeExtendsColon.after.kt");
        }

        @TestMetadata("LineBreakBeforeExtendsColonWrap.after.kt")
        public void testLineBreakBeforeExtendsColonWrap() throws Exception {
            runTest("idea/testData/formatter/LineBreakBeforeExtendsColonWrap.after.kt");
        }

        @TestMetadata("LocalVariableAnnotationWrap.after.kt")
        public void testLocalVariableAnnotationWrap() throws Exception {
            runTest("idea/testData/formatter/LocalVariableAnnotationWrap.after.kt");
        }

        @TestMetadata("LoopParameterWithExplicitType.after.kt")
        public void testLoopParameterWithExplicitType() throws Exception {
            runTest("idea/testData/formatter/LoopParameterWithExplicitType.after.kt");
        }

        @TestMetadata("MethodAnnotationWrapping.after.kt")
        public void testMethodAnnotationWrapping() throws Exception {
            runTest("idea/testData/formatter/MethodAnnotationWrapping.after.kt");
        }

        @TestMetadata("MethodCall.after.kt")
        public void testMethodCall() throws Exception {
            runTest("idea/testData/formatter/MethodCall.after.kt");
        }

        @TestMetadata("MethodLParenthOnNextLine.after.kt")
        public void testMethodLParenthOnNextLine() throws Exception {
            runTest("idea/testData/formatter/MethodLParenthOnNextLine.after.kt");
        }

        @TestMetadata("MethodRParenthOnNextLine.after.kt")
        public void testMethodRParenthOnNextLine() throws Exception {
            runTest("idea/testData/formatter/MethodRParenthOnNextLine.after.kt");
        }

        @TestMetadata("Multideclaration.after.kt")
        public void testMultideclaration() throws Exception {
            runTest("idea/testData/formatter/Multideclaration.after.kt");
        }

        @TestMetadata("MultilineFunctionLiteral.after.kt")
        public void testMultilineFunctionLiteral() throws Exception {
            runTest("idea/testData/formatter/MultilineFunctionLiteral.after.kt");
        }

        @TestMetadata("MultilineFunctionLiteralWithParams.after.kt")
        public void testMultilineFunctionLiteralWithParams() throws Exception {
            runTest("idea/testData/formatter/MultilineFunctionLiteralWithParams.after.kt");
        }

        @TestMetadata("NewLineForRBrace.after.kt")
        public void testNewLineForRBrace() throws Exception {
            runTest("idea/testData/formatter/NewLineForRBrace.after.kt");
        }

        @TestMetadata("NotIn.after.kt")
        public void testNotIn() throws Exception {
            runTest("idea/testData/formatter/NotIn.after.kt");
        }

        @TestMetadata("NotIs.after.kt")
        public void testNotIs() throws Exception {
            runTest("idea/testData/formatter/NotIs.after.kt");
        }

        @TestMetadata("NullableType.after.kt")
        public void testNullableType() throws Exception {
            runTest("idea/testData/formatter/NullableType.after.kt");
        }

        @TestMetadata("ObjectInBody.after.kt")
        public void testObjectInBody() throws Exception {
            runTest("idea/testData/formatter/ObjectInBody.after.kt");
        }

        @TestMetadata("ParameterAnnotationWrap.after.kt")
        public void testParameterAnnotationWrap() throws Exception {
            runTest("idea/testData/formatter/ParameterAnnotationWrap.after.kt");
        }

        @TestMetadata("ParameterDocComments.after.kt")
        public void testParameterDocComments() throws Exception {
            runTest("idea/testData/formatter/ParameterDocComments.after.kt");
        }

        @TestMetadata("Parameters.after.kt")
        public void testParameters() throws Exception {
            runTest("idea/testData/formatter/Parameters.after.kt");
        }

        @TestMetadata("PrimaryConstructor.after.kt")
        public void testPrimaryConstructor() throws Exception {
            runTest("idea/testData/formatter/PrimaryConstructor.after.kt");
        }

        @TestMetadata("PropertyAccessorLineBreak.after.kt")
        public void testPropertyAccessorLineBreak() throws Exception {
            runTest("idea/testData/formatter/PropertyAccessorLineBreak.after.kt");
        }

        @TestMetadata("PropertyAccessors.after.kt")
        public void testPropertyAccessors() throws Exception {
            runTest("idea/testData/formatter/PropertyAccessors.after.kt");
        }

        @TestMetadata("PropertyAnnotationWrap.after.kt")
        public void testPropertyAnnotationWrap() throws Exception {
            runTest("idea/testData/formatter/PropertyAnnotationWrap.after.kt");
        }

        @TestMetadata("PropertyInitializerLineBreak.after.kt")
        public void testPropertyInitializerLineBreak() throws Exception {
            runTest("idea/testData/formatter/PropertyInitializerLineBreak.after.kt");
        }

        @TestMetadata("PropertyTypeParameterList.after.kt")
        public void testPropertyTypeParameterList() throws Exception {
            runTest("idea/testData/formatter/PropertyTypeParameterList.after.kt");
        }

        @TestMetadata("PropertyWithInference.after.kt")
        public void testPropertyWithInference() throws Exception {
            runTest("idea/testData/formatter/PropertyWithInference.after.kt");
        }

        @TestMetadata("ReferenceExpressionFunctionLiteral.after.kt")
        public void testReferenceExpressionFunctionLiteral() throws Exception {
            runTest("idea/testData/formatter/ReferenceExpressionFunctionLiteral.after.kt");
        }

        @TestMetadata("RemoveSpacesAroundOperations.after.kt")
        public void testRemoveSpacesAroundOperations() throws Exception {
            runTest("idea/testData/formatter/RemoveSpacesAroundOperations.after.kt");
        }

        @TestMetadata("ReturnExpression.after.kt")
        public void testReturnExpression() throws Exception {
            runTest("idea/testData/formatter/ReturnExpression.after.kt");
        }

        @TestMetadata("RightBracketOnNewLine.after.kt")
        public void testRightBracketOnNewLine() throws Exception {
            runTest("idea/testData/formatter/RightBracketOnNewLine.after.kt");
        }

        @TestMetadata("SaveSpacesInDocComments.after.kt")
        public void testSaveSpacesInDocComments() throws Exception {
            runTest("idea/testData/formatter/SaveSpacesInDocComments.after.kt");
        }

        @TestMetadata("Script.after.kts")
        public void testScript() throws Exception {
            runTest("idea/testData/formatter/Script.after.kts");
        }

        @TestMetadata("SecondaryConstructors.after.kt")
        public void testSecondaryConstructors() throws Exception {
            runTest("idea/testData/formatter/SecondaryConstructors.after.kt");
        }

        @TestMetadata("secondaryCtorLineBreak.after.kt")
        public void testSecondaryCtorLineBreak() throws Exception {
            runTest("idea/testData/formatter/secondaryCtorLineBreak.after.kt");
        }

        @TestMetadata("Semicolon.after.kt")
        public void testSemicolon() throws Exception {
            runTest("idea/testData/formatter/Semicolon.after.kt");
        }

        @TestMetadata("SingleLineFunctionLiteral.after.kt")
        public void testSingleLineFunctionLiteral() throws Exception {
            runTest("idea/testData/formatter/SingleLineFunctionLiteral.after.kt");
        }

        @TestMetadata("SpaceAroundDotInUserReference.after.kt")
        public void testSpaceAroundDotInUserReference() throws Exception {
            runTest("idea/testData/formatter/SpaceAroundDotInUserReference.after.kt");
        }

        @TestMetadata("SpaceAroundExtendColon.after.kt")
        public void testSpaceAroundExtendColon() throws Exception {
            runTest("idea/testData/formatter/SpaceAroundExtendColon.after.kt");
        }

        @TestMetadata("SpaceAroundExtendColonInObjects.after.kt")
        public void testSpaceAroundExtendColonInObjects() throws Exception {
            runTest("idea/testData/formatter/SpaceAroundExtendColonInObjects.after.kt");
        }

        @TestMetadata("SpaceAroundExtendColonInSecondaryCtr.after.kt")
        public void testSpaceAroundExtendColonInSecondaryCtr() throws Exception {
            runTest("idea/testData/formatter/SpaceAroundExtendColonInSecondaryCtr.after.kt");
        }

        @TestMetadata("SpaceBeforeCatchParentheses.after.kt")
        public void testSpaceBeforeCatchParentheses() throws Exception {
            runTest("idea/testData/formatter/SpaceBeforeCatchParentheses.after.kt");
        }

        @TestMetadata("SpaceBeforeForParentheses.after.kt")
        public void testSpaceBeforeForParentheses() throws Exception {
            runTest("idea/testData/formatter/SpaceBeforeForParentheses.after.kt");
        }

        @TestMetadata("SpaceBeforeFunctionLiteral.after.kt")
        public void testSpaceBeforeFunctionLiteral() throws Exception {
            runTest("idea/testData/formatter/SpaceBeforeFunctionLiteral.after.kt");
        }

        @TestMetadata("SpaceBeforeIfParentheses.after.kt")
        public void testSpaceBeforeIfParentheses() throws Exception {
            runTest("idea/testData/formatter/SpaceBeforeIfParentheses.after.kt");
        }

        @TestMetadata("SpaceBeforeIndices.after.kt")
        public void testSpaceBeforeIndices() throws Exception {
            runTest("idea/testData/formatter/SpaceBeforeIndices.after.kt");
        }

        @TestMetadata("SpaceBeforeTypeArgumentList.after.kt")
        public void testSpaceBeforeTypeArgumentList() throws Exception {
            runTest("idea/testData/formatter/SpaceBeforeTypeArgumentList.after.kt");
        }

        @TestMetadata("SpaceBeforeWhenParentheses.after.kt")
        public void testSpaceBeforeWhenParentheses() throws Exception {
            runTest("idea/testData/formatter/SpaceBeforeWhenParentheses.after.kt");
        }

        @TestMetadata("SpaceBeforeWhileParentheses.after.kt")
        public void testSpaceBeforeWhileParentheses() throws Exception {
            runTest("idea/testData/formatter/SpaceBeforeWhileParentheses.after.kt");
        }

        @TestMetadata("SpacedInsideParans.after.kt")
        public void testSpacedInsideParans() throws Exception {
            runTest("idea/testData/formatter/SpacedInsideParans.after.kt");
        }

        @TestMetadata("SpacesAroundOperations.after.kt")
        public void testSpacesAroundOperations() throws Exception {
            runTest("idea/testData/formatter/SpacesAroundOperations.after.kt");
        }

        @TestMetadata("SpacesAroundUnaryOperations.after.kt")
        public void testSpacesAroundUnaryOperations() throws Exception {
            runTest("idea/testData/formatter/SpacesAroundUnaryOperations.after.kt");
        }

        @TestMetadata("SpacesInDeclarations.after.kt")
        public void testSpacesInDeclarations() throws Exception {
            runTest("idea/testData/formatter/SpacesInDeclarations.after.kt");
        }

        @TestMetadata("SpacesInQualifiedExpressions.after.kt")
        public void testSpacesInQualifiedExpressions() throws Exception {
            runTest("idea/testData/formatter/SpacesInQualifiedExpressions.after.kt");
        }

        @TestMetadata("SuperListIndent.after.kt")
        public void testSuperListIndent() throws Exception {
            runTest("idea/testData/formatter/SuperListIndent.after.kt");
        }

        @TestMetadata("TryCatchLineBreak.after.kt")
        public void testTryCatchLineBreak() throws Exception {
            runTest("idea/testData/formatter/TryCatchLineBreak.after.kt");
        }

        @TestMetadata("TypeAliasSpacing.after.kt")
        public void testTypeAliasSpacing() throws Exception {
            runTest("idea/testData/formatter/TypeAliasSpacing.after.kt");
        }

        @TestMetadata("UnnecessarySpacesInParametersLists.after.kt")
        public void testUnnecessarySpacesInParametersLists() throws Exception {
            runTest("idea/testData/formatter/UnnecessarySpacesInParametersLists.after.kt");
        }

        @TestMetadata("ValVarSpaces.after.kt")
        public void testValVarSpaces() throws Exception {
            runTest("idea/testData/formatter/ValVarSpaces.after.kt");
        }

        @TestMetadata("When.after.kt")
        public void testWhen() throws Exception {
            runTest("idea/testData/formatter/When.after.kt");
        }

        @TestMetadata("WhenArrow.after.kt")
        public void testWhenArrow() throws Exception {
            runTest("idea/testData/formatter/WhenArrow.after.kt");
        }

        @TestMetadata("WhenBlockBlankLines.after.kt")
        public void testWhenBlockBlankLines() throws Exception {
            runTest("idea/testData/formatter/WhenBlockBlankLines.after.kt");
        }

        @TestMetadata("WhenBraceAndEntry.after.kt")
        public void testWhenBraceAndEntry() throws Exception {
            runTest("idea/testData/formatter/WhenBraceAndEntry.after.kt");
        }

        @TestMetadata("WhenComment.after.kt")
        public void testWhenComment() throws Exception {
            runTest("idea/testData/formatter/WhenComment.after.kt");
        }

        @TestMetadata("WhenEntryExpr.after.kt")
        public void testWhenEntryExpr() throws Exception {
            runTest("idea/testData/formatter/WhenEntryExpr.after.kt");
        }

        @TestMetadata("WhenLineBreak.after.kt")
        public void testWhenLineBreak() throws Exception {
            runTest("idea/testData/formatter/WhenLineBreak.after.kt");
        }

        @TestMetadata("WhenLinesBeforeLbrace.after.kt")
        public void testWhenLinesBeforeLbrace() throws Exception {
            runTest("idea/testData/formatter/WhenLinesBeforeLbrace.after.kt");
        }

        @TestMetadata("WhenWithVariable.after.kt")
        public void testWhenWithVariable() throws Exception {
            runTest("idea/testData/formatter/WhenWithVariable.after.kt");
        }

        @TestMetadata("WhereClause.after.kt")
        public void testWhereClause() throws Exception {
            runTest("idea/testData/formatter/WhereClause.after.kt");
        }

        @TestMetadata("WhileLineBreak.after.kt")
        public void testWhileLineBreak() throws Exception {
            runTest("idea/testData/formatter/WhileLineBreak.after.kt");
        }

        @TestMetadata("WhileOnNewLine.after.kt")
        public void testWhileOnNewLine() throws Exception {
            runTest("idea/testData/formatter/WhileOnNewLine.after.kt");
        }

        @TestMetadata("WhileSpacing.after.kt")
        public void testWhileSpacing() throws Exception {
            runTest("idea/testData/formatter/WhileSpacing.after.kt");
        }

        @TestMetadata("idea/testData/formatter/callChain")
        @TestDataPath("$PROJECT_ROOT")
        @RunWith(JUnit3RunnerWithInners.class)
        public static class CallChain extends AbstractFormatterTest {
            private void runTest(String testDataFilePath) throws Exception {
                KotlinTestUtils.runTest(this::doTest, TargetBackend.ANY, testDataFilePath);
            }

            public void testAllFilesPresentInCallChain() throws Exception {
                KotlinTestUtils.assertAllTestsPresentByMetadata(this.getClass(), new File("idea/testData/formatter/callChain"), Pattern.compile("^([^\\.]+)\\.after\\.kt.*$"), TargetBackend.ANY, true);
            }

            @TestMetadata("CallChainWrapping.after.kt")
            public void testCallChainWrapping() throws Exception {
                runTest("idea/testData/formatter/callChain/CallChainWrapping.after.kt");
            }

            @TestMetadata("ConsecutiveCalls.after.kt")
            public void testConsecutiveCalls() throws Exception {
                runTest("idea/testData/formatter/callChain/ConsecutiveCalls.after.kt");
            }

            @TestMetadata("ConsecutiveSafeCallsIndent.after.kt")
            public void testConsecutiveSafeCallsIndent() throws Exception {
                runTest("idea/testData/formatter/callChain/ConsecutiveSafeCallsIndent.after.kt");
            }

            @TestMetadata("ContinuationIndentForChainedCalls.after.kt")
            public void testContinuationIndentForChainedCalls() throws Exception {
                runTest("idea/testData/formatter/callChain/ContinuationIndentForChainedCalls.after.kt");
            }

            @TestMetadata("FunctionLiteralsInChainCalls.after.kt")
            public void testFunctionLiteralsInChainCalls() throws Exception {
                runTest("idea/testData/formatter/callChain/FunctionLiteralsInChainCalls.after.kt");
            }

            @TestMetadata("KT15099.after.kt")
            public void testKT15099() throws Exception {
                runTest("idea/testData/formatter/callChain/KT15099.after.kt");
            }

            @TestMetadata("KT20362.after.kt")
            public void testKT20362() throws Exception {
                runTest("idea/testData/formatter/callChain/KT20362.after.kt");
            }

            @TestMetadata("KT22071.after.kt")
            public void testKT22071() throws Exception {
                runTest("idea/testData/formatter/callChain/KT22071.after.kt");
            }

            @TestMetadata("KT22115.after.kt")
            public void testKT22115() throws Exception {
                runTest("idea/testData/formatter/callChain/KT22115.after.kt");
            }

            @TestMetadata("KT22148.after.kt")
            public void testKT22148() throws Exception {
                runTest("idea/testData/formatter/callChain/KT22148.after.kt");
            }

            @TestMetadata("KT22346.after.kt")
            public void testKT22346() throws Exception {
                runTest("idea/testData/formatter/callChain/KT22346.after.kt");
            }
        }

        @TestMetadata("idea/testData/formatter/fileAnnotations")
        @TestDataPath("$PROJECT_ROOT")
        @RunWith(JUnit3RunnerWithInners.class)
        public static class FileAnnotations extends AbstractFormatterTest {
            private void runTest(String testDataFilePath) throws Exception {
                KotlinTestUtils.runTest(this::doTest, TargetBackend.ANY, testDataFilePath);
            }

            @TestMetadata("afterComment.after.kt")
            public void testAfterComment() throws Exception {
                runTest("idea/testData/formatter/fileAnnotations/afterComment.after.kt");
            }

            public void testAllFilesPresentInFileAnnotations() throws Exception {
                KotlinTestUtils.assertAllTestsPresentByMetadata(this.getClass(), new File("idea/testData/formatter/fileAnnotations"), Pattern.compile("^([^\\.]+)\\.after\\.kt.*$"), TargetBackend.ANY, true);
            }

            @TestMetadata("beforeDeclaration.after.kt")
            public void testBeforeDeclaration() throws Exception {
                runTest("idea/testData/formatter/fileAnnotations/beforeDeclaration.after.kt");
            }

            @TestMetadata("beforeImportList.after.kt")
            public void testBeforeImportList() throws Exception {
                runTest("idea/testData/formatter/fileAnnotations/beforeImportList.after.kt");
            }

            @TestMetadata("beforePackage.after.kt")
            public void testBeforePackage() throws Exception {
                runTest("idea/testData/formatter/fileAnnotations/beforePackage.after.kt");
            }

            @TestMetadata("inEmptyFile.after.kt")
            public void testInEmptyFile() throws Exception {
                runTest("idea/testData/formatter/fileAnnotations/inEmptyFile.after.kt");
            }

            @TestMetadata("manyLinesFromFileBegin.after.kt")
            public void testManyLinesFromFileBegin() throws Exception {
                runTest("idea/testData/formatter/fileAnnotations/manyLinesFromFileBegin.after.kt");
            }
        }

        @TestMetadata("idea/testData/formatter/modifierList")
        @TestDataPath("$PROJECT_ROOT")
        @RunWith(JUnit3RunnerWithInners.class)
        public static class ModifierList extends AbstractFormatterTest {
            private void runTest(String testDataFilePath) throws Exception {
                KotlinTestUtils.runTest(this::doTest, TargetBackend.ANY, testDataFilePath);
            }

            public void testAllFilesPresentInModifierList() throws Exception {
                KotlinTestUtils.assertAllTestsPresentByMetadata(this.getClass(), new File("idea/testData/formatter/modifierList"), Pattern.compile("^([^\\.]+)\\.after\\.kt.*$"), TargetBackend.ANY, true);
            }

            @TestMetadata("funAnnotationBeforeAnnotation.after.kt")
            public void testFunAnnotationBeforeAnnotation() throws Exception {
                runTest("idea/testData/formatter/modifierList/funAnnotationBeforeAnnotation.after.kt");
            }

            @TestMetadata("funAnnotationBeforeAnnotationEntry.after.kt")
            public void testFunAnnotationBeforeAnnotationEntry() throws Exception {
                runTest("idea/testData/formatter/modifierList/funAnnotationBeforeAnnotationEntry.after.kt");
            }

            @TestMetadata("funAnnotationBeforeModifiers.after.kt")
            public void testFunAnnotationBeforeModifiers() throws Exception {
                runTest("idea/testData/formatter/modifierList/funAnnotationBeforeModifiers.after.kt");
            }

            @TestMetadata("funAnnotationEntryBeforeAnnotation.after.kt")
            public void testFunAnnotationEntryBeforeAnnotation() throws Exception {
                runTest("idea/testData/formatter/modifierList/funAnnotationEntryBeforeAnnotation.after.kt");
            }

            @TestMetadata("funAnnotationEntryBeforeAnnotationEntry.after.kt")
            public void testFunAnnotationEntryBeforeAnnotationEntry() throws Exception {
                runTest("idea/testData/formatter/modifierList/funAnnotationEntryBeforeAnnotationEntry.after.kt");
            }

            @TestMetadata("funAnnotationEntryBeforeModifiers.after.kt")
            public void testFunAnnotationEntryBeforeModifiers() throws Exception {
                runTest("idea/testData/formatter/modifierList/funAnnotationEntryBeforeModifiers.after.kt");
            }

            @TestMetadata("funModifierBeforeAnnotation.after.kt")
            public void testFunModifierBeforeAnnotation() throws Exception {
                runTest("idea/testData/formatter/modifierList/funModifierBeforeAnnotation.after.kt");
            }

            @TestMetadata("funModifierBeforeAnnotationEntry.after.kt")
            public void testFunModifierBeforeAnnotationEntry() throws Exception {
                runTest("idea/testData/formatter/modifierList/funModifierBeforeAnnotationEntry.after.kt");
            }

            @TestMetadata("funModifierBeforeModifiers.after.kt")
            public void testFunModifierBeforeModifiers() throws Exception {
                runTest("idea/testData/formatter/modifierList/funModifierBeforeModifiers.after.kt");
            }

            @TestMetadata("funTheOnlyModifier.after.kt")
            public void testFunTheOnlyModifier() throws Exception {
                runTest("idea/testData/formatter/modifierList/funTheOnlyModifier.after.kt");
            }

            @TestMetadata("memberFunTheOnlyModifier.after.kt")
            public void testMemberFunTheOnlyModifier() throws Exception {
                runTest("idea/testData/formatter/modifierList/memberFunTheOnlyModifier.after.kt");
            }

            @TestMetadata("memberValTheOnlyModifier.after.kt")
            public void testMemberValTheOnlyModifier() throws Exception {
                runTest("idea/testData/formatter/modifierList/memberValTheOnlyModifier.after.kt");
            }

            @TestMetadata("memberVarTheOnlyModifier.after.kt")
            public void testMemberVarTheOnlyModifier() throws Exception {
                runTest("idea/testData/formatter/modifierList/memberVarTheOnlyModifier.after.kt");
            }

            @TestMetadata("secondMemberFunTheOnlyModifier.after.kt")
            public void testSecondMemberFunTheOnlyModifier() throws Exception {
                runTest("idea/testData/formatter/modifierList/secondMemberFunTheOnlyModifier.after.kt");
            }

            @TestMetadata("secondMemberValTheOnlyModifier.after.kt")
            public void testSecondMemberValTheOnlyModifier() throws Exception {
                runTest("idea/testData/formatter/modifierList/secondMemberValTheOnlyModifier.after.kt");
            }

            @TestMetadata("secondMemberVarTheOnlyModifier.after.kt")
            public void testSecondMemberVarTheOnlyModifier() throws Exception {
                runTest("idea/testData/formatter/modifierList/secondMemberVarTheOnlyModifier.after.kt");
            }
        }

        @TestMetadata("idea/testData/formatter/parameterList")
        @TestDataPath("$PROJECT_ROOT")
        @RunWith(JUnit3RunnerWithInners.class)
        public static class ParameterList extends AbstractFormatterTest {
            private void runTest(String testDataFilePath) throws Exception {
                KotlinTestUtils.runTest(this::doTest, TargetBackend.ANY, testDataFilePath);
            }

            public void testAllFilesPresentInParameterList() throws Exception {
                KotlinTestUtils.assertAllTestsPresentByMetadata(this.getClass(), new File("idea/testData/formatter/parameterList"), Pattern.compile("^([^\\.]+)\\.after\\.kt.*$"), TargetBackend.ANY, true);
            }

            @TestMetadata("ArgumentListChopAsNeeded.after.kt")
            public void testArgumentListChopAsNeeded() throws Exception {
                runTest("idea/testData/formatter/parameterList/ArgumentListChopAsNeeded.after.kt");
            }

            @TestMetadata("ArgumentListDoNotWrap.after.kt")
            public void testArgumentListDoNotWrap() throws Exception {
                runTest("idea/testData/formatter/parameterList/ArgumentListDoNotWrap.after.kt");
            }

            @TestMetadata("ArgumentListWrapAlways.after.kt")
            public void testArgumentListWrapAlways() throws Exception {
                runTest("idea/testData/formatter/parameterList/ArgumentListWrapAlways.after.kt");
            }

            @TestMetadata("ArgumentListWrapAsNeeded.after.kt")
            public void testArgumentListWrapAsNeeded() throws Exception {
                runTest("idea/testData/formatter/parameterList/ArgumentListWrapAsNeeded.after.kt");
            }

            @TestMetadata("ArgumentListWrapLParen.after.kt")
            public void testArgumentListWrapLParen() throws Exception {
                runTest("idea/testData/formatter/parameterList/ArgumentListWrapLParen.after.kt");
            }

            @TestMetadata("DefaultParameterValues.after.kt")
            public void testDefaultParameterValues() throws Exception {
                runTest("idea/testData/formatter/parameterList/DefaultParameterValues.after.kt");
            }

            @TestMetadata("KT19727.after.kt")
            public void testKT19727() throws Exception {
                runTest("idea/testData/formatter/parameterList/KT19727.after.kt");
            }

            @TestMetadata("ParameterListChopAsNeeded.after.kt")
            public void testParameterListChopAsNeeded() throws Exception {
                runTest("idea/testData/formatter/parameterList/ParameterListChopAsNeeded.after.kt");
            }

            @TestMetadata("ParameterListDoNotWrap.after.kt")
            public void testParameterListDoNotWrap() throws Exception {
                runTest("idea/testData/formatter/parameterList/ParameterListDoNotWrap.after.kt");
            }

            @TestMetadata("ParameterListWrapAlways.after.kt")
            public void testParameterListWrapAlways() throws Exception {
                runTest("idea/testData/formatter/parameterList/ParameterListWrapAlways.after.kt");
            }

            @TestMetadata("ParameterListWrapAsNeeded.after.kt")
            public void testParameterListWrapAsNeeded() throws Exception {
                runTest("idea/testData/formatter/parameterList/ParameterListWrapAsNeeded.after.kt");
            }
        }
    }

    @TestMetadata("idea/testData/formatter")
    @TestDataPath("$PROJECT_ROOT")
    @RunWith(JUnit3RunnerWithInners.class)
    public static class FormatterInverted extends AbstractFormatterTest {
        private void runTest(String testDataFilePath) throws Exception {
            KotlinTestUtils.runTest(this::doTestInverted, TargetBackend.ANY, testDataFilePath);
        }

        public void testAllFilesPresentInFormatterInverted() throws Exception {
            KotlinTestUtils.assertAllTestsPresentByMetadata(this.getClass(), new File("idea/testData/formatter"), Pattern.compile("^([^\\.]+)\\.after\\.inv\\.kt.*$"), TargetBackend.ANY, true);
        }

        @TestMetadata("AnonymousInitializersLineBreak.after.inv.kt")
        public void testAnonymousInitializersLineBreak() throws Exception {
            runTest("idea/testData/formatter/AnonymousInitializersLineBreak.after.inv.kt");
        }

        @TestMetadata("BinaryExpressions.after.inv.kt")
        public void testBinaryExpressions() throws Exception {
            runTest("idea/testData/formatter/BinaryExpressions.after.inv.kt");
        }

        @TestMetadata("BinaryExpressionsBoolean.after.inv.kt")
        public void testBinaryExpressionsBoolean() throws Exception {
            runTest("idea/testData/formatter/BinaryExpressionsBoolean.after.inv.kt");
        }

        @TestMetadata("BinaryExpressionsWithoutAlignment.after.inv.kt")
        public void testBinaryExpressionsWithoutAlignment() throws Exception {
            runTest("idea/testData/formatter/BinaryExpressionsWithoutAlignment.after.inv.kt");
        }

        @TestMetadata("CallLParenthOnNextLine.after.inv.kt")
        public void testCallLParenthOnNextLine() throws Exception {
            runTest("idea/testData/formatter/CallLParenthOnNextLine.after.inv.kt");
        }

        @TestMetadata("CallRParenthOnNextLine.after.inv.kt")
        public void testCallRParenthOnNextLine() throws Exception {
            runTest("idea/testData/formatter/CallRParenthOnNextLine.after.inv.kt");
        }

        @TestMetadata("CatchFinallyOnNewLine.after.inv.kt")
        public void testCatchFinallyOnNewLine() throws Exception {
            runTest("idea/testData/formatter/CatchFinallyOnNewLine.after.inv.kt");
        }

        @TestMetadata("ClassLineBreak.after.inv.kt")
        public void testClassLineBreak() throws Exception {
            runTest("idea/testData/formatter/ClassLineBreak.after.inv.kt");
        }

        @TestMetadata("ColonSpaces.after.inv.kt")
        public void testColonSpaces() throws Exception {
            runTest("idea/testData/formatter/ColonSpaces.after.inv.kt");
        }

        @TestMetadata("ContinuationIndentForExpressionBodies.after.inv.kt")
        public void testContinuationIndentForExpressionBodies() throws Exception {
            runTest("idea/testData/formatter/ContinuationIndentForExpressionBodies.after.inv.kt");
        }

        @TestMetadata("ContinuationIndentInAssigments.after.inv.kt")
        public void testContinuationIndentInAssigments() throws Exception {
            runTest("idea/testData/formatter/ContinuationIndentInAssigments.after.inv.kt");
        }

        @TestMetadata("DelegationList.after.inv.kt")
        public void testDelegationList() throws Exception {
            runTest("idea/testData/formatter/DelegationList.after.inv.kt");
        }

        @TestMetadata("DoWhileLineBreak.after.inv.kt")
        public void testDoWhileLineBreak() throws Exception {
            runTest("idea/testData/formatter/DoWhileLineBreak.after.inv.kt");
        }

        @TestMetadata("ElseOnNewLine.after.inv.kt")
        public void testElseOnNewLine() throws Exception {
            runTest("idea/testData/formatter/ElseOnNewLine.after.inv.kt");
        }

        @TestMetadata("Elvis.after.inv.kt")
        public void testElvis() throws Exception {
            runTest("idea/testData/formatter/Elvis.after.inv.kt");
        }

        @TestMetadata("ElvisContinuationIndentOptions.after.inv.kt")
        public void testElvisContinuationIndentOptions() throws Exception {
            runTest("idea/testData/formatter/ElvisContinuationIndentOptions.after.inv.kt");
        }

        @TestMetadata("ElvisIndent.after.inv.kt")
        public void testElvisIndent() throws Exception {
            runTest("idea/testData/formatter/ElvisIndent.after.inv.kt");
        }

        @TestMetadata("EmptyBlocks.after.inv.kt")
        public void testEmptyBlocks() throws Exception {
            runTest("idea/testData/formatter/EmptyBlocks.after.inv.kt");
        }

        @TestMetadata("EmptyLineBetweenEnumEntries.after.inv.kt")
        public void testEmptyLineBetweenEnumEntries() throws Exception {
            runTest("idea/testData/formatter/EmptyLineBetweenEnumEntries.after.inv.kt");
        }

        @TestMetadata("ExtendsListAlignEnum.after.inv.kt")
        public void testExtendsListAlignEnum() throws Exception {
            runTest("idea/testData/formatter/ExtendsListAlignEnum.after.inv.kt");
        }

        @TestMetadata("ForLineBreak.after.inv.kt")
        public void testForLineBreak() throws Exception {
            runTest("idea/testData/formatter/ForLineBreak.after.inv.kt");
        }

        @TestMetadata("FormatFirstColumnComments.after.inv.kt")
        public void testFormatFirstColumnComments() throws Exception {
            runTest("idea/testData/formatter/FormatFirstColumnComments.after.inv.kt");
        }

        @TestMetadata("FormatFirstColumnCommentsBeforeDeclaration.after.inv.kt")
        public void testFormatFirstColumnCommentsBeforeDeclaration() throws Exception {
            runTest("idea/testData/formatter/FormatFirstColumnCommentsBeforeDeclaration.after.inv.kt");
        }

        @TestMetadata("FunctionLineBreak.after.inv.kt")
        public void testFunctionLineBreak() throws Exception {
            runTest("idea/testData/formatter/FunctionLineBreak.after.inv.kt");
        }

        @TestMetadata("FunctionalType.after.inv.kt")
        public void testFunctionalType() throws Exception {
            runTest("idea/testData/formatter/FunctionalType.after.inv.kt");
        }

        @TestMetadata("IfConditionIndent.after.inv.kt")
        public void testIfConditionIndent() throws Exception {
            runTest("idea/testData/formatter/IfConditionIndent.after.inv.kt");
        }

        @TestMetadata("IfElseWithTrickyComments.after.inv.kt")
        public void testIfElseWithTrickyComments() throws Exception {
            runTest("idea/testData/formatter/IfElseWithTrickyComments.after.inv.kt");
        }

        @TestMetadata("KeepLineBreak.after.inv.kt")
        public void testKeepLineBreak() throws Exception {
            runTest("idea/testData/formatter/KeepLineBreak.after.inv.kt");
        }

        @TestMetadata("LambdaArrow.after.inv.kt")
        public void testLambdaArrow() throws Exception {
            runTest("idea/testData/formatter/LambdaArrow.after.inv.kt");
        }

        @TestMetadata("MethodLParenthOnNextLine.after.inv.kt")
        public void testMethodLParenthOnNextLine() throws Exception {
            runTest("idea/testData/formatter/MethodLParenthOnNextLine.after.inv.kt");
        }

        @TestMetadata("MethodRParenthOnNextLine.after.inv.kt")
        public void testMethodRParenthOnNextLine() throws Exception {
            runTest("idea/testData/formatter/MethodRParenthOnNextLine.after.inv.kt");
        }

        @TestMetadata("MultilineFunctionLiteralWithParams.after.inv.kt")
        public void testMultilineFunctionLiteralWithParams() throws Exception {
            runTest("idea/testData/formatter/MultilineFunctionLiteralWithParams.after.inv.kt");
        }

        @TestMetadata("Parameters.after.inv.kt")
        public void testParameters() throws Exception {
            runTest("idea/testData/formatter/Parameters.after.inv.kt");
        }

        @TestMetadata("RightBracketOnNewLine.after.inv.kt")
        public void testRightBracketOnNewLine() throws Exception {
            runTest("idea/testData/formatter/RightBracketOnNewLine.after.inv.kt");
        }

        @TestMetadata("secondaryCtorLineBreak.after.inv.kt")
        public void testSecondaryCtorLineBreak() throws Exception {
            runTest("idea/testData/formatter/secondaryCtorLineBreak.after.inv.kt");
        }

        @TestMetadata("SingleLineFunctionLiteral.after.inv.kt")
        public void testSingleLineFunctionLiteral() throws Exception {
            runTest("idea/testData/formatter/SingleLineFunctionLiteral.after.inv.kt");
        }

        @TestMetadata("SpaceAroundExtendColon.after.inv.kt")
        public void testSpaceAroundExtendColon() throws Exception {
            runTest("idea/testData/formatter/SpaceAroundExtendColon.after.inv.kt");
        }

        @TestMetadata("SpaceAroundExtendColonInObjects.after.inv.kt")
        public void testSpaceAroundExtendColonInObjects() throws Exception {
            runTest("idea/testData/formatter/SpaceAroundExtendColonInObjects.after.inv.kt");
        }

        @TestMetadata("SpaceAroundExtendColonInSecondaryCtr.after.inv.kt")
        public void testSpaceAroundExtendColonInSecondaryCtr() throws Exception {
            runTest("idea/testData/formatter/SpaceAroundExtendColonInSecondaryCtr.after.inv.kt");
        }

        @TestMetadata("SpaceBeforeCatchParentheses.after.inv.kt")
        public void testSpaceBeforeCatchParentheses() throws Exception {
            runTest("idea/testData/formatter/SpaceBeforeCatchParentheses.after.inv.kt");
        }

        @TestMetadata("SpaceBeforeForParentheses.after.inv.kt")
        public void testSpaceBeforeForParentheses() throws Exception {
            runTest("idea/testData/formatter/SpaceBeforeForParentheses.after.inv.kt");
        }

        @TestMetadata("SpaceBeforeIfParentheses.after.inv.kt")
        public void testSpaceBeforeIfParentheses() throws Exception {
            runTest("idea/testData/formatter/SpaceBeforeIfParentheses.after.inv.kt");
        }

        @TestMetadata("SpaceBeforeWhenParentheses.after.inv.kt")
        public void testSpaceBeforeWhenParentheses() throws Exception {
            runTest("idea/testData/formatter/SpaceBeforeWhenParentheses.after.inv.kt");
        }

        @TestMetadata("SpaceBeforeWhileParentheses.after.inv.kt")
        public void testSpaceBeforeWhileParentheses() throws Exception {
            runTest("idea/testData/formatter/SpaceBeforeWhileParentheses.after.inv.kt");
        }

        @TestMetadata("SpacesAroundOperations.after.inv.kt")
        public void testSpacesAroundOperations() throws Exception {
            runTest("idea/testData/formatter/SpacesAroundOperations.after.inv.kt");
        }

        @TestMetadata("SpacesAroundUnaryOperations.after.inv.kt")
        public void testSpacesAroundUnaryOperations() throws Exception {
            runTest("idea/testData/formatter/SpacesAroundUnaryOperations.after.inv.kt");
        }

        @TestMetadata("TryCatchLineBreak.after.inv.kt")
        public void testTryCatchLineBreak() throws Exception {
            runTest("idea/testData/formatter/TryCatchLineBreak.after.inv.kt");
        }

        @TestMetadata("When.after.inv.kt")
        public void testWhen() throws Exception {
            runTest("idea/testData/formatter/When.after.inv.kt");
        }

        @TestMetadata("WhenArrow.after.inv.kt")
        public void testWhenArrow() throws Exception {
            runTest("idea/testData/formatter/WhenArrow.after.inv.kt");
        }

        @TestMetadata("WhenLineBreak.after.inv.kt")
        public void testWhenLineBreak() throws Exception {
            runTest("idea/testData/formatter/WhenLineBreak.after.inv.kt");
        }

        @TestMetadata("WhileLineBreak.after.inv.kt")
        public void testWhileLineBreak() throws Exception {
            runTest("idea/testData/formatter/WhileLineBreak.after.inv.kt");
        }

        @TestMetadata("WhileOnNewLine.after.inv.kt")
        public void testWhileOnNewLine() throws Exception {
            runTest("idea/testData/formatter/WhileOnNewLine.after.inv.kt");
        }

        @TestMetadata("idea/testData/formatter/callChain")
        @TestDataPath("$PROJECT_ROOT")
        @RunWith(JUnit3RunnerWithInners.class)
        public static class CallChain extends AbstractFormatterTest {
            private void runTest(String testDataFilePath) throws Exception {
                KotlinTestUtils.runTest(this::doTestInverted, TargetBackend.ANY, testDataFilePath);
            }

            public void testAllFilesPresentInCallChain() throws Exception {
                KotlinTestUtils.assertAllTestsPresentByMetadata(this.getClass(), new File("idea/testData/formatter/callChain"), Pattern.compile("^([^\\.]+)\\.after\\.inv\\.kt.*$"), TargetBackend.ANY, true);
            }

            @TestMetadata("CallChainWrapping.after.inv.kt")
            public void testCallChainWrapping() throws Exception {
                runTest("idea/testData/formatter/callChain/CallChainWrapping.after.inv.kt");
            }

            @TestMetadata("ConsecutiveSafeCallsIndent.after.inv.kt")
            public void testConsecutiveSafeCallsIndent() throws Exception {
                runTest("idea/testData/formatter/callChain/ConsecutiveSafeCallsIndent.after.inv.kt");
            }

            @TestMetadata("ContinuationIndentForChainedCalls.after.inv.kt")
            public void testContinuationIndentForChainedCalls() throws Exception {
                runTest("idea/testData/formatter/callChain/ContinuationIndentForChainedCalls.after.inv.kt");
            }

            @TestMetadata("FunctionLiteralsInChainCalls.after.inv.kt")
            public void testFunctionLiteralsInChainCalls() throws Exception {
                runTest("idea/testData/formatter/callChain/FunctionLiteralsInChainCalls.after.inv.kt");
            }
        }

        @TestMetadata("idea/testData/formatter/fileAnnotations")
        @TestDataPath("$PROJECT_ROOT")
        @RunWith(JUnit3RunnerWithInners.class)
        public static class FileAnnotations extends AbstractFormatterTest {
            private void runTest(String testDataFilePath) throws Exception {
                KotlinTestUtils.runTest(this::doTestInverted, TargetBackend.ANY, testDataFilePath);
            }

            public void testAllFilesPresentInFileAnnotations() throws Exception {
                KotlinTestUtils.assertAllTestsPresentByMetadata(this.getClass(), new File("idea/testData/formatter/fileAnnotations"), Pattern.compile("^([^\\.]+)\\.after\\.inv\\.kt.*$"), TargetBackend.ANY, true);
            }
        }

        @TestMetadata("idea/testData/formatter/modifierList")
        @TestDataPath("$PROJECT_ROOT")
        @RunWith(JUnit3RunnerWithInners.class)
        public static class ModifierList extends AbstractFormatterTest {
            private void runTest(String testDataFilePath) throws Exception {
                KotlinTestUtils.runTest(this::doTestInverted, TargetBackend.ANY, testDataFilePath);
            }

            public void testAllFilesPresentInModifierList() throws Exception {
                KotlinTestUtils.assertAllTestsPresentByMetadata(this.getClass(), new File("idea/testData/formatter/modifierList"), Pattern.compile("^([^\\.]+)\\.after\\.inv\\.kt.*$"), TargetBackend.ANY, true);
            }
        }

        @TestMetadata("idea/testData/formatter/parameterList")
        @TestDataPath("$PROJECT_ROOT")
        @RunWith(JUnit3RunnerWithInners.class)
        public static class ParameterList extends AbstractFormatterTest {
            private void runTest(String testDataFilePath) throws Exception {
                KotlinTestUtils.runTest(this::doTestInverted, TargetBackend.ANY, testDataFilePath);
            }

            public void testAllFilesPresentInParameterList() throws Exception {
                KotlinTestUtils.assertAllTestsPresentByMetadata(this.getClass(), new File("idea/testData/formatter/parameterList"), Pattern.compile("^([^\\.]+)\\.after\\.inv\\.kt.*$"), TargetBackend.ANY, true);
            }

            @TestMetadata("DefaultParameterValues.after.inv.kt")
            public void testDefaultParameterValues() throws Exception {
                runTest("idea/testData/formatter/parameterList/DefaultParameterValues.after.inv.kt");
            }
        }
    }
}
