#ifndef _TEST_H
#define _TEST_H

#include "backend.h"

typedef enum {
  BIT_NONE,
  BIT8,
  BIT16,
  BIT32,
} BitSize;

enum {
  SPEC_NONE	= 0,
  SPEC_NOLOG	= 1,
  SPEC_READONLY = 2,
  SPEC_INDEX	= 3,
  SPEC_DATA	= 4,
  SPEC_INCR	= 5,
  SPEC_FWD_W    = 6,
  SPEC_FWD_R    = 7,
  SPEC_RESET    = 8,
  SPEC_RESET_R  = 9,
  SPEC_RESET_W  = 10,
  SPEC_FLIP     = 11,
  SPEC_VGA_AR   = 12,
  SPEC_SWITCH	= 13,
};

enum {
  ZONE_NONE = -1,
  ZONE_MMIO = 0,
  ZONE_PORT = 1,
  ZONE_CRT  = 3,
  ZONE_CRT2 = 4,
  ZONE_SEQ  = 5,
  ZONE_SEQ2 = 6,
  ZONE_GR   = 7,
  ZONE_GR2  = 8,
  ZONE_AR   = 9, 
  ZONE_AR2  = 10,
  ZONE_DAC  = 11,
  ZONE_DAC2 = 12,
  ZONE_NZ   = 15,
  ZONE_CH1  = 16,
  ZONE_CH2  = 17,
  ZONE_CX1  = 18,
  ZONE_CX2  = 19,
  ZONE_PH1  = 20,
  ZONE_PH2  = 21,
};

#define MAX_SWITCH_VAL 4
#define MAX_SWITCH_NUM 1

typedef struct {
  int zone;
  int switcher;
  int dest[MAX_SWITCH_VAL];
} RecordSwitch;

typedef struct {
  int zone;
  CARD32 low, high;
  BitSize bits;
} RecordAccess;

typedef struct {
  CARD32 addr;
  CARD32 data;
  CARD32 mask; /* default 0 = full value */
} RecordDefault;

typedef struct {
  CARD32 low, high;
  int special;
  int param;
} RecordSpecial;

typedef struct _RecordDevice *RecordDevicePtr;

typedef struct _RecordDevice {
  char *bus;
  int dev;
  int (*access) (RecordDevicePtr this, int subaddr);
  int (*status) (RecordDevicePtr this);
  int zone;
  int current;
} RecordDevice;

typedef struct {
  int zone;
  RecordDefault* defaults;
} RecordInit;

typedef struct {
  char** zone;
  RecordAccess* access;
  RecordSwitch* switches;
  RecordSpecial** specials;
  RecordDevice** devices;
} RecordConfig;

/* -------- */
  
extern RecordDevice 
  TestDeviceCH1, TestDeviceCH2, TestDeviceCX1, TestDeviceCX2,
  TestDevicePH1, TestDevicePH2;

/* -------- */
  
extern Bool testopt_snoop;	/* simulate on real hardware */
extern Bool testopt_log;	/* log reads/writes to stdout */
extern Bool testopt_dump;
extern int testopt_default;	/* default value for empty entries */

extern CardPtr mmio_card;

extern RecordConfig* config;

#endif /* _TEST_H */

