/*
 * Decompiled with CFR 0.152.
 */
package org.apache.turbine.services.intake.validator;

import java.util.Map;
import org.apache.regexp.RE;
import org.apache.regexp.RESyntaxException;
import org.apache.turbine.services.intake.validator.Constraint;
import org.apache.turbine.services.intake.validator.ValidationException;
import org.apache.turbine.services.intake.validator.Validator;
import org.apache.turbine.util.TurbineException;

public class DefaultValidator
implements Validator {
    protected boolean required;
    protected String requiredMessage;
    protected RE mask;
    protected String maskMessage;
    protected int minLength;
    protected String minLengthMessage;
    protected int maxLength;
    protected String maxLengthMessage;
    protected String message;

    public void init(Map paramMap) throws TurbineException {
        String param;
        this.mask = null;
        this.maskMessage = null;
        this.minLength = 0;
        this.minLengthMessage = null;
        this.maxLength = 0;
        this.maxLengthMessage = null;
        Constraint constraint = (Constraint)paramMap.get("mask");
        if (constraint != null) {
            param = constraint.getValue();
            try {
                this.mask = new RE(param);
            }
            catch (RESyntaxException e) {
                throw new TurbineException(e);
            }
            this.maskMessage = constraint.getMessage();
        }
        if ((constraint = (Constraint)paramMap.get("minLength")) != null) {
            param = constraint.getValue();
            this.minLength = Integer.parseInt(param);
            this.minLengthMessage = constraint.getMessage();
        }
        if ((constraint = (Constraint)paramMap.get("maxLength")) != null) {
            param = constraint.getValue();
            this.maxLength = Integer.parseInt(param);
            this.maxLengthMessage = constraint.getMessage();
        }
        if ((constraint = (Constraint)paramMap.get("required")) == null) {
            this.required = false;
        } else {
            param = constraint.getValue();
            this.required = new Boolean(param);
            this.requiredMessage = constraint.getMessage();
        }
    }

    public boolean isValid(String testValue) {
        boolean valid = false;
        try {
            this.assertValidity(testValue);
            valid = true;
        }
        catch (ValidationException ve) {
            valid = false;
        }
        return valid;
    }

    public void assertValidity(String testValue) throws ValidationException {
        this.message = null;
        if (!(this.required || testValue != null && testValue.length() != 0)) {
            return;
        }
        if (this.required && (testValue == null || testValue.length() == 0)) {
            this.message = this.requiredMessage;
            throw new ValidationException(this.requiredMessage);
        }
        this.doAssertValidity(testValue);
        if (this.mask != null && !this.mask.match(testValue)) {
            this.message = this.maskMessage;
            throw new ValidationException(this.maskMessage);
        }
        if (this.minLength > 0 && testValue.length() < this.minLength) {
            this.message = this.minLengthMessage;
            throw new ValidationException(this.minLengthMessage);
        }
        if (this.maxLength > 0 && testValue.length() > this.maxLength) {
            this.message = this.maxLengthMessage;
            throw new ValidationException(this.maxLengthMessage);
        }
    }

    public String getMessage() {
        if (this.message == null) {
            return "";
        }
        return this.message;
    }

    protected void doAssertValidity(String testValue) throws ValidationException {
    }

    public int getMaxLength() {
        return this.maxLength;
    }

    public DefaultValidator(Map paramMap) throws TurbineException {
        this.init(paramMap);
    }

    public DefaultValidator() {
    }
}

