// Copyright (c) Lawrence Livermore National Security, LLC and other VisIt
// Project developers.  See the top-level LICENSE file for dates and other
// details.  No copyright assignment is required to contribute to VisIt.

// ************************************************************************* //
//                            avtChomboOptions.C                             //
// ************************************************************************* //

#include <avtChomboOptions.h>

#include <DBOptionsAttributes.h>

#include <string>


// ****************************************************************************
//  Function: GetChomboReadOptions
//
//  Purpose:
//      Creates the options for Chombo readers.
//
//  Important Note:
//      The code below sets up empty options.  If your format 
//      does not require read options, no modifications are 
//      necessary.
//
//  Programmer: childs -- generated by xml2avt
//  Creation:   Mon Oct 8 17:14:13 PST 2007
//
// ****************************************************************************

DBOptionsAttributes *
GetChomboReadOptions(void)
{
    DBOptionsAttributes *rv = new DBOptionsAttributes;
    rv->SetBool("Use ghost data (if present)", true);
    rv->SetBool("Enable only root level by default", false);
    rv->SetBool("Enable only explicitly defined materials by default", false);
    rv->SetBool("Check for mapping file and import coordinates if available", true);
    rv->SetBool("Use particle_nid and polymer_id to connect particles", false);
    rv->SetBool("Always compute domain boundaries (hack for AMR stitch cells)", false);
    return rv;
}

// ****************************************************************************
//  Function: GetChomboWriteOptions
//
//  Purpose:
//      Creates the options for Chombo writers.
//
//  Important Note:
//      The code below sets up empty options.  If your format 
//      does not require write options, no modifications are 
//      necessary.
//
//  Programmer: childs -- generated by xml2avt
//  Creation:   Mon Oct 8 17:14:13 PST 2007
//
// ****************************************************************************

DBOptionsAttributes *
GetChomboWriteOptions(void)
{
    DBOptionsAttributes *rv = new DBOptionsAttributes;
    return rv;
}
