/**********************************************************************
 * $show_all_nets example -- C source code using ACC PLI routines
 *
 * C source to scan through a module and list the names of all nets in
 * the module with the current logic value.
 *
 * For the book, "The Verilog PLI Handbook" by Stuart Sutherland
 *  Book copyright 1999, Kluwer Academic Publishers, Norwell, MA, USA
 *   Contact: www.wkap.il
 *  Example copyright 1998, Sutherland HDL Inc, Portland, Oregon, USA
 *   Contact: www.sutherland.com or (503) 692-0898
 *
 * Usage: $show_all_nets(<module_instance>);
 *
 * Routine definitions for a veriusertfs array:
 *  /* routine prototypes -/
 *   extern int PLIbook_ShowNets_checktf(),
 *              PLIbook_ShowNets_calltf();
 *  /* table entries -/
 *   {usertask,                       /* type of PLI routine -/
 *     0,                             /* user_data value -/
 *     PLIbook_ShowNets_checktf,      /* checktf routine -/
 *     0,                             /* sizetf routine -/
 *     PLIbook_ShowNets_calltf,       /* calltf routine -/
 *     0,                             /* misctf routine -/
 *     "$show_all_nets",              /* system task/function name -/
 *     1                              /* forward reference = true -/
 *   },
 *********************************************************************/

#include "veriuser.h"         /* IEEE 1364 PLI TF  routine library */
#include "acc_user.h"         /* IEEE 1364 PLI ACC routine library */
/**********************************************************************
 * checktf routine
 *********************************************************************/
int PLIbook_ShowNets_checktf()
{
  acc_initialize();
  if (tf_nump() != 1)
    tf_error("$show_all_nets must have 1 argument.");
  else if (tf_typep(1) == TF_NULLPARAM)
    tf_error("$show_all_nets arg cannot be null.");
  else if (acc_fetch_type(acc_handle_tfarg(1)) != accModule)
    tf_error("$show_all_nets arg must be a module instance.");
  acc_close();
  return(0);
}

/**********************************************************************
 * calltf routine
 *********************************************************************/
int PLIbook_ShowNets_calltf()
{
  handle module_handle, net_handle;
  acc_initialize();
  module_handle = acc_handle_tfarg(1);
  io_printf("\nAt time %s, nets in module %s (%s):\n",
            tf_strgettime(),
            acc_fetch_fullname(module_handle),
            acc_fetch_defname(module_handle));
  net_handle = null;    /* start with known value for target handle */
  while (net_handle=acc_next_net(module_handle,net_handle)) {
    io_printf("  %-13s %-13s  value is  %s (hex)\n",
              acc_fetch_type_str(acc_fetch_fulltype(net_handle)),
              acc_fetch_name(net_handle),
              acc_fetch_value(net_handle, "%h", null));
  }
  acc_close();
  return(0);
}
/*********************************************************************/

