# coding=utf-8
# --------------------------------------------------------------------------
# Copyright (c) Microsoft Corporation. All rights reserved.
# Licensed under the MIT License. See License.txt in the project root for license information.
# Code generated by Microsoft (R) Python Code Generator.
# Changes may cause incorrect behavior and will be lost if the code is regenerated.
# --------------------------------------------------------------------------

from azure.identity import DefaultAzureCredential

from azure.mgmt.servicefabricmanagedclusters import ServiceFabricManagedClustersManagementClient

"""
# PREREQUISITES
    pip install azure-identity
    pip install azure-mgmt-servicefabricmanagedclusters
# USAGE
    python service_action_restart_replica_example.py

    Before run the sample, please set the values of the client ID, tenant ID and client secret
    of the AAD application as environment variables: AZURE_CLIENT_ID, AZURE_TENANT_ID,
    AZURE_CLIENT_SECRET. For more info about how to get the value, please see:
    https://docs.microsoft.com/azure/active-directory/develop/howto-create-service-principal-portal
"""


def main():
    client = ServiceFabricManagedClustersManagementClient(
        credential=DefaultAzureCredential(),
        subscription_id="SUBSCRIPTION_ID",
    )

    client.services.begin_restart_replica(
        resource_group_name="resRg",
        cluster_name="myCluster",
        application_name="myApp",
        service_name="myService",
        parameters={
            "forceRestart": False,
            "partitionId": "00000000-0000-0000-0000-000000000000",
            "replicaIds": [123456789012345680],
            "restartKind": "Simultaneous",
            "timeout": 60,
        },
    ).result()


# x-ms-original-file: 2025-10-01-preview/ServiceActionRestartReplica_example.json
if __name__ == "__main__":
    main()
