/* ScummVM - Graphic Adventure Engine
 *
 * ScummVM is the legal property of its developers, whose names
 * are too numerous to list here. Please refer to the COPYRIGHT
 * file distributed with this source distribution.
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 *
 */

#include "titanic/game/bar_menu_button.h"
#include "titanic/messages/pet_messages.h"

namespace Titanic {

BEGIN_MESSAGE_MAP(CBarMenuButton, CGameObject)
	ON_MESSAGE(MouseButtonDownMsg)
	ON_MESSAGE(MouseButtonUpMsg)
END_MESSAGE_MAP()

void CBarMenuButton::save(SimpleFile *file, int indent) {
	file->writeNumberLine(1, indent);
	file->writeNumberLine(_value, indent);
	CGameObject::save(file, indent);
}

void CBarMenuButton::load(SimpleFile *file) {
	file->readNumber();
	_value = file->readNumber();
	CGameObject::load(file);
}

bool CBarMenuButton::MouseButtonDownMsg(CMouseButtonDownMsg *msg) {
	return true;
}

bool CBarMenuButton::MouseButtonUpMsg(CMouseButtonUpMsg *msg) {
	if (_value) {
		CPETUpMsg upMsg("", -1);
		upMsg.execute("BarTelevision");
	} else {
		CPETDownMsg downMsg("", -1);
		downMsg.execute("BarTelevision");
	}

	return true;
}

} // End of namespace Titanic
