#
# u1d1.rb
#   $Id$
#

require "numru/dcl"

include NumRu
include Math

nmax = 51
xmin = 1945
xmax = 1995

y = NArray.sfloat(nmax)

#-- data ----
y0 = 0.5
for n in 0..nmax-1
  y[n] = 5.0*y0 + 10.0
  y0 = 3.7*y0*(1.0-y0)
end

rundef = DCL::glrget('RUNDEF')

#-- graph ----
iws = (ARGV[0] || (puts ' WORKSTATION ID (I)  ? ;'; DCL::sgpwsn; gets)).to_i
DCL::gropn iws
DCL::grfrm

DCL::grswnd(xmin, xmax, rundef, rundef)
DCL::ussttl('TIME', 'YEAR', 'TEMPERATURE', 'DEG')
DCL::usgrph(rundef, y)

DCL::grcls

