#
#       Makefile for $(DENNOUDIR)/???
#       

include	../Mkinclude

SUBDIRS		= 

PROGRAM		= 

$(PROGRAM): libs
	@cd MAIN ; $(MAKE) $(PROGRAM)

libs:
	@for i in $(SUBDIRS) ; do \
	  cd $$i ; \
	  echo "Making $$i/" ; \
	  $(MAKE) ; \
	  cd .. ; \
	done

install:
	@for i in $(SUBDIRS) ; do \
	  cd $$i ; \
	  echo "Installing $$i/" ; \
	  $(MAKE) install ; \
	  cd .. ; \
	done

clean: clean.local clean.dir

clean.local:
	$(RM) *.o *~ core *.trace *.f

clean.dir:
	@for i in $(SUBDIRS) ; do \
	  cd $$i ; \
	  echo "Cleaning $$i/" ; \
	  $(MAKE) clean ; \
	  cd .. ; \
	done

tags: tags.local tags.dir

tags.local:
	@$(TAGS) *.F */*.F

tags.dir:
	@for i in $(SUBDIRS) ; do \
	  cd $$i ; \
	  $(MAKE) index ; \
	  cd .. ; \
	done

index: index.local index.dir

index.local:
		@$(INDEX) $(HDRS) $(SRCS)

index.dir:
	@for i in $(SUBDIRS) ; do \
	  cd $$i ; \
	  $(MAKE) index ; \
	  cd .. ; \
	done

print: print.local print.dir

print.local:	$(PRINTSTAMP)

$(PRINTSTAMP): $(HDRS) $(SRCS_ALL)
		$(PRINT) $?
		$(TOUCH) $(PRINTSTAMP)

print.dir:
	@for i in $(SUBDIRS) ; do \
	  cd $$i ; \
	  echo "Printing $$i/" ; \
	  $(MAKE) print ; \
	  cd .. ; \
	done

pack: pack.local pack.dir

pack.local:	$(PACKFILE) $(SRCS:.F=.pac) 
	$(MD) $(PACKDIR)
	$(MV) $(PACKFILE) $(PACKDIR)/MAIN

pack.dir:
	@for i in $(SUBDIRS) ; do \
	  cd $$i ; \
	  echo "Packing $$i/" ; \
	  $(MAKE) pack; \
	  cd .. ; \
	done	

####