/* gtslp.f -- translated by f2c (version 19990503).
   You must link the resulting object file with the libraries:
	-lf2c -lm   (in that order)
*/

#include "f2c.h"

/* Common Block Declarations */

struct {
    real mwork[557056];
} gmwork_;

#define gmwork_1 gmwork_

/* Table of constant values */

static integer c__91 = 91;
static integer c_b6 = 557056;
static logical c_false = FALSE_;
static integer c__2 = 2;
static integer c__9 = 9;
static integer c__1 = 1;
static integer c__0 = 0;
static integer c__100 = 100;
static integer c__3 = 3;

/* PACKAGE  GTSLP !" */
/* ********************************************************************** */
/* Main program */ MAIN__(void)
{
    /* Initialized data */

    static char out[100] = "$GTTMPDIR/gtool.out                             "
	    "                                                    ";
    static logical apnd = FALSE_;
    static char item[16] = "SLP             ";
    static char title[32] = "Sea Level Pressure              ";
    static char unit[16] = "                ";
    static char dset[16] = "                ";
    static char edit[16] = "                ";
    static char ettl[16] = "                ";
    static logical greset = FALSE_;
    static logical help = FALSE_;
    static integer jfile = 60;
    static real grav = 9.8f;
    static char ps[100] = "Ps                                               "
	    "                                                   ";
    static char t[100] = "T                                                 "
	    "                                                  ";
    static char zs[100] = "ZS                                               "
	    "                                                   ";

    /* System generated locals */
    address a__1[2];
    integer i__1[2];
    real r__1;
    char ch__1[107];
    cllist cl__1;

    /* Builtin functions */
    integer s_rsne(cilist *), f_clos(cllist *), s_wsne(cilist *);
    /* Subroutine */ int s_stop(char *, ftnlen);
    integer s_wsle(cilist *);
    /* Subroutine */ int s_cat(char *, char **, integer *, integer *, ftnlen);
    integer do_lio(integer *, integer *, char *, ftnlen), e_wsle(void), s_cmp(
	    char *, char *, ftnlen, ftnlen);

    /* Local variables */
    extern integer lenc_(char *, ftnlen);
    static integer nopt, nfile, ieodp, ieodt, ieodz;
    static char hitez[16];
    extern /* Subroutine */ int gmcal3_(U_fp, char *, real *, char *, real *, 
	    char *, real *, char *, char *, ftnlen, ftnlen, ftnlen, ftnlen, 
	    ftnlen);
    static integer il;
    extern /* Subroutine */ int gfread_(char *, real *, integer *, integer *, 
	    integer *, ftnlen);
    static char hheadp[16*64], hheadt[16*64];
    static real gdatap[557056];
    extern /* Subroutine */ int ghcget_(char *, char *, char *, ftnlen, 
	    ftnlen, ftnlen);
    static char hheadz[16*64];
    static real gdatat[557056];
    extern /* Subroutine */ int gmffct_(char *, real *, real *, char *, char *
	    , ftnlen, ftnlen, ftnlen);
    static integer ifilep;
    static real gdataz[557056];
    static integer ifilet;
    extern /* Subroutine */ int calslp_();
    extern /* Subroutine */ int ghcset_(char *, char *, char *, ftnlen, 
	    ftnlen, ftnlen);
    static integer ifilez;
    extern /* Subroutine */ int msgdmp_(char *, char *, char *, ftnlen, 
	    ftnlen, ftnlen), gfoopn_(integer *, char *, logical *, ftnlen), 
	    ghrsgp_(char *, ftnlen), gfropn_(integer *, char *, ftnlen), 
	    optarg_(integer *, char *, char *, integer *, integer *, ftnlen, 
	    ftnlen), gtopen_(void), gmsize_(integer *), ghcsts_(char *, char *
	    , char *, ftnlen, ftnlen, ftnlen), gunenv_(char *, char *, 
	    logical *, ftnlen, ftnlen), gfwrit_(char *, real *, integer *, 
	    integer *, integer *, ftnlen), gtsize_(char *, integer *, ftnlen),
	     gurntf_(char *, char *, char *, ftnlen, ftnlen, ftnlen);
    static integer ios;

    /* Namelist stuff */

    static Vardesc apnd_dv = { "APND", (char *)&apnd, (ftnlen *)0, 8 };
    static Vardesc edit_dv = { "EDIT", edit, (ftnlen *)0, -16 };
    static Vardesc help_dv = { "HELP", (char *)&help, (ftnlen *)0, 8 };
    static Vardesc item_dv = { "ITEM", item, (ftnlen *)0, -16 };
    static Vardesc dset_dv = { "DSET", dset, (ftnlen *)0, -16 };
    static Vardesc ettl_dv = { "ETTL", ettl, (ftnlen *)0, -16 };
    static Vardesc unit_dv = { "UNIT", unit, (ftnlen *)0, -16 };
    static Vardesc t_dv = { "T", t, (ftnlen *)0, -100 };
    static Vardesc title_dv = { "TITLE", title, (ftnlen *)0, -32 };
    static Vardesc ps_dv = { "PS", ps, (ftnlen *)0, -100 };
    static Vardesc zs_dv = { "ZS", zs, (ftnlen *)0, -100 };
    static Vardesc greset_dv = { "GRESET", (char *)&greset, (ftnlen *)0, 8 };
    static Vardesc out_dv = { "OUT", out, (ftnlen *)0, -100 };

    static Vardesc *option_vl[] = { &ps_dv, &t_dv, &zs_dv, &out_dv, &apnd_dv, 
	    &item_dv, &unit_dv, &title_dv, &dset_dv, &edit_dv, &ettl_dv, &
	    greset_dv, &help_dv };
    static Namelist option = { "OPTION", option_vl, 13 };

    /* Fortran I/O blocks */
    static cilist io___23 = { 1, 91, 1, (char *)&option, 0 };
    static cilist io___24 = { 0, 6, 0, (char *)&option, 0 };
    static cilist io___32 = { 0, 6, 0, 0, 0 };



/* PACKAGE GTSINC  !" ΰ礭(IJKDIMΤ̣߰) */
/* **************************************************************** */







    optarg_(&c__91, "OPTION", "HFILE", &nopt, &nfile, (ftnlen)6, (ftnlen)5);
    ios = s_rsne(&io___23);
    cl__1.cerr = 0;
    cl__1.cunit = 91;
    cl__1.csta = 0;
    f_clos(&cl__1);
    if (ios != 0 || help) {
	s_wsne(&io___24);
	s_stop("", (ftnlen)0);
    }

    gtopen_();
    gtsize_(hheadp, &c_b6, (ftnlen)16);
    gtsize_(hheadt, &c_b6, (ftnlen)16);
    gtsize_(hheadz, &c_b6, (ftnlen)16);
    gmsize_(&c_b6);

    gurntf_(ps, out, "$GTTMPDIR/gtool.in", (ftnlen)100, (ftnlen)100, (ftnlen)
	    18);
    gurntf_(t, out, "$GTTMPDIR/gtool.in", (ftnlen)100, (ftnlen)100, (ftnlen)
	    18);
    gurntf_(zs, out, "$GTTMPDIR/gtool.in", (ftnlen)100, (ftnlen)100, (ftnlen)
	    18);

    gfropn_(&ifilep, ps, (ftnlen)100);
    gfropn_(&ifilet, t, (ftnlen)100);
    gfropn_(&ifilez, zs, (ftnlen)100);
    gfoopn_(&jfile, out, &apnd, (ftnlen)100);

    gunenv_(out, ".", &c_false, (ftnlen)100, (ftnlen)1);
    il = lenc_(out, (ftnlen)100);
    s_wsle(&io___32);
/* Writing concatenation */
    i__1[0] = 7, a__1[0] = "output=";
    i__1[1] = il, a__1[1] = out;
    s_cat(ch__1, a__1, i__1, &c__2, (ftnlen)107);
    do_lio(&c__9, &c__1, ch__1, il + 7);
    e_wsle();

    gfread_(hheadz, gdataz, &ieodz, &ifilez, &c__1, (ftnlen)16);

    if (ieodz != 0) {
	msgdmp_("E", "GTSLP", "ZS FILE NOT FOUND", (ftnlen)1, (ftnlen)5, (
		ftnlen)17);
    }

    ghcget_(hheadz, "ITEM", hitez, (ftnlen)16, (ftnlen)4, (ftnlen)16);
    if (s_cmp(hitez, "GPHIS", (ftnlen)16, (ftnlen)5) == 0) {
	r__1 = 1.f / grav;
	gmffct_(hheadz, gdataz, &r__1, "  ", "  ", (ftnlen)16, (ftnlen)2, (
		ftnlen)2);
    }

L1100:
    gfread_(hheadp, gdatap, &ieodp, &ifilep, &c__1, (ftnlen)16);
    gfread_(hheadt, gdatat, &ieodt, &ifilet, &c__1, (ftnlen)16);

    if (max(ieodp,ieodt) == 0) {
	gmcal3_((U_fp)calslp_, hheadp, gdatap, hheadt, gdatat, hheadz, gdataz,
		 edit, ettl, (ftnlen)16, (ftnlen)16, (ftnlen)16, (ftnlen)16, (
		ftnlen)16);

	if (s_cmp(item, " ", (ftnlen)16, (ftnlen)1) != 0) {
	    ghcset_(hheadp, "ITEM", item, (ftnlen)16, (ftnlen)4, (ftnlen)16);
	}
	if (s_cmp(unit, " ", (ftnlen)16, (ftnlen)1) != 0) {
	    ghcset_(hheadp, "UNIT", unit, (ftnlen)16, (ftnlen)4, (ftnlen)16);
	}
	if (s_cmp(title, " ", (ftnlen)32, (ftnlen)1) != 0) {
	    ghcsts_(hheadp, "TITL", title, (ftnlen)16, (ftnlen)4, (ftnlen)32);
	}
	if (s_cmp(dset, " ", (ftnlen)16, (ftnlen)1) != 0) {
	    ghcset_(hheadp, "DSET", dset, (ftnlen)16, (ftnlen)4, (ftnlen)16);
	}
	if (greset) {
	    ghrsgp_(hheadp, (ftnlen)16);
	}

	gfwrit_(hheadp, gdatap, &jfile, &c__1, &c__0, (ftnlen)16);

	goto L1100;
    }

    s_stop("", (ftnlen)0);
    return 0;
} /* MAIN__ */

/* ******************************************************************* */
/* Subroutine */ int calslp_(char *hps, real *ps, char *ht, real *t, char *
	hzs, real *zs, char *hslp, real *slp, integer *imax, integer *jmax, 
	integer *kmax, integer *imax2, integer *jmax2, integer *kmax2, 
	integer *imax3, integer *jmax3, integer *kmax3, ftnlen hps_len, 
	ftnlen ht_len, ftnlen hzs_len, ftnlen hslp_len)
{
    /* System generated locals */
    integer ps_dim1, ps_offset, t_dim1, t_dim2, t_offset, zs_dim1, zs_offset, 
	    slp_dim1, slp_offset;

    /* Local variables */
    static integer ieod;
    extern /* Subroutine */ int ps2slp_(real *, real *, real *, real *, 
	    integer *, integer *, real *), msgdmp_(char *, char *, char *, 
	    ftnlen, ftnlen, ftnlen), gtsize_(char *, integer *, ftnlen), 
	    guqaxv_(char *, integer *, char *, char *, real *, integer *, 
	    ftnlen, ftnlen, ftnlen);
    static char hhs[16*64];
    static real sig[100];




    /* Parameter adjustments */
    hps -= hps_len;
    ht -= ht_len;
    hzs -= hzs_len;
    hslp -= hslp_len;
    slp_dim1 = *imax;
    slp_offset = 1 + slp_dim1 * 1;
    slp -= slp_offset;
    ps_dim1 = *imax;
    ps_offset = 1 + ps_dim1 * 1;
    ps -= ps_offset;
    t_dim1 = *imax2;
    t_dim2 = *jmax2;
    t_offset = 1 + t_dim1 * (1 + t_dim2 * 1);
    t -= t_offset;
    zs_dim1 = *imax3;
    zs_offset = 1 + zs_dim1 * 1;
    zs -= zs_offset;

    /* Function Body */
    if (*kmax > 100) {
	msgdmp_("E", "SLP", "WORK AREA TOO SMALL", (ftnlen)1, (ftnlen)3, (
		ftnlen)19);
    }
    gtsize_(hhs, &c__100, (ftnlen)16);
    guqaxv_(ht + ht_len, &c__3, "LOC", hhs, sig, &ieod, ht_len, (ftnlen)3, (
	    ftnlen)16);

    ps2slp_(&zs[zs_offset], &t[t_offset], &ps[ps_offset], sig, imax, jmax, &
	    slp[slp_offset]);

    return 0;
} /* calslp_ */

/* ***************************************************************** */
/* Subroutine */ int ps2slp_(real *z__, real *t, real *ps, real *sig, integer 
	*imax, integer *jmax, real *rslp)
{
    /* Initialized data */

    static real rair = 287.04f;
    static real grav = 9.8f;

    /* System generated locals */
    integer i__1;
    real r__1;

    /* Builtin functions */
    double log(doublereal);

    /* Local variables */
    static integer ij;
    extern doublereal deltap_(real *, real *, real *);
    static real rz;

/* --------------------------------------- */
/*  CALCULATE SEA LEVEL PRESSURE */

/* [INPUT] */
/*   Z    : SURFACE ALTITUDE */
/*   T    : TEMPERATURE AT SIGMA LEVEL 1 */
/*   PS   : SURFACE AIR PRESSURE */
/*   SIG  : SIGMA LEVEL AT EACH LAYER */
/* [OUTPUT] */
/*   RSLP : SEA LEVEL PRESSURE */
/* [INTERNAL] */
/*   RZ   : ALTITUDE AT SIGMA LEVEL 1 */
/*   P    : AIR PRESSURE AT SIGMA LEVEL 1 */
/* --------------------------------------- */


/* EVALUATE Z(LEVEL1) USING HYDROSTATIC RELATION */

    /* Parameter adjustments */
    --sig;
    --rslp;
    --ps;
    --t;
    --z__;

    /* Function Body */
    i__1 = *imax * *jmax;
    for (ij = 1; ij <= i__1; ++ij) {
	rz = z__[ij] - log(sig[1]) * rair * t[ij] / grav;

/* SEA LEVEL PRESSURE */

	r__1 = ps[ij] * sig[1];
	rslp[ij] = ps[ij] + deltap_(&rz, &t[ij], &r__1);
/* L100: */
    }

    return 0;
} /* ps2slp_ */

/* ********************************************************************* */
doublereal deltap_(real *z__, real *t, real *p)
{
    /* Initialized data */

    static real t00 = 273.15f;
    static real grav = 9.8f;
    static real rair = 287.05f;
    static real tlaps = .005f;

    /* System generated locals */
    real ret_val;

    /* Builtin functions */
    double exp(doublereal);

    /* Local variables */
    extern doublereal epsm_(real *);
    static real em, tm, tvm;

/* --------------------------------------------------------------- */
/*  ( SEA LEVEL PRESSURE ) - ( SURFACE PRESSURE ) */

/*  THIS METHOD HAVE USED BY THE OBSERVATION SECTION */
/*                        IN THE JAPANESE METEOROLOGICAL AGENCY. */
/* [INPUT] */
/*   Z   : ALTITUDE */
/*   T   : TEMPERATURE */
/*   P   : AIR PRESSURE */
/* [INTERNAL] */
/*   TM  : MEAN TEMPERATURE IN THE DESTINATION AIR COLUMN */
/*   EM  : EFFECT ON AIR MOISTURE */
/*   TVM : MEAN VIRTUAL TEMPERATURE IN THE DESTINATION AIR COLUMN */
/* --------------------------------------------------------------- */

    tm = *t - t00 + tlaps / 2.f * *z__;
    em = epsm_(&tm);
    tvm = t00 + tm + em;

    ret_val = *p * (exp(grav * *z__ / (rair * tvm)) - 1.f);

    return ret_val;
} /* deltap_ */

/* ******************************************************************** */
doublereal epsm_(real *tm)
{
    /* System generated locals */
    real ret_val;

    /* Local variables */
    static real a, b, c__;

/* --------------------------------------- */
/*  EFFECT ON AIR MOISTURE */
/*   (MEAN STATE OF LOWER LAYER IN JAPAN) */
/* --------------------------------------- */
    if (*tm < -30.f) {
	ret_val = .09f;
	return ret_val;
    } else if (-30.f <= *tm && *tm < 0.f) {
	a = 4.89e-4f;
	b = .03f;
	c__ = .55f;
    } else if (0.f <= *tm && *tm < 20.f) {
	a = .00285f;
	b = .0165f;
	c__ = .55f;
    } else if (20.f <= *tm && *tm < 33.8f) {
	a = -.006933f;
	b = .4687f;
	c__ = -4.58f;
    } else {
	ret_val = 3.34f;
	return ret_val;
    }

    ret_val = (a * *tm + b) * *tm + c__;

    return ret_val;
} /* epsm_ */

/* Main program alias */ int gtslp_ () { MAIN__ (); return 0; }
