/* sinqf.f -- translated by f2c (version 19990503).
   You must link the resulting object file with the libraries:
	-lf2c -lm   (in that order)
*/

#include "f2c.h"

/* ----------------------------------------------------------------------- */
/*     SUBROUTINE SINQF(N,X,WSAVE) */

/*     SUBROUTINE SINQF COMPUTES THE FAST FOURIER TRANSFORM OF QUARTER */
/*     WAVE DATA. THAT IS , SINQF COMPUTES THE COEFFICIENTS IN A SINE */
/*     SERIES REPRESENTATION WITH ONLY ODD WAVE NUMBERS. THE TRANSFORM */
/*     IS DEFINED BELOW AT OUTPUT PARAMETER X. */

/*     SINQB IS THE UNNORMALIZED INVERSE OF SINQF SINCE A CALL OF SINQF */
/*     FOLLOWED BY A CALL OF SINQB WILL MULTIPLY THE INPUT SEQUENCE X */
/*     BY 4*N. */

/*     THE ARRAY WSAVE WHICH IS USED BY SUBROUTINE SINQF MUST BE */
/*     INITIALIZED BY CALLING SUBROUTINE SINQI(N,WSAVE). */


/*     INPUT PARAMETERS */

/*     N       THE LENGTH OF THE ARRAY X TO BE TRANSFORMED.  THE METHOD */
/*             IS MOST EFFICIENT WHEN N IS A PRODUCT OF SMALL PRIMES. */

/*     X       AN ARRAY WHICH CONTAINS THE SEQUENCE TO BE TRANSFORMED */

/*     WSAVE   A WORK ARRAY WHICH MUST BE DIMENSIONED AT LEAST 3*N+15. */
/*             IN THE PROGRAM THAT CALLS SINQF. THE WSAVE ARRAY MUST BE */
/*             INITIALIZED BY CALLING SUBROUTINE SINQI(N,WSAVE) AND A */
/*             DIFFERENT WSAVE ARRAY MUST BE USED FOR EACH DIFFERENT */
/*             VALUE OF N. THIS INITIALIZATION DOES NOT HAVE TO BE */
/*             REPEATED SO LONG AS N REMAINS UNCHANGED THUS SUBSEQUENT */
/*             TRANSFORMS CAN BE OBTAINED FASTER THAN THE FIRST. */

/*     OUTPUT PARAMETERS */

/*     X       FOR I=1,...,N */

/*                  X(I) = (-1)**(I-1)*X(N) */

/*                     + THE SUM FROM K=1 TO K=N-1 OF */

/*                     2*X(K)*SIN((2*I-1)*K*PI/(2*N)) */

/*                  A CALL OF SINQF FOLLOWED BY A CALL OF */
/*                  SINQB WILL MULTIPLY THE SEQUENCE X BY 4*N. */
/*                  THEREFORE SINQB IS THE UNNORMALIZED INVERSE */
/*                  OF SINQF. */

/*     WSAVE   CONTAINS INITIALIZATION CALCULATIONS WHICH MUST NOT */
/*             BE DESTROYED BETWEEN CALLS OF SINQF OR SINQB. */

/* Subroutine */ int sinqf_(integer *n, real *x, real *wsave)
{
    /* System generated locals */
    integer i__1;

    /* Local variables */
    static integer k;
    extern /* Subroutine */ int cosqf_(integer *, real *, real *);
    static real xhold;
    static integer kc, ns2;


    /* Parameter adjustments */
    --wsave;
    --x;

    /* Function Body */
    if (*n == 1) {
	return 0;
    }
    ns2 = *n / 2;
    i__1 = ns2;
    for (k = 1; k <= i__1; ++k) {
	kc = *n - k;
	xhold = x[k];
	x[k] = x[kc + 1];
	x[kc + 1] = xhold;
/* L101: */
    }
    cosqf_(n, &x[1], &wsave[1]);
    i__1 = *n;
    for (k = 2; k <= i__1; k += 2) {
	x[k] = -x[k];
/* L102: */
    }
    return 0;
} /* sinqf_ */

