/* gthydro.f -- translated by f2c (version 19990503).
   You must link the resulting object file with the libraries:
	-lf2c -lm   (in that order)
*/

#include "f2c.h"

/* Common Block Declarations */

struct {
    real mwork[557056];
} gmwork_;

#define gmwork_1 gmwork_

/* Table of constant values */

static integer c__91 = 91;
static integer c_b6 = 557056;
static logical c_false = FALSE_;
static integer c__2 = 2;
static integer c__9 = 9;
static integer c__1 = 1;
static integer c__0 = 0;
static integer c__100 = 100;
static integer c__3 = 3;

/* PACKAGE  GTHYDRO !" T -> z hydrostatic */
/* ********************************************************************** */
/* Main program */ MAIN__(void)
{
    /* Initialized data */

    static char out[100] = "$GTTMPDIR/gtool.out                             "
	    "                                                    ";
    static logical apnd = FALSE_;
    static char item[16] = "Z               ";
    static char title[32] = "G.P. Height                     ";
    static char unit[16] = "m               ";
    static char dset[16] = "                ";
    static char edit[16] = "                ";
    static char ettl[16] = "                ";
    static logical greset = TRUE_;
    static logical help = FALSE_;
    static integer jfile = 60;
    static real grav = 9.8f;
    static char t[100] = "T                                                 "
	    "                                                  ";
    static char q[100] = "q                                                 "
	    "                                                  ";
    static char zs[100] = "ZS                                               "
	    "                                                   ";

    /* System generated locals */
    address a__1[2];
    integer i__1[2];
    real r__1;
    char ch__1[107];
    cllist cl__1;

    /* Builtin functions */
    integer s_rsne(cilist *), f_clos(cllist *), s_wsne(cilist *);
    /* Subroutine */ int s_stop(char *, ftnlen);
    integer s_wsle(cilist *);
    /* Subroutine */ int s_cat(char *, char **, integer *, integer *, ftnlen);
    integer do_lio(integer *, integer *, char *, ftnlen), e_wsle(void), s_cmp(
	    char *, char *, ftnlen, ftnlen);

    /* Local variables */
    extern integer lenc_(char *, ftnlen);
    static integer nopt, nfile, ieodq, ieodt, ieodz;
    static char hitez[16];
    extern /* Subroutine */ int gmcal3_(U_fp, char *, real *, char *, real *, 
	    char *, real *, char *, char *, ftnlen, ftnlen, ftnlen, ftnlen, 
	    ftnlen);
    static integer il;
    extern /* Subroutine */ int gfread_(char *, real *, integer *, integer *, 
	    integer *, ftnlen);
    static char hheadq[16*64], hheadt[16*64];
    extern /* Subroutine */ int calgph_();
    static real gdataq[557056];
    extern /* Subroutine */ int ghcget_(char *, char *, char *, ftnlen, 
	    ftnlen, ftnlen);
    static char hheadz[16*64];
    static real gdatat[557056];
    extern /* Subroutine */ int gmffct_(char *, real *, real *, char *, char *
	    , ftnlen, ftnlen, ftnlen);
    static integer ifileq;
    static real gdataz[557056];
    static integer ifilet;
    extern /* Subroutine */ int ghcset_(char *, char *, char *, ftnlen, 
	    ftnlen, ftnlen);
    static integer ifilez;
    extern /* Subroutine */ int msgdmp_(char *, char *, char *, ftnlen, 
	    ftnlen, ftnlen), gfoopn_(integer *, char *, logical *, ftnlen), 
	    ghrsgp_(char *, ftnlen), gfropn_(integer *, char *, ftnlen), 
	    optarg_(integer *, char *, char *, integer *, integer *, ftnlen, 
	    ftnlen), gtopen_(void), gmsize_(integer *), ghcsts_(char *, char *
	    , char *, ftnlen, ftnlen, ftnlen), gunenv_(char *, char *, 
	    logical *, ftnlen, ftnlen), gfwrit_(char *, real *, integer *, 
	    integer *, integer *, ftnlen), gtsize_(char *, integer *, ftnlen),
	     gurntf_(char *, char *, char *, ftnlen, ftnlen, ftnlen);
    static integer ios;

    /* Namelist stuff */

    static Vardesc apnd_dv = { "APND", (char *)&apnd, (ftnlen *)0, 8 };
    static Vardesc edit_dv = { "EDIT", edit, (ftnlen *)0, -16 };
    static Vardesc help_dv = { "HELP", (char *)&help, (ftnlen *)0, 8 };
    static Vardesc item_dv = { "ITEM", item, (ftnlen *)0, -16 };
    static Vardesc dset_dv = { "DSET", dset, (ftnlen *)0, -16 };
    static Vardesc ettl_dv = { "ETTL", ettl, (ftnlen *)0, -16 };
    static Vardesc unit_dv = { "UNIT", unit, (ftnlen *)0, -16 };
    static Vardesc q_dv = { "Q", q, (ftnlen *)0, -100 };
    static Vardesc t_dv = { "T", t, (ftnlen *)0, -100 };
    static Vardesc title_dv = { "TITLE", title, (ftnlen *)0, -32 };
    static Vardesc zs_dv = { "ZS", zs, (ftnlen *)0, -100 };
    static Vardesc greset_dv = { "GRESET", (char *)&greset, (ftnlen *)0, 8 };
    static Vardesc out_dv = { "OUT", out, (ftnlen *)0, -100 };

    static Vardesc *option_vl[] = { &t_dv, &q_dv, &zs_dv, &out_dv, &apnd_dv, &
	    item_dv, &unit_dv, &title_dv, &dset_dv, &edit_dv, &ettl_dv, &
	    greset_dv, &help_dv };
    static Namelist option = { "OPTION", option_vl, 13 };

    /* Fortran I/O blocks */
    static cilist io___23 = { 1, 91, 1, (char *)&option, 0 };
    static cilist io___24 = { 0, 6, 0, (char *)&option, 0 };
    static cilist io___32 = { 0, 6, 0, 0, 0 };



/* PACKAGE GTSINC  !" ΰ礭(IJKDIMΤ̣߰) */
/* **************************************************************** */







    optarg_(&c__91, "OPTION", "HFILE", &nopt, &nfile, (ftnlen)6, (ftnlen)5);
    ios = s_rsne(&io___23);
    cl__1.cerr = 0;
    cl__1.cunit = 91;
    cl__1.csta = 0;
    f_clos(&cl__1);
    if (ios != 0 || help) {
	s_wsne(&io___24);
	s_stop("", (ftnlen)0);
    }

    gtopen_();
    gtsize_(hheadt, &c_b6, (ftnlen)16);
    gtsize_(hheadq, &c_b6, (ftnlen)16);
    gtsize_(hheadz, &c_b6, (ftnlen)16);
    gmsize_(&c_b6);

    gurntf_(t, out, "$GTTMPDIR/gtool.in", (ftnlen)100, (ftnlen)100, (ftnlen)
	    18);
    gurntf_(q, out, "$GTTMPDIR/gtool.in", (ftnlen)100, (ftnlen)100, (ftnlen)
	    18);
    gurntf_(zs, out, "$GTTMPDIR/gtool.in", (ftnlen)100, (ftnlen)100, (ftnlen)
	    18);

    gfropn_(&ifilet, t, (ftnlen)100);
    gfropn_(&ifileq, q, (ftnlen)100);
    gfropn_(&ifilez, zs, (ftnlen)100);
    gfoopn_(&jfile, out, &apnd, (ftnlen)100);

    gunenv_(out, ".", &c_false, (ftnlen)100, (ftnlen)1);
    il = lenc_(out, (ftnlen)100);
    s_wsle(&io___32);
/* Writing concatenation */
    i__1[0] = 7, a__1[0] = "output=";
    i__1[1] = il, a__1[1] = out;
    s_cat(ch__1, a__1, i__1, &c__2, (ftnlen)107);
    do_lio(&c__9, &c__1, ch__1, il + 7);
    e_wsle();

    gfread_(hheadz, gdataz, &ieodz, &ifilez, &c__1, (ftnlen)16);

    if (ieodz != 0) {
	msgdmp_("E", "GTHYDRO", "ZS FILE NOT FOUND", (ftnlen)1, (ftnlen)7, (
		ftnlen)17);
    }

    ghcget_(hheadz, "ITEM", hitez, (ftnlen)16, (ftnlen)4, (ftnlen)16);
    if (s_cmp(hitez, "GPHIS", (ftnlen)16, (ftnlen)5) == 0) {
	r__1 = 1.f / grav;
	gmffct_(hheadz, gdataz, &r__1, "  ", "  ", (ftnlen)16, (ftnlen)2, (
		ftnlen)2);
    }

L1100:
    gfread_(hheadt, gdatat, &ieodt, &ifilet, &c__1, (ftnlen)16);
    gfread_(hheadq, gdataq, &ieodq, &ifileq, &c__1, (ftnlen)16);

    if (max(ieodt,ieodq) == 0) {
	gmcal3_((U_fp)calgph_, hheadt, gdatat, hheadq, gdataq, hheadz, gdataz,
		 edit, ettl, (ftnlen)16, (ftnlen)16, (ftnlen)16, (ftnlen)16, (
		ftnlen)16);

	if (s_cmp(item, " ", (ftnlen)16, (ftnlen)1) != 0) {
	    ghcset_(hheadt, "ITEM", item, (ftnlen)16, (ftnlen)4, (ftnlen)16);
	}
	if (s_cmp(unit, " ", (ftnlen)16, (ftnlen)1) != 0) {
	    ghcset_(hheadt, "UNIT", unit, (ftnlen)16, (ftnlen)4, (ftnlen)16);
	}
	if (s_cmp(title, " ", (ftnlen)32, (ftnlen)1) != 0) {
	    ghcsts_(hheadt, "TITL", title, (ftnlen)16, (ftnlen)4, (ftnlen)32);
	}
	if (s_cmp(dset, " ", (ftnlen)16, (ftnlen)1) != 0) {
	    ghcset_(hheadt, "DSET", dset, (ftnlen)16, (ftnlen)4, (ftnlen)16);
	}
	if (greset) {
	    ghrsgp_(hheadt, (ftnlen)16);
	}

	gfwrit_(hheadt, gdatat, &jfile, &c__1, &c__0, (ftnlen)16);

	goto L1100;
    }

    s_stop("", (ftnlen)0);
    return 0;
} /* MAIN__ */

/* ******************************************************************* */
/* Subroutine */ int calgph_(char *ht, real *t, char *hq, real *q, char *hzs, 
	real *zs, char *hzgp, real *zgp, integer *imax, integer *jmax, 
	integer *kmax, integer *imax2, integer *jmax2, integer *kmax2, 
	integer *imax3, integer *jmax3, integer *kmax3, ftnlen ht_len, ftnlen 
	hq_len, ftnlen hzs_len, ftnlen hzgp_len)
{
    /* System generated locals */
    integer t_dim1, t_dim2, t_offset, q_dim1, q_dim2, q_offset, zs_dim1, 
	    zs_offset, zgp_dim1, zgp_dim2, zgp_offset, i__1;

    /* Local variables */
    static integer ieod;
    static real dsig[100];
    extern /* Subroutine */ int hydro_(real *, real *, real *, real *, real *,
	     real *, integer *, integer *), msgdmp_(char *, char *, char *, 
	    ftnlen, ftnlen, ftnlen), gtsize_(char *, integer *, ftnlen), 
	    guqaxv_(char *, integer *, char *, char *, real *, integer *, 
	    ftnlen, ftnlen, ftnlen);
    static char hhs[16*64];
    static real sig[100];




    /* Parameter adjustments */
    ht -= ht_len;
    hq -= hq_len;
    hzs -= hzs_len;
    hzgp -= hzgp_len;
    zgp_dim1 = *imax;
    zgp_dim2 = *jmax;
    zgp_offset = 1 + zgp_dim1 * (1 + zgp_dim2 * 1);
    zgp -= zgp_offset;
    t_dim1 = *imax;
    t_dim2 = *jmax;
    t_offset = 1 + t_dim1 * (1 + t_dim2 * 1);
    t -= t_offset;
    zs_dim1 = *imax3;
    zs_offset = 1 + zs_dim1 * 1;
    zs -= zs_offset;
    q_dim1 = *imax2;
    q_dim2 = *jmax2;
    q_offset = 1 + q_dim1 * (1 + q_dim2 * 1);
    q -= q_offset;

    /* Function Body */
    if (*kmax > 100) {
	msgdmp_("E", "CALGPH", "WORK AREA TOO SMALL", (ftnlen)1, (ftnlen)6, (
		ftnlen)19);
    }

    gtsize_(hhs, &c__100, (ftnlen)16);
    guqaxv_(ht + ht_len, &c__3, "LOC", hhs, sig, &ieod, ht_len, (ftnlen)3, (
	    ftnlen)16);
    guqaxv_(ht + ht_len, &c__3, "WGT", hhs, dsig, &ieod, ht_len, (ftnlen)3, (
	    ftnlen)16);

    i__1 = *imax * *jmax;
    hydro_(&zgp[zgp_offset], &t[t_offset], &q[q_offset], &zs[zs_offset], sig, 
	    dsig, &i__1, kmax);

    return 0;
} /* calgph_ */

/* ********************************************************************* */
/* Subroutine */ int hydro_(real *z__, real *t, real *q, real *zs, real *sig, 
	real *dsig, integer *ijmax, integer *kmax)
{
    /* Initialized data */

    static real cp = 1004.6f;
    static real rair = 287.04f;
    static real grav = 9.8f;
    static real rvap = 461.f;

    /* System generated locals */
    integer z_dim1, z_offset, t_dim1, t_offset, q_dim1, q_offset, i__1, i__2;
    real r__1;
    doublereal d__1, d__2;

    /* Builtin functions */
    double pow_dd(doublereal *, doublereal *);

    /* Local variables */
    static real epsv;
    static integer k;
    static real sbeta[100], epsvt;
    static integer ij;
    static real akappa, salpha[100];
    extern /* Subroutine */ int msgdmp_(char *, char *, char *, ftnlen, 
	    ftnlen, ftnlen);





    /* Parameter adjustments */
    --zs;
    --dsig;
    --sig;
    q_dim1 = *ijmax;
    q_offset = 1 + q_dim1 * 1;
    q -= q_offset;
    t_dim1 = *ijmax;
    t_offset = 1 + t_dim1 * 1;
    t -= t_offset;
    z_dim1 = *ijmax;
    z_offset = 1 + z_dim1 * 1;
    z__ -= z_offset;

    /* Function Body */
    if (*kmax > 100) {
	msgdmp_("E", "HYDRO", "WORK AREA TOO SMALL", (ftnlen)1, (ftnlen)5, (
		ftnlen)19);
    }

    akappa = rair / cp;
    epsv = rair / rvap;
    epsvt = 1.f / epsv - 1.f;

    i__1 = *kmax;
    for (k = 1; k <= i__1; ++k) {
	d__1 = (doublereal) (dsig[k] / sig[k] / 2.f + 1.f);
	d__2 = (doublereal) akappa;
	salpha[k - 1] = pow_dd(&d__1, &d__2) - 1.f;
/* Computing MAX */
	r__1 = 1.f - dsig[k] / sig[k] / 2.f;
	d__1 = (doublereal) dmax(r__1,0.f);
	d__2 = (doublereal) akappa;
	sbeta[k - 1] = 1.f - pow_dd(&d__1, &d__2);
/* L100: */
    }

    i__1 = *ijmax;
    for (ij = 1; ij <= i__1; ++ij) {
	z__[ij + z_dim1] = zs[ij] + cp / grav * salpha[0] * t[ij + t_dim1] * (
		epsvt * q[ij + q_dim1] + 1.f);
/* L1100: */
    }

    i__1 = *kmax;
    for (k = 2; k <= i__1; ++k) {
	i__2 = *ijmax;
	for (ij = 1; ij <= i__2; ++ij) {
	    z__[ij + k * z_dim1] = z__[ij + (k - 1) * z_dim1] + cp / grav * 
		    salpha[k - 1] * t[ij + k * t_dim1] * (epsvt * q[ij + k * 
		    q_dim1] + 1.f) + cp / grav * sbeta[k - 2] * t[ij + (k - 1)
		     * t_dim1] * (epsvt * q[ij + (k - 1) * q_dim1] + 1.f);
/* L2310: */
	}
/* L2300: */
    }

    return 0;
} /* hydro_ */

/* Main program alias */ int gthydr_ () { MAIN__ (); return 0; }
