## set arrays ##

require "NMDArray"

nlon=36
nlat=19

lon=NMDArray.indgen(nlon)/(nlon) * (2*PI)
lat=NMDArray.indgen(nlat)/(nlat-1.0) * (PI) - PI/2

data =  lon.insert_dim([1,nlat]).sin  *  lat.insert_dim([0,nlon]).cos

# cyclic differentiation:
dx=lon.cyc_extend_coord(0,2*PI).dif(0).insert_dim([1,nlat])
xdiff =  data.cycdif(0)/dx

# centered differentiation:
dy=lat.cdif(0).insert_dim([0,nlon])
ydiff =  data.cdif(1)/dy

## graphic ##

#require "~/pub/gtrb.990629/dcl/dcl"   # doesn''t work (don''t know why)
#require "/home/horinout/pub/gtrb.990629/dcl/dcl"    # dcl library
require "dcl"    # dcl library

Dcl.gropn(1)
Dcl.grfrm()
Dcl.grswnd(lon.min, lon.max, lat.min, lat.max)
Dcl.grsvpt(0.2, 0.8, 0.2, 0.8)
Dcl.grstrn(1)
Dcl.grstrf()
Dcl.usdaxs()
Dcl.udcntr(data.to_a,nlon,nlon,nlat)
Dcl.grcls

Dcl.gropn(1)
Dcl.grfrm()
Dcl.grswnd(lon.min, lon.max, lat.min, lat.max)
Dcl.grsvpt(0.2, 0.8, 0.2, 0.8)
Dcl.grstrn(1)
Dcl.grstrf()
Dcl.usdaxs()
Dcl.udcntr(xdiff.to_a,nlon,nlon,nlat)
Dcl.grcls

Dcl.gropn(1)
Dcl.grfrm()
Dcl.grswnd(lon.min, lon.max, lat.min, lat.max)
Dcl.grsvpt(0.2, 0.8, 0.2, 0.8)
Dcl.grstrn(1)
Dcl.grstrf()
Dcl.usdaxs()
Dcl.udcntr(ydiff.to_a,nlon,nlon,nlat)
Dcl.grcls

### memo ###
## another way to define data:
# data =  lon.rebin(nlon,nlat).sin  *  lat.rebin(nlat,nlon).transpose.cos

