## set arrays ##

require "NMDArray"

nlon=36
nlat=19

lon=NMDArray.indgen(nlon)/(nlon) * (2*PI)
lat=NMDArray.indgen(nlat)/(nlat-1.0) * (PI) - PI/2

data =  lon.rebin(nlon,nlat).sin  *  lat.rebin(nlat,nlon).transpose.cos

# example of the cyclic difference
dx=lon.dif(0).cyc_extend(0).rebin(nlon,nlat)
xdiff =  data.cycdif(0)/dx

# example of the centered difference
dy=lat.cdif(0).rebin(nlat,nlon).transpose
ydiff =  data.cdif(1)/dy

## graphic ##

#require "~/pub/gtrb.990629/dcl/dcl"   # doesn''t work (don''t know why)
require "/home/muradar/horinout/pub/gtrb.990629/dcl/dcl"    # dcl library

Dcl.gropn(1)
Dcl.grfrm()
Dcl.grswnd(lon.min, lon.max, lat.min, lat.max)
Dcl.grsvpt(0.2, 0.8, 0.2, 0.8)
Dcl.grstrn(1)
Dcl.grstrf()
Dcl.usdaxs()
Dcl.udcntr(data.to_a,nlon,nlon,nlat)
Dcl.grcls

Dcl.gropn(1)
Dcl.grfrm()
Dcl.grswnd(lon.min, lon.max, lat.min, lat.max)
Dcl.grsvpt(0.2, 0.8, 0.2, 0.8)
Dcl.grstrn(1)
Dcl.grstrf()
Dcl.usdaxs()
Dcl.udcntr(xdiff.to_a,nlon,nlon,nlat)
Dcl.grcls

Dcl.gropn(1)
Dcl.grfrm()
Dcl.grswnd(lon.min, lon.max, lat.min, lat.max)
Dcl.grsvpt(0.2, 0.8, 0.2, 0.8)
Dcl.grstrn(1)
Dcl.grstrf()
Dcl.usdaxs()
Dcl.udcntr(ydiff.to_a,nlon,nlon,nlat)
Dcl.grcls
