require "VNMDArray"

class PMDArray < VNMDArray

# PMDArray -- Physial Multi-Dimensional Array
# 1999/09/22  T. Horinouchi
#
#
#  redifined
#
#    + - * /    if the rank of the two does not agree, try to expand one of
#               them to make them conform to each other
#
#  DISABLED:
#   rebin

  ## class methods ##

  def initialize(name,units,*nm_lens)
    # Usage example:
    #    PMDArray.new('temperature','K',{'lon',20},{'lat',10},{'time',30})

    @name=name.dup
    @units=units.dup

    nd=nm_lens.length
    @dimnames=[] ; lens=[]   ## initialization
    for i in 0..nd-1
      raise(RuntimeError,"Not a hash") if (!nm_lens[i].is_a?(Hash))
      kv=nm_lens[i].to_a
      @dimnames=@dimnames+kv[0][0]
      lens=lens+kv[0][1]
    end
    super(*lens)
  end

  def PMDArray.indgen(*args)
    out=self.new(*args)
    out.instance_eval{@dat =  NArray.indgen(self.length,0.0)}
    return out
  end

  ## disabled ##

  undef rebin

  ## redefined methods ##

  def dclone
    out=super
    copy_list=['@dimnames']
    copy_list.each{ |v|
      out.instance_eval("#{v} = #{v}.clone")
    }
    return out
  end

  def trim!
    while ( (id=@lens.index(1)) != nil )
      @lens.delete_at(id)
      @dimnames.delete_at(id)
    end
    @nd=@lens.length
  end

  def insert_dim(*dim_name_lens)
    dim_name_lens=dim_name_lens.sort  # sort by the first elements of subarrays
    narg=dim_name_lens.length
    dim_lens=[] ; names=[]
    for i in 0..narg-1
      if ! (nmlen=dim_name_lens[i][1]).is_a?(Hash) then
	raise(RuntimeError,"the 2nd element of each argument mus be a Hash")
      end
      nmlen=nmlen.to_a[0]              # {name,len} -> [name,len]
      dim_lens=dim_lens+[ [dim_name_lens[i][0],nmlen[1]] ]
      names=names+[nmlen[0]]
    end


    nd=@nd
    dimnames_=@dimnames.dup

    out=super(*dim_lens)

    for i in 0..narg-1
      dim=dim_lens[i][0]
      if(dim==0)
	dimnames_=[names[i]]+dimnames_
      elsif(dim==nd)
	dimnames_=dimnames_+[names[i]]
      else
	dimnames_=dimnames_[0..dim-1]+[names[i]]+dimnames_[dim..nd-1]
      end
    end

    out.instance_eval{@dimnames = dimnames_}
    return out
  end

  def +(a)
    if a.is_a?(PMDArray)
      case (self.ndims <=> a.ndims)
      when 0;       super(a)
      when 1;       super(a.expand_to_conform(self))
      when -1;      self.expand_to_conform(a).super(a)
      end
    else
      super(a)
    end
  end
  def -(a)
    if a.is_a?(PMDArray)
      case (self.ndims <=> a.ndims)
      when 0;       super(a)
      when 1;       super(a.expand_to_conform(self))
      when -1;      self.expand_to_conform(a).super(a)
      end
    else
      super(a)
    end
  end
  def *(a)
    if a.is_a?(PMDArray)
      case (self.ndims <=> a.ndims)
      when 0;       super(a)
      when 1;       super(a.expand_to_conform(self))
      when -1;      self.expand_to_conform(a).super(a)
      end
    else
      super(a)
    end
  end
  def /(a)
    if a.is_a?(PMDArray)
      case (self.ndims <=> a.ndims)
      when 0;       super(a)
      when 1;       super(a.expand_to_conform(self))
      when -1;      self.expand_to_conform(a).super(a)
      end
    else
      super(a)
    end
  end


  ## new methods ##

  def dimnames; @dimnames; end

  def name=(nm);  @name=nm; end
  def name; @name if defined?(@name); end

  def units=(un);  @units=un; end
  def units; @units if defined?(@units); end

  def att=(key,val)
    # set an attribute whose name is KEY and value is VAL
    # usage example: Object.att='memo','averaged'
    #                Object.att=('memo','averaged')
    if !defined?(@ath) then
      @ath={key=>val}
    else
      @ath=@ath.update({key=>val})
    end
  end

  def att(key)
    # return an attribute value associated with KEY
    if !defined?(@ath) then
      nil
    else
      @ath.fetch(key)
    end
  end

  ######### PRIVATE & PROTECTED METHODS ########

  protected

  def init_another(dimmap=nil, lens=nil)
    # initialize another object (with the same shape by default, or the shape 
    # specified by dimmap or by dimmap and lens). 
    # Note that lens is an Array (not init_another(*lens))
    out=super(dimmap, lens)
    out.instance_eval{@name = @name.dup}
    out.instance_eval{@units = @units.dup}
    if (dimmap != nil) then
      dimnames=@dimnames.indices(*dimmap)
    else
      dimnames=@dimnames
    end
    out.instance_eval{@dimnames = dimnames}
    return out
  end

  def expand_to_conform(ar)
    if (@nd >= ar.ndims)
      raise(RuntimeError,"no need to (or cannot) expand to conform") 
    end

    alens=ar.shape

    ## dimension length mapping ##

    #(forward mapping)
    pos=-1 ; map=[]                  # initialization
    for i in 0..@lens.length-1
      l=@lens[i]
      idx=alens[(pos+1)..-1].index(l)
      if ( idx == nil); raise(RuntimeError,"dimension matching failed"); end
      pos=idx+pos+1
      map=map+[pos]
    end

    #(backward mapping for comparison)
    pos=0 ; rmap=[]                  # initialization
    for i in (0..@lens.length-1).to_a.reverse
      l=@lens[i]
      idx=alens[0..(pos-1)].rindex(l)
      if ( idx == nil); raise(RuntimeError,"dimension matching failed"); end
      pos=idx-alens.length
      rmap=[pos+alens.length]+rmap
    end

    admns=ar.dimnames

    if (map != rmap)
      #(mapping ambiguous  -- judge by the dimnames)
      pos=-1 ; map=[]                  # initialization
      for i in 0..@dimnames.length-1
        l=@dimnames[i]
        idx=admns[(pos+1)..-1].index(l)
        if ( idx == nil); raise(RuntimeError,"dimension matching failed"); end
        pos=idx+pos+1
        map=map+[pos]
      end
      if (@lens != alens.indices(*map)) then
	raise(RuntimeError,"mapping failed")
      end
    end

    ## fill the missing dimensions ##

    miss_dims = (0..alens.length-1).to_a - map
    dim_name_lens=[]
    for i in miss_dims
      dim_name_lens=dim_name_lens+[ [i,{admns[i],alens[i]}] ]
    end

    return self.insert_dim(*dim_name_lens)

  end

end

####### test for development ########

if __FILE__ == $0
  #a=PMDArray.new('T','K',{'lon',3},{'lat',2},{'time',3})
  #a.import1d(NArray.indgen(18))
  #p a.name
  #p a.units
  #p a.dimnames
  #p a.to_a
  #p (a+a)

  lon=PMDArray.new('lon','degrees_east',{'lon',3})
  lon.import1d(NArray.indgen(3))
  p lon
  lonex=lon.insert_dim([1,{'lat',4}],[2,{'time',2}])
  lonex.prt
  a=lonex+lonex
  p a.type
  p a
end
