
require "SData"

## set up data values ##

nlon=36
nlat=19

londim={'lon',nlon}
latdim={'lat',nlat}

lon=PMDArray.indgen("lon","rad",londim)/(nlon) * (2*PI)
lat=PMDArray.indgen("lat","rad",latdim)/(nlat-1.0) * (PI) - PI/2

u_val = - lon.cos.insert_dim([1,latdim]) * lat.sin * 50
                                    # u_val = -50*cos(lon)*sin(lat)
v_val =   lon.sin.insert_dim([1,latdim]) * lat.cos * 50
                                    # v_val = 50*sin(lon)*cos(lat)

u_val.name='U wind' ;  u_val.units='m/s'
v_val.name='V wind' ;  v_val.units='m/s'

## define self-descriptive data ##

uwnd = SData.new(u_val,lon,lat)
vwnd = SData.new(v_val,lon,lat)

uwnd.cont
vwnd.cont

## vorticity, absolute vorticity ##

vor = (vwnd.cderiv(0) - uwnd.cderiv(1)) / 6.37E6

f = lat.sin * (4*PI/86400) 
absvor = vor + f

vor.name='relative vorticity' ; vor.units='1/s'
absvor.name='absolute vorticity' ; absvor.units='1/s'

vor.cont
absvor.cont

