#!/usr/local/bin/ruby 

require 'mcarray'

cycle = 5

print "Using ordinary array\n"
a = Array.new(100);
for i in 0..99
  a[i] = Array.new(100);
  for j in 0..99
    a[i][j] = i*j
  end
end

print "start\n"
t = Time.times.utime
for z in 1..cycle
  a.each_index do |i|
    a[i].each_index do |j|
      a[i][j] = a[i][j]+1
    end
  end
end

print "time: ",Time.times.utime - t,"\n"


print "using IntArray\n"

a = IntArray.new(100,100)

for i in 0..99
  for j in 0..99
    a[i,j] = i*j
  end
end

print "start\n"
t = Time.times.utime
for z in 1..cycle
  a.each_index do |i,j|
  a[i,j] = a[i,j]+1
#  print i,",",j,",",a[i,j],"\n"
  end
end

print "time: ",Time.times.utime - t,"\n"

print "using FloatArray\n"

a = FloatArray.new(100,100)

for i in 0..99
  for j in 0..99
    a[i,j] = i*j
  end
end

print "start\n"
t = Time.times.utime
for z in 1..cycle
  a.each_index do |i,j|
  a[i,j] = a[i,j]+1
#  print i,",",j,",",a[i,j],"\n"
  end
end

print "time: ",Time.times.utime - t,"\n"

print "using DoubleArray\n"

a = DoubleArray.new(100,100)

for i in 0..99
  for j in 0..99
    a[i,j] = i*j
  end
end

print "start\n"
t = Time.times.utime
for z in 1..cycle
  a.each_index do |i,j|
  a[i,j] = a[i,j]+1
#  print i,",",j,",",a[i,j],"\n"
  end
end

print "time: ",Time.times.utime - t,"\n"

print "Using one-dimensional Array\n"
a = Array.new(90000);
for i in 0..99
  for j in 0..99
    a[i*100+j] = i*j
  end
end

print "start\n"
t = Time.times.utime
for z in 1..cycle
  for i in 0..99
    for j in 0..99
      a[i*100+j] = a[i*100+j]+1
    end
  end
end

print "time: ",Time.times.utime - t,"\n"

print "Using hash\n"
a = Hash.new;
for i in 0..99
  for j in 0..99
    a[i.to_s+","+j.to_s] = i*j
  end
end

print "start\n"
t = Time.times.utime
for z in 1..cycle
  for i in 0..99
    for j in 0..99
      idx = i.to_s+","+j.to_s
      a[idx] = a[idx]+1
    end
  end
end

print "time: ",Time.times.utime - t,"\n"

