integer function ANVarNDimsAll(var) result(result)
    use an_types, only: AN_VARIABLE
    type(AN_VARIABLE), intent(in):: var
    print *, "ANVarNDimsAll fake"
    result = 1
end function

integer function ANVarDimSize(var, name) result(result)
    use an_types, only: AN_VARIABLE
    use iso_varying_string, only: VARYING_STRING    
    type(AN_VARIABLE), intent(in):: var
    type(VARYING_STRING), intent(in):: name
    result = 1
end function

subroutine ANVarSlice(var, dimord, start, count, stride)
    use an_types, only: AN_VARIABLE
    type(AN_VARIABLE), intent(in):: var
    integer, intent(in):: dimord
    integer, intent(in), optional:: start
    integer, intent(in), optional:: count
    integer, intent(in), optional:: stride
end subroutine

subroutine ANVarGetSlice(var, dimord, start, count, stride)
    use an_types, only: AN_VARIABLE
    use dc_error
    use netcdf_f77
    implicit none
    type(AN_VARIABLE), intent(in):: var
    integer, intent(in):: dimord
    integer, intent(out), optional:: start
    integer, intent(out), optional:: count
    integer, intent(out), optional:: stride
    integer:: stat
    stat = 0
    if (.not. associated(var%count)) then
        stat = NF_ENOTVAR
        goto 999
    endif
    if (dimord < 0 .or. dimord > size(var%count)) then
        stat = NF_EINVALCOORDS
        goto 999
    endif
    if (present(start)) start = var%start(dimord)
    if (present(count)) count = var%count(dimord)
    if (present(stride)) stride = var%stride(dimord)
999 continue
    call StoreError(stat, "ANVarGetSlice")
end subroutine

subroutine ANVarSliceNext(var, dimord)
    use an_types, only: AN_VARIABLE
    type(AN_VARIABLE), intent(in):: var
    integer, intent(in), optional:: dimord
end subroutine
