! gtcontdefault.f90 - Definitions of Gtool Contours subroutines

function GTContDefault(var) result(result)
    use gtgraph_types, only: GT_CONTOURS
    use gtgraph_generic, only: Axis
    use gtdata_types, only: GT_VARIABLE
    type(GT_CONTOURS):: result
    type(GT_VARIABLE), intent(in):: var
    result%var = var
    result%interval = 0.0  ! missing
    allocate(result%h_axis, result%v_axis)
    result%h_axis = Axis(var, 1)
    result%v_axis = Axis(var, 2)
end function

subroutine GTFigPutCont(fig, cont)
    use gtgraph_types, only: GT_FIGURE, GT_CONTOURS
    use gtdata_generic, only: get_attr, name
    use iso_varying_string
    use dc_error
    use dc_string, only: GTStringQuoteForDcl
    use netcdf_f77, only: NF_ENOMEM
    type(GT_FIGURE), intent(inout):: fig
    type(GT_CONTOURS), intent(in):: cont
    type(GT_CONTOURS), pointer:: newconts(:)
    type(VARYING_STRING):: title, units
    integer:: nconts, stat
    stat = GT_EFAKE
    if (associated(fig%h_axis) .or. associated(fig%v_axis)) goto 999
    fig%h_axis => cont%h_axis
    fig%v_axis => cont%v_axis
    !
    call get_attr(cont%var, 'long_name', title)
    if (title == '') title = Name(cont%var)
    call get_attr(cont%var, 'units', units, default='no units')
    title = title // ' [' // units // ']'
    if (fig%title == "untitled") then
        fig%title = title
    else
        fig%title = fig%title // ", " // title
    endif
    !
    stat = 0
    if (associated(fig%contours)) then
        nconts = size(fig%contours)
        allocate(newconts(nconts + 1), stat=stat)
        newconts(1: nconts) = fig%contours(1: nconts)
        deallocate(fig%contours)
    else
        nconts = 0
        allocate(newconts(1), stat=stat)
    endif
    if (stat /= 0) stat = NF_ENOMEM
    newconts(nconts + 1) = cont
    fig%contours => newconts
999 continue
    call StoreError(stat, 'GTFigPutCont')
end subroutine

subroutine GTContDraw(cont, parent)
    use gtgraph_types, only: GT_CONTOURS, GT_FIGURE
    use gtdata_generic, only: Get
    use dcl
    type(GT_CONTOURS), intent(inout):: cont
    type(GT_FIGURE), intent(in):: parent
    real, pointer:: buffer(:, :)
    real:: hi, lo, prec
    character(len = 10):: fmt
    ! f[^̎擾ƕ`
    call Get(cont%var, buffer)
    call DclSetShadeLevel(buffer, 0.0)
    call DclShadeContour(buffer)
    hi = maxval(buffer)
    lo = minval(buffer)
    prec = abs(hi - lo)
    hi = max(abs(hi), abs(lo), epsilon(lo))
    prec = prec / hi
    if (prec < 0.1) then
        fmt = "(g10.4)"
    else if (prec < 0.01) then
        fmt = "(g11.5)"
    else if (prec < 0.001) then
        fmt = "(g12.6)"
    else
        fmt = "D"
    endif
    call DclSetContourLabelFormat(fmt) 
    call DclDrawContour(buffer)
    call DclSetContourLabelFormat("D")
    deallocate(buffer)
end subroutine