! Copyright (C) TOYODA Eizi, 2000.  All rights reserved.

subroutine ANVarPutAttrChar(var, name, value, err)
    use an_types, only: AN_VARIABLE
    use an_file, only: ANFileDefineMode
    use netcdf_f77, only: NF_PUT_ATT_TEXT, NF_NOERR, NF_DEL_ATT, &
        NF_ENOTINDEFINE
    use dc_error
    implicit none
    type(AN_VARIABLE), intent(in):: var
    character(len = *), intent(in):: name
    character(len = *), intent(in):: value
    logical, intent(out), optional:: err
    integer:: stat
continue
    if (len(value) == 0) then
        stat = nf_del_att(var%fileid, var%varid, name=name)
        goto 999
    endif
    stat = nf_put_att_text(var%fileid, var%varid, name=name, &
        len=len(value), text=value)
    if (stat == NF_NOERR) goto 999
    if (stat /= NF_ENOTINDEFINE) goto 999
    stat = ANFileDefineMode(var%fileid)
    if (stat /= NF_NOERR) goto 999
    stat = nf_put_att_text(var%fileid, var%varid, name=name, &
        len=len(value), text=value)
    999 continue
    call StoreError(stat, 'ANVarPutAttrChar', err)
end subroutine
