! gtgraph_generic.f90 - 
! Copyright (C) TOYODA Eizi, 2000.  All rights reserved.

module gtgraph_generic

    use gtgraph_types, only: GT_AXIS

    interface Axis
        type(GT_AXIS) function GTAxisDefault(var, dimno, vertical)
            use gtgraph_types, only: GT_AXIS
            use gtdata_types, only: GT_VARIABLE
            type(GT_VARIABLE), intent(in):: var
            integer, intent(in):: dimno
            logical, intent(in), optional:: vertical
        end function
    end interface

    interface Contours
        type(GT_CONTOURS) function GTContDefault(var)
            use gtgraph_types, only: GT_CONTOURS
            use gtdata_types, only: GT_VARIABLE
            type(GT_VARIABLE), intent(in):: var
        end function
    end interface

    interface Line
        type(GT_LINE) function GTLineDefault(var)
            use gtgraph_types, only: GT_LINE
            use gtdata_types, only: GT_VARIABLE
            type(GT_VARIABLE), intent(in):: var
        end function
    end interface

    interface Clear
        subroutine GTObjectClear(obj)
            use gtgraph_types, only: GT_OBJECT
            type(GT_OBJECT), intent(out):: obj
        end subroutine
    end interface

    interface Open

        subroutine GTDevOpen(dev, ws_id, err)
            use gtgraph_types, only: GT_DEVICE
            type(GT_DEVICE), intent(out):: dev
            integer, intent(in), optional:: ws_id
            logical, intent(out), optional:: err
        end subroutine

        subroutine GTFrameOpen(frame)
            use gtgraph_types, only: GT_FRAME
            type(GT_FRAME), intent(out):: frame
        end subroutine

        subroutine GTFigOpen(fig)
            use gtgraph_types, only: GT_FIGURE
            type(GT_FIGURE), intent(out):: fig
        end subroutine

        subroutine GTObjectOpen(obj, varname)
            use iso_varying_string, only: VARYING_STRING
            use gtgraph_types, only: GT_OBJECT
            type(GT_OBJECT), intent(out):: obj
            type(VARYING_STRING), intent(in):: varname
        end subroutine

    end interface

    interface Close

        subroutine GTDevClose(dev)
            use gtgraph_types, only: GT_DEVICE
            type(GT_DEVICE), intent(inout):: dev
        end subroutine

        subroutine GTFrameClose(frame)
            use gtgraph_types, only: GT_FRAME
            type(GT_FRAME), intent(inout):: frame
        end subroutine

        subroutine GTFigClose(fig)
            use gtgraph_types, only: GT_FIGURE
            type(GT_FIGURE), intent(inout):: fig
        end subroutine

        subroutine GTAxisClose(axis)
            use gtgraph_types, only: GT_AXIS
            type(GT_AXIS), intent(inout):: axis
        end subroutine

    end interface

    interface Option

        subroutine GtObjectOption(obj, option, value, err)
            use gtgraph_types, only: GT_OBJECT
            type(GT_OBJECT), intent(in):: obj
            character(len = *), intent(in):: option
            character(len = *), intent(in):: value
            logical, intent(out):: err
        end subroutine

        subroutine GtFigOption(fig, optname, value, err)
            use gtgraph_types, only: GT_FIGURE
            type(GT_FIGURE), intent(inout):: fig
            character(len = *), intent(in):: optname
            character(len = *), intent(in):: value
            logical, intent(out):: err
        end subroutine

        subroutine GtContOption(cont, optname, value, err)
            use gtgraph_types, only: GT_CONTOURS
            type(GT_CONTOURS), intent(inout):: cont
            character(len = *), intent(in):: optname
            character(len = *), intent(in):: value
            logical, intent(out):: err
        end subroutine

        subroutine GtLineOption(line, optname, value, err)
            use gtgraph_types, only: GT_LINE
            type(GT_LINE), intent(inout):: line
            character(len = *), intent(in):: optname
            character(len = *), intent(in):: value
            logical, intent(out):: err
        end subroutine

    end interface

    interface Put

        subroutine GTObjPutObj(tray, dish)
            use gtgraph_types, only: GT_OBJECT
            type(GT_OBJECT), intent(inout):: tray
            type(GT_OBJECT), intent(in):: dish
        end subroutine

        subroutine GTFigPutObject(fig, obj)
            use gtgraph_types, only: GT_OBJECT, GT_FIGURE
            type(GT_FIGURE), intent(inout):: fig
            type(GT_OBJECT), intent(in):: obj
        end subroutine

        subroutine GTFigPutAxis(fig, axis, vertical)
            use gtgraph_types, only: GT_FIGURE, GT_AXIS
            type(GT_FIGURE), intent(inout):: fig
            type(GT_AXIS), pointer:: axis
            logical, intent(in), optional:: vertical
        end subroutine

        subroutine GTFigPutCont(fig, cont)
            use gtgraph_types, only: GT_FIGURE, GT_CONTOURS
            type(GT_FIGURE), intent(inout):: fig
            type(GT_CONTOURS), intent(in):: cont
        end subroutine

        subroutine GTFigPutLine(fig, line)
            use gtgraph_types, only: GT_FIGURE, GT_LINE
            type(GT_FIGURE), intent(inout):: fig
            type(GT_LINE), intent(in):: line
        end subroutine

        subroutine GTFramePutFig(frame, fig)
            use gtgraph_types, only: GT_FRAME, GT_FIGURE
            type(GT_FRAME), intent(out):: frame
            type(GT_FIGURE), intent(in):: fig
        end subroutine

    end interface

    !
    ! ʂ̃[U Display() ĂяoB
    ! I Draw Tu[`QĂяoĂB
    ! 
    interface Display
 
        subroutine GTFrameDisplay(dev, frame)
            use gtgraph_types, only: GT_DEVICE, GT_FRAME
            type(GT_DEVICE), intent(inout):: dev
            type(GT_FRAME), intent(inout):: frame
        end subroutine

        subroutine GTFigDisplay(dev, fig)
            use gtgraph_types, only: GT_DEVICE, GT_FIGURE
            type(GT_DEVICE), intent(inout):: dev
            type(GT_FIGURE), intent(inout):: fig
        end subroutine

    end interface

    !
    ! Draw(..., paent) ͓I Display(dev, ...) 
    ! p邽߂ɂBparent ͒ʏ햳p[U
    ! ~X^CvŌĂяoȂ߂ Put Ƌtʒu
    ! tĂB
    !
    interface Draw

        subroutine GTAxesDraw(h_axis, v_axis, parent, set_space)
            use gtgraph_types, only: GT_AXIS, GT_FIGURE
            type(GT_AXIS), intent(inout):: h_axis, v_axis
            type(GT_FIGURE), intent(in):: parent
            logical, intent(in), optional:: set_space
        end subroutine

        subroutine GTContDraw(cont, parent)
            use gtgraph_types, only: GT_CONTOURS, GT_FIGURE
            type(GT_CONTOURS), intent(inout):: cont
            type(GT_FIGURE), intent(in):: parent
        end subroutine

        subroutine GTLineDraw(line, parent)
            use gtgraph_types, only: GT_LINE, GT_FIGURE
            type(GT_LINE), intent(inout):: line
            type(GT_FIGURE), intent(in):: parent
        end subroutine

        subroutine GTFigDraw(fig, parent)
            use gtgraph_types, only: GT_FRAME, GT_FIGURE
            type(GT_FIGURE), intent(inout):: fig
            type(GT_FRAME), intent(in):: parent
        end subroutine

    end interface

    ! --- Save ---
    !
    ! Save ͐}`ϐi[Bvarname ȗ
    ! ϐ͎B

    interface Save

        subroutine GTFrameSave(frame, varname, resultname)
            use gtgraph_types, only: GT_FRAME
            use iso_varying_string, only: VARYING_STRING
            type(GT_FRAME), intent(in):: frame
            type(VARYING_STRING), intent(in), optional:: varname
            type(VARYING_STRING), intent(out), optional:: resultname
        end subroutine

        subroutine GTFigSave(fig, varname, resultname)
            use gtgraph_types, only: GT_FIGURE
            use iso_varying_string, only: VARYING_STRING
            type(GT_FIGURE), intent(in):: fig
            type(VARYING_STRING), intent(in), optional:: varname
            type(VARYING_STRING), intent(out), optional:: resultname
        end subroutine

        subroutine GTLineSave(line, varname, resultname)
            use gtgraph_types, only: GT_LINE
            use iso_varying_string, only: VARYING_STRING
            type(GT_LINE), intent(in):: line
            type(VARYING_STRING), intent(in), optional:: varname
            type(VARYING_STRING), intent(out), optional:: resultname
        end subroutine

        subroutine GTContSave(cont, varname, resultname)
            use gtgraph_types, only: GT_CONTOURS
            use iso_varying_string, only: VARYING_STRING
            type(GT_CONTOURS), intent(in):: cont
            type(VARYING_STRING), intent(in), optional:: varname
            type(VARYING_STRING), intent(out), optional:: resultname
        end subroutine

        subroutine GTAxisSave(axis, varname, resultname)
            use gtgraph_types, only: GT_AXIS
            use iso_varying_string, only: VARYING_STRING
            type(GT_AXIS), intent(in):: axis
            type(VARYING_STRING), intent(in), optional:: varname
            type(VARYING_STRING), intent(out), optional:: resultname
        end subroutine

    end interface

    ! Save gO

    interface
        type(VARYING_STRING) function GTGraphSaveName()
            use iso_varying_string, only: VARYING_STRING
        end function
    end interface

end module
