! Copyright (C) TOYODA Eizi, 2000.  All rights reserved.

subroutine GTVarPutAttrChar(var, name, value, err)
    use gtdata_types, only: GT_VARIABLE
    use an_generic, only: put_attr
    implicit none
    type(GT_VARIABLE), intent(in):: var
    character(len = *), intent(in):: name
    character(len = *), intent(in):: value
    logical, intent(out), optional:: err
    if (associated(var%an)) then
        call put_attr(var%an, name, value, err)
    endif
end subroutine

subroutine GTVarPutAttrString(var, name, value, err)
    use gtdata_types, only: GT_VARIABLE
    use iso_varying_string, only: VARYING_STRING, char
    use gtdata_generic, only: put_attr
    implicit none
    type(GT_VARIABLE), intent(in):: var
    character(len = *), intent(in):: name
    type(VARYING_STRING), intent(in):: value
    logical, intent(out), optional:: err
    call put_attr(var, name, char(value), err)
end subroutine
