! gtframe.f90 - GT_FRAME handlers
! Copyright (C) TOYODA Eizi, 2000.  All rights reserved.

subroutine GTFrameOpen(frame)
    use gtgraph_types, only: GT_FRAME
    use iso_varying_string
    implicit none
    type(GT_FRAME), intent(out):: frame
    nullify(frame%figs)
    frame%title = "untitled frame"
end subroutine

subroutine GTFrameClose(frame)
    use gtgraph_types, only: GT_FRAME
    use gtgraph_generic, only: Close
    use iso_varying_string
    implicit none
    type(GT_FRAME), intent(inout):: frame
    integer:: i
    if (associated(frame%figs)) then
        do, i = 1, size(frame%figs)
            call Close(frame%figs(i))
        enddo
        deallocate(frame%figs)
    endif
    frame%title = ""
end subroutine

subroutine GTFrameBindFig(frame, fig)
    use gtgraph_types, only: GT_FRAME, GT_FIGURE
    use iso_varying_string
    implicit none
    type(GT_FRAME), intent(out):: frame
    type(GT_FIGURE), intent(in):: fig
    type(GT_FIGURE), pointer:: newfigbuf(:)
    integer:: newsize
continue
    if (.not. associated(frame%figs)) then
        allocate(frame%figs(1))
        frame%figs(1) = fig
        frame%title = fig%title
    else
        newsize = size(frame%figs) + 1
        allocate(newfigbuf(newsize))
        newfigbuf(1: newsize - 1) = frame%figs(1: newsize - 1)
        deallocate(frame%figs)
        frame%figs => newfigbuf
        frame%figs(newsize) = fig
        ! ƍHv
        frame%title = frame%title // '/' // fig%title
    endif
end subroutine

subroutine GTFrameDisplay(dev, frame)
    use gtgraph_types, only: GT_DEVICE, GT_FRAME
    use gtgraph_generic, only: Draw, Option
    use iso_varying_string
    use dc_string, only: GTStringQuoteForDcl
    use dcl
    implicit none
    type(GT_DEVICE), intent(inout):: dev
    type(GT_FRAME), intent(inout):: frame
    character(len = 30):: title
    integer:: i
    logical:: err, all_reached_eof
continue
    if (dev%ws_id == 0) return
    !
    ! EBhEςɕ\邽߂̎w 
    !
    call DclSetParm('GRAPH:lfull', .TRUE.)
    call DclSetFrameMargin(left=0.0, right=0.0, bottom=0.05, top=0.08)
    call DclSetAspectRatio(x=1.0, y=0.6)
    title = GTStringQuoteForDcl(frame%title)
    call DclSetFrameTitle(title=trim(title), side='t', &
        x_position=0.0, y_position=0.0, height=0.03, num=1)
    call DclSetFrameTitle(title='gtool4/Fortran90 gtcont', side='b', &
        x_position=-1.0, y_position=-1.0, height=0.01, num=2)
    call DclSetFrameTitle(title='date:#date page:#page', side='b', &
        x_position=+1.0, y_position=-1.0, height=0.01, num=3)
    do
        call DclNewFrame
        frame%first_figure = .TRUE.
        do, i = 1, size(frame%figs)
            call Draw(frame%figs(i), parent=frame)
            frame%first_figure = .FALSE.
        enddo
        all_reached_eof = .TRUE.
        do, i = 1, size(frame%figs)
            call Option(frame%figs(i), "-next", "", err)
            if (.not. err) all_reached_eof = .FALSE.
        enddo
        if (all_reached_eof) exit
        enddo
end subroutine
