! GTDataTmpNam - ϐ̎쐬
! Copyright (C) GFD Dennou Club, 2000.  All rights reserved.

type(VARYING_STRING) function GTDataTmpNam(file, base) result(result)
    use iso_varying_string
    use gtdata_generic, only: Open, Close
    use gtdata_types, only: GT_VARIABLE
    use dc_url, only: UrlMerge
    use dc_string, only: toString
    implicit none
    type(VARYING_STRING), intent(in), optional:: file, base
    type(VARYING_STRING):: fnam, vnam, vnambase
    type(GT_VARIABLE):: var
    logical:: failed
    integer, save:: n = 0
continue
    if (present(file)) then
        fnam = file
    else
        fnam = "gtool.nc"
    endif
    if (present(base)) then
        vnambase = base
    else
        vnambase = "tmp"
    endif
    do
        n = n + 1
        vnam = vnambase // toString(n)
        result = UrlMerge(file=fnam, var=vnam)
        call Open(var, result, writable=.FALSE., err=failed)
        if (failed) return
        call Close(var)
    enddo
end function
