program test
  use Statistics
  use max_min
  use dcl
  implicit none
  real, allocatable, dimension(:) :: x, y, xa, ya
  integer :: nx, er, i
  real :: a, cc, slope, intercept
  real :: xmax, xmin, ymax, ymin, xmean, ymean
  integer :: xmim, ymim, xmam, ymam
  character(1) :: alter
  character(8) :: ccn

  nx=0
  open(unit=10,file='data.org',status='old',iostat=er)
  do
     read(10,*,iostat=er) a, a
     if(er/=0)then
        exit
     end if
     nx=nx+1
  end do
  close(unit=10,status='keep')

  allocate(x(nx))
  allocate(y(nx))
  allocate(xa(nx))
  allocate(ya(nx))

  open(unit=11,file='data.org',status='old',iostat=er)
  do i=1,nx
     read(11,*) x(i), y(i)
  end do
  close(unit=11,status='keep')

  call Cor_Coe( x, y, cc )
  call Reg_Line( x, y, slope, intercept )
  call Mean_1d( x, xmean )
  call Mean_1d( y, xmean )
!  call Anomaly_1d( nx, x, xa )
!  call Anomaly_1d( nx, y, ya )

  do i=1,nx
     xa(i)=x(i)/xmean
     ya(i)=y(i)/ymean
  end do

  call max_val_1d(xa, xmam, xmax )
  call max_val_1d(ya, ymam, ymax )
  call min_val_1d(xa, xmim, xmin )
  call min_val_1d(ya, ymim, ymin )

  write(*,*) '************************************'
  write(*,*) 'slope =', slope
  write(*,*) 'intercept =', intercept
  write(*,*) 'Cor_Coe =', cc
  write(*,*) 'data number =', nx
  write(*,*) '************************************'

  write(ccn,'(f8.6)') cc

  call DclOpenGraphics()          ! ֤Υץ
  call DclNewFrame                ! ΰ
  call DclScalingPoint( xa, ya )
  call DclFitscalingParm
!  call DclDrawTitle( 'b', 'Cor_Coe ='//ccn )
  call DclSetTransFunction
  call DclDrawScaledAxis
  call DclDrawMarker( xa, ya, type=3 ) ! ޤǥդ
  call DclDrawLine( (/0.0, xmax/), (/intercept, (slope*xmax+intercept)/), index=2 )
  call DclDrawLine( (/xmin, 0.0/), (/(slope*xmin+intercept), intercept/), index=2 )
  call DclCloseGraphics           ! ֤Υ

  deallocate(x)
  deallocate(y)
  deallocate(xa)
  deallocate(ya)

end program
