module Alge_Solv   ! 黻Ѥʬ򤯥⥸塼

  public :: Poisson_GauSei
  public :: Poisson_Jacobi
  private :: free
  private :: fix
  private :: period

contains
subroutine Poisson_GauSei(nx, ny, dx, dy, rho, eps, boundary, psi, bound_opt)
!-- =ǥˡˤݥε ---
  implicit none
  integer, intent(in) :: nx  ! x 
  integer, intent(in) :: ny  ! y 
  real, intent(in) :: dx  ! x γʻҴֳ
  real, intent(in) :: dy  ! y γʻҴֳ
  real, intent(in) :: rho(nx,ny)  ! ݥζ
  real, intent(in) :: eps  ! «
  integer, intent(in) :: boundary  ! 
  real, intent(in), optional :: bound_opt(nx,ny)  ! üξζ
  real, intent(inout) :: psi(nx,ny)  ! ݥβ
  integer :: i, j, k, l, m, n
  real :: tmp, err, err_max
  ! boundary  1 : ü, 2 : ͳü, 3 : 
  ! rho =0 ǥץ饹Ѳǽ

  psi = 0.0

  select case (boundary)

  case(1)
     call fix(nx,ny,dx,dy,eps,rho,psi,bound_opt)

  case(2)
     call free(nx,ny,dx,dy,eps,rho,psi)

  case(3)
     call period(nx,ny,dx,dy,eps,rho,psi)

  end select

contains

subroutine fix(nx,ny,dx,dy,eps,rho,psi,bound_opt)
  implicit none
  integer, intent(in) :: nx  ! x 
  integer, intent(in) :: ny  ! y 
  real, intent(in) :: dx  ! x γʻҴֳ
  real, intent(in) :: dy  ! y γʻҴֳ
  real, intent(in) :: rho(nx,ny)  ! ݥζ
  real, intent(in) :: eps  ! «
  real, intent(in) :: bound_opt(nx,ny)  ! üξζ
  real, intent(inout) :: psi(nx,ny)  ! ݥβ
  integer :: i, j, k, l, m, n
  real :: delta, err_max, err

  delta=dx/dy
!-- ü ---
  psi(1,:)=bound_opt(1,:)
  psi(nx,:)=bound_opt(nx,:)
  psi(:,1)=bound_opt(:,1)
  psi(:,nx)=bound_opt(:,nx)

  err_max=eps  ! while 뤿صŪ

!-- ºݤΥ ---
  do while(err_max>=eps)
     err_max=0.0
  do j=2,ny-1
     do i=2,nx-1
        tmp=(0.5/(1.0+delta**2))*(-dx**2*rho(i,j)  &
  &              +(psi(i+1,j)+psi(i-1,j)+delta**2*(psi(i,j+1)+psi(i,j-1))))

!-- η׻ ---
        if(psi(i,j)==0.0)then
           err=abs(tmp-psi(i,j))/abs(tmp)
        else
           err=abs(tmp-psi(i,j))/abs(psi(i,j))
        end if

!-- ι
        if(err_max<=err)then
           err_max=err
        end if

        psi(i,j)=tmp

     end do
  end do
  end do

  

end subroutine fix

subroutine free(nx,ny,dx,dy,eps,rho,psi)
  implicit none
  integer, intent(in) :: nx  ! x 
  integer, intent(in) :: ny  ! y 
  real, intent(in) :: dx  ! x γʻҴֳ
  real, intent(in) :: dy  ! y γʻҴֳ
  real, intent(in) :: rho(nx,ny)  ! ݥζ
  real, intent(in) :: eps  ! «
  real, intent(inout) :: psi(nx,ny)  ! ݥβ
  integer :: i, j, k, l, m, n
  real :: delta, err_max, err

  delta=dx/dy

  err_max=eps  ! while 뤿صŪ

!-- ºݤΥ ---
  do while(err_max>=eps)
     err_max=0.0
  do j=2,ny-1
     do i=2,nx-1
        tmp=(0.5/(1.0+delta**2))*(-dx**2*rho(i,j)  &
  &              +(psi(i+1,j)+psi(i-1,j)+delta**2*(psi(i,j+1)+psi(i,j-1))))

!-- η׻ ---
        if(psi(i,j)==0.0)then
           err=abs(tmp-psi(i,j))/abs(tmp)
        else
           err=abs(tmp-psi(i,j))/abs(psi(i,j))
        end if

!-- ι
        if(err_max<=err)then
           err_max=err
        end if

        psi(i,j)=tmp

     end do
  end do
!-- 
     psi(2:nx-1,1)=psi(2:nx-1,2)
     psi(1,2:ny-1)=psi(2,2:ny-1)
     psi(2:nx-1,ny)=psi(2:nx-1,ny-1)
     psi(nx,2:ny-1)=psi(nx-1,2:ny-1)
!-- 4 ξ
     psi(1,1)=0.5*(psi(1,2)+psi(2,1))
     psi(1,ny)=0.5*(psi(1,ny-1)+psi(2,ny))
     psi(nx,1)=0.5*(psi(nx,2)+psi(nx-1,1))
     psi(nx,ny)=0.5*(psi(nx,ny-1)+psi(nx-1,ny))
  end do

  

end subroutine free

subroutine period(nx,ny,dx,dy,eps,rho,psi)
  implicit none
  integer, intent(in) :: nx  ! x 
  integer, intent(in) :: ny  ! y 
  real, intent(in) :: dx  ! x γʻҴֳ
  real, intent(in) :: dy  ! y γʻҴֳ
  real, intent(in) :: rho(nx,ny)  ! ݥζ
  real, intent(in) :: eps  ! «
  real, intent(inout) :: psi(nx,ny)  ! ݥβ
  integer :: i, j, k, l, m, n
  real :: delta, err_max, err

  delta=dx/dy

  err_max=eps  ! while 뤿صŪ

!-- ºݤΥ ---
  do while(err_max>=eps)
     err_max=0.0
  do j=2,ny-1
     do i=2,nx-1
        tmp=(0.5/(1.0+delta**2))*(-dx**2*rho(i,j)  &
  &              +(psi(i+1,j)+psi(i-1,j)+delta**2*(psi(i,j+1)+psi(i,j-1))))

!-- η׻ ---
        if(psi(i,j)==0.0)then
           err=abs(tmp-psi(i,j))/abs(tmp)
        else
           err=abs(tmp-psi(i,j))/abs(psi(i,j))
        end if

!-- ι
        if(err_max<=err)then
           err_max=err
        end if

        psi(i,j)=tmp

     end do
  end do
!-- 
     psi(2:nx-1,1)=psi(2:nx-1,ny-1)
     psi(1,2:ny-1)=psi(nx-1,2:ny-1)
     psi(2:nx-1,ny)=psi(2:nx-1,2)
     psi(nx,2:ny-1)=psi(2,2:ny-1)
!-- 4 ξ
     psi(1,1)=0.5*(psi(1,ny-1)+psi(nx-1,1))
     psi(1,ny)=0.5*(psi(1,2)+psi(nx-1,ny))
     psi(nx,1)=0.5*(psi(nx,ny-1)+psi(2,1))
     psi(nx,ny)=0.5*(psi(nx,2)+psi(2,ny))
  end do

  

end subroutine period

end subroutine Poisson_GauSei


subroutine Poisson_Jacobi(nx, ny, dx, dy, rho, eps, boundary, psi, bound_opt)
! 䥳ˡˤݥεѡʳȯopenmp
  implicit none
  integer, intent(in) :: nx  ! x 
  integer, intent(in) :: ny  ! y 
  real, intent(in) :: dx  ! x γʻҴֳ
  real, intent(in) :: dy  ! y γʻҴֳ
  real, intent(in) :: rho(nx,ny)  ! ݥζ
  real, intent(in) :: eps  ! «
  integer, intent(in) :: boundary  ! 
  real, intent(in), optional :: bound_opt(nx,ny)  ! üξζ
  real, intent(inout) :: psi(nx,ny)  ! ݥβ
  integer :: i, j, k, l, m, n
  real :: tmp, err, err_max
  ! boundary  1 : ü, 2 : ͳü, 3 : 
  ! rho =0 ǥץ饹Ѳǽ.
  ! openmp ˤ륹å󤬲ǽ.
  ! ǥˡǤϥ르ꥺ󲽤Ȼפ줿Τ,
  ! ׻ˤݥεѤɬפȤʤʤ,
  ! 䥳ˡΤΤѤ줿.

  psi = 0.0

  select case (boundary)

  case(1)
     call fix(nx,ny,dx,dy,eps,rho,psi,bound_opt)

  case(2)
     call free(nx,ny,dx,dy,eps,rho,psi)

  case(3)
     call period(nx,ny,dx,dy,eps,rho,psi)

  end select

contains

subroutine fix(nx,ny,dx,dy,eps,rho,psi,bound_opt)
  implicit none
  integer, intent(in) :: nx  ! x 
  integer, intent(in) :: ny  ! y 
  real, intent(in) :: dx  ! x γʻҴֳ
  real, intent(in) :: dy  ! y γʻҴֳ
  real, intent(in) :: rho(nx,ny)  ! ݥζ
  real, intent(in) :: eps  ! «
  real, intent(in) :: bound_opt(nx,ny)  ! üξζ
  real, intent(inout) :: psi(nx,ny)  ! ݥβ
  real :: tmp(nx,ny)  ! 䥳ˡǲ򤯤, ƥ졼ȸͤס뤹
  integer :: i, j, k, l, m, n
  real :: delta, err_max, err

  delta=dx/dy
!-- ü ---
  psi(1,:)=bound_opt(1,:)
  psi(nx,:)=bound_opt(nx,:)
  psi(:,1)=bound_opt(:,1)
  psi(:,nx)=bound_opt(:,nx)

  err_max=eps  ! while 뤿صŪ

!-- ºݤΥ ---
  do while(err_max>=eps)
     err_max=0.0
!$omp parallel do shared(tmp,psi,rho,delta,dx) private(i,j)
  do j=2,ny-1
     do i=2,nx-1
        tmp(i,j)=(0.5/(1.0+delta**2))*(-dx**2*rho(i,j)  &
  &              +(psi(i+1,j)+psi(i-1,j)+delta**2*(psi(i,j+1)+psi(i,j-1))))
     end do
  end do
!$omp end parallel do

!-- η׻ ---
  do j=2,ny-1
     do i=2,nx-1
        if(psi(i,j)==0.0)then
           err=abs(tmp(i,j)-psi(i,j))/abs(tmp(i,j))
        else
           err=abs(tmp(i,j)-psi(i,j))/abs(psi(i,j))
        end if

!-- ι
        if(err_max<=err)then
           err_max=err
        end if

     end do
  end do

!$omp parallel do shared(tmp,psi) private(i,j)
  do j=2,ny-1
     do i=2,nx-1
        psi(i,j)=tmp(i,j)
     end do
  end do
!$omp end parallel do

  end do

  

end subroutine fix

subroutine free(nx,ny,dx,dy,eps,rho,psi)
  implicit none
  integer, intent(in) :: nx  ! x 
  integer, intent(in) :: ny  ! y 
  real, intent(in) :: dx  ! x γʻҴֳ
  real, intent(in) :: dy  ! y γʻҴֳ
  real, intent(in) :: rho(nx,ny)  ! ݥζ
  real, intent(in) :: eps  ! «
  real, intent(inout) :: psi(nx,ny)  ! ݥβ
  real :: tmp(nx,ny)  ! 䥳ˡǲ򤯤, ƥ졼ȸͤס뤹
  integer :: i, j, k, l, m, n
  real :: delta

  delta=dx/dy

  err_max=eps  ! while 뤿صŪ

!-- ºݤΥ ---
  do while(err_max>=eps)
     err_max=0.0
!$omp parallel do shared(tmp,psi,rho,delta,dx) private(i,j)
  do j=2,ny-1
     do i=2,nx-1
        tmp(i,j)=(0.5/(1.0+delta**2))*(-dx**2*rho(i,j)  &
  &              +(psi(i+1,j)+psi(i-1,j)+delta**2*(psi(i,j+1)+psi(i,j-1))))
     end do
  end do
!$omp end parallel do

!-- η׻ ---
  do j=2,ny-1
     do i=2,nx-1
        if(psi(i,j)==0.0)then
           err=abs(tmp(i,j)-psi(i,j))/abs(tmp(i,j))
        else
           err=abs(tmp(i,j)-psi(i,j))/abs(psi(i,j))
        end if

!-- ι
        if(err_max<=err)then
           err_max=err
        end if

     end do
  end do

!$omp parallel do shared(tmp,psi) private(i,j)
  do j=2,ny-1
     do i=2,nx-1
        psi(i,j)=tmp(i,j)
     end do
  end do
!$omp end parallel do

!-- 
     psi(2:nx-1,1)=psi(2:nx-1,2)
     psi(1,2:ny-1)=psi(2,2:ny-1)
     psi(2:nx-1,ny)=psi(2:nx-1,ny-1)
     psi(nx,2:ny-1)=psi(nx-1,2:ny-1)
!-- 4 ξ
     psi(1,1)=0.5*(psi(1,2)+psi(2,1))
     psi(1,ny)=0.5*(psi(1,ny-1)+psi(2,ny))
     psi(nx,1)=0.5*(psi(nx,2)+psi(nx-1,1))
     psi(nx,ny)=0.5*(psi(nx,ny-1)+psi(nx-1,ny))
  end do

  

end subroutine free

subroutine period(nx,ny,dx,dy,eps,rho,psi)
  implicit none
  integer, intent(in) :: nx  ! x 
  integer, intent(in) :: ny  ! y 
  real, intent(in) :: dx  ! x γʻҴֳ
  real, intent(in) :: dy  ! y γʻҴֳ
  real, intent(in) :: rho(nx,ny)  ! ݥζ
  real, intent(in) :: eps  ! «
  real, intent(inout) :: psi(nx,ny)  ! ݥβ
  real :: tmp(nx,ny)  ! 䥳ˡǲ򤯤, ƥ졼ȸͤס뤹
  integer :: i, j, k, l, m, n
  real :: delta

  delta=dx/dy

  err_max=eps  ! while 뤿صŪ

!-- ºݤΥ ---
  do while(err_max>=eps)
     err_max=0.0
!$omp parallel do shared(tmp,psi,rho,delta,dx) private(i,j)
  do j=2,ny-1
     do i=2,nx-1
        tmp(i,j)=(0.5/(1.0+delta**2))*(-dx**2*rho(i,j)  &
  &              +(psi(i+1,j)+psi(i-1,j)+delta**2*(psi(i,j+1)+psi(i,j-1))))
     end do
  end do
!$omp end parallel do

!-- η׻ ---
  do j=2,ny-1
     do i=2,nx-1
        if(psi(i,j)==0.0)then
           err=abs(tmp(i,j)-psi(i,j))/abs(tmp(i,j))
        else
           err=abs(tmp(i,j)-psi(i,j))/abs(psi(i,j))
        end if

!-- ι
        if(err_max<=err)then
           err_max=err
        end if

     end do
  end do

!$omp parallel do shared(tmp,psi,rho,delta,dx) private(i,j)
  do j=2,ny-1
     do i=2,nx-1
        psi(i,j)=tmp(i,j)
     end do
  end do
!$omp end parallel do

!-- 
     psi(2:nx-1,1)=psi(2:nx-1,ny-1)
     psi(1,2:ny-1)=psi(nx-1,2:ny-1)
     psi(2:nx-1,ny)=psi(2:nx-1,2)
     psi(nx,2:ny-1)=psi(2,2:ny-1)
!-- 4 ξ
     psi(1,1)=0.5*(psi(1,ny-1)+psi(nx-1,1))
     psi(1,ny)=0.5*(psi(1,2)+psi(nx-1,ny))
     psi(nx,1)=0.5*(psi(nx,ny-1)+psi(2,1))
     psi(nx,ny)=0.5*(psi(nx,2)+psi(2,ny))
  end do

  

end subroutine period

end subroutine Poisson_Jacobi


subroutine diffus_Gausei(nx, ny, dx, dy, rho, eps, boundary, psi, bound_opt)
!-- =ǥˡˤݥε ---
!-- ȯ!!!
  implicit none
  integer, intent(in) :: nx  ! x 
  integer, intent(in) :: ny  ! y 
  real, intent(in) :: dx  ! x γʻҴֳ
  real, intent(in) :: dy  ! y γʻҴֳ
  real, intent(in) :: rho(nx,ny)  ! ݥζ
  real, intent(in) :: eps  ! «
  integer, intent(in) :: boundary  ! 
  real, intent(in), optional :: bound_opt(nx,ny)  ! üξζ
  real, intent(inout) :: psi(nx,ny)  ! ݥβ
  integer :: i, j, k, l, m, n
  real :: tmp, err, err_max
  ! boundary  1 : ü, 2 : ͳü, 3 : 
  ! rho =0 ǥץ饹Ѳǽ

  psi = 0.0

  select case (boundary)

  case(1)
     call fix(nx,ny,dx,dy,eps,rho,psi,bound_opt)

  case(2)
     call free(nx,ny,dx,dy,eps,rho,psi)

  case(3)
     call period(nx,ny,dx,dy,eps,rho,psi)

  end select

contains

subroutine fix(nx,ny,dx,dy,eps,rho,psi,bound_opt)
  implicit none
  integer, intent(in) :: nx  ! x 
  integer, intent(in) :: ny  ! y 
  real, intent(in) :: dx  ! x γʻҴֳ
  real, intent(in) :: dy  ! y γʻҴֳ
  real, intent(in) :: rho(nx,ny)  ! ݥζ
  real, intent(in) :: eps  ! «
  real, intent(in) :: bound_opt(nx,ny)  ! üξζ
  real, intent(inout) :: psi(nx,ny)  ! ݥβ
  integer :: i, j, k, l, m, n
  real :: delta, err_max, err

  delta=dx/dy
!-- ü ---
  psi(1,:)=bound_opt(1,:)
  psi(nx,:)=bound_opt(nx,:)
  psi(:,1)=bound_opt(:,1)
  psi(:,nx)=bound_opt(:,nx)

  err_max=eps  ! while 뤿صŪ

!-- ºݤΥ ---
  do while(err_max>=eps)
     err_max=0.0
  do j=2,ny-1
     do i=2,nx-1
        tmp=(0.5/(1.0+delta**2))*(-dx**2*rho(i,j)  &
  &              +(psi(i+1,j)+psi(i-1,j)+delta**2*(psi(i,j+1)+psi(i,j-1))))

!-- η׻ ---
        if(psi(i,j)==0.0)then
           err=abs(tmp-psi(i,j))/abs(tmp)
        else
           err=abs(tmp-psi(i,j))/abs(psi(i,j))
        end if

!-- ι
        if(err_max<=err)then
           err_max=err
        end if

        psi(i,j)=tmp

     end do
  end do
  end do

  

end subroutine fix

subroutine free(nx,ny,dx,dy,eps,rho,psi)
  implicit none
  integer, intent(in) :: nx  ! x 
  integer, intent(in) :: ny  ! y 
  real, intent(in) :: dx  ! x γʻҴֳ
  real, intent(in) :: dy  ! y γʻҴֳ
  real, intent(in) :: rho(nx,ny)  ! ݥζ
  real, intent(in) :: eps  ! «
  real, intent(inout) :: psi(nx,ny)  ! ݥβ
  integer :: i, j, k, l, m, n
  real :: delta, err_max, err

  delta=dx/dy

  err_max=eps  ! while 뤿صŪ

!-- ºݤΥ ---
  do while(err_max>=eps)
     err_max=0.0
  do j=2,ny-1
     do i=2,nx-1
        tmp=(0.5/(1.0+delta**2))*(-dx**2*rho(i,j)  &
  &              +(psi(i+1,j)+psi(i-1,j)+delta**2*(psi(i,j+1)+psi(i,j-1))))

!-- η׻ ---
        if(psi(i,j)==0.0)then
           err=abs(tmp-psi(i,j))/abs(tmp)
        else
           err=abs(tmp-psi(i,j))/abs(psi(i,j))
        end if

!-- ι
        if(err_max<=err)then
           err_max=err
        end if

        psi(i,j)=tmp

     end do
  end do
!-- 
     psi(2:nx-1,1)=psi(2:nx-1,2)
     psi(1,2:ny-1)=psi(2,2:ny-1)
     psi(2:nx-1,ny)=psi(2:nx-1,ny-1)
     psi(nx,2:ny-1)=psi(nx-1,2:ny-1)
!-- 4 ξ
     psi(1,1)=0.5*(psi(1,2)+psi(2,1))
     psi(1,ny)=0.5*(psi(1,ny-1)+psi(2,ny))
     psi(nx,1)=0.5*(psi(nx,2)+psi(nx-1,1))
     psi(nx,ny)=0.5*(psi(nx,ny-1)+psi(nx-1,ny))
  end do

  

end subroutine free

subroutine period(nx,ny,dx,dy,eps,rho,psi)
  implicit none
  integer, intent(in) :: nx  ! x 
  integer, intent(in) :: ny  ! y 
  real, intent(in) :: dx  ! x γʻҴֳ
  real, intent(in) :: dy  ! y γʻҴֳ
  real, intent(in) :: rho(nx,ny)  ! ݥζ
  real, intent(in) :: eps  ! «
  real, intent(inout) :: psi(nx,ny)  ! ݥβ
  integer :: i, j, k, l, m, n
  real :: delta, err_max, err

  delta=dx/dy

  err_max=eps  ! while 뤿صŪ

!-- ºݤΥ ---
  do while(err_max>=eps)
     err_max=0.0
  do j=2,ny-1
     do i=2,nx-1
        tmp=(0.5/(1.0+delta**2))*(-dx**2*rho(i,j)  &
  &              +(psi(i+1,j)+psi(i-1,j)+delta**2*(psi(i,j+1)+psi(i,j-1))))

!-- η׻ ---
        if(psi(i,j)==0.0)then
           err=abs(tmp-psi(i,j))/abs(tmp)
        else
           err=abs(tmp-psi(i,j))/abs(psi(i,j))
        end if

!-- ι
        if(err_max<=err)then
           err_max=err
        end if

        psi(i,j)=tmp

     end do
  end do
!-- 
     psi(2:nx-1,1)=psi(2:nx-1,ny-1)
     psi(1,2:ny-1)=psi(nx-1,2:ny-1)
     psi(2:nx-1,ny)=psi(2:nx-1,2)
     psi(nx,2:ny-1)=psi(2,2:ny-1)
!-- 4 ξ
     psi(1,1)=0.5*(psi(1,ny-1)+psi(nx-1,1))
     psi(1,ny)=0.5*(psi(1,2)+psi(nx-1,ny))
     psi(nx,1)=0.5*(psi(nx,ny-1)+psi(2,1))
     psi(nx,ny)=0.5*(psi(nx,2)+psi(2,ny))
  end do

  

end subroutine period

end subroutine diffus_GauSei


subroutine Diff_2d_Jacobi(nx, ny, dx, dy, rho, eps, boundary, psi, lambda, bound_opt)
! 䥳ˡˤݥεѡʳȯopenmp
  implicit none
  integer, intent(in) :: nx  ! x 
  integer, intent(in) :: ny  ! y 
  real, intent(in) :: dx  ! x γʻҴֳ
  real, intent(in) :: dy  ! y γʻҴֳ
  real, intent(in) :: rho(nx,ny)  ! ݥζ
  real, intent(in) :: eps  ! «
  integer, intent(in) :: boundary  ! 
  real, intent(in) :: lambda  ! ·
  real, intent(in), optional :: bound_opt(nx,ny)  ! üξζ
  real, intent(inout) :: psi(nx,ny)  ! ݥβ
  integer :: i, j, k, l, m, n
  real :: tmp, err, err_max
  ! boundary  1 : ü, 2 : ͳü, 3 : 
  ! rho =0 ǥץ饹Ѳǽ.
  ! openmp ˤ륹å󤬲ǽ.
  ! ǥˡǤϥ르ꥺ󲽤Ȼפ줿Τ,
  ! ׻ˤݥεѤɬפȤʤʤ,
  ! 䥳ˡΤΤѤ줿.

  psi = 0.0

  select case (boundary)

  case(1)
     call fix(nx,ny,dx,dy,eps,rho,psi,bound_opt)

  case(2)
     call free(nx,ny,dx,dy,eps,rho,psi)

  case(3)
     call period(nx,ny,dx,dy,eps,rho,psi)

  end select

contains

subroutine fix(nx,ny,dx,dy,eps,rho,psi,bound_opt)
  implicit none
  integer, intent(in) :: nx  ! x 
  integer, intent(in) :: ny  ! y 
  real, intent(in) :: dx  ! x γʻҴֳ
  real, intent(in) :: dy  ! y γʻҴֳ
  real, intent(in) :: rho(nx,ny)  ! ݥζ
  real, intent(in) :: eps  ! «
  real, intent(in) :: bound_opt(nx,ny)  ! üξζ
  real, intent(inout) :: psi(nx,ny)  ! ݥβ
  real :: tmp(nx,ny)  ! 䥳ˡǲ򤯤, ƥ졼ȸͤס뤹
  integer :: i, j, k, l, m, n
  real :: delta, err_max, err

  delta=dx/dy
!-- ü ---
  psi(1,:)=bound_opt(1,:)
  psi(nx,:)=bound_opt(nx,:)
  psi(:,1)=bound_opt(:,1)
  psi(:,nx)=bound_opt(:,nx)

  err_max=eps  ! while 뤿صŪ

!-- ºݤΥ ---
  do while(err_max>=eps)
     err_max=0.0
!$omp parallel do shared(tmp,psi,rho,delta,dx) private(i,j)
  do j=2,ny-1
     do i=2,nx-1
        tmp(i,j)=(0.5/(1.0+delta**2))*(-dx**2*rho(i,j)  &
  &              +(psi(i+1,j)+psi(i-1,j)+delta**2*(psi(i,j+1)+psi(i,j-1))))
     end do
  end do
!$omp end parallel do

!-- η׻ ---
  do j=2,ny-1
     do i=2,nx-1
        if(psi(i,j)==0.0)then
           err=abs(tmp(i,j)-psi(i,j))/abs(tmp(i,j))
        else
           err=abs(tmp(i,j)-psi(i,j))/abs(psi(i,j))
        end if

!-- ι
        if(err_max<=err)then
           err_max=err
        end if

     end do
  end do

!$omp parallel do shared(tmp,psi) private(i,j)
  do j=2,ny-1
     do i=2,nx-1
        psi(i,j)=tmp(i,j)
     end do
  end do
!$omp end parallel do

  end do

  

end subroutine fix

subroutine free(nx,ny,dx,dy,eps,rho,psi)
  implicit none
  integer, intent(in) :: nx  ! x 
  integer, intent(in) :: ny  ! y 
  real, intent(in) :: dx  ! x γʻҴֳ
  real, intent(in) :: dy  ! y γʻҴֳ
  real, intent(in) :: rho(nx,ny)  ! ݥζ
  real, intent(in) :: eps  ! «
  real, intent(inout) :: psi(nx,ny)  ! ݥβ
  real :: tmp(nx,ny)  ! 䥳ˡǲ򤯤, ƥ졼ȸͤס뤹
  integer :: i, j, k, l, m, n
  real :: delta

  delta=dx/dy

  err_max=eps  ! while 뤿صŪ

!-- ºݤΥ ---
  do while(err_max>=eps)
     err_max=0.0
!$omp parallel do shared(tmp,psi,rho,delta,dx) private(i,j)
  do j=2,ny-1
     do i=2,nx-1
        tmp(i,j)=(0.5/(1.0+delta**2))*(-dx**2*rho(i,j)  &
  &              +(psi(i+1,j)+psi(i-1,j)+delta**2*(psi(i,j+1)+psi(i,j-1))))
     end do
  end do
!$omp end parallel do

!-- η׻ ---
  do j=2,ny-1
     do i=2,nx-1
        if(psi(i,j)==0.0)then
           err=abs(tmp(i,j)-psi(i,j))/abs(tmp(i,j))
        else
           err=abs(tmp(i,j)-psi(i,j))/abs(psi(i,j))
        end if

!-- ι
        if(err_max<=err)then
           err_max=err
        end if

     end do
  end do

!$omp parallel do shared(tmp,psi) private(i,j)
  do j=2,ny-1
     do i=2,nx-1
        psi(i,j)=tmp(i,j)
     end do
  end do
!$omp end parallel do

!-- 
     psi(2:nx-1,1)=psi(2:nx-1,2)
     psi(1,2:ny-1)=psi(2,2:ny-1)
     psi(2:nx-1,ny)=psi(2:nx-1,ny-1)
     psi(nx,2:ny-1)=psi(nx-1,2:ny-1)
!-- 4 ξ
     psi(1,1)=0.5*(psi(1,2)+psi(2,1))
     psi(1,ny)=0.5*(psi(1,ny-1)+psi(2,ny))
     psi(nx,1)=0.5*(psi(nx,2)+psi(nx-1,1))
     psi(nx,ny)=0.5*(psi(nx,ny-1)+psi(nx-1,ny))
  end do

  

end subroutine free

subroutine period(nx,ny,dx,dy,eps,rho,psi)
  implicit none
  integer, intent(in) :: nx  ! x 
  integer, intent(in) :: ny  ! y 
  real, intent(in) :: dx  ! x γʻҴֳ
  real, intent(in) :: dy  ! y γʻҴֳ
  real, intent(in) :: rho(nx,ny)  ! ݥζ
  real, intent(in) :: eps  ! «
  real, intent(inout) :: psi(nx,ny)  ! ݥβ
  real :: tmp(nx,ny)  ! 䥳ˡǲ򤯤, ƥ졼ȸͤס뤹
  integer :: i, j, k, l, m, n
  real :: delta

  delta=dx/dy

  err_max=eps  ! while 뤿صŪ

!-- ºݤΥ ---
  do while(err_max>=eps)
     err_max=0.0
!$omp parallel do shared(tmp,psi,rho,delta,dx) private(i,j)
  do j=2,ny-1
     do i=2,nx-1
        tmp(i,j)=(0.5/(1.0+delta**2))*(-dx**2*rho(i,j)  &
  &              +(psi(i+1,j)+psi(i-1,j)+delta**2*(psi(i,j+1)+psi(i,j-1))))
     end do
  end do
!$omp end parallel do

!-- η׻ ---
  do j=2,ny-1
     do i=2,nx-1
        if(psi(i,j)==0.0)then
           err=abs(tmp(i,j)-psi(i,j))/abs(tmp(i,j))
        else
           err=abs(tmp(i,j)-psi(i,j))/abs(psi(i,j))
        end if

!-- ι
        if(err_max<=err)then
           err_max=err
        end if

     end do
  end do

!$omp parallel do shared(tmp,psi,rho,delta,dx) private(i,j)
  do j=2,ny-1
     do i=2,nx-1
        psi(i,j)=tmp(i,j)
     end do
  end do
!$omp end parallel do

!-- 
     psi(2:nx-1,1)=psi(2:nx-1,ny-1)
     psi(1,2:ny-1)=psi(nx-1,2:ny-1)
     psi(2:nx-1,ny)=psi(2:nx-1,2)
     psi(nx,2:ny-1)=psi(2,2:ny-1)
!-- 4 ξ
     psi(1,1)=0.5*(psi(1,ny-1)+psi(nx-1,1))
     psi(1,ny)=0.5*(psi(1,2)+psi(nx-1,ny))
     psi(nx,1)=0.5*(psi(nx,ny-1)+psi(2,1))
     psi(nx,ny)=0.5*(psi(nx,2)+psi(2,ny))
  end do

  

end subroutine period

end subroutine Diff_2d_Jacobi


end module
