!---------------------------------------------------------------
! Copyright (C) 2009-2015 GFD Dennou Club. All rights reserved.
!---------------------------------------------------------------

module Math_Const  ! 
  implicit none
  real, parameter :: pi=3.14159265e0  ! ߼Ψ
  complex, parameter :: img=(0.0,1.0)  ! ñ
  complex, save, dimension(0:1,0:1) :: romega2  ! ȿ 2 βž (Ѵ)
  complex, save, dimension(0:2,0:2) :: romega3  ! ȿ 3 βž (Ѵ)
  complex, save, dimension(0:4,0:4) :: romega5  ! ȿ 5 βž (Ѵ)
  complex, save, dimension(0:6,0:6) :: romega7  ! ȿ 7 βž (Ѵ)
  complex, save, dimension(0:1,0:1) :: iomega2  ! ȿ 2 βž (Ѵ)
  complex, save, dimension(0:2,0:2) :: iomega3  ! ȿ 3 βž (Ѵ)
  complex, save, dimension(0:4,0:4) :: iomega5  ! ȿ 5 βž (Ѵ)
  complex, save, dimension(0:6,0:6) :: iomega7  ! ȿ 7 βž (Ѵ)

  double precision, parameter :: pi_dp=3.14159265358979d0  ! ߼Ψ
  complex(kind(0d0)), parameter :: img_cdp=(0.0d0,1.0d0)  ! ñ
  complex(kind(0d0)), save, dimension(0:1,0:1) :: romega2_cdp  ! ȿ 2 βž (Ѵ)
  complex(kind(0d0)), save, dimension(0:2,0:2) :: romega3_cdp  ! ȿ 3 βž (Ѵ)
  complex(kind(0d0)), save, dimension(0:4,0:4) :: romega5_cdp  ! ȿ 5 βž (Ѵ)
  complex(kind(0d0)), save, dimension(0:6,0:6) :: romega7_cdp  ! ȿ 7 βž (Ѵ)
  complex(kind(0d0)), save, dimension(0:1,0:1) :: iomega2_cdp  ! ȿ 2 βž (Ѵ)
  complex(kind(0d0)), save, dimension(0:2,0:2) :: iomega3_cdp  ! ȿ 3 βž (Ѵ)
  complex(kind(0d0)), save, dimension(0:4,0:4) :: iomega5_cdp  ! ȿ 5 βž (Ѵ)
  complex(kind(0d0)), save, dimension(0:6,0:6) :: iomega7_cdp  ! ȿ 7 βž (Ѵ)


contains

subroutine rotate_array_f()
  ! FFT Ѥβž׻
  implicit none

  integer :: i, j

  romega2=1.0
  romega2(1,1)=-1.0
  do j=0,2
     do i=0,2
        romega3(i,j)=cos(2.0*pi*real(i)*real(j)/3.0)  &
  &                  -img*sin(2.0*pi*real(i)*real(j)/3.0)
     end do
  end do
  do j=0,4
     do i=0,4
        romega5(i,j)=cos(2.0*pi*real(i)*real(j)/5.0)  &
  &                  -img*sin(2.0*pi*real(i)*real(j)/5.0)
     end do
  end do
  do j=0,6
     do i=0,6
        romega7(i,j)=cos(2.0*pi*real(i)*real(j)/7.0)  &
  &                  -img*sin(2.0*pi*real(i)*real(j)/7.0)
     end do
  end do

  iomega2=1.0
  iomega2(1,1)=-1.0
  do j=0,2
     do i=0,2
        iomega3(i,j)=cos(2.0*pi*real(i)*real(j)/3.0)  &
  &                  +img*sin(2.0*pi*real(i)*real(j)/3.0)
     end do
  end do
  do j=0,4
     do i=0,4
        iomega5(i,j)=cos(2.0*pi*real(i)*real(j)/5.0)  &
  &                  +img*sin(2.0*pi*real(i)*real(j)/5.0)
     end do
  end do
  do j=0,6
     do i=0,6
        iomega7(i,j)=cos(2.0*pi*real(i)*real(j)/7.0)  &
  &+img*sin(2.0*pi*real(i)*real(j)/7.0)
     end do
  end do

end subroutine rotate_array_f


subroutine rotate_array_d()
  ! FFT Ѥβž׻
  implicit none

  integer :: i, j

  romega2_cdp=1.0d0
  romega2_cdp(1,1)=-1.0d0
  do j=0,2
     do i=0,2
        romega3_cdp(i,j)=dcos(2.0d0*pi_dp*dble(i)*dble(j)/3.0d0)  &
  &                      -img_cdp*dsin(2.0d0*pi_dp*dble(i)*dble(j)/3.0d0)
     end do
  end do
  do j=0,4
     do i=0,4
        romega5_cdp(i,j)=dcos(2.0d0*pi_dp*dble(i)*dble(j)/5.0d0)  &
  &                      -img_cdp*dsin(2.0d0*pi_dp*dble(i)*dble(j)/5.0d0)
     end do
  end do
  do j=0,6
     do i=0,6
        romega7_cdp(i,j)=dcos(2.0d0*pi_dp*dble(i)*dble(j)/7.0d0)  &
  &                      -img_cdp*dsin(2.0d0*pi_dp*dble(i)*dble(j)/7.0d0)
     end do
  end do

  iomega2_cdp=1.0d0
  iomega2_cdp(1,1)=-1.0d0
  do j=0,2
     do i=0,2
        iomega3_cdp(i,j)=dcos(2.0d0*pi_dp*dble(i)*dble(j)/3.0d0)  &
  &                      +img_cdp*dsin(2.0d0*pi_dp*dble(i)*dble(j)/3.0d0)
     end do
  end do
  do j=0,4
     do i=0,4
        iomega5_cdp(i,j)=dcos(2.0d0*pi_dp*dble(i)*dble(j)/5.0d0)  &
  &                      +img_cdp*dsin(2.0d0*pi_dp*dble(i)*dble(j)/5.0d0)
     end do
  end do
  do j=0,6
     do i=0,6
        iomega7_cdp(i,j)=dcos(2.0d0*pi_dp*dble(i)*dble(j)/7.0d0)  &
  &                      +img_cdp*dsin(2.0d0*pi_dp*dble(i)*dble(j)/7.0d0)
     end do
  end do

end subroutine rotate_array_d

end module
