program make_initial
! 初期値データを作成する.

  use gtool_history
  use Algebra
  use Phys_Const

  implicit none

  integer :: nr
  integer :: i
  real, allocatable, dimension(:) :: ri, vb, hb, ub, fv
  real, parameter :: rmin=0.0, dr=110.0, r0=100000.0, coril=1.0e-5, hmin=1.0e3
  real, parameter :: vmax=60.0
  character(80) :: finame, fname
  character(1) :: data_flag, radial_flag

!-- 初期値ファイル名の入力

  write(*,*) "input the initial file name."
  read(*,*) finame

!-- 風速分布ファイルを読み込んで depth を計算するか,
!-- 関数を用いて風速場を作成し, そこから depth を計算するかの問い

  write(*,*) "You have velocity data [Y/N]."
  read(*,*) data_flag

  if(data_flag=='Y')then
     write(*,*) "input file name and radial grid number."
     read(*,*) fname, nr
     write(*,*) "radial flow is forced to zero ? [Y/N]."
     read(*,*) radial_flag
  else
     nr=10000
  end if

  allocate(ri(nr))
  allocate(vb(nr))
  allocate(ub(nr))
  allocate(hb(nr))
  allocate(fv(nr))

!-- 座標変数の定義

  if(data_flag=='Y')then
     call HistoryGet( trim(fname), 'r', ri )
     call HistoryGet( trim(fname), 'vbar', vb )
     call HistoryGet( trim(fname), 'ubar', ub )
  else
     ri=(/((rmin+dr*(i-1)),i=1,nr)/)
  end if

!-- 各軸対称風の定義

  do i=1,nr
     if(ri(i)/=0.0)then
        if(data_flag=='N')then
           vb(i)=2.0*vmax*(ri(i)/r0)/(1.0+(ri(i)/r0)**3)
        end if

        fv(i)=coril*vb(i)+vb(i)*vb(i)/ri(i)
        call rectangle_int( ri(1:i), fv(1:i), ri(1), ri(i), hb(i) )
        hb(i)=hmin+hb(i)/g

        if(radial_flag=='Y'.or.data_flag=='N')then
           ub(i)=0.0
        end if
     else
        fv(i)=0.0
        vb(i)=0.0
        hb(i)=hmin
        ub(i)=0.0
     end if
  end do

!-- 出力ファイルの初期化

  call HistoryCreate( file=trim(finame), title='shallow initial data', &
  & source='test', institution='test', dims=(/'r'/), dimsizes=(/nr/),  & 
  & longnames=(/'r-coordinate'/),  &
  & units=(/'m'/), origin=0.0, interval=0.0 )
  
  call HistoryPut( 'r', ri )
  
  call HistoryAddVariable( varname='vbar', dims=(/'r'/), &
    & longname='basic tangential wind', units='m/s', xtype='float')

  call HistoryPut( 'vbar', vb )

  call HistoryAddVariable( varname='hbar', dims=(/'r'/), &
    & longname='basic geopotential', units='m', xtype='float')

  call HistoryPut( 'hbar', hb )

  call HistoryAddVariable( varname='ubar', dims=(/'r'/), &
    & longname='basic radial wind', units='m/s', xtype='float')

  call HistoryPut( 'ubar', ub )

end program
