module read_namelist

  implicit none

contains

subroutine read_name()

  use savegloval_define

  namelist /basic /nx, ny, jxnt, jynt, hxnt, hynt,  &
  &                nt, Lx, Ly, dt, dmpstp, time_flag, foname
  namelist /param_nbm /calc_nbm_flag, nu, flag_fric, mu,  &
  &                    flag_stretch, force_type, sth_fname, sth_vname, zetam,  &
  &                    flag_sthmod, sth_thres_zeta, cent_lat, rho0
  namelist /param_sbl /calc_sbl_flag, h_sbl, K_sbl
  namelist /input /nxi, nyi, ininame, inix, iniy, iniz, inixd, iniyd, i_adj
  namelist /restart /resopt, resfname, restp
  read(5,nml=basic)
  read(5,nml=param_nbm)
  read(5,nml=param_sbl)
  read(5,nml=input)
  read(5,nml=restart)

  kxnt=2*hxnt+1
  kynt=2*hynt+1
  dx=Lx/dble(nx-1)
  dy=Ly/dble(ny-1)
  xmin=0.0d0
  ymin=0.0d0

end subroutine read_name

end module read_namelist
