module val_define
! 変数の定義
! 変数名の命名規則
! 実数 -> r, 純虚数 -> i, 複素数 -> c
! 平均場 -> b, 擾乱場 -> p
! 時間発展 -> old, mid, new  (mid は LF スキームのときのみ)
!-- 配列および一貫変数は save 属性をつけて module を読み込んだときに値が
!  保存される仕様にする.

  implicit none

!-- value definition
!-- integer, save part
  integer, save :: nr  ! r 方向の配列個数
  integer, save :: ntheta  ! theta 方向の配列個数
  integer, save :: nz  ! z 方向の配列個数
  integer, save :: nt  ! 時間ステップ
  integer, save :: jnt  ! 非線形変換法における分点
  integer, save :: hnt  ! theta 方向の切断波数
  integer, save :: nri  ! r 方向の配列個数(初期値データ)
  integer, save :: nzi  ! z 方向の配列個数(初期値データ)
  integer, save :: dmpstp  ! ダンプ間隔
  integer, save :: init_n  ! 初期の波数

!-- logical part
  logical, save :: nl_flag  ! 非線形項計算を行うかどうかのフラグ

!-- real, save part
  real, save :: rmin  ! 動径方向内径
  real, save :: zmin  ! 鉛直方向下端
  real, save :: dr  ! 動径方向格子間隔
  real, save :: dz  ! 鉛直方向格子間隔
  real, save :: dt  ! 接線方向格子間隔
  real, save :: r_dmp  ! レイリーダンピングをかける半径
  real, save :: diff_r  ! 動径方向の拡散係数
  real, save :: diff_t  ! 接線方向の拡散係数

!-- 1d val
  real, save, allocatable, dimension(:) :: ri  ! スカラー動径座標初期値
  real, save, allocatable, dimension(:) :: zi  ! スカラー鉛直座標初期値
  real, save, allocatable, dimension(:) :: rs  ! スカラー動径座標
  real, save, allocatable, dimension(:) :: zs  ! スカラー鉛直座標
  real, save, allocatable, dimension(:) :: rv  ! 水平速度動径座標
  real, save, allocatable, dimension(:) :: zv  ! 水平速度鉛直座標
  real, save, allocatable, dimension(:) :: theta  ! 接線座標

!-- 2d val
  real, save, allocatable, dimension(:,:) :: coril  ! コリオリパラメータ
  real, save, allocatable, dimension(:,:) :: epsu   ! レイリーダンピング係数 u
  real, save, allocatable, dimension(:,:) :: epsv   ! レイリーダンピング係数 v
  real, save, allocatable, dimension(:,:) :: epsh   ! レイリーダンピング係数 h

!-- 3d val
  real, save, allocatable, dimension(:,:,:) :: urs_dmp ! 動径風速 dmp (scalar)
  real, save, allocatable, dimension(:,:,:) :: vrs_dmp ! 接線風速 dmp (scalar)
  real, save, allocatable, dimension(:,:,:) :: wrs_dmp ! 鉛直風速 dmp (scalar)
  real, save, allocatable, dimension(:,:,:) :: hrs_dmp ! ジオポテンシャル dmp (scalar)
  real, save, allocatable, dimension(:,:,:) :: ptsr_dmp! 温位 dmp (scalar)
  real, save, allocatable, dimension(:,:,:) :: ur_dmp  ! 動径風速 dmp
  real, save, allocatable, dimension(:,:,:) :: vr_dmp  ! 接線風速 dmp
  real, save, allocatable, dimension(:,:,:) :: wr_dmp  ! 鉛直風速 dmp
  real, save, allocatable, dimension(:,:,:) :: hr_dmp  ! ジオポテンシャル dmp
  real, save, allocatable, dimension(:,:,:) :: ptr_dmp ! 温位 dmp
  real, save, allocatable, dimension(:,:,:) :: ur_old  ! 動径風速 old
  real, save, allocatable, dimension(:,:,:) :: vr_old  ! 接線風速 old
  real, save, allocatable, dimension(:,:,:) :: ptr_old ! 温位 old
  real, save, allocatable, dimension(:,:,:) :: ui_old  ! 動径風速 old
  real, save, allocatable, dimension(:,:,:) :: vi_old  ! 接線風速 old
  real, save, allocatable, dimension(:,:,:) :: pti_old ! 温位 old
  real, save, allocatable, dimension(:,:,:) :: ur_mid  ! 動径風速 mid
  real, save, allocatable, dimension(:,:,:) :: vr_mid  ! 接線風速 mid
  real, save, allocatable, dimension(:,:,:) :: ptr_mid ! 温位 mid
  real, save, allocatable, dimension(:,:,:) :: ui_mid  ! 動径風速 mid
  real, save, allocatable, dimension(:,:,:) :: vi_mid  ! 接線風速 mid
  real, save, allocatable, dimension(:,:,:) :: pti_mid ! 温位 mid
  real, save, allocatable, dimension(:,:,:) :: ur_new  ! 動径風速 new
  real, save, allocatable, dimension(:,:,:) :: vr_new  ! 接線風速 new
  real, save, allocatable, dimension(:,:,:) :: ptr_new ! 温位 new
  real, save, allocatable, dimension(:,:,:) :: ui_new  ! 動径風速 new
  real, save, allocatable, dimension(:,:,:) :: vi_new  ! 接線風速 new
  real, save, allocatable, dimension(:,:,:) :: pti_new ! 温位 new
  real, save, allocatable, dimension(:,:,:) :: dval1r  ! 任意変数の勾配
  real, save, allocatable, dimension(:,:,:) :: dval2r  ! 任意変数の勾配
  real, save, allocatable, dimension(:,:,:) :: dval3r  ! 任意変数の勾配
  real, save, allocatable, dimension(:,:,:) :: dval1i  ! 任意変数の勾配
  real, save, allocatable, dimension(:,:,:) :: dval2i  ! 任意変数の勾配
  real, save, allocatable, dimension(:,:,:) :: dval3i  ! 任意変数の勾配

!-- complex, save part

  complex, parameter :: img=( 0.0, 1.0 )  ! 虚数単位

  complex, save, allocatable, dimension(:,:,:) :: uc_old  ! 動径風速 old
  complex, save, allocatable, dimension(:,:,:) :: vc_old  ! 接線風速 old
  complex, save, allocatable, dimension(:,:,:) :: wc_old  ! 鉛直風速 old
  complex, save, allocatable, dimension(:,:,:) :: hc_old  ! ジオポテンシャル old
  complex, save, allocatable, dimension(:,:,:) :: ptc_old ! 温位 old
  complex, save, allocatable, dimension(:,:,:) :: uc_mid  ! 動径風速 mid
  complex, save, allocatable, dimension(:,:,:) :: vc_mid  ! 接線風速 mid
  complex, save, allocatable, dimension(:,:,:) :: wc_mid  ! 鉛直風速 mid
  complex, save, allocatable, dimension(:,:,:) :: hc_mid  ! ジオポテンシャル mid
  complex, save, allocatable, dimension(:,:,:) :: ptc_mid ! 温位 mid
  complex, save, allocatable, dimension(:,:,:) :: uc_new  ! 動径風速 new
  complex, save, allocatable, dimension(:,:,:) :: vc_new  ! 接線風速 new
  complex, save, allocatable, dimension(:,:,:) :: wc_new  ! 鉛直風速 new
  complex, save, allocatable, dimension(:,:,:) :: hc_new  ! ジオポテンシャル new
  complex, save, allocatable, dimension(:,:,:) :: ptc_new ! 温位 new
  complex, save, allocatable, dimension(:,:,:) :: ducdr  ! du/dr
  complex, save, allocatable, dimension(:,:,:) :: dvcdr  ! dv/dr
  complex, save, allocatable, dimension(:,:,:) :: dptcdr ! dtheta/dr
  complex, save, allocatable, dimension(:,:,:) :: ducdz  ! du/dz
  complex, save, allocatable, dimension(:,:,:) :: dvcdz  ! dv/dz
  complex, save, allocatable, dimension(:,:,:) :: dptcdz ! dtheta/dz
  complex, save, allocatable, dimension(:,:,:) :: forceu  ! forceu
  complex, save, allocatable, dimension(:,:,:) :: forcev  ! forcev
  complex, save, allocatable, dimension(:,:,:) :: forcept ! forcept

!-- character part
  character(80) :: finame  ! 初期値ファイル名
  character(80) :: foname  ! 結果値ファイル名
  character(1) :: time_flag  ! 時間スキームに関するフラグ
  character(10) :: force_flag  ! 強制項の各効果を入れるためのフラグ

end module
