module val_alloc
! 変数の定義
! 変数名の命名規則
! 実数 -> r, 純虚数 -> i, 複素数 -> c
! 平均場 -> b, 擾乱場 -> p
! 時間発展 -> old, new

  use val_define
  use read_namelist

  implicit none

contains

subroutine val_allocate()

  implicit none

  allocate(ibp(nx,ny))  ! 境界計算方式指定 (psi)
  allocate(ibo(nx,ny))  ! 境界計算方式指定 (omg)
  allocate(ibb(nx,ny))  ! 境界計算方式指定 (buo)

  allocate(calc_flag(nx,ny))

  allocate(x(nx))  ! ベクトル動径座標
  allocate(y(ny))  ! 接線座標

!-- 2d val (prognostic value)
  allocate(omega_dmp(nx,ny))  ! 渦度 dmp
  allocate(omega_old(nx,ny))  ! 渦度 old
  allocate(omega_new(nx,ny))  ! 渦度 new
  allocate(omega_tmp(nx,ny))  ! 渦度 tmp
  allocate(buoy_dmp(nx,ny))  ! 浮力 dmp
  allocate(buoy_old(nx,ny))  ! 浮力 old
  allocate(buoy_new(nx,ny))  ! 浮力 new
  allocate(buoy_tmp(nx,ny))  ! 浮力 tmp

!-- 2d val (diagnostic value)
  allocate(psi_dmp(nx,ny))  ! 流線関数 dmp
  allocate(psi_old(nx,ny))  ! 流線関数 old
  allocate(psi_new(nx,ny))  ! 流線関数 new
  allocate(psi_tmp(nx,ny))  ! 流線関数 tmp
  allocate(u_dmp(nx,ny))  ! x 方向速度 dmp
  allocate(v_dmp(nx,ny))  ! y 方向速度 dmp

!-- 2d val (force term)
  allocate(force_omega(nx,ny))  ! omega forcing term
  allocate(forcea_omega(nx,ny))  ! omega forcing term
  allocate(force_buoy(nx,ny))  ! buoy forcing term
  allocate(forcea_buoy(nx,ny))  ! buoy forcing term
  allocate(ADV(nx,ny))
  allocate(DIFF(nx,ny))
  allocate(dpdx(nx,ny))
  allocate(dpdy(nx,ny))
  allocate(dodx(nx,ny))
  allocate(dody(nx,ny))
  allocate(dbdx(nx,ny))
  allocate(dbdy(nx,ny))
  allocate(do2dx2(nx,ny))
  allocate(do2dy2(nx,ny))
  allocate(db2dx2(nx,ny))
  allocate(db2dy2(nx,ny))
  allocate(dp2dx2(nx,ny))
  allocate(dp2dy2(nx,ny))
  allocate(pois_force(nx,ny))
  allocate(bndp(nx,ny))
  allocate(bndo(nx,ny))
  allocate(bndb(nx,ny))
  allocate(dpdoydx(nx,ny))
  allocate(dpdoxdy(nx,ny))
  allocate(dodpxdy(nx,ny))
  allocate(dodpydx(nx,ny))
  allocate(pdoy(nx,ny))
  allocate(pdox(nx,ny))
  allocate(odpx(nx,ny))
  allocate(odpy(nx,ny))
  allocate(AJ(nx,ny,3))

  allocate(cval(nx,ny))

end subroutine

end module
