program harmonic
  use Math_Const
  use gtool_history
  implicit none
  integer, parameter :: nlon=5  ! longititude 方向の切断波数
  integer, parameter :: nlat=5  ! latitude 方向の切断波数
  real :: dt  ! 計算時間間隔
  integer :: nt  ! 計算ステップ数
  integer :: j, k
  integer, parameter :: nx=100
  integer, parameter :: ny=100
  real, dimension(nx) :: x  ! x 座標
  real, dimension(ny) :: y  ! y 座標
  real, dimension(nx) :: lon  ! x 座標
  real, dimension(ny) :: lat  ! y 座標
  complex, dimension(0:n,-m:m,nx,ny) :: pm  ! 全球データ
  complex, parameter :: img=(0.0,1.0)

  x=(/((2.0*pi*real(j-1)/real(nx-1)),j=1,nx)/)
  y=(/((2.0*pi*real(j-1)/real(ny-1)),j=1,ny)/)

  call ymn( nlat, nlon, x, y, pm )

!-- gtool history (netcdf dump)

  call HistoryCreate( &                             ! ヒストリー作成
    & file='advection.nc', title='spectral advecting model', &
    & source='Sample program of gtool_history/gtool5',   &
    & institution='GFD_Dennou Club davis project',       &
    & dims=(/'x','t'/), dimsizes=(/2*nx+1,nt+1/),               &
    & longnames=(/'X-coordinate','time        '/),       &
    & units=(/'m','s'/),                                 &
    & origin=0.0, interval=real(nt*dt) )

  call HistoryPut( 'x', x )                            ! 次元変数出力

  call HistoryAddVariable( &                           ! 変数定義
    & varname='amp', dims=(/'x','t'/), &
    & longname='amplitude', units='1', xtype='float')

!-- 時間積分開始
  do j=1,nt
!-- CR 法で時間積分
     fm2(0)=fm1(0)
     do k=1,nx
        fm2(k)=((1.0-0.25*(dt*real(k))**2-i*dt*real(k))/  &
  &            (1.0+0.25*(dt*real(k))**2))*fm1(k)
        fm1(k)=fm2(k)  ! 次ステップへ渡す
        fm2(nx+k)=conjg(fm2(nx-k+1))  ! 計算不要な配列に結果を渡す
     end do

     call ffttp_1d( 2*nx+1, fm2, fm_tmp, 'i', 'o' )

     do k=0,2*nx  ! 実数への変換
        y(k)=real(fm_tmp(k))
        amp(k,j+1)=y(k)
     end do

  end do

  call HistoryPut( 'amp', amp )                         ! 変数出力

  call HistoryClose

end program
