module diag_function
!-- a module for functions and subroutines to diagnose variables and conversion among variables

contains

double precision function Cd_K16( us, vs )
!-- calculate exchange coefficient in Kuo et al. (2016; JGR)
  implicit none
  double precision, intent(in) :: us     ! U on physical space
  double precision, intent(in) :: vs     ! V on physical space
  double precision :: winds

  winds=0.78d0*dsqrt(us*us+vs*vs)

  if(winds<=25.0d0)then
     if(winds==0.0d0)then
        Cd_K16=0.142d0
     else
        Cd_K16=2.7d0/winds+0.142d0+0.0764d0*winds
     end if
  else
     Cd_K16=2.16d0+0.5406d0*(1.0d0-dexp(-(winds-25.0d0)/7.5d0))
  end if

  Cd_K16=1.0d-3*Cd_K16

  return

end function Cd_K16

end module diag_function
