program combinator
! 出力結果を 1 つにまとめる.
! splitter と全く逆の処理.

  use gtool_history
  use Algebra
  use Math_Const
  use Phys_Const
  use Statistics
  use Basis
  use val_define
  use read_namelist

  implicit none

  integer :: pnr, tnt
  integer :: i, j, k, id, m
  real, allocatable, dimension(:) :: tri, pri, tim, tti
  real, allocatable, dimension(:,:) :: tvb, thb, tub
  real, allocatable, dimension(:,:) :: pvb, phb, pub
  character(80) :: fname, pfiname
  character(1) :: data_flag, radial_flag
  character(4) :: cpe
  character(20) :: ctime

!-- namelist の読み込み

  call read_name()   ! _mpi ではないので, nr はプロセスで割られていない.

!-- allocating array

  if(mod((nr-2),proc)==0)then
     pnr=(nr-2)/proc+2
  else
     write(*,*) "ERROR : parameter 'proc' must be a prime factor of 'nr-2'."
     write(*,*) "now configuration : nr   = ", nr
     write(*,*) "now configuration : proc = ", proc
     write(*,*) "stop abnormally."
     stop
  end if

  tnt=nt/dmpstp+1
  write(*,*) "tnt check", tnt

  allocate(tim(tnt))
  allocate(tri(nr))
  allocate(tti(ntheta))
  allocate(tvb(nr,ntheta))
  allocate(tub(nr,ntheta))
  allocate(thb(nr,ntheta))
  allocate(pri(pnr))
  allocate(pvb(pnr,ntheta))
  allocate(pub(pnr,ntheta))
  allocate(phb(pnr,ntheta))

!-- 出力ファイルの座標定義

  tim=(/((real(dmpstp)*dt*(i-1)),i=1,tnt)/)
  tri=(/((rmin+dr*(i-1)),i=1,nr)/)
  tti=(/(((real(i-1))*2.0*pi/real(ntheta-1)),i=1,ntheta)/)

!-- 結合ファイルの初期化

  call HistoryCreate( file=trim(foname),  &
  &                   title='shallow result data',  &
  &                   source='test', institution='test',  &
  &                   dims=(/'r    ','theta', 't    '/),  &
  &                   dimsizes=(/nr,ntheta, 0/),  & 
  &                   longnames=(/'r-coordinate    ','theta-coordinate', 'time            '/),  &
  &                   units=(/'m  ', 'rad', 's  '/),  &
  &                   origin=0.0, interval=dmpstp*dt )

  call HistoryAddVariable( varname='up', dims=(/'r    ','theta','t    '/), &
  &                        longname='radial wind',  &
  &                        units='m/s', xtype='float')

  call HistoryAddVariable( varname='vp', dims=(/'r    ','theta','t    '/), &
  &                        longname='tangential wind',  &
  &                        units='m/s', xtype='float')

  call HistoryAddVariable( varname='hp', dims=(/'r    ','theta','t    '/), &
  &                        longname='geopotential height',  &
  &                        units='m', xtype='float')

  call HistoryPut( 'r', tri )
  call HistoryPut( 'theta', tti )

!-- 結果ファイルからの読み出し

  do id=1,tnt
     do j=1,proc
   
        write(cpe,'(i4.4)') j-1
   
        pfiname=trim(adjustl(foname(1:len_trim(foname)-3)))  &
  &             //'.'//cpe(1:4)//'.nc'
  
        ctime=r2c_convert( tim(id), '(f20.3)' )
 
        call HistoryGet( trim(pfiname), 'up', pub,  &
  &                      range='t='//trim(adjustl(ctime)) )
        call HistoryGet( trim(pfiname), 'vp', pvb,  &
  &                      range='t='//trim(adjustl(ctime)) )
        call HistoryGet( trim(pfiname), 'hp', phb,  &
  &                      range='t='//trim(adjustl(ctime)) )
   
        do i=1,pnr
           m=(pnr-2)*(j-1)+i
           do k=1,ntheta
              tub(m,k)=pub(i,k)
              tvb(m,k)=pvb(i,k)
              thb(m,k)=phb(i,k)
           end do
        end do

     end do

     call HistoryPut( 'up', tub )
     call HistoryPut( 'vp', tvb )
     call HistoryPut( 'hp', thb )

  end do

  write(*,*) "stop, normally."

end program
